/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodePair;
import edu.cmu.tetrad.search.IndTestChiSquare;
import edu.cmu.tetrad.search.IndependenceResult;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.SearchLogUtils;
import edu.cmu.tetrad.search.SepsetMapDci;
import edu.cmu.tetrad.util.ProbUtils;
import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.math3.util.FastMath;

public final class ResolveSepsets {
    public static SepsetMapDci resolveSepsets(List<SepsetMapDci> sepsets, List<IndependenceTest> independenceTests, Method method, SepsetMapDci resolvedIndependent, SepsetMapDci resolvedDependent) {
        SepsetMapDci resolvedSepset = new SepsetMapDci();
        HashSet<Node> allVars = new HashSet<Node>();
        for (IndependenceTest independenceTest : independenceTests) {
            allVars.addAll(independenceTest.getVariables());
        }
        for (NodePair pair : ResolveSepsets.allNodePairs(new ArrayList<Node>(allVars))) {
            ArrayList<List<List<Node>>> pairSepsets = new ArrayList<List<List<Node>>>();
            ArrayList<IndependenceTest> testsWithPair = new ArrayList<IndependenceTest>();
            for (int k = 0; k < independenceTests.size(); ++k) {
                IndependenceTest independenceTest = independenceTests.get(k);
                if (!independenceTest.getVariables().containsAll(Arrays.asList(pair.getFirst(), pair.getSecond()))) continue;
                pairSepsets.add(sepsets.get(k).getSet(pair.getFirst(), pair.getSecond()));
                testsWithPair.add(independenceTest);
            }
            if (testsWithPair.size() < 2) {
                if (testsWithPair.size() != 1 || pairSepsets.get(0) == null) continue;
                for (List sepset : (List)pairSepsets.get(0)) {
                    resolvedSepset.set(pair.getFirst(), pair.getSecond(), sepset);
                }
                continue;
            }
            ArrayList allConditioningSets = new ArrayList();
            for (List list : pairSepsets) {
                if (list == null) continue;
                allConditioningSets.addAll(list);
            }
            for (List list : allConditioningSets) {
                ArrayList<IndependenceTest> testsWithSet = new ArrayList<IndependenceTest>();
                for (IndependenceTest independenceTest : testsWithPair) {
                    if (!independenceTest.getVariables().containsAll(list) && !list.isEmpty()) continue;
                    testsWithSet.add(independenceTest);
                }
                if (testsWithSet.size() < 2) {
                    if (testsWithPair.size() != 1) continue;
                    resolvedSepset.set(pair.getFirst(), pair.getSecond(), list);
                    continue;
                }
                boolean separated = false;
                boolean inconsistent = false;
                for (int k = 0; k < testsWithSet.size(); ++k) {
                    IndependenceTest testWithSet = (IndependenceTest)testsWithSet.get(k);
                    if (k == 0) {
                        separated = testWithSet.checkIndependence(pair.getFirst(), pair.getSecond(), list).independent();
                        continue;
                    }
                    if (separated == testWithSet.checkIndependence(pair.getFirst(), pair.getSecond(), list).independent()) continue;
                    inconsistent = true;
                    break;
                }
                if (inconsistent) {
                    if (method == Method.fisher) {
                        if (ResolveSepsets.isIndependentPooledFisher(testsWithSet, pair.getFirst(), pair.getSecond(), list)) {
                            resolvedSepset.set(pair.getFirst(), pair.getFirst(), list);
                            resolvedIndependent.set(pair.getFirst(), pair.getSecond(), list);
                            continue;
                        }
                        resolvedDependent.set(pair.getFirst(), pair.getSecond(), list);
                        continue;
                    }
                    if (method == Method.fisher2) {
                        if (ResolveSepsets.isIndependentPooledFisher2(testsWithSet, pair.getFirst(), pair.getSecond(), list)) {
                            resolvedSepset.set(pair.getFirst(), pair.getFirst(), list);
                            resolvedIndependent.set(pair.getFirst(), pair.getSecond(), list);
                            continue;
                        }
                        resolvedDependent.set(pair.getFirst(), pair.getSecond(), list);
                        continue;
                    }
                    if (method == Method.tippett) {
                        if (ResolveSepsets.isIndependentPooledTippett(testsWithSet, pair.getFirst(), pair.getSecond(), list)) {
                            resolvedSepset.set(pair.getFirst(), pair.getFirst(), list);
                            resolvedIndependent.set(pair.getFirst(), pair.getSecond(), list);
                            continue;
                        }
                        resolvedDependent.set(pair.getFirst(), pair.getSecond(), list);
                        continue;
                    }
                    if (method == Method.worsleyfriston) {
                        if (ResolveSepsets.isIndependentPooledWorsleyFriston(testsWithSet, pair.getFirst(), pair.getSecond(), list)) {
                            resolvedSepset.set(pair.getFirst(), pair.getFirst(), list);
                            resolvedIndependent.set(pair.getFirst(), pair.getSecond(), list);
                            continue;
                        }
                        resolvedDependent.set(pair.getFirst(), pair.getSecond(), list);
                        continue;
                    }
                    if (method == Method.stouffer) {
                        if (ResolveSepsets.isIndependentPooledStouffer(testsWithSet, pair.getFirst(), pair.getSecond(), list)) {
                            resolvedSepset.set(pair.getFirst(), pair.getFirst(), list);
                            resolvedIndependent.set(pair.getFirst(), pair.getSecond(), list);
                            continue;
                        }
                        resolvedDependent.set(pair.getFirst(), pair.getSecond(), list);
                        continue;
                    }
                    if (method == Method.mudholkergeorge) {
                        if (ResolveSepsets.isIndependentPooledMudholkerGeorge(testsWithSet, pair.getFirst(), pair.getSecond(), list)) {
                            resolvedSepset.set(pair.getFirst(), pair.getFirst(), list);
                            resolvedIndependent.set(pair.getFirst(), pair.getSecond(), list);
                            continue;
                        }
                        resolvedDependent.set(pair.getFirst(), pair.getSecond(), list);
                        continue;
                    }
                    if (method == Method.mudholkergeorge2) {
                        if (ResolveSepsets.isIndependentPooledMudholkerGeorge2(testsWithSet, pair.getFirst(), pair.getSecond(), list)) {
                            resolvedSepset.set(pair.getFirst(), pair.getFirst(), list);
                            resolvedIndependent.set(pair.getFirst(), pair.getSecond(), list);
                            continue;
                        }
                        resolvedDependent.set(pair.getFirst(), pair.getSecond(), list);
                        continue;
                    }
                    if (method == Method.averagetest) {
                        if (ResolveSepsets.isIndependentPooledAverageTest(testsWithSet, pair.getFirst(), pair.getSecond(), list)) {
                            resolvedSepset.set(pair.getFirst(), pair.getFirst(), list);
                            resolvedIndependent.set(pair.getFirst(), pair.getSecond(), list);
                            continue;
                        }
                        resolvedDependent.set(pair.getFirst(), pair.getSecond(), list);
                        continue;
                    }
                    if (method == Method.average) {
                        if (ResolveSepsets.isIndependentPooledAverage(testsWithSet, pair.getFirst(), pair.getSecond(), list)) {
                            resolvedSepset.set(pair.getFirst(), pair.getFirst(), list);
                            resolvedIndependent.set(pair.getFirst(), pair.getSecond(), list);
                            continue;
                        }
                        resolvedDependent.set(pair.getFirst(), pair.getSecond(), list);
                        continue;
                    }
                    if (method == Method.random) {
                        if (ResolveSepsets.isIndependentPooledRandom(testsWithSet, pair.getFirst(), pair.getSecond(), list)) {
                            resolvedSepset.set(pair.getFirst(), pair.getFirst(), list);
                            resolvedIndependent.set(pair.getFirst(), pair.getSecond(), list);
                            continue;
                        }
                        resolvedDependent.set(pair.getFirst(), pair.getSecond(), list);
                        continue;
                    }
                    if (method == Method.fdr) {
                        if (ResolveSepsets.isIndependentMajorityFdr(testsWithSet, pair.getFirst(), pair.getSecond(), list)) {
                            resolvedSepset.set(pair.getFirst(), pair.getFirst(), list);
                            resolvedIndependent.set(pair.getFirst(), pair.getSecond(), list);
                            continue;
                        }
                        resolvedDependent.set(pair.getFirst(), pair.getSecond(), list);
                        continue;
                    }
                    if (method == Method.majority) {
                        if (ResolveSepsets.isIndependentMajorityIndep(testsWithSet, pair.getFirst(), pair.getSecond(), list)) {
                            resolvedSepset.set(pair.getFirst(), pair.getFirst(), list);
                            resolvedIndependent.set(pair.getFirst(), pair.getSecond(), list);
                            continue;
                        }
                        resolvedDependent.set(pair.getFirst(), pair.getSecond(), list);
                        continue;
                    }
                    throw new RuntimeException("Invalid Test");
                }
                resolvedSepset.set(pair.getFirst(), pair.getSecond(), list);
            }
        }
        return resolvedSepset;
    }

    public static boolean isIndependentPooled(Method method, List<IndependenceTest> independenceTests, Node x, Node y, List<Node> condSet) {
        if (method == Method.fisher) {
            return ResolveSepsets.isIndependentPooledFisher(independenceTests, x, y, condSet);
        }
        if (method == Method.fisher2) {
            return ResolveSepsets.isIndependentPooledFisher2(independenceTests, x, y, condSet);
        }
        if (method == Method.tippett) {
            return ResolveSepsets.isIndependentPooledTippett(independenceTests, x, y, condSet);
        }
        if (method == Method.worsleyfriston) {
            return ResolveSepsets.isIndependentPooledWorsleyFriston(independenceTests, x, y, condSet);
        }
        if (method == Method.stouffer) {
            return ResolveSepsets.isIndependentPooledStouffer(independenceTests, x, y, condSet);
        }
        if (method == Method.mudholkergeorge) {
            return ResolveSepsets.isIndependentPooledMudholkerGeorge(independenceTests, x, y, condSet);
        }
        if (method == Method.mudholkergeorge2) {
            return ResolveSepsets.isIndependentPooledMudholkerGeorge2(independenceTests, x, y, condSet);
        }
        if (method == Method.averagetest) {
            return ResolveSepsets.isIndependentPooledAverageTest(independenceTests, x, y, condSet);
        }
        if (method == Method.average) {
            return ResolveSepsets.isIndependentPooledAverage(independenceTests, x, y, condSet);
        }
        if (method == Method.random) {
            return ResolveSepsets.isIndependentPooledRandom(independenceTests, x, y, condSet);
        }
        if (method == Method.fdr) {
            return ResolveSepsets.isIndependentMajorityFdr(independenceTests, x, y, condSet);
        }
        if (method == Method.majority) {
            return ResolveSepsets.isIndependentMajorityIndep(independenceTests, x, y, condSet);
        }
        throw new RuntimeException("Invalid Test");
    }

    public static boolean isIndependentPooledFisher(List<IndependenceTest> independenceTests, Node x, Node y, List<Node> condSet) {
        double alpha = independenceTests.get(0).getAlpha();
        double tf = 0.0;
        for (IndependenceTest independenceTest : independenceTests) {
            if (ResolveSepsets.missingVariable(x, y, condSet, independenceTest)) continue;
            ArrayList<Node> localCondSet = new ArrayList<Node>();
            for (Node node : condSet) {
                localCondSet.add(independenceTest.getVariable(node.getName()));
            }
            IndependenceResult result = independenceTest.checkIndependence(independenceTest.getVariable(x.getName()), independenceTest.getVariable(y.getName()), localCondSet);
            tf += -2.0 * FastMath.log(result.getPValue());
        }
        double p = 1.0 - ProbUtils.chisqCdf(tf, 2 * independenceTests.size());
        return p > alpha;
    }

    public static boolean isIndependentPooledFisher2(List<IndependenceTest> independenceTests, Node x, Node y, List<Node> condSet) {
        double alpha = independenceTests.get(0).getAlpha();
        List<Double> pValues = ResolveSepsets.getAvailablePValues(independenceTests, x, y, condSet);
        double tf = 0.0;
        int numPValues = 0;
        for (double p : pValues) {
            tf += -2.0 * FastMath.log(p);
            ++numPValues;
        }
        double p = 1.0 - ProbUtils.chisqCdf(tf, 2 * numPValues);
        return p > alpha;
    }

    public static boolean isIndependentPooledTippett(List<IndependenceTest> independenceTests, Node x, Node y, List<Node> condSet) {
        double alpha = independenceTests.get(0).getAlpha();
        double p = -1.0;
        for (IndependenceTest independenceTest : independenceTests) {
            double newp;
            if (ResolveSepsets.missingVariable(x, y, condSet, independenceTest)) continue;
            ArrayList<Node> localCondSet = new ArrayList<Node>();
            for (Node node : condSet) {
                localCondSet.add(independenceTest.getVariable(node.getName()));
            }
            IndependenceResult result = independenceTest.checkIndependence(independenceTest.getVariable(x.getName()), independenceTest.getVariable(y.getName()), localCondSet);
            if (Double.isNaN(result.getPValue()) || !((newp = result.getPValue()) < p)) continue;
            p = newp;
        }
        return p > 1.0 - FastMath.pow(1.0 - alpha, 1.0 / (double)independenceTests.size());
    }

    public static boolean isIndependentPooledWilkinson(List<IndependenceTest> independenceTests, Node x, Node y, List<Node> condSet, int r) {
        double alpha = independenceTests.get(0).getAlpha();
        double[] p = new double[independenceTests.size()];
        int k = 0;
        for (IndependenceTest independenceTest : independenceTests) {
            IndependenceResult result = independenceTest.checkIndependence(x, y, condSet);
            p[k] = result.getPValue();
            ++k;
        }
        Arrays.sort(p);
        return p[r] > 1.0 - FastMath.pow(1.0 - FastMath.pow(alpha, 1.0 / (double)r), (double)r / (double)independenceTests.size());
    }

    public static boolean isIndependentPooledWorsleyFriston(List<IndependenceTest> independenceTests, Node x, Node y, List<Node> condSet) {
        double alpha = independenceTests.get(0).getAlpha();
        double p = -1.0;
        for (IndependenceTest independenceTest : independenceTests) {
            double newp;
            ArrayList<Node> localCondSet = new ArrayList<Node>();
            if (ResolveSepsets.missingVariable(x, y, condSet, independenceTest)) continue;
            for (Node node : condSet) {
                localCondSet.add(independenceTest.getVariable(node.getName()));
            }
            IndependenceResult result = independenceTest.checkIndependence(independenceTest.getVariable(x.getName()), independenceTest.getVariable(y.getName()), localCondSet);
            if (Double.isNaN(result.getPValue()) || !((newp = result.getPValue()) > p)) continue;
            p = newp;
        }
        return p > FastMath.pow(alpha, 1.0 / (double)independenceTests.size());
    }

    public static boolean isIndependentPooledStouffer(List<IndependenceTest> independenceTests, Node x, Node y, List<Node> condSet) {
        double alpha = independenceTests.get(0).getAlpha();
        double ts = 0.0;
        for (IndependenceTest independenceTest : independenceTests) {
            ArrayList<Node> localCondSet = new ArrayList<Node>();
            for (Node node : condSet) {
                localCondSet.add(independenceTest.getVariable(node.getName()));
            }
            IndependenceResult result = independenceTest.checkIndependence(independenceTest.getVariable(x.getName()), independenceTest.getVariable(y.getName()), localCondSet);
            ts += ProbUtils.normalQuantile(result.getPValue()) / FastMath.sqrt(independenceTests.size());
        }
        double p = 2.0 * (1.0 - RandomUtil.getInstance().normalCdf(0.0, 1.0, FastMath.abs(ts)));
        return p > alpha;
    }

    public static boolean isIndependentPooledMudholkerGeorge(List<IndependenceTest> independenceTests, Node x, Node y, List<Node> condSet) {
        double alpha = independenceTests.get(0).getAlpha();
        double c = FastMath.sqrt((double)(3 * (5 * independenceTests.size() + 4)) / ((double)independenceTests.size() * FastMath.pow(Math.PI, 2) * (double)(5 * independenceTests.size() + 2)));
        double tm = 0.0;
        for (IndependenceTest independenceTest : independenceTests) {
            ArrayList<Node> localCondSet = new ArrayList<Node>();
            for (Node node : condSet) {
                localCondSet.add(independenceTest.getVariable(node.getName()));
            }
            IndependenceResult result = independenceTest.checkIndependence(independenceTest.getVariable(x.getName()), independenceTest.getVariable(y.getName()), localCondSet);
            double pk = result.getPValue();
            if (pk == 0.0 || pk == 1.0) continue;
            tm += -c * FastMath.log(pk / (1.0 - pk));
        }
        double p = 2.0 * (1.0 - ProbUtils.tCdf(FastMath.abs(tm), 5 * independenceTests.size() + 4));
        return p > alpha;
    }

    public static boolean isIndependentPooledMudholkerGeorge2(List<IndependenceTest> independenceTests, Node x, Node y, List<Node> condSet) {
        double alpha = independenceTests.get(0).getAlpha();
        List<Double> pValues = ResolveSepsets.getAvailablePValues(independenceTests, x, y, condSet);
        double c = FastMath.sqrt((double)(3 * (5 * pValues.size() + 4)) / ((double)pValues.size() * FastMath.pow(Math.PI, 2) * (double)(5 * pValues.size() + 2)));
        double tm = 0.0;
        for (double pk : pValues) {
            tm += -c * FastMath.log(pk / (1.0 - pk));
        }
        double p = 2.0 * (1.0 - ProbUtils.tCdf(FastMath.abs(tm), 5 * pValues.size() + 4));
        return p > alpha;
    }

    public static boolean isIndependentPooledAverage(List<IndependenceTest> independenceTests, Node x, Node y, List<Node> condSet) {
        double alpha = independenceTests.get(0).getAlpha();
        double sum = 0.0;
        int numTests = 0;
        for (IndependenceTest independenceTest : independenceTests) {
            if (ResolveSepsets.missingVariable(x, y, condSet, independenceTest)) continue;
            ArrayList<Node> localCondSet = new ArrayList<Node>();
            for (Node node : condSet) {
                localCondSet.add(independenceTest.getVariable(node.getName()));
            }
            IndependenceResult result = independenceTest.checkIndependence(independenceTest.getVariable(x.getName()), independenceTest.getVariable(y.getName()), localCondSet);
            double p = result.getPValue();
            if (Double.isNaN(p)) continue;
            sum += p;
            ++numTests;
        }
        return sum / (double)numTests > alpha;
    }

    private static boolean missingVariable(Node x, Node y, List<Node> condSet, IndependenceTest independenceTest) {
        DataSet dataSet = (DataSet)independenceTest.getData();
        if (ResolveSepsets.isMissing(x, dataSet)) {
            return true;
        }
        if (ResolveSepsets.isMissing(y, dataSet)) {
            return true;
        }
        for (Node z : condSet) {
            if (!ResolveSepsets.isMissing(z, dataSet)) continue;
            return true;
        }
        return false;
    }

    private static boolean isMissing(Node node, DataSet dataSet) {
        Node _node = dataSet.getVariable(node.getName());
        int col = dataSet.getColumn(_node);
        for (int i = 0; i < dataSet.getNumRows(); ++i) {
            if (!Double.isNaN(dataSet.getDouble(i, col))) continue;
            return true;
        }
        return false;
    }

    public static boolean isIndependentPooledAverageTest(List<IndependenceTest> independenceTests, Node x, Node y, List<Node> condSet) {
        double alpha = independenceTests.get(0).getAlpha();
        double ts = 0.0;
        int df = 0;
        for (IndependenceTest independenceTest : independenceTests) {
            if (!(independenceTest instanceof IndTestChiSquare)) {
                throw new RuntimeException("Must be ChiSquare Test");
            }
            ArrayList<Node> localCondSet = new ArrayList<Node>();
            for (Node node : condSet) {
                localCondSet.add(independenceTest.getVariable(node.getName()));
            }
            independenceTest.checkIndependence(independenceTest.getVariable(x.getName()), independenceTest.getVariable(y.getName()), localCondSet);
            ts += ((IndTestChiSquare)independenceTest).getXSquare() / (double)independenceTests.size();
            df += ((IndTestChiSquare)independenceTest).getDf();
        }
        double p = 1.0 - ProbUtils.chisqCdf(ts, df /= independenceTests.size());
        return p > alpha;
    }

    public static boolean isIndependentPooledRandom(List<IndependenceTest> independenceTests, Node x, Node y, List<Node> condSet) {
        double alpha = independenceTests.get(0).getAlpha();
        int r = RandomUtil.getInstance().nextInt(independenceTests.size());
        IndependenceTest independenceTest = independenceTests.get(r);
        ArrayList<Node> localCondSet = new ArrayList<Node>();
        for (Node node : condSet) {
            localCondSet.add(independenceTest.getVariable(node.getName()));
        }
        IndependenceResult result = independenceTest.checkIndependence(independenceTest.getVariable(x.getName()), independenceTest.getVariable(y.getName()), localCondSet);
        double p = result.getPValue();
        return p > alpha;
    }

    public static List<NodePair> allNodePairs(List<Node> nodes) {
        ArrayList<NodePair> nodePairs = new ArrayList<NodePair>();
        for (int j = 0; j < nodes.size() - 1; ++j) {
            for (int k = j + 1; k < nodes.size(); ++k) {
                nodePairs.add(new NodePair(nodes.get(j), nodes.get(k)));
            }
        }
        return nodePairs;
    }

    private static boolean isIndependentMajorityFdr(List<IndependenceTest> independenceTests, Node x, Node y, List<Node> condSet) {
        boolean independent;
        int c;
        List<Double> allPValues = ResolveSepsets.getAvailablePValues(independenceTests, x, y, condSet);
        Collections.sort(allPValues);
        for (c = 0; c < allPValues.size() && allPValues.get(c) < independenceTests.get(0).getAlpha() * ((double)c + 1.0) / (double)allPValues.size(); ++c) {
        }
        boolean bl = independent = c < allPValues.size() / 2;
        if (independent) {
            TetradLogger.getInstance().log("independence", "***FDR judges " + SearchLogUtils.independenceFact(x, y, condSet) + " independent");
        } else {
            TetradLogger.getInstance().log("independence", "###FDR judges " + SearchLogUtils.independenceFact(x, y, condSet) + " dependent");
        }
        TetradLogger.getInstance().log("independence", "c = " + c);
        return independent;
    }

    private static List<Double> getAvailablePValues(List<IndependenceTest> independenceTests, Node x, Node y, List<Node> condSet) {
        ArrayList<Double> allPValues = new ArrayList<Double>();
        for (IndependenceTest test : independenceTests) {
            if (ResolveSepsets.missingVariable(x, y, condSet, test)) continue;
            ArrayList<Node> localCondSet = new ArrayList<Node>();
            for (Node node : condSet) {
                localCondSet.add(test.getVariable(node.getName()));
            }
            try {
                IndependenceResult result = test.checkIndependence(test.getVariable(x.getName()), test.getVariable(y.getName()), localCondSet);
                allPValues.add(result.getPValue());
            }
            catch (Exception exception) {}
        }
        return allPValues;
    }

    private static boolean isIndependentMajorityIndep(List<IndependenceTest> independenceTests, Node x, Node y, List<Node> condSet) {
        boolean independent;
        int c;
        List<Double> allPValues = ResolveSepsets.getAvailablePValues(independenceTests, x, y, condSet);
        Collections.sort(allPValues);
        for (c = 0; c < allPValues.size() && allPValues.get(c) < independenceTests.get(0).getAlpha(); ++c) {
        }
        boolean bl = independent = c < allPValues.size() / 2;
        if (independent) {
            TetradLogger.getInstance().log("independence", "***Majority = " + SearchLogUtils.independenceFact(x, y, condSet) + " independent");
        } else {
            TetradLogger.getInstance().log("independence", "###Majority = " + SearchLogUtils.independenceFact(x, y, condSet) + " dependent");
        }
        TetradLogger.getInstance().log("independence", "c = " + c);
        return independent;
    }

    public static enum Method {
        fisher,
        fisher2,
        tippett,
        worsleyfriston,
        stouffer,
        mudholkergeorge,
        mudholkergeorge2,
        average,
        averagetest,
        random,
        fdr,
        majority;

    }
}

