/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.KnowledgeEdge;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.GraphScore;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.Score;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.search.TeyssierScorer;
import edu.cmu.tetrad.util.MillisecondTimes;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.PermutationGenerator;
import edu.cmu.tetrad.util.RandomUtil;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SP {
    private final List<Node> variables;
    private long start;
    private Score score;
    private IndependenceTest test;
    private int numStarts = 1;
    private Knowledge knowledge = new Knowledge();
    private TeyssierScorer scorer;
    private boolean useScore = true;
    private boolean verbose = false;
    private boolean useDataOrder = false;

    public SP(@NotNull Score score) {
        this.score = score;
        this.variables = new ArrayList<Node>(score.getVariables());
        this.useScore = true;
    }

    public SP(@NotNull IndependenceTest test) {
        this.test = test;
        this.variables = new ArrayList<Node>(test.getVariables());
        this.useScore = false;
    }

    public SP(@NotNull IndependenceTest test, Score score) {
        this.test = test;
        this.score = score;
        this.variables = new ArrayList<Node>(test.getVariables());
    }

    public List<Node> bestOrder(@NotNull List<Node> _order) {
        ArrayList<Node> order = new ArrayList<Node>(_order);
        long start = MillisecondTimes.timeMillis();
        if (this.useScore && !(this.score instanceof GraphScore)) {
            this.scorer = new TeyssierScorer(this.test, this.score);
            this.scorer.setUseScore(true);
        } else {
            this.scorer = new TeyssierScorer(this.test, this.score);
            boolean usePearl = false;
            this.scorer.setUseRaskuttiUhler(usePearl);
            this.scorer.score(this.variables);
            this.scorer.setUseScore(this.useScore);
        }
        this.scorer.setKnowledge(this.knowledge);
        this.scorer.clearBookmarks();
        List<Node> bestPerm = new ArrayList<Node>(order);
        double best = Double.NEGATIVE_INFINITY;
        for (int r = 0; r < (this.useDataOrder ? 1 : this.numStarts); ++r) {
            if (!this.useDataOrder) {
                RandomUtil.shuffle(order);
            }
            this.start = MillisecondTimes.timeMillis();
            this.makeValidKnowledgeOrder(order);
            this.scorer.score(order);
            this.useDataOrder = true;
            List<Node> perm = this.sp(this.scorer);
            this.scorer.score(perm);
            if (!(this.scorer.score() > best)) continue;
            best = this.scorer.score();
            bestPerm = perm;
        }
        long stop = MillisecondTimes.timeMillis();
        if (this.verbose) {
            System.out.println("Final order = " + this.scorer.getPi());
            System.out.println("Elapsed time = " + (double)(stop - start) / 1000.0 + " s");
        }
        return bestPerm;
    }

    public int getNumEdges() {
        return this.scorer.getNumEdges();
    }

    private void makeValidKnowledgeOrder(List<Node> order) {
        if (!this.knowledge.isEmpty()) {
            order.sort((o1, o2) -> {
                if (o1.getName().equals(o2.getName())) {
                    return 0;
                }
                if (this.knowledge.isRequired(o1.getName(), o2.getName())) {
                    return 1;
                }
                if (this.knowledge.isRequired(o2.getName(), o1.getName())) {
                    return -1;
                }
                if (this.knowledge.isForbidden(o2.getName(), o1.getName())) {
                    return -1;
                }
                if (this.knowledge.isForbidden(o1.getName(), o2.getName())) {
                    return 1;
                }
                return 1;
            });
        }
    }

    public List<Node> sp(@NotNull TeyssierScorer scorer) {
        int[] perm;
        double maxScore = Double.NEGATIVE_INFINITY;
        List<Node> maxP = null;
        List<Node> variables = scorer.getPi();
        PermutationGenerator gen = new PermutationGenerator(variables.size());
        HashSet<Graph> frugalCpdags = new HashSet<Graph>();
        int[] v = new int[scorer.size()];
        for (int i = 0; i < scorer.size(); ++i) {
            v[i] = i;
        }
        List<Node> pi0 = GraphUtils.asList(v, variables);
        scorer.score(pi0);
        System.out.println("\t\t# edges for " + pi0 + scorer.getNumEdges());
        while ((perm = gen.next()) != null) {
            List<Node> p = GraphUtils.asList(perm, variables);
            if (this.violatesKnowledge(p)) continue;
            scorer.score(p);
            if (scorer.score() > maxScore) {
                maxScore = scorer.score();
                maxP = p;
                frugalCpdags.clear();
            }
            if (scorer.score() != maxScore) continue;
            frugalCpdags.add(scorer.getGraph(true));
        }
        System.out.println("\t\t# frugal cpdags BY SP = " + frugalCpdags.size());
        System.out.println("\t\t# edges for frugal = " + ((Graph)frugalCpdags.iterator().next()).getNumEdges());
        if (frugalCpdags.size() == 1) {
            System.out.println("\t!!!! U-FRUGAL BY SP");
        }
        if (this.verbose) {
            System.out.println("# Edges = " + scorer.getNumEdges() + " Score = " + scorer.score() + " (SP) Elapsed " + (double)(MillisecondTimes.timeMillis() - this.start) / 1000.0 + " sp");
        }
        System.out.println("Frugal CPDAGs: ");
        for (Graph g : frugalCpdags) {
            System.out.println(g);
        }
        return maxP;
    }

    @NotNull
    public Graph getGraph(boolean cpDag) {
        if (this.scorer == null) {
            throw new IllegalArgumentException("Please run algorithm first.");
        }
        Graph graph = this.scorer.getGraph(cpDag);
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        graph.addAttribute("score ", nf.format(this.scorer.score()));
        return graph;
    }

    public void orientbk(Knowledge bk, Graph graph, List<Node> variables) {
        Node to;
        Node from;
        KnowledgeEdge edge;
        Iterator<KnowledgeEdge> it = bk.forbiddenEdgesIterator();
        while (it.hasNext() && !Thread.currentThread().isInterrupted()) {
            edge = it.next();
            from = SearchGraphUtils.translate(edge.getFrom(), variables);
            to = SearchGraphUtils.translate(edge.getTo(), variables);
            if (from == null || to == null || graph.getEdge(from, to) == null) continue;
            graph.setEndpoint(to, from, Endpoint.ARROW);
        }
        it = bk.requiredEdgesIterator();
        while (it.hasNext() && !Thread.currentThread().isInterrupted()) {
            edge = it.next();
            from = SearchGraphUtils.translate(edge.getFrom(), variables);
            to = SearchGraphUtils.translate(edge.getTo(), variables);
            if (from == null || to == null || graph.getEdge(from, to) == null) continue;
            graph.setEndpoint(from, to, Endpoint.ARROW);
        }
    }

    public void setNumStarts(int numStarts) {
        this.numStarts = numStarts;
    }

    public List<Node> getVariables() {
        return this.variables;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = new Knowledge(knowledge);
    }

    public void setUseDataOrder(boolean useDataOrder) {
        this.useDataOrder = useDataOrder;
    }

    public void setUseScore(boolean useScore) {
        this.useScore = useScore;
    }

    private boolean violatesKnowledge(List<Node> order) {
        if (!this.knowledge.isEmpty()) {
            for (int i = 0; i < order.size(); ++i) {
                for (int j = i + 1; j < order.size(); ++j) {
                    if (this.knowledge.isForbidden(order.get(i).getName(), order.get(j).getName())) {
                        return true;
                    }
                    if (!this.knowledge.isRequired(order.get(j).getName(), order.get(i).getName())) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

