/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.Score;
import java.util.ArrayList;
import java.util.List;

public class ScoredIndTest
implements Score {
    private final IndependenceTest test;
    private final List<Node> variables = new ArrayList<Node>();
    private boolean verbose;

    public ScoredIndTest(IndependenceTest test) {
        for (Node node : test.getVariables()) {
            if (node.getNodeType() != NodeType.MEASURED) continue;
            this.variables.add(node);
        }
        this.test = test;
    }

    @Override
    public double localScore(int i, int[] parents) {
        throw new UnsupportedOperationException();
    }

    private List<Node> getVariableList(int[] indices) {
        ArrayList<Node> variables = new ArrayList<Node>();
        for (int i : indices) {
            variables.add(this.variables.get(i));
        }
        return variables;
    }

    @Override
    public double localScoreDiff(int x, int y, int[] z) {
        this.test.checkIndependence(this.variables.get(x), this.variables.get(y), this.getVariableList(z));
        return this.test.getScore();
    }

    @Override
    public double localScoreDiff(int x, int y) {
        return this.localScoreDiff(x, y, new int[0]);
    }

    @Override
    public double localScore(int i, int parent) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double localScore(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEffectEdge(double bump) {
        return true;
    }

    public DataSet getDataSet() {
        throw new UnsupportedOperationException();
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public List<Node> getVariables() {
        return this.variables;
    }

    @Override
    public int getSampleSize() {
        return 0;
    }

    public boolean getAlternativePenalty() {
        return false;
    }

    @Override
    public Node getVariable(String targetName) {
        for (Node node : this.variables) {
            if (!node.getName().equals(targetName)) continue;
            return node;
        }
        return null;
    }

    @Override
    public int getMaxDegree() {
        return 1000;
    }

    @Override
    public boolean determines(List<Node> z, Node y) {
        return false;
    }
}

