/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.KnowledgeEdge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.search.DagInCPDAGIterator;
import edu.cmu.tetrad.search.DagSepsets;
import edu.cmu.tetrad.search.DagToPag;
import edu.cmu.tetrad.search.FciOrient;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.LegalPairs;
import edu.cmu.tetrad.search.MeekRules;
import edu.cmu.tetrad.search.SearchLogUtils;
import edu.cmu.tetrad.search.SepsetMap;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.CombinationGenerator;
import edu.cmu.tetrad.util.TetradLogger;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.apache.commons.math3.util.FastMath;
import org.jetbrains.annotations.NotNull;

public final class SearchGraphUtils {
    public static void pcOrientbk(Knowledge bk, Graph graph, List<Node> nodes) {
        Node to;
        Node from;
        KnowledgeEdge edge;
        TetradLogger.getInstance().log("details", "Staring BK Orientation.");
        Iterator<KnowledgeEdge> it = bk.forbiddenEdgesIterator();
        while (it.hasNext()) {
            edge = it.next();
            from = SearchGraphUtils.translate(edge.getFrom(), nodes);
            to = SearchGraphUtils.translate(edge.getTo(), nodes);
            if (from == null || to == null || graph.getEdge(from, to) == null) continue;
            graph.removeEdge(from, to);
            graph.addDirectedEdge(to, from);
            TetradLogger.getInstance().log("knowledgeOrientations", SearchLogUtils.edgeOrientedMsg("Knowledge", graph.getEdge(to, from)));
        }
        it = bk.requiredEdgesIterator();
        while (it.hasNext()) {
            edge = it.next();
            from = SearchGraphUtils.translate(edge.getFrom(), nodes);
            to = SearchGraphUtils.translate(edge.getTo(), nodes);
            if (from == null || to == null || graph.getEdge(from, to) == null) continue;
            graph.removeEdges(from, to);
            graph.addDirectedEdge(from, to);
            TetradLogger.getInstance().log("knowledgeOrientations", SearchLogUtils.edgeOrientedMsg("Knowledge", graph.getEdge(from, to)));
        }
        TetradLogger.getInstance().log("details", "Finishing BK Orientation.");
    }

    public static void pcdOrientC(IndependenceTest test, Knowledge knowledge, Graph graph) {
        TetradLogger.getInstance().log("info", "Starting Collider Orientation:");
        List<Node> nodes = graph.getNodes();
        for (Node y : nodes) {
            int[] combination;
            List<Node> adjacentNodes = graph.getAdjacentNodes(y);
            if (adjacentNodes.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
            while ((combination = cg.next()) != null) {
                List<Node> sepset;
                Node z;
                Node x = adjacentNodes.get(combination[0]);
                if (graph.isAdjacentTo(x, z = adjacentNodes.get(combination[1])) || (sepset = SearchGraphUtils.sepset(graph, x, z, new HashSet<Node>(), new HashSet<Node>(), test)) == null || sepset.contains(y)) continue;
                LinkedList<Node> augmentedSet = new LinkedList<Node>(sepset);
                if (!augmentedSet.contains(y)) {
                    augmentedSet.add(y);
                }
                if (test.determines(sepset, x) || test.determines(sepset, z) || test.determines(augmentedSet, x) || test.determines(augmentedSet, z) || !SearchGraphUtils.isArrowpointAllowed(x, y, knowledge) || !SearchGraphUtils.isArrowpointAllowed(z, y, knowledge)) continue;
                graph.setEndpoint(x, y, Endpoint.ARROW);
                graph.setEndpoint(z, y, Endpoint.ARROW);
                System.out.println(SearchLogUtils.colliderOrientedMsg(x, y, z) + " sepset = " + sepset);
                TetradLogger.getInstance().log("colliderOrientations", SearchLogUtils.colliderOrientedMsg(x, y, z));
            }
        }
        TetradLogger.getInstance().log("info", "Finishing Collider Orientation.");
    }

    private static List<Node> sepset(Graph graph, Node a, Node c, Set<Node> containing, Set<Node> notContaining, IndependenceTest independenceTest) {
        List<Node> adj = graph.getAdjacentNodes(a);
        adj.addAll(graph.getAdjacentNodes(c));
        adj.remove(c);
        adj.remove(a);
        for (int d = 0; d <= FastMath.min(1000, adj.size()); ++d) {
            int[] choice;
            ChoiceGenerator gen = new ChoiceGenerator(adj.size(), d);
            while ((choice = gen.next()) != null) {
                Set<Node> v2 = GraphUtils.asSet(choice, adj);
                v2.addAll(containing);
                v2.removeAll(notContaining);
                v2.remove(a);
                v2.remove(c);
                independenceTest.checkIndependence(a, c, new ArrayList<Node>(v2));
                double p2 = independenceTest.getScore();
                if (!(p2 < 0.0)) continue;
                return new ArrayList<Node>(v2);
            }
        }
        return null;
    }

    public static void orientUsingMeekRulesLocally(Knowledge knowledge, Graph graph, IndependenceTest test, int depth) {
        boolean changed;
        TetradLogger.getInstance().log("info", "Starting Orientation Step D.");
        while (changed = SearchGraphUtils.meekR1Locally(graph, knowledge, test, depth) || SearchGraphUtils.meekR2(graph, knowledge) || SearchGraphUtils.meekR3(graph, knowledge) || SearchGraphUtils.meekR4(graph, knowledge)) {
        }
        TetradLogger.getInstance().log("info", "Finishing Orientation Step D.");
    }

    public static void orientCollidersUsingSepsets(SepsetMap set, Knowledge knowledge, Graph graph, boolean verbose, boolean enforceCpdag) {
        TetradLogger.getInstance().log("details", "Starting Collider Orientation:");
        List<Node> nodes = graph.getNodes();
        for (Node b : nodes) {
            int[] combination;
            List<Node> adjacentNodes = graph.getAdjacentNodes(b);
            if (adjacentNodes.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
            while ((combination = cg.next()) != null) {
                List<Node> sepset;
                Node c;
                Node a = adjacentNodes.get(combination[0]);
                if (graph.isAdjacentTo(a, c = adjacentNodes.get(combination[1])) || (sepset = set.get(a, c)) == null || sepset.contains(b) || !SearchGraphUtils.isArrowpointAllowed(a, b, knowledge) || !SearchGraphUtils.isArrowpointAllowed(c, b, knowledge)) continue;
                if (verbose) {
                    System.out.println("Collider orientation <" + a + ", " + b + ", " + c + "> sepset = " + sepset);
                }
                if (enforceCpdag && (graph.getEndpoint(b, a) == Endpoint.ARROW || graph.getEndpoint(b, c) == Endpoint.ARROW)) continue;
                graph.removeEdge(a, b);
                graph.removeEdge(c, b);
                graph.addDirectedEdge(a, b);
                graph.addDirectedEdge(c, b);
                TetradLogger.getInstance().log("colliderOrientations", SearchLogUtils.colliderOrientedMsg(a, b, c, sepset));
            }
        }
        TetradLogger.getInstance().log("details", "Finishing Collider Orientation.");
    }

    public static boolean existsLocalSepsetWithout(Node x, Node y, Node z, IndependenceTest test, Graph graph, int depth) {
        HashSet<Node> __nodes = new HashSet<Node>(graph.getAdjacentNodes(x));
        __nodes.addAll(graph.getAdjacentNodes(z));
        __nodes.remove(x);
        __nodes.remove(z);
        LinkedList<Node> _nodes = new LinkedList<Node>(__nodes);
        TetradLogger.getInstance().log("adjacencies", "Adjacents for " + x + "--" + y + "--" + z + " = " + _nodes);
        int _depth = depth;
        if (_depth == -1) {
            _depth = 1000;
        }
        _depth = FastMath.min(_depth, _nodes.size());
        for (int d = 0; d <= _depth; ++d) {
            int[] choice;
            if (_nodes.size() < d) continue;
            ChoiceGenerator cg2 = new ChoiceGenerator(_nodes.size(), d);
            while ((choice = cg2.next()) != null) {
                List<Node> condSet = GraphUtils.asList(choice, _nodes);
                if (condSet.contains(y) || !test.checkIndependence(x, z, condSet).independent()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean meekR1Locally(Graph graph, Knowledge knowledge, IndependenceTest test, int depth) {
        List<Node> nodes = graph.getNodes();
        boolean changed = true;
        while (changed) {
            changed = false;
            for (Node a : nodes) {
                int[] combination;
                List<Node> adjacentNodes = graph.getAdjacentNodes(a);
                if (adjacentNodes.size() < 2) continue;
                ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
                while ((combination = cg.next()) != null) {
                    Node c;
                    Node b = adjacentNodes.get(combination[0]);
                    if (graph.isAdjacentTo(b, c = adjacentNodes.get(combination[1]))) continue;
                    if (graph.getEndpoint(b, a) == Endpoint.ARROW && graph.paths().isUndirectedFromTo(a, c)) {
                        if (SearchGraphUtils.existsLocalSepsetWithout(b, a, c, test, graph, depth) || !SearchGraphUtils.isArrowpointAllowed(a, c, knowledge)) continue;
                        graph.setEndpoint(a, c, Endpoint.ARROW);
                        TetradLogger.getInstance().log("impliedOrientation", SearchLogUtils.edgeOrientedMsg("Meek R1", graph.getEdge(a, c)));
                        changed = true;
                        continue;
                    }
                    if (graph.getEndpoint(c, a) != Endpoint.ARROW || !graph.paths().isUndirectedFromTo(a, b) || SearchGraphUtils.existsLocalSepsetWithout(b, a, c, test, graph, depth) || !SearchGraphUtils.isArrowpointAllowed(a, b, knowledge)) continue;
                    graph.setEndpoint(a, b, Endpoint.ARROW);
                    TetradLogger.getInstance().log("impliedOrientation", SearchLogUtils.edgeOrientedMsg("Meek R1", graph.getEdge(a, b)));
                    changed = true;
                }
            }
        }
        return false;
    }

    public static boolean meekR2(Graph graph, Knowledge knowledge) {
        List<Node> nodes = graph.getNodes();
        boolean changed = false;
        for (Node a : nodes) {
            int[] combination;
            List<Node> adjacentNodes = graph.getAdjacentNodes(a);
            if (adjacentNodes.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
            while ((combination = cg.next()) != null) {
                Node b = adjacentNodes.get(combination[0]);
                Node c = adjacentNodes.get(combination[1]);
                if (graph.paths().isDirectedFromTo(b, a) && graph.paths().isDirectedFromTo(a, c) && graph.paths().isUndirectedFromTo(b, c)) {
                    if (!SearchGraphUtils.isArrowpointAllowed(b, c, knowledge)) continue;
                    graph.setEndpoint(b, c, Endpoint.ARROW);
                    TetradLogger.getInstance().log("impliedOrientation", SearchLogUtils.edgeOrientedMsg("Meek R2", graph.getEdge(b, c)));
                    continue;
                }
                if (!graph.paths().isDirectedFromTo(c, a) || !graph.paths().isDirectedFromTo(a, b) || !graph.paths().isUndirectedFromTo(c, b) || !SearchGraphUtils.isArrowpointAllowed(c, b, knowledge)) continue;
                graph.setEndpoint(c, b, Endpoint.ARROW);
                TetradLogger.getInstance().log("impliedOrientation", SearchLogUtils.edgeOrientedMsg("Meek R2", graph.getEdge(c, b)));
            }
        }
        return false;
    }

    public static boolean meekR3(Graph graph, Knowledge knowledge) {
        List<Node> nodes = graph.getNodes();
        boolean changed = false;
        for (Node a : nodes) {
            List<Node> adjacentNodes = graph.getAdjacentNodes(a);
            if (adjacentNodes.size() < 3) continue;
            block1: for (Node b : adjacentNodes) {
                int[] combination;
                LinkedList<Node> otherAdjacents = new LinkedList<Node>(adjacentNodes);
                otherAdjacents.remove(b);
                if (!graph.paths().isUndirectedFromTo(a, b)) continue;
                ChoiceGenerator cg = new ChoiceGenerator(otherAdjacents.size(), 2);
                while ((combination = cg.next()) != null) {
                    Node d;
                    Node c = (Node)otherAdjacents.get(combination[0]);
                    if (graph.isAdjacentTo(c, d = (Node)otherAdjacents.get(combination[1])) || !graph.paths().isUndirectedFromTo(a, c) || !graph.paths().isUndirectedFromTo(a, d) || !graph.paths().isDirectedFromTo(c, b) || !graph.paths().isDirectedFromTo(d, b) || !SearchGraphUtils.isArrowpointAllowed(a, b, knowledge)) continue;
                    graph.setEndpoint(a, b, Endpoint.ARROW);
                    TetradLogger.getInstance().log("impliedOrientation", SearchLogUtils.edgeOrientedMsg("Meek R3", graph.getEdge(a, b)));
                    changed = true;
                    continue block1;
                }
            }
        }
        return changed;
    }

    public static boolean meekR4(Graph graph, Knowledge knowledge) {
        if (knowledge == null) {
            return false;
        }
        List<Node> nodes = graph.getNodes();
        boolean changed = false;
        for (Node a : nodes) {
            List<Node> adjacentNodes = graph.getAdjacentNodes(a);
            if (adjacentNodes.size() < 3) continue;
            block1: for (Node d : adjacentNodes) {
                int[] combination;
                if (!graph.isAdjacentTo(a, d)) continue;
                LinkedList<Node> otherAdjacents = new LinkedList<Node>(adjacentNodes);
                otherAdjacents.remove(d);
                ChoiceGenerator cg = new ChoiceGenerator(otherAdjacents.size(), 2);
                while ((combination = cg.next()) != null) {
                    Node b = (Node)otherAdjacents.get(combination[0]);
                    Node c = (Node)otherAdjacents.get(combination[1]);
                    if (!graph.paths().isUndirectedFromTo(a, b) || !graph.paths().isUndirectedFromTo(a, c)) continue;
                    if (graph.paths().isDirectedFromTo(b, c) && graph.paths().isDirectedFromTo(d, c)) {
                        if (!SearchGraphUtils.isArrowpointAllowed(a, c, knowledge)) continue;
                        graph.setEndpoint(a, c, Endpoint.ARROW);
                        TetradLogger.getInstance().log("impliedOrientation", SearchLogUtils.edgeOrientedMsg("Meek T1", graph.getEdge(a, c)));
                        changed = true;
                        continue block1;
                    }
                    if (!graph.paths().isDirectedFromTo(c, d) || !graph.paths().isDirectedFromTo(d, b) || !SearchGraphUtils.isArrowpointAllowed(a, b, knowledge)) continue;
                    graph.setEndpoint(a, b, Endpoint.ARROW);
                    TetradLogger.getInstance().log("impliedOrientation", SearchLogUtils.edgeOrientedMsg("Meek T1", graph.getEdge(a, b)));
                    changed = true;
                    continue block1;
                }
            }
        }
        return changed;
    }

    public static boolean isArrowpointAllowed(Object from, Object to, Knowledge knowledge) {
        if (knowledge == null) {
            return true;
        }
        return !knowledge.isRequired(to.toString(), from.toString()) && !knowledge.isForbidden(from.toString(), to.toString());
    }

    public static void basicCPDAG(Graph graph) {
        HashSet<Edge> undirectedEdges = new HashSet<Edge>();
        block0: for (Edge edge : graph.getEdges()) {
            if (!edge.isDirected()) continue;
            Node x = Edges.getDirectedEdgeTail(edge);
            Node y = Edges.getDirectedEdgeHead(edge);
            for (Node parent : graph.getParents(y)) {
                if (parent == x || graph.isAdjacentTo(parent, x)) continue;
                continue block0;
            }
            undirectedEdges.add(edge);
        }
        for (Edge nextUndirected : undirectedEdges) {
            Node node1 = nextUndirected.getNode1();
            Node node2 = nextUndirected.getNode2();
            graph.removeEdges(node1, node2);
            graph.addUndirectedEdge(node1, node2);
        }
    }

    public static void basicCpdagRestricted2(Graph graph, Node node) {
        HashSet<Edge> undirectedEdges = new HashSet<Edge>();
        block0: for (Edge edge : graph.getEdges(node)) {
            if (!edge.isDirected()) continue;
            Node _x = Edges.getDirectedEdgeTail(edge);
            Node _y = Edges.getDirectedEdgeHead(edge);
            for (Node parent : graph.getParents(_y)) {
                if (parent == _x || graph.isAdjacentTo(parent, _x)) continue;
                continue block0;
            }
            undirectedEdges.add(edge);
        }
        for (Edge nextUndirected : undirectedEdges) {
            Node node1 = nextUndirected.getNode1();
            Node node2 = nextUndirected.getNode2();
            graph.removeEdge(nextUndirected);
            graph.addUndirectedEdge(node1, node2);
        }
    }

    public static Graph cpdagFromDag(Graph dag) {
        EdgeListGraph graph = new EdgeListGraph(dag);
        SearchGraphUtils.basicCPDAG(graph);
        MeekRules rules = new MeekRules();
        rules.orientImplied(graph);
        return graph;
    }

    public static Graph dagFromCPDAG(Graph graph) {
        return SearchGraphUtils.dagFromCPDAG(graph, null);
    }

    public static Graph dagFromCPDAG(Graph graph, Knowledge knowledge) {
        EdgeListGraph dag = new EdgeListGraph(graph);
        for (Edge edge : dag.getEdges()) {
            if (!Edges.isBidirectedEdge(edge)) continue;
            throw new IllegalArgumentException("That 'cpdag' contains a bidirected edge.");
        }
        MeekRules rules = new MeekRules();
        if (knowledge != null) {
            rules.setKnowledge(knowledge);
        }
        rules.setRevertToUnshieldedColliders(false);
        block1: while (true) {
            for (Edge edge : dag.getEdges()) {
                Node x = edge.getNode1();
                Node y = edge.getNode2();
                if (!Edges.isUndirectedEdge(edge) || graph.paths().isAncestorOf(y, x)) continue;
                SearchGraphUtils.direct(x, y, dag);
                rules.orientImplied(dag);
                continue block1;
            }
            break;
        }
        return dag;
    }

    private static void direct(Node a, Node c, Graph graph) {
        Edge before = graph.getEdge(a, c);
        Edge after = Edges.directedEdge(a, c);
        graph.removeEdge(before);
        graph.addEdge(after);
    }

    public static Graph pagToMag(Graph pag) {
        Node y;
        Node x;
        EdgeListGraph mag = new EdgeListGraph(pag.getNodes());
        for (Edge e : pag.getEdges()) {
            mag.addEdge(new Edge(e));
        }
        DagSepsets sepsets = new DagSepsets(mag);
        FciOrient fciOrient = new FciOrient(sepsets);
        List<Node> nodes = mag.getNodes();
        EdgeListGraph pcafci = new EdgeListGraph(nodes);
        for (int i = 0; i < nodes.size(); ++i) {
            for (int j = 0; j < nodes.size(); ++j) {
                if (i == j) continue;
                x = nodes.get(i);
                y = nodes.get(j);
                if (mag.getEndpoint(y, x) == Endpoint.CIRCLE && mag.getEndpoint(x, y) == Endpoint.ARROW) {
                    mag.setEndpoint(y, x, Endpoint.TAIL);
                }
                if (mag.getEndpoint(y, x) == Endpoint.TAIL && mag.getEndpoint(x, y) == Endpoint.CIRCLE) {
                    mag.setEndpoint(x, y, Endpoint.ARROW);
                }
                if (mag.getEndpoint(y, x) != Endpoint.CIRCLE || mag.getEndpoint(x, y) != Endpoint.CIRCLE) continue;
                pcafci.addEdge(mag.getEdge(x, y));
            }
        }
        for (Edge e : pcafci.getEdges()) {
            e.setEndpoint1(Endpoint.TAIL);
            e.setEndpoint2(Endpoint.TAIL);
        }
        block4: while (true) {
            for (Edge e : pcafci.getEdges()) {
                if (!Edges.isUndirectedEdge(e)) continue;
                x = e.getNode1();
                y = e.getNode2();
                pcafci.setEndpoint(y, x, Endpoint.TAIL);
                pcafci.setEndpoint(x, y, Endpoint.ARROW);
                MeekRules meekRules = new MeekRules();
                meekRules.setRevertToUnshieldedColliders(false);
                meekRules.orientImplied(pcafci);
                continue block4;
            }
            break;
        }
        for (Edge e : pcafci.getEdges()) {
            mag.removeEdge(e.getNode1(), e.getNode2());
            mag.addEdge(e);
        }
        return mag;
    }

    public static LegalPagRet isLegalPag(Graph pag) {
        for (Node n : pag.getNodes()) {
            if (n.getNodeType() == NodeType.MEASURED) continue;
            return new LegalPagRet(false, "Node " + n + " is not measured");
        }
        Graph mag = SearchGraphUtils.pagToMag(pag);
        LegalMagRet legalMag = SearchGraphUtils.isLegalMag(mag);
        if (!legalMag.isLegalMag()) {
            return new LegalPagRet(false, legalMag.getReason() + " in a MAG implied by this graph");
        }
        Graph pag2 = SearchGraphUtils.dagToPag(mag);
        if (!pag.equals(pag2)) {
            String edgeMismatch = "";
            for (Edge e : pag.getEdges()) {
                Edge e2;
                if (e.equals(e2 = pag2.getEdge(e.getNode1(), e.getNode2()))) continue;
                edgeMismatch = "For example, the original PAG has edge " + e + " whereas the reconstituted PAG has edge " + e2;
            }
            String reason = "Could be a MAG or between a MAG and a PAG; cannot recover the original graph by finding the PAG of an implied MAG";
            if (!edgeMismatch.equals("")) {
                reason = reason + ". " + edgeMismatch;
            }
            return new LegalPagRet(false, reason);
        }
        return new LegalPagRet(true, "This is a legal PAG");
    }

    private static LegalMagRet isLegalMag(Graph mag) {
        int i;
        Edge e;
        Node y;
        Node x;
        for (Node n : mag.getNodes()) {
            if (n.getNodeType() != NodeType.LATENT) continue;
            return new LegalMagRet(false, "Node " + n + " is not measured");
        }
        List<Node> nodes = mag.getNodes();
        for (int i2 = 0; i2 < nodes.size(); ++i2) {
            for (int j = i2 + 1; j < nodes.size(); ++j) {
                x = nodes.get(i2);
                if (!mag.isAdjacentTo(x, y = nodes.get(j))) continue;
                if (mag.getEdges(x, y).size() > 1) {
                    return new LegalMagRet(false, "There is more than one edge between " + x + " and " + y);
                }
                e = mag.getEdge(x, y);
                if (Edges.isDirectedEdge(e) || Edges.isBidirectedEdge(e) || Edges.isUndirectedEdge(e)) continue;
                return new LegalMagRet(false, "Edge " + e + " should be directed, bidirected, or undirected.");
            }
        }
        for (Node n : mag.getNodes()) {
            if (!mag.paths().existsDirectedPathFromTo(n, n)) continue;
            return new LegalMagRet(false, "Acyclicity violated: There is a directed cyclic path from from " + n + " to itself");
        }
        for (Edge e2 : mag.getEdges()) {
            List<Node> path;
            x = e2.getNode1();
            y = e2.getNode2();
            if (!Edges.isBidirectedEdge(e2)) continue;
            if (mag.paths().existsDirectedPathFromTo(x, y)) {
                path = mag.paths().directedPathsFromTo(x, y, 100).get(0);
                return new LegalMagRet(false, "Bidirected edge semantics violated: there is a directed path for " + e2 + " from " + x + " to " + y + ". This is \"almost cyclic\"; for <-> edges there should not be a path from either endpoint to the other. An example path is " + GraphUtils.pathString(mag, path));
            }
            if (!mag.paths().existsDirectedPathFromTo(y, x)) continue;
            path = mag.paths().directedPathsFromTo(y, x, 100).get(0);
            return new LegalMagRet(false, "Bidirected edge semantics violated: There is an a directed path for " + e2 + " from " + y + " to " + x + ". This is \"almost cyclic\"; for <-> edges there should not be a path from either endpoint to the other. An example path is " + GraphUtils.pathString(mag, path));
        }
        for (i = 0; i < nodes.size(); ++i) {
            for (int j = i + 1; j < nodes.size(); ++j) {
                x = nodes.get(i);
                if (mag.isAdjacentTo(x, y = nodes.get(j)) || !mag.paths().existsInducingPath(x, y)) continue;
                return new LegalMagRet(false, "This is not maximal; there is an inducing path between non-adjacent " + x + " and " + y);
            }
        }
        for (i = 0; i < nodes.size(); ++i) {
            for (int j = i + 1; j < nodes.size(); ++j) {
                x = nodes.get(i);
                if (!mag.isAdjacentTo(x, y = nodes.get(j)) || !Edges.isUndirectedEdge(e = mag.getEdge(x, y))) continue;
                for (Node z : mag.getAdjacentNodes(x)) {
                    if (!mag.isParentOf(z, x) && !Edges.isBidirectedEdge(mag.getEdge(z, x))) continue;
                    return new LegalMagRet(false, "For undirected edge " + e + ", " + z + " should not be a parent or a spouse of " + x);
                }
                for (Node z : mag.getAdjacentNodes(y)) {
                    if (!mag.isParentOf(z, y) && !Edges.isBidirectedEdge(mag.getEdge(z, y))) continue;
                    return new LegalMagRet(false, "For undirected edge " + e + ", " + z + " should not be a parent or a spouse of " + y);
                }
            }
        }
        return new LegalMagRet(true, "This is a legal MAG");
    }

    public static void arrangeByKnowledgeTiers(Graph graph, Knowledge knowledge) {
        if (knowledge.getNumTiers() == 0) {
            throw new IllegalArgumentException("There are no Tiers to arrange.");
        }
        int ySpace = 500 / knowledge.getNumTiers();
        ySpace = FastMath.max(ySpace, 50);
        List<String> notInTier = knowledge.getVariablesNotInTiers();
        Collections.sort(notInTier);
        int x = 0;
        int y = 50 - ySpace;
        if (notInTier.size() > 0) {
            y += ySpace;
            for (String name : notInTier) {
                x += 90;
                Node node = graph.getNode(name);
                if (node == null) continue;
                node.setCenterX(x);
                node.setCenterY(y);
            }
        }
        for (int i = 0; i < knowledge.getNumTiers(); ++i) {
            List<String> tier = knowledge.getTier(i);
            Collections.sort(tier);
            y += ySpace;
            x = -25;
            for (String name : tier) {
                x += 90;
                Node node = graph.getNode(name);
                if (node == null) continue;
                node.setCenterX(x);
                node.setCenterY(y);
            }
        }
    }

    public static void arrangeByKnowledgeTiers(Graph graph) {
        int maxLag = 0;
        for (Node node : graph.getNodes()) {
            String name = node.getName();
            String[] tokens1 = name.split(":");
            int index = tokens1.length > 1 ? Integer.parseInt(tokens1[tokens1.length - 1]) : 0;
            if (index < maxLag) continue;
            maxLag = index;
        }
        ArrayList tiers = new ArrayList();
        for (int i = 0; i <= maxLag; ++i) {
            tiers.add(new ArrayList());
        }
        for (Node node : graph.getNodes()) {
            String name = node.getName();
            String[] tokens = name.split(":");
            int index = tokens.length > 1 ? Integer.parseInt(tokens[tokens.length - 1]) : 0;
            if (((List)tiers.get(index)).contains(node)) continue;
            ((List)tiers.get(index)).add(node);
        }
        for (int i = 0; i <= maxLag; ++i) {
            Collections.sort((List)tiers.get(i));
        }
        int ySpace = maxLag == 0 ? 150 : 150 / maxLag;
        int y = 60;
        for (int i = maxLag; i >= 0; --i) {
            List tier = (List)tiers.get(i);
            int x = 60;
            for (Node node : tier) {
                System.out.println(node + " " + x + " " + y);
                node.setCenterX(x);
                node.setCenterY(y);
                x += 90;
            }
            y += ySpace;
        }
    }

    public static Set<Node> getReachableNodes(List<Node> initialNodes, LegalPairs legalPairs, List<Node> c, List<Node> d, Graph graph, int maxPathLength) {
        HashSet<Node> reachable = new HashSet<Node>();
        MultiKeyMap<Node, Boolean> visited = new MultiKeyMap<Node, Boolean>();
        LinkedList<ReachabilityEdge> nextEdges = new LinkedList<ReachabilityEdge>();
        for (Node x : initialNodes) {
            List<Node> adjX = graph.getAdjacentNodes(x);
            for (Node y : adjX) {
                if (!legalPairs.isLegalFirstEdge(x, y)) continue;
                reachable.add(y);
                nextEdges.add(new ReachabilityEdge(x, y));
                visited.put(x, y, Boolean.TRUE);
            }
        }
        int pathLength = 1;
        while (nextEdges.size() > 0) {
            if (++pathLength > maxPathLength) {
                return reachable;
            }
            LinkedList<ReachabilityEdge> currEdges = nextEdges;
            nextEdges = new LinkedList();
            for (ReachabilityEdge edge : currEdges) {
                Node x = edge.getFrom();
                Node y = edge.getTo();
                List<Node> adjY = graph.getAdjacentNodes(y);
                for (Node z : adjY) {
                    if (visited.get(y, z) == Boolean.TRUE || !legalPairs.isLegalPair(x, y, z, c, d)) continue;
                    reachable.add(z);
                    nextEdges.add(new ReachabilityEdge(y, z));
                    visited.put(y, z, Boolean.TRUE);
                }
            }
        }
        return reachable;
    }

    public static Node translate(String a, List<Node> nodes) {
        for (Node node : nodes) {
            if (!node.getName().equals(a)) continue;
            return node;
        }
        return null;
    }

    public static List<Set<Node>> powerSet(List<Node> nodes) {
        ArrayList<Set<Node>> subsets = new ArrayList<Set<Node>>();
        int total = (int)FastMath.pow(2.0, nodes.size());
        for (int i = 0; i < total; ++i) {
            HashSet<Node> newSet = new HashSet<Node>();
            String selection = Integer.toBinaryString(i);
            for (int j = selection.length() - 1; j >= 0; --j) {
                if (selection.charAt(j) != '1') continue;
                newSet.add(nodes.get(selection.length() - j - 1));
            }
            subsets.add(newSet);
        }
        return subsets;
    }

    public static boolean isArrowpointAllowed1(Node from, Node to, Knowledge knowledge) {
        if (knowledge == null) {
            return true;
        }
        return !knowledge.isRequired(to.toString(), from.toString()) && !knowledge.isForbidden(from.toString(), to.toString());
    }

    public static List<Graph> generateCpdagDags(Graph cpdag, boolean orientBidirectedEdges) {
        if (orientBidirectedEdges) {
            cpdag = GraphUtils.removeBidirectedOrientations(cpdag);
        }
        return SearchGraphUtils.getDagsInCpdagMeek(cpdag, new Knowledge());
    }

    public static List<Graph> getDagsInCpdagMeek(Graph cpdag, Knowledge knowledge) {
        DagInCPDAGIterator iterator = new DagInCPDAGIterator(cpdag, knowledge);
        ArrayList<Graph> dags = new ArrayList<Graph>();
        while (iterator.hasNext()) {
            Graph graph = iterator.next();
            try {
                if (knowledge.isViolatedBy(graph)) continue;
                dags.add(graph);
            }
            catch (IllegalArgumentException e) {
                System.out.println("Found a non-DAG: " + graph);
            }
        }
        return dags;
    }

    public static List<Graph> getAllGraphsByDirectingUndirectedEdges(Graph skeleton) {
        int[] comb;
        ArrayList<Graph> graphs = new ArrayList<Graph>();
        ArrayList<Edge> edges = new ArrayList<Edge>(skeleton.getEdges());
        ArrayList<Integer> undirectedIndices = new ArrayList<Integer>();
        for (int i = 0; i < edges.size(); ++i) {
            if (!Edges.isUndirectedEdge((Edge)edges.get(i))) continue;
            undirectedIndices.add(i);
        }
        int[] dims = new int[undirectedIndices.size()];
        for (int i = 0; i < undirectedIndices.size(); ++i) {
            dims[i] = 2;
        }
        CombinationGenerator gen = new CombinationGenerator(dims);
        while ((comb = gen.next()) != null) {
            EdgeListGraph graph = new EdgeListGraph(skeleton.getNodes());
            for (Edge edge : edges) {
                if (Edges.isUndirectedEdge(edge)) continue;
                graph.addEdge(edge);
            }
            for (int i = 0; i < undirectedIndices.size(); ++i) {
                Edge edge;
                edge = (Edge)edges.get((Integer)undirectedIndices.get(i));
                Node node1 = edge.getNode1();
                Node node2 = edge.getNode2();
                if (comb[i] == 1) {
                    graph.addEdge(Edges.directedEdge(node1, node2));
                    continue;
                }
                graph.addEdge(Edges.directedEdge(node2, node1));
            }
            graphs.add(graph);
        }
        return graphs;
    }

    public static CpcTripleType getCpcTripleType(Node x, Node y, Node z, IndependenceTest test, int depth, Graph graph) {
        List<Node> cond;
        int[] choice;
        ChoiceGenerator cg;
        int d;
        int numSepsetsContainingY = 0;
        int numSepsetsNotContainingY = 0;
        List<Node> _nodes = graph.getAdjacentNodes(x);
        _nodes.remove(z);
        TetradLogger.getInstance().log("adjacencies", "Adjacents for " + x + "--" + y + "--" + z + " = " + _nodes);
        int _depth = depth;
        if (_depth == -1) {
            _depth = 1000;
        }
        _depth = FastMath.min(_depth, _nodes.size());
        for (d = 0; d <= _depth; ++d) {
            cg = new ChoiceGenerator(_nodes.size(), d);
            while ((choice = cg.next()) != null) {
                cond = GraphUtils.asList(choice, _nodes);
                if (test.checkIndependence(x, z, cond).independent()) {
                    if (cond.contains(y)) {
                        ++numSepsetsContainingY;
                    } else {
                        ++numSepsetsNotContainingY;
                    }
                }
                if (numSepsetsContainingY <= 0 || numSepsetsNotContainingY <= 0) continue;
                return CpcTripleType.AMBIGUOUS;
            }
        }
        _nodes = graph.getAdjacentNodes(z);
        _nodes.remove(x);
        TetradLogger.getInstance().log("adjacencies", "Adjacents for " + x + "--" + y + "--" + z + " = " + _nodes);
        _depth = FastMath.min(_depth, _nodes.size());
        for (d = 0; d <= _depth; ++d) {
            cg = new ChoiceGenerator(_nodes.size(), d);
            while ((choice = cg.next()) != null) {
                cond = GraphUtils.asList(choice, _nodes);
                if (test.checkIndependence(x, z, cond).independent()) {
                    if (cond.contains(y)) {
                        ++numSepsetsContainingY;
                    } else {
                        ++numSepsetsNotContainingY;
                    }
                }
                if (numSepsetsContainingY <= 0 || numSepsetsNotContainingY <= 0) continue;
                return CpcTripleType.AMBIGUOUS;
            }
        }
        if (numSepsetsContainingY > 0) {
            return CpcTripleType.NONCOLLIDER;
        }
        return CpcTripleType.COLLIDER;
    }

    public static Graph cpdagForDag(Graph dag) {
        EdgeListGraph cpdag = new EdgeListGraph(dag);
        MeekRules rules = new MeekRules();
        rules.setRevertToUnshieldedColliders(true);
        rules.orientImplied(cpdag);
        return cpdag;
    }

    public static int structuralHammingDistance(Graph trueGraph, Graph estGraph) {
        int shd = 0;
        try {
            estGraph = GraphUtils.replaceNodes(estGraph, trueGraph.getNodes());
            trueGraph = SearchGraphUtils.cpdagForDag(trueGraph);
            estGraph = SearchGraphUtils.cpdagForDag(estGraph);
            if (trueGraph.paths().existsDirectedCycle()) {
                TetradLogger.getInstance().forceLogMessage("SHD failed: True graph couldn't be converted to a CPDAG");
            }
            if (estGraph.paths().existsDirectedCycle()) {
                TetradLogger.getInstance().forceLogMessage("SHD failed: Estimated graph couldn't be converted to a CPDAG");
                return -99;
            }
            List<Node> _allNodes = estGraph.getNodes();
            for (int i1 = 0; i1 < _allNodes.size(); ++i1) {
                for (int i2 = i1 + 1; i2 < _allNodes.size(); ++i2) {
                    Node n1 = _allNodes.get(i1);
                    Node n2 = _allNodes.get(i2);
                    Edge e1 = trueGraph.getEdge(n1, n2);
                    Edge e2 = estGraph.getEdge(n1, n2);
                    if (e1 != null && !Edges.isDirectedEdge(e1) && !Edges.isUndirectedEdge(e1)) {
                        TetradLogger.getInstance().forceLogMessage("SHD failed: True graph couldn't be converted to a CPDAG");
                        return -99;
                    }
                    if (e2 != null && !Edges.isDirectedEdge(e2) && !Edges.isUndirectedEdge(e2)) {
                        TetradLogger.getInstance().forceLogMessage("SHD failed: Estimated graph couldn't be converted to a CPDAG");
                        return -99;
                    }
                    int error = SearchGraphUtils.structuralHammingDistanceOneEdge(e1, e2);
                    shd += error;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return -99;
        }
        return shd;
    }

    private static int structuralHammingDistanceOneEdge(Edge e1, Edge e2) {
        int error = 0;
        if (e1 != null || e2 != null) {
            if (e1 != null && e2 != null) {
                if (!e1.equals(e2)) {
                    System.out.println("Difference " + e1 + " " + e2);
                    ++error;
                }
            } else if (e2 == null) {
                if (Edges.isUndirectedEdge(e1)) {
                    ++error;
                } else {
                    ++error;
                    ++error;
                }
            } else if (Edges.isUndirectedEdge(e2)) {
                ++error;
            } else {
                ++error;
                ++error;
            }
        }
        return error;
    }

    public static GraphUtils.GraphComparison getGraphComparison(Graph trueGraph, Graph targetGraph) {
        Node n2;
        Node n1;
        targetGraph = GraphUtils.replaceNodes(targetGraph, trueGraph.getNodes());
        int adjFn = GraphUtils.countAdjErrors(trueGraph, targetGraph);
        int adjFp = GraphUtils.countAdjErrors(targetGraph, trueGraph);
        int adjCorrect = trueGraph.getNumEdges() - adjFn;
        int arrowptFn = GraphUtils.countArrowptErrors(trueGraph, targetGraph);
        int arrowptFp = GraphUtils.countArrowptErrors(targetGraph, trueGraph);
        int arrowptCorrect = GraphUtils.getNumCorrectArrowpts(trueGraph, targetGraph);
        double adjPrec = (double)adjCorrect / (double)(adjCorrect + adjFp);
        double adjRec = (double)adjCorrect / (double)(adjCorrect + adjFn);
        double arrowptPrec = (double)arrowptCorrect / (double)(arrowptCorrect + arrowptFp);
        double arrowptRec = (double)arrowptCorrect / (double)(arrowptCorrect + arrowptFn);
        boolean twoCycleCorrect = false;
        boolean twoCycleFn = false;
        boolean twoCycleFp = false;
        ArrayList<Edge> edgesAdded = new ArrayList<Edge>();
        ArrayList<Edge> edgesRemoved = new ArrayList<Edge>();
        ArrayList<Edge> edgesReorientedFrom = new ArrayList<Edge>();
        ArrayList<Edge> edgesReorientedTo = new ArrayList<Edge>();
        ArrayList<Edge> correctAdjacency = new ArrayList<Edge>();
        for (Edge edge : trueGraph.getEdges()) {
            n1 = edge.getNode1();
            if (targetGraph.isAdjacentTo(n1, n2 = edge.getNode2())) continue;
            Edge trueGraphEdge = trueGraph.getEdge(n1, n2);
            edgesRemoved.add(trueGraphEdge);
        }
        for (Edge edge : targetGraph.getEdges()) {
            n1 = edge.getNode1();
            if (trueGraph.isAdjacentTo(n1, n2 = edge.getNode2())) continue;
            Edge graphEdge = targetGraph.getEdge(n1, n2);
            edgesAdded.add(graphEdge);
        }
        for (Edge edge : trueGraph.getEdges()) {
            if (targetGraph.containsEdge(edge)) continue;
            Node node1 = edge.getNode1();
            Node node2 = edge.getNode2();
            for (Edge _edge : targetGraph.getEdges(node1, node2)) {
                Endpoint e1a = edge.getProximalEndpoint(node1);
                Endpoint e1b = edge.getProximalEndpoint(node2);
                Endpoint e2a = _edge.getProximalEndpoint(node1);
                Endpoint e2b = _edge.getProximalEndpoint(node2);
                if (!(e1a != Endpoint.CIRCLE && e2a != Endpoint.CIRCLE && e1a != e2a || e1b != Endpoint.CIRCLE && e2b != Endpoint.CIRCLE && e1b != e2b)) continue;
                edgesReorientedFrom.add(edge);
                edgesReorientedTo.add(_edge);
            }
        }
        for (Edge edge : trueGraph.getEdges()) {
            if (!targetGraph.isAdjacentTo(edge.getNode1(), edge.getNode2())) continue;
            correctAdjacency.add(edge);
        }
        int shd = SearchGraphUtils.structuralHammingDistance(trueGraph, targetGraph);
        int[][] counts = SearchGraphUtils.graphComparison(trueGraph, targetGraph, null);
        return new GraphUtils.GraphComparison(adjFn, adjFp, adjCorrect, arrowptFn, arrowptFp, arrowptCorrect, adjPrec, adjRec, arrowptPrec, arrowptRec, shd, 0, 0, 0, edgesAdded, edgesRemoved, edgesReorientedFrom, edgesReorientedTo, correctAdjacency, counts);
    }

    public static GraphUtils.GraphComparison getGraphComparison2(Graph graph, Graph trueGraph) {
        Node y;
        Node x;
        int i;
        Edge graphEdge;
        Edge trueGraphEdge;
        Node n2;
        Node n1;
        graph = GraphUtils.replaceNodes(graph, trueGraph.getNodes());
        GraphUtils.TwoCycleErrors twoCycleErrors = GraphUtils.getTwoCycleErrors(trueGraph, graph);
        int adjFn = GraphUtils.countAdjErrors(trueGraph, graph);
        int adjFp = GraphUtils.countAdjErrors(graph, trueGraph);
        Graph undirectedGraph = GraphUtils.undirectedGraph(graph);
        int adjCorrect = undirectedGraph.getNumEdges() - adjFp;
        ArrayList<Edge> edgesAdded = new ArrayList<Edge>();
        ArrayList<Edge> edgesRemoved = new ArrayList<Edge>();
        ArrayList<Edge> edgesReorientedFrom = new ArrayList<Edge>();
        ArrayList<Edge> edgesReorientedTo = new ArrayList<Edge>();
        ArrayList<Edge> correctAdjacency = new ArrayList<Edge>();
        for (Edge edge : trueGraph.getEdges()) {
            n1 = edge.getNode1();
            if (graph.isAdjacentTo(n1, n2 = edge.getNode2())) continue;
            trueGraphEdge = trueGraph.getEdge(n1, n2);
            graphEdge = graph.getEdge(n1, n2);
            edgesRemoved.add(trueGraphEdge == null ? graphEdge : trueGraphEdge);
        }
        for (Edge edge : graph.getEdges()) {
            n1 = edge.getNode1();
            if (trueGraph.isAdjacentTo(n1, n2 = edge.getNode2())) continue;
            trueGraphEdge = trueGraph.getEdge(n1, n2);
            graphEdge = graph.getEdge(n1, n2);
            edgesAdded.add(trueGraphEdge == null ? graphEdge : trueGraphEdge);
        }
        List<Node> nodes = trueGraph.getNodes();
        int arrowptFn = 0;
        int arrowptFp = 0;
        int arrowptCorrect = 0;
        for (i = 0; i < nodes.size(); ++i) {
            for (int j = i + 1; j < nodes.size(); ++j) {
                boolean _existsArrow;
                if (i == j) continue;
                x = nodes.get(i);
                y = nodes.get(j);
                Edge edge = trueGraph.getEdge(x, y);
                Edge _edge = graph.getEdge(x, y);
                boolean existsArrow = edge != null && edge.getProximalEndpoint(y) == Endpoint.ARROW;
                boolean bl = _existsArrow = _edge != null && _edge.getProximalEndpoint(y) == Endpoint.ARROW;
                if (existsArrow && !_existsArrow) {
                    ++arrowptFn;
                }
                if (!existsArrow && _existsArrow) {
                    ++arrowptFp;
                }
                if (!existsArrow || !_existsArrow) continue;
                ++arrowptCorrect;
            }
        }
        for (i = 0; i < nodes.size(); ++i) {
            for (int j = i + 1; j < nodes.size(); ++j) {
                boolean _existsArrow;
                if (i == j) continue;
                x = nodes.get(i);
                y = nodes.get(j);
                Node _x = graph.getNode(x.getName());
                Node _y = graph.getNode(y.getName());
                Edge edge = trueGraph.getEdge(x, y);
                Edge _edge = graph.getEdge(_x, _y);
                boolean existsArrow = edge != null && edge.getDistalEndpoint(y) == Endpoint.ARROW;
                boolean bl = _existsArrow = _edge != null && _edge.getDistalEndpoint(_y) == Endpoint.ARROW;
                if (existsArrow && !_existsArrow) {
                    ++arrowptFn;
                }
                if (!existsArrow && _existsArrow) {
                    ++arrowptFp;
                }
                if (!existsArrow || !_existsArrow) continue;
                ++arrowptCorrect;
            }
        }
        for (Edge edge : trueGraph.getEdges()) {
            if (graph.containsEdge(edge)) continue;
            Node node1 = edge.getNode1();
            Node node2 = edge.getNode2();
            for (Edge _edge : graph.getEdges(node1, node2)) {
                Endpoint e1a = edge.getProximalEndpoint(node1);
                Endpoint e1b = edge.getProximalEndpoint(node2);
                Endpoint e2a = _edge.getProximalEndpoint(node1);
                Endpoint e2b = _edge.getProximalEndpoint(node2);
                if (!(e1a != Endpoint.CIRCLE && e2a != Endpoint.CIRCLE && e1a != e2a || e1b != Endpoint.CIRCLE && e2b != Endpoint.CIRCLE && e1b != e2b)) continue;
                edgesReorientedFrom.add(edge);
                edgesReorientedTo.add(_edge);
            }
        }
        for (Edge edge : trueGraph.getEdges()) {
            if (!graph.isAdjacentTo(edge.getNode1(), edge.getNode2())) continue;
            correctAdjacency.add(edge);
        }
        double adjPrec = (double)adjCorrect / (double)(adjCorrect + adjFp);
        double adjRec = (double)adjCorrect / (double)(adjCorrect + adjFn);
        double arrowptPrec = (double)arrowptCorrect / (double)(arrowptCorrect + arrowptFp);
        double arrowptRec = (double)arrowptCorrect / (double)(arrowptCorrect + arrowptFn);
        int shd = SearchGraphUtils.structuralHammingDistance(trueGraph, graph);
        graph = GraphUtils.replaceNodes(graph, trueGraph.getNodes());
        int[][] counts = GraphUtils.edgeMisclassificationCounts(trueGraph, graph, false);
        return new GraphUtils.GraphComparison(adjFn, adjFp, adjCorrect, arrowptFn, arrowptFp, arrowptCorrect, adjPrec, adjRec, arrowptPrec, arrowptRec, shd, twoCycleErrors.twoCycCor, twoCycleErrors.twoCycFn, twoCycleErrors.twoCycFp, edgesAdded, edgesRemoved, edgesReorientedFrom, edgesReorientedTo, correctAdjacency, counts);
    }

    /*
     * WARNING - void declaration
     */
    public static String graphComparisonString(String trueGraphName, Graph trueGraph, String targetGraphName, Graph targetGraph, boolean printStars) {
        Edge edge2;
        Edge edge1;
        Node node1;
        trueGraph = new EdgeListGraph(trueGraph);
        targetGraph = new EdgeListGraph(targetGraph);
        StringBuilder builder = new StringBuilder();
        targetGraph = GraphUtils.replaceNodes(targetGraph, trueGraph.getNodes());
        String trueGraphAndTarget = "True graph from " + trueGraphName + "\nTarget graph from " + targetGraphName;
        builder.append(trueGraphAndTarget).append("\n");
        GraphUtils.GraphComparison comparison = SearchGraphUtils.getGraphComparison(trueGraph, targetGraph);
        List<Edge> edgesAdded = comparison.getEdgesAdded();
        ArrayList<Edge> edgesAdded2 = new ArrayList<Edge>();
        for (Edge e1 : edgesAdded) {
            boolean twoCycle2;
            Node n2;
            Node n1 = e1.getNode1();
            boolean twoCycle1 = trueGraph.getDirectedEdge(n1, n2 = e1.getNode2()) != null && trueGraph.getDirectedEdge(n2, n1) != null;
            boolean bl = twoCycle2 = targetGraph.getDirectedEdge(n1, n2) != null && targetGraph.getDirectedEdge(n2, n1) != null;
            if (twoCycle1 || twoCycle2) continue;
            edgesAdded2.add(e1);
        }
        Collections.sort(edgesAdded2);
        builder.append("\nAdjacencies added (not involving 2-cycles and not reoriented):");
        if (edgesAdded2.isEmpty()) {
            builder.append("\n  --NONE--");
        } else {
            for (int i = 0; i < edgesAdded2.size(); ++i) {
                Edge _edge = (Edge)edgesAdded2.get(i);
                Edge edge12 = targetGraph.getEdge(_edge.getNode1(), _edge.getNode2());
                node1 = targetGraph.getNode(edge12.getNode1().getName());
                Node node2 = targetGraph.getNode(edge12.getNode2().getName());
                builder.append("\n").append(i + 1).append(". ").append(edge12);
                if (!printStars) continue;
                boolean directedInGraph2 = false;
                if (Edges.isDirectedEdge(edge12) && targetGraph.paths().existsSemidirectedPath(node1, node2)) {
                    directedInGraph2 = true;
                } else if ((Edges.isUndirectedEdge(edge12) || Edges.isBidirectedEdge(edge12)) && (targetGraph.paths().existsSemidirectedPath(node1, node2) || targetGraph.paths().existsSemidirectedPath(node2, node1))) {
                    directedInGraph2 = true;
                }
                if (!directedInGraph2) continue;
                builder.append(" *");
            }
        }
        builder.append("\n\nAdjacencies removed:");
        List<Edge> edgesRemoved = comparison.getEdgesRemoved();
        Collections.sort(edgesRemoved);
        if (edgesRemoved.isEmpty()) {
            builder.append("\n  --NONE--");
        } else {
            for (int i = 0; i < edgesRemoved.size(); ++i) {
                Edge edge = edgesRemoved.get(i);
                node1 = trueGraph.getNode(edge.getNode1().getName());
                Node node2 = trueGraph.getNode(edge.getNode2().getName());
                builder.append("\n").append(i + 1).append(". ").append(edge);
                if (!printStars) continue;
                boolean directedInGraph1 = false;
                if (Edges.isDirectedEdge(edge) && trueGraph.paths().existsSemidirectedPath(node1, node2)) {
                    directedInGraph1 = true;
                } else if ((Edges.isUndirectedEdge(edge) || Edges.isBidirectedEdge(edge)) && (trueGraph.paths().existsSemidirectedPath(node1, node2) || trueGraph.paths().existsSemidirectedPath(node2, node1))) {
                    directedInGraph1 = true;
                }
                if (!directedInGraph1) continue;
                builder.append(" *");
            }
        }
        ArrayList<Edge> edges1 = new ArrayList<Edge>(trueGraph.getEdges());
        ArrayList<Edge> twoCycles = new ArrayList<Edge>();
        ArrayList<Edge> allSingleEdges = new ArrayList<Edge>();
        for (Edge edge : edges1) {
            if (edge.isDirected() && targetGraph.containsEdge(edge) && targetGraph.containsEdge(edge.reverse())) {
                twoCycles.add(edge);
                continue;
            }
            if (!trueGraph.containsEdge(edge)) continue;
            allSingleEdges.add(edge);
        }
        builder.append("\n\nTwo-cycles in true correctly adjacent in estimated");
        Collections.sort(allSingleEdges);
        if (twoCycles.isEmpty()) {
            builder.append("\n  --NONE--");
        } else {
            for (int i = 0; i < twoCycles.size(); ++i) {
                Edge adj = (Edge)edges1.get(i);
                builder.append("\n").append(i + 1).append(". ").append(adj).append(" ").append(adj.reverse()).append(" ====> ").append(trueGraph.getEdge(((Edge)twoCycles.get(i)).getNode1(), ((Edge)twoCycles.get(i)).getNode2()));
            }
        }
        ArrayList<Edge> incorrect = new ArrayList<Edge>();
        ArrayList compatible = new ArrayList();
        ArrayList incompatible = new ArrayList();
        for (Edge edge : allSingleEdges) {
            Edge edge22;
            Edge edge3 = trueGraph.getEdge(edge.getNode1(), edge.getNode2());
            if (edge3.equals(edge22 = targetGraph.getEdge(edge.getNode1(), edge.getNode2()))) continue;
            incorrect.add(edge);
        }
        builder.append("\n\nEdges incorrectly oriented");
        if (incorrect.isEmpty()) {
            builder.append("\n  --NONE--");
        } else {
            int j1 = 0;
            Collections.sort(incorrect);
            for (Edge edge : incorrect) {
                edge1 = trueGraph.getEdge(edge.getNode1(), edge.getNode2());
                edge2 = targetGraph.getEdge(edge.getNode1(), edge.getNode2());
                if (edge1 == null || edge2 == null) continue;
                builder.append("\n").append(++j1).append(". ").append(edge1).append(" ====> ").append(edge2);
            }
        }
        builder.append("\n\nEdges correctly oriented");
        ArrayList<Edge> correct = new ArrayList<Edge>();
        for (Edge edge : allSingleEdges) {
            edge1 = trueGraph.getEdge(edge.getNode1(), edge.getNode2());
            if (!edge1.equals(edge2 = targetGraph.getEdge(edge.getNode1(), edge.getNode2()))) continue;
            correct.add(edge1);
        }
        if (correct.isEmpty()) {
            builder.append("\n  --NONE--");
        } else {
            Collections.sort(correct);
            boolean bl = false;
            for (Edge edge : correct) {
                void var18_35;
                builder.append("\n").append((int)(++var18_35)).append(". ").append(edge);
            }
        }
        return builder.toString();
    }

    public static int[][] graphComparison(Graph trueCpdag, Graph estCpdag, PrintStream out) {
        GraphUtils.GraphComparison comparison = SearchGraphUtils.getGraphComparison2(estCpdag, trueCpdag);
        if (out != null) {
            out.println("Adjacencies:");
        }
        int adjTp = comparison.getAdjCor();
        int adjFp = comparison.getAdjFp();
        int adjFn = comparison.getAdjFn();
        int arrowptTp = comparison.getAhdCor();
        int arrowptFp = comparison.getAhdFp();
        int arrowptFn = comparison.getAhdFn();
        if (out != null) {
            out.println("TP " + adjTp + " FP = " + adjFp + " FN = " + adjFn);
            out.println("Arrow Orientations:");
            out.println("TP " + arrowptTp + " FP = " + arrowptFp + " FN = " + arrowptFn);
        }
        estCpdag = GraphUtils.replaceNodes(estCpdag, trueCpdag.getNodes());
        int[][] counts = GraphUtils.edgeMisclassificationCounts(trueCpdag, estCpdag, false);
        if (out != null) {
            out.println(GraphUtils.edgeMisclassifications(counts));
        }
        double adjRecall = (double)adjTp / (double)(adjTp + adjFn);
        double adjPrecision = (double)adjTp / (double)(adjTp + adjFp);
        double arrowRecall = (double)arrowptTp / (double)(arrowptTp + arrowptFn);
        double arrowPrecision = (double)arrowptTp / (double)(arrowptTp + arrowptFp);
        DecimalFormat nf = new DecimalFormat("0.0");
        if (out != null) {
            out.println();
            out.println("APRE\tAREC\tOPRE\tOREC");
            out.println(nf.format(adjPrecision * 100.0) + "%\t" + nf.format(adjRecall * 100.0) + "%\t" + nf.format(arrowPrecision * 100.0) + "%\t" + nf.format(arrowRecall * 100.0) + "%");
            out.println();
        }
        return counts;
    }

    @NotNull
    public static Graph dagToPag(Graph trueGraph) {
        return new DagToPag(trueGraph).convert();
    }

    public static class LegalPagRet {
        private final boolean legalPag;
        private final String reason;

        public LegalPagRet(boolean legalPag, String reason) {
            if (reason == null) {
                throw new NullPointerException("Reason must be given.");
            }
            this.legalPag = legalPag;
            this.reason = reason;
        }

        public boolean isLegalPag() {
            return this.legalPag;
        }

        public String getReason() {
            return this.reason;
        }
    }

    public static class LegalMagRet {
        private final boolean legalMag;
        private final String reason;

        public LegalMagRet(boolean legalPag, String reason) {
            if (reason == null) {
                throw new NullPointerException("Reason must be given.");
            }
            this.legalMag = legalPag;
            this.reason = reason;
        }

        public boolean isLegalMag() {
            return this.legalMag;
        }

        public String getReason() {
            return this.reason;
        }
    }

    private static class ReachabilityEdge {
        private final Node from;
        private final Node to;

        public ReachabilityEdge(Node from, Node to) {
            this.from = from;
            this.to = to;
        }

        public int hashCode() {
            int hash = 17;
            hash += 63 * this.getFrom().hashCode();
            return hash += 71 * this.getTo().hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ReachabilityEdge)) {
                return false;
            }
            ReachabilityEdge edge = (ReachabilityEdge)obj;
            if (!edge.getFrom().equals(this.getFrom())) {
                return false;
            }
            return edge.getTo().equals(this.getTo());
        }

        public Node getFrom() {
            return this.from;
        }

        public Node getTo() {
            return this.to;
        }
    }

    public static enum CpcTripleType {
        COLLIDER,
        NONCOLLIDER,
        AMBIGUOUS;

    }
}

