/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.NumberFormatUtil;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.List;

public class SearchLogUtils {
    public static String edgeOrientedMsg(String reason, Edge edge) {
        return "Orienting edge (" + reason + "): " + edge;
    }

    public static String colliderOrientedMsg(String note, Node x, Node y, Node z) {
        return "Orienting collider (" + note + "): " + x.getName() + " *-> " + y.getName() + " <-* " + z.getName();
    }

    public static String colliderOrientedMsg(Node x, Node y, Node z) {
        return "Orienting collider: " + x.getName() + " *-> " + y.getName() + " <-* " + z.getName();
    }

    public static String colliderOrientedMsg(Node x, Node y, Node z, List<Node> sepset) {
        return "Orienting collider: " + x.getName() + " *-&gt; " + y.getName() + " <-* " + z.getName() + "\t(Sepset = " + sepset + ")";
    }

    public static String determinismDetected(List<Node> sepset, Node x) {
        return "Determinism detected: " + sepset + " -> " + x.getName();
    }

    public static String independenceFactMsg(Node x, Node y, List<Node> condSet, double pValue) {
        StringBuilder sb = new StringBuilder();
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        sb.append("Independence accepted: ");
        sb.append(SearchLogUtils.independenceFact(x, y, condSet));
        if (!Double.isNaN(pValue)) {
            sb.append("\tp = ").append(nf.format(pValue));
        }
        return sb.toString();
    }

    public static String dependenceFactMsg(Node x, Node y, List<Node> condSet, double pValue) {
        StringBuilder sb = new StringBuilder();
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        sb.append("Dependent: ");
        sb.append(SearchLogUtils.independenceFact(x, y, condSet));
        if (!Double.isNaN(pValue)) {
            sb.append("\tp = ").append(nf.format(pValue));
        }
        return sb.toString();
    }

    public static String independenceFact(Node x, Node y, List<Node> condSet) {
        StringBuilder sb = new StringBuilder();
        sb.append(x.getName());
        sb.append(" _||_ ");
        sb.append(y.getName());
        Iterator<Node> it = condSet.iterator();
        if (it.hasNext()) {
            sb.append(" | ");
            sb.append(it.next());
        }
        while (it.hasNext()) {
            sb.append(", ");
            sb.append(it.next());
        }
        return sb.toString();
    }
}

