/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.Score;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.Vector;
import java.util.List;
import org.apache.commons.math3.linear.SingularMatrixException;
import org.apache.commons.math3.util.FastMath;

public class SemBicScoreDeterministic
implements Score {
    private ICovarianceMatrix covariances;
    private List<Node> variables;
    private final int sampleSize;
    private double penaltyDiscount = 1.0;
    private boolean verbose;
    private double determinismThreshold = 0.1;

    public SemBicScoreDeterministic(ICovarianceMatrix covariances) {
        if (covariances == null) {
            throw new NullPointerException();
        }
        this.setCovariances(covariances);
        this.variables = covariances.getVariables();
        this.sampleSize = covariances.getSampleSize();
    }

    @Override
    public double localScore(int i, int ... parents) {
        double small = this.getDeterminismThreshold();
        double s2 = this.getCovariances().getValue(i, i);
        int p = parents.length;
        Matrix covxx = this.getSelection(this.getCovariances(), parents, parents);
        Vector covxy = this.getSelection(this.getCovariances(), parents, new int[]{i}).getColumn(0);
        try {
            s2 -= covxx.inverse().times(covxy).dotProduct(covxy);
        }
        catch (SingularMatrixException e) {
            s2 = 0.0;
        }
        int n = this.getSampleSize();
        int k = 2 * p + 1;
        if (s2 < small) {
            s2 = 0.0;
        }
        if (s2 == 0.0) {
            return Double.NaN;
        }
        double score = (double)(-n) * FastMath.log(s2) - this.getPenaltyDiscount() * (double)k * FastMath.log(n);
        if (Double.isNaN(score) || Double.isInfinite(score)) {
            return Double.NaN;
        }
        return score;
    }

    @Override
    public double localScoreDiff(int x, int y, int[] z) {
        double v1 = this.localScore(y, this.append(z, x));
        double v2 = this.localScore(y, z);
        double v3 = this.localScore(y, x);
        if (Double.isNaN(v1) && !Double.isNaN(v2) && !Double.isNaN(v3)) {
            return Double.NaN;
        }
        if (Double.isNaN(v1) || Double.isNaN(v2) || Double.isNaN(v3)) {
            return Double.NEGATIVE_INFINITY;
        }
        return v1 - v2;
    }

    @Override
    public double localScoreDiff(int x, int y) {
        return this.localScoreDiff(x, y, new int[0]);
    }

    private int[] append(int[] parents, int extra) {
        int[] all = new int[parents.length + 1];
        System.arraycopy(parents, 0, all, 1, parents.length);
        all[0] = extra;
        return all;
    }

    @Override
    public double localScore(int i, int parent) {
        return this.localScore(i, new int[]{parent});
    }

    @Override
    public double localScore(int i) {
        return this.localScore(i, new int[0]);
    }

    public double getPenaltyDiscount() {
        return this.penaltyDiscount;
    }

    public ICovarianceMatrix getCovariances() {
        return this.covariances;
    }

    @Override
    public int getSampleSize() {
        return this.sampleSize;
    }

    @Override
    public boolean isEffectEdge(double bump) {
        return bump > 0.0;
    }

    public DataSet getDataSet() {
        throw new UnsupportedOperationException();
    }

    public void setPenaltyDiscount(double penaltyDiscount) {
        this.penaltyDiscount = penaltyDiscount;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public List<Node> getVariables() {
        return this.variables;
    }

    private Matrix getSelection(ICovarianceMatrix cov, int[] rows, int[] cols) {
        return cov.getSelection(rows, cols);
    }

    private void setCovariances(ICovarianceMatrix covariances) {
        this.covariances = covariances;
    }

    public void setVariables(List<Node> variables) {
        this.covariances.setVariables(variables);
        this.variables = variables;
    }

    @Override
    public Node getVariable(String targetName) {
        for (Node node : this.variables) {
            if (!node.getName().equals(targetName)) continue;
            return node;
        }
        return null;
    }

    @Override
    public int getMaxDegree() {
        return (int)FastMath.ceil(FastMath.log(this.sampleSize));
    }

    @Override
    public boolean determines(List<Node> z, Node y) {
        int i = this.variables.indexOf(y);
        int[] parents = new int[z.size()];
        for (int t = 0; t < z.size(); ++t) {
            parents[t] = this.variables.indexOf(z.get(t));
        }
        double small = this.getDeterminismThreshold();
        try {
            double s2 = this.getCovariances().getValue(i, i);
            Matrix covxx = this.getSelection(this.getCovariances(), parents, parents);
            Vector covxy = this.getSelection(this.getCovariances(), parents, new int[]{i}).getColumn(0);
            s2 -= covxx.inverse().times(covxy).dotProduct(covxy);
            if (s2 <= small) {
                return true;
            }
        }
        catch (SingularMatrixException ignored) {
            throw new RuntimeException("Singular");
        }
        return false;
    }

    public double getDeterminismThreshold() {
        return this.determinismThreshold;
    }

    public void setDeterminismThreshold(double determinismThreshold) {
        this.determinismThreshold = determinismThreshold;
    }
}

