/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.ISemBicScore;
import edu.cmu.tetrad.search.SemBicScore;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.util.FastMath;

public class SemBicScoreImages
implements ISemBicScore {
    private final List<SemBicScore> semBicScores;
    private final List<Node> variables;
    private final int sampleSize;
    private double penaltyDiscount = 2.0;
    private boolean verbose;

    public SemBicScoreImages(List<DataModel> dataModels) {
        if (dataModels == null) {
            throw new NullPointerException();
        }
        ArrayList<SemBicScore> semBicScores = new ArrayList<SemBicScore>();
        for (DataModel model : dataModels) {
            if (model instanceof DataSet) {
                DataSet dataSet = (DataSet)model;
                if (!dataSet.isContinuous()) {
                    throw new IllegalArgumentException("Datasets must be continuous.");
                }
                SemBicScore semBicScore = new SemBicScore(dataSet);
                semBicScore.setPenaltyDiscount(this.penaltyDiscount);
                semBicScores.add(semBicScore);
                continue;
            }
            if (model instanceof ICovarianceMatrix) {
                SemBicScore semBicScore = new SemBicScore((ICovarianceMatrix)model);
                semBicScore.setPenaltyDiscount(this.penaltyDiscount);
                semBicScores.add(semBicScore);
                continue;
            }
            throw new IllegalArgumentException("Only continuous data sets and covariance matrices may be used as input.");
        }
        List<Node> variables = ((SemBicScore)semBicScores.get(0)).getVariables();
        for (int i = 2; i < semBicScores.size(); ++i) {
            ((SemBicScore)semBicScores.get(i)).setVariables(variables);
        }
        this.semBicScores = semBicScores;
        this.variables = variables;
        this.sampleSize = ((SemBicScore)semBicScores.get(0)).getSampleSize();
    }

    @Override
    public double localScoreDiff(int x, int y, int[] z) {
        double sum = 0.0;
        for (SemBicScore score : this.semBicScores) {
            sum += score.localScoreDiff(x, y, z);
        }
        return sum / (double)this.semBicScores.size();
    }

    @Override
    public double localScoreDiff(int x, int y) {
        return this.localScoreDiff(x, y, new int[0]);
    }

    @Override
    public double localScore(int i, int[] parents) {
        double sum = 0.0;
        int count = 0;
        for (SemBicScore score : this.semBicScores) {
            double _score = score.localScore(i, parents);
            if (Double.isNaN(_score)) continue;
            sum += _score;
            ++count;
        }
        double score = sum / (double)count;
        if (Double.isNaN(score) || Double.isInfinite(score)) {
            return Double.NaN;
        }
        return score;
    }

    public double localScore(int i, int[] parents, int index) {
        return this.localScoreOneDataSet(i, parents, index);
    }

    private double localScoreOneDataSet(int i, int[] parents, int index) {
        return this.semBicScores.get(index).localScore(i, parents);
    }

    @Override
    public double localScore(int i, int parent) {
        double sum = 0.0;
        int count = 0;
        for (SemBicScore score : this.semBicScores) {
            double _score = score.localScore(i, parent);
            if (Double.isNaN(_score)) continue;
            sum += _score;
            ++count;
        }
        return sum / (double)count;
    }

    @Override
    public double localScore(int i) {
        double sum = 0.0;
        int count = 0;
        for (SemBicScore score : this.semBicScores) {
            double _score = score.localScore(i);
            if (Double.isNaN(_score)) continue;
            sum += _score;
            ++count;
        }
        return sum / (double)count;
    }

    @Override
    public double getPenaltyDiscount() {
        return this.penaltyDiscount;
    }

    @Override
    public boolean isEffectEdge(double bump) {
        return bump > -0.25 * this.getPenaltyDiscount() * FastMath.log(this.sampleSize);
    }

    public DataSet getDataSet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPenaltyDiscount(double penaltyDiscount) {
        this.penaltyDiscount = penaltyDiscount;
        for (SemBicScore score : this.semBicScores) {
            score.setPenaltyDiscount(penaltyDiscount);
        }
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public List<Node> getVariables() {
        return this.variables;
    }

    @Override
    public int getSampleSize() {
        return this.sampleSize;
    }

    @Override
    public Node getVariable(String targetName) {
        for (Node node : this.variables) {
            if (!node.getName().equals(targetName)) continue;
            return node;
        }
        return null;
    }

    @Override
    public int getMaxDegree() {
        return 1000;
    }

    @Override
    public boolean determines(List<Node> z, Node y) {
        return false;
    }
}

