/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.SemBicScore;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SemBicScorer {
    public static double scoreDag(Graph dag, DataModel data) {
        return SemBicScorer.scoreDag(dag, data, true);
    }

    public static double scoreDag(Graph dag, DataModel data, boolean precomputeCovariances) {
        SemBicScore score;
        if (dag == null) {
            throw new NullPointerException("DAG not specified.");
        }
        if (data instanceof ICovarianceMatrix) {
            score = new SemBicScore((ICovarianceMatrix)((Object)dag));
        } else if (data instanceof DataSet) {
            score = new SemBicScore((DataSet)data);
        } else {
            throw new IllegalArgumentException("Expecting a covariance matrix of a dataset.");
        }
        dag = GraphUtils.replaceNodes(dag, data.getVariables());
        Map<Node, Integer> hashIndices = SemBicScorer.buildIndexing(dag.getNodes());
        double _score = 0.0;
        for (Node node : dag.getNodes()) {
            List<Node> x = dag.getParents(node);
            int[] parentIndices = new int[x.size()];
            int count = 0;
            for (Node parent : x) {
                parentIndices[count++] = hashIndices.get(parent);
            }
            _score += score.localScore((int)hashIndices.get(node), parentIndices);
        }
        return _score;
    }

    private static Map<Node, Integer> buildIndexing(List<Node> nodes) {
        HashMap<Node, Integer> hashIndices = new HashMap<Node, Integer>();
        int i = -1;
        for (Node n : nodes) {
            hashIndices.put(n, ++i);
        }
        return hashIndices;
    }
}

