/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.TetradSerializable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class SepsetMap
implements TetradSerializable {
    static final long serialVersionUID = 23L;
    private Map<Set<Node>, List<Node>> sepsets = new ConcurrentHashMap<Set<Node>, List<Node>>();
    private Map<Set<Node>, Double> pValues = new ConcurrentHashMap<Set<Node>, Double>();
    private final Map<Node, HashSet<Node>> parents = new HashMap<Node, HashSet<Node>>();

    public SepsetMap() {
    }

    public SepsetMap(SepsetMap map) {
        this.sepsets = new HashMap<Set<Node>, List<Node>>(map.sepsets);
        this.pValues = new HashMap<Set<Node>, Double>(map.pValues);
    }

    public static SepsetMap serializableInstance() {
        return new SepsetMap();
    }

    public void set(Node x, Node y, List<Node> z) {
        HashSet<Node> pair = new HashSet<Node>(2);
        pair.add(x);
        pair.add(y);
        if (z == null) {
            this.sepsets.remove(pair);
        } else {
            this.sepsets.put(pair, z);
        }
    }

    public List<Node> get(Node a, Node b) {
        HashSet<Node> pair = new HashSet<Node>(2);
        pair.add(a);
        pair.add(b);
        return this.sepsets.get(pair);
    }

    public double getPValue(Node x, Node y) {
        HashSet<Node> pair = new HashSet<Node>(2);
        pair.add(x);
        pair.add(y);
        return this.pValues.get(pair);
    }

    public void set(Node x, LinkedHashSet<Node> z) {
        if (this.parents.get(x) != null) {
            this.parents.get(x).addAll(z);
        } else {
            this.parents.put(x, z);
        }
    }

    public HashSet<Node> get(Node x) {
        return this.parents.get(x) == null ? new HashSet<Node>() : this.parents.get(x);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof SepsetMap)) {
            return false;
        }
        SepsetMap _sepset = (SepsetMap)o;
        return this.sepsets.equals(_sepset.sepsets);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.sepsets == null) {
            throw new NullPointerException();
        }
    }

    public int size() {
        return this.sepsets.keySet().size();
    }

    public String toString() {
        return this.sepsets.toString();
    }

    public void addAll(SepsetMap newSepsets) {
        this.sepsets.putAll(newSepsets.sepsets);
    }
}

