/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.SepsetMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class SepsetMapDci {
    static final long serialVersionUID = 23L;
    private Map<Set<Node>, List<Node>> sepsets = new HashMap<Set<Node>, List<Node>>();
    private Map<Set<Node>, List<List<Node>>> sepsetSets = new HashMap<Set<Node>, List<List<Node>>>();
    private final Map<Node, LinkedHashSet<Node>> parents = new HashMap<Node, LinkedHashSet<Node>>();

    public SepsetMapDci() {
    }

    public SepsetMapDci(SepsetMapDci map) {
        this.sepsets = new HashMap<Set<Node>, List<Node>>(map.sepsets);
        this.sepsetSets = new HashMap<Set<Node>, List<List<Node>>>(map.sepsetSets);
    }

    public static SepsetMap serializableInstance() {
        return new SepsetMap();
    }

    public void set(Node x, Node y, List<Node> z) {
        HashSet<Node> pair = new HashSet<Node>(2);
        pair.add(x);
        pair.add(y);
        if (this.sepsets.get(pair) == null) {
            this.sepsets.put(pair, z);
        } else {
            ArrayList<Node> newSet = new ArrayList<Node>((Collection)this.sepsets.get(pair));
            newSet.addAll(z);
            this.sepsets.put(pair, newSet);
        }
        if (this.sepsetSets.containsKey(pair)) {
            this.sepsetSets.get(pair).add(new ArrayList<Node>(z));
        } else {
            ArrayList<ArrayList<Node>> condSets = new ArrayList<ArrayList<Node>>();
            condSets.add(new ArrayList<Node>(z));
            this.sepsetSets.put(pair, condSets);
        }
    }

    public List<Node> get(Node x, Node y) {
        HashSet<Node> pair = new HashSet<Node>(2);
        pair.add(x);
        pair.add(y);
        return this.sepsets.get(pair);
    }

    public List<List<Node>> getSet(Node x, Node y) {
        HashSet<Node> pair = new HashSet<Node>(2);
        pair.add(x);
        pair.add(y);
        return this.sepsetSets.get(pair);
    }

    public void set(Node x, LinkedHashSet<Node> z) {
        if (this.parents.get(x) != null) {
            this.parents.get(x).addAll(z);
        } else {
            this.parents.put(x, z);
        }
    }

    public LinkedHashSet<Node> get(Node x) {
        return this.parents.get(x) == null ? new LinkedHashSet<Node>() : this.parents.get(x);
    }

    public Set<Set<Node>> getSeparatedPairs() {
        return this.sepsets.keySet();
    }

    public boolean equals(Object o) {
        if (!(o instanceof SepsetMapDci)) {
            return false;
        }
        SepsetMapDci _sepset = (SepsetMapDci)o;
        return this.sepsets.equals(_sepset.sepsets) && this.sepsetSets.equals(_sepset.sepsetSets);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.sepsets == null) {
            throw new NullPointerException();
        }
    }

    public int size() {
        return this.sepsets.keySet().size();
    }

    public String toString() {
        return this.sepsets.toString() + "\n" + this.sepsetSets.toString();
    }
}

