/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndTestDSep;
import edu.cmu.tetrad.search.IndependenceResult;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.SepsetMap;
import edu.cmu.tetrad.search.SepsetProducer;
import edu.cmu.tetrad.util.ChoiceGenerator;
import java.util.List;
import org.apache.commons.math3.util.FastMath;

public class SepsetsGreedy
implements SepsetProducer {
    private final Graph graph;
    private final IndependenceTest independenceTest;
    private final SepsetMap extraSepsets;
    private int depth;
    private boolean verbose;
    private IndependenceResult result;

    public SepsetsGreedy(Graph graph, IndependenceTest independenceTest, SepsetMap extraSepsets, int depth) {
        this.graph = graph;
        this.independenceTest = independenceTest;
        this.extraSepsets = extraSepsets;
        this.depth = depth;
    }

    @Override
    public List<Node> getSepset(Node i, Node k) {
        return this.getSepsetGreedy(i, k);
    }

    @Override
    public boolean isUnshieldedCollider(Node i, Node j, Node k) {
        List<Node> set = this.getSepsetGreedy(i, k);
        return set != null && !set.contains(j);
    }

    @Override
    public boolean isUnshieldedNoncollider(Node i, Node j, Node k) {
        List<Node> set = this.getSepsetGreedy(i, k);
        return set != null && set.contains(j);
    }

    private List<Node> getSepsetGreedy(Node i, Node k) {
        List<Node> v;
        if (this.extraSepsets != null && (v = this.extraSepsets.get(i, k)) != null) {
            return v;
        }
        List<Node> adji = this.graph.getAdjacentNodes(i);
        List<Node> adjk = this.graph.getAdjacentNodes(k);
        adji.remove(k);
        adjk.remove(i);
        for (int d = 0; d <= FastMath.min(this.depth == -1 ? 1000 : this.depth, FastMath.max(adji.size(), adjk.size())); ++d) {
            List<Node> v2;
            int[] choice;
            ChoiceGenerator gen;
            if (d <= adji.size()) {
                gen = new ChoiceGenerator(adji.size(), d);
                while ((choice = gen.next()) != null) {
                    v2 = GraphUtils.asList(choice, adji);
                    if (!this.getIndependenceTest().checkIndependence(i, k, v2).independent()) continue;
                    return v2;
                }
            }
            if (d > adjk.size()) continue;
            gen = new ChoiceGenerator(adjk.size(), d);
            while ((choice = gen.next()) != null) {
                v2 = GraphUtils.asList(choice, adjk);
                if (!this.getIndependenceTest().checkIndependence(i, k, v2).independent()) continue;
                return v2;
            }
        }
        return null;
    }

    @Override
    public boolean isIndependent(Node a, Node b, List<Node> c) {
        IndependenceResult result;
        this.result = result = this.independenceTest.checkIndependence(a, b, c);
        return result.independent();
    }

    @Override
    public double getScore() {
        return -(this.result.getPValue() - this.independenceTest.getAlpha());
    }

    @Override
    public List<Node> getVariables() {
        return this.independenceTest.getVariables();
    }

    private IndependenceTest getIndependenceTest() {
        return this.independenceTest;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public Graph getDag() {
        if (this.independenceTest instanceof IndTestDSep) {
            return ((IndTestDSep)this.independenceTest).getGraph();
        }
        return null;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }
}

