/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndependenceResult;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.SepsetProducer;
import edu.cmu.tetrad.util.SublistGenerator;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.util.FastMath;

public class SepsetsPossibleDsep
implements SepsetProducer {
    private final Graph graph;
    private final int maxPathLength;
    private final Knowledge knowledge;
    private final int depth;
    private boolean verbose;
    private final IndependenceTest test;
    private IndependenceResult result;

    public SepsetsPossibleDsep(Graph graph, IndependenceTest test, Knowledge knowledge, int depth, int maxPathLength) {
        this.graph = graph;
        this.test = test;
        this.maxPathLength = maxPathLength;
        this.knowledge = knowledge;
        this.depth = depth;
    }

    @Override
    public List<Node> getSepset(Node i, Node k) {
        List<Node> condSet = this.getCondSet(i, k, this.maxPathLength);
        if (condSet == null) {
            condSet = this.getCondSet(k, i, this.maxPathLength);
        }
        return condSet;
    }

    @Override
    public boolean isUnshieldedCollider(Node i, Node j, Node k) {
        List<Node> sepset = this.getSepset(i, k);
        return sepset != null && !sepset.contains(j);
    }

    @Override
    public boolean isUnshieldedNoncollider(Node i, Node j, Node k) {
        List<Node> sepset = this.getSepset(i, k);
        return sepset != null && sepset.contains(j);
    }

    private List<Node> getCondSet(Node node1, Node node2, int maxPathLength) {
        int[] choice;
        List<Node> possibleDsepSet = this.getPossibleDsep(node1, node2, maxPathLength);
        ArrayList<Node> possibleDsep = new ArrayList<Node>(possibleDsepSet);
        boolean noEdgeRequired = this.knowledge.noEdgeRequired(node1.getName(), node2.getName());
        int _depth = this.depth == -1 ? 1000 : this.depth;
        _depth = FastMath.min(_depth, possibleDsep.size());
        SublistGenerator cg = new SublistGenerator(possibleDsep.size(), _depth);
        while ((choice = cg.next()) != null && !Thread.currentThread().isInterrupted()) {
            IndependenceResult result;
            if (choice.length < 1) continue;
            List<Node> condSet = GraphUtils.asList(choice, possibleDsep);
            boolean flagForbid = false;
            for (Node j : condSet) {
                if (this.knowledge.isInWhichTier(j) <= FastMath.max(this.knowledge.isInWhichTier(node1), this.knowledge.isInWhichTier(node2))) continue;
                flagForbid = true;
                break;
            }
            if (flagForbid) continue;
            this.result = result = this.test.checkIndependence(node1, node2, condSet);
            if (!result.independent() || !noEdgeRequired) continue;
            return condSet;
        }
        return null;
    }

    private List<Node> getPossibleDsep(Node x, Node y, int maxPathLength) {
        List<Node> dsep = this.graph.paths().possibleDsep(x, y, maxPathLength);
        if (this.verbose) {
            System.out.println("Possible-D-Sep(" + x + ", " + y + ") = " + dsep);
        }
        return dsep;
    }

    @Override
    public double getScore() {
        return -(this.result.getPValue() - this.test.getAlpha());
    }

    @Override
    public List<Node> getVariables() {
        return this.test.getVariables();
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public boolean isIndependent(Node d, Node c, List<Node> path) {
        IndependenceResult result = this.test.checkIndependence(d, c, path);
        return result.independent();
    }
}

