/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndependenceResult;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.SepsetMap;
import edu.cmu.tetrad.search.SepsetProducer;
import java.util.List;

public class SepsetsSet
implements SepsetProducer {
    private final SepsetMap sepsets;
    private final IndependenceTest test;
    private double p;
    private boolean verbose;
    private IndependenceResult result;

    public SepsetsSet(SepsetMap sepsets, IndependenceTest test) {
        this.sepsets = sepsets;
        this.test = test;
    }

    @Override
    public List<Node> getSepset(Node a, Node b) {
        return this.sepsets.get(a, b);
    }

    @Override
    public boolean isUnshieldedCollider(Node i, Node j, Node k) {
        List<Node> sepset = this.sepsets.get(i, k);
        if (sepset == null) {
            throw new IllegalArgumentException("That triple was covered: " + i + " " + j + " " + k);
        }
        return !sepset.contains(j);
    }

    @Override
    public boolean isUnshieldedNoncollider(Node i, Node j, Node k) {
        List<Node> sepset = this.sepsets.get(i, k);
        if (sepset == null) {
            throw new IllegalArgumentException("That triple was covered: " + i + " " + j + " " + k);
        }
        return sepset.contains(j);
    }

    @Override
    public boolean isIndependent(Node a, Node b, List<Node> c) {
        IndependenceResult result;
        this.result = result = this.test.checkIndependence(a, b, c);
        return result.independent();
    }

    @Override
    public double getScore() {
        return -(this.result.getPValue() - this.test.getAlpha());
    }

    @Override
    public List<Node> getVariables() {
        return this.test.getVariables();
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

