/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.Boss;
import edu.cmu.tetrad.search.SepsetMap;
import edu.cmu.tetrad.search.SepsetProducer;
import edu.cmu.tetrad.search.TeyssierScorer;
import edu.cmu.tetrad.util.ChoiceGenerator;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.util.FastMath;

public class SepsetsTeyssier
implements SepsetProducer {
    private final Graph graph;
    private final TeyssierScorer scorer;
    private final SepsetMap extraSepsets;
    private final int sepsetsDepth;

    public SepsetsTeyssier(Graph graph, TeyssierScorer scorer, SepsetMap extraSepsets, int sepsetsDepth) {
        this.graph = graph;
        this.scorer = scorer;
        this.extraSepsets = extraSepsets;
        this.sepsetsDepth = sepsetsDepth;
    }

    @Override
    public List<Node> getSepset(Node i, Node k) {
        return this.getSepsetGreedy(i, k);
    }

    @Override
    public boolean isUnshieldedCollider(Node i, Node j, Node k) {
        List<Node> set = this.getSepsetGreedy(i, k);
        return set != null && !set.contains(j);
    }

    @Override
    public boolean isUnshieldedNoncollider(Node i, Node j, Node k) {
        List<Node> set = this.getSepsetGreedy(i, k);
        return set != null && set.contains(j);
    }

    private List<Node> getSepsetGreedy(Node i, Node k) {
        List<Node> v;
        if (this.extraSepsets != null && (v = this.extraSepsets.get(i, k)) != null) {
            return v;
        }
        List<Node> adji = this.graph.getAdjacentNodes(i);
        List<Node> adjk = this.graph.getAdjacentNodes(k);
        adji.remove(k);
        adjk.remove(i);
        for (int d = 0; d <= FastMath.min(this.sepsetsDepth == -1 ? 1000 : this.sepsetsDepth, FastMath.max(adji.size(), adjk.size())); ++d) {
            List<Node> v2;
            int[] choice;
            ChoiceGenerator gen;
            if (d <= adji.size()) {
                gen = new ChoiceGenerator(adji.size(), d);
                while ((choice = gen.next()) != null) {
                    v2 = GraphUtils.asList(choice, adji);
                    if (!this.isIndependent(i, k, v2)) continue;
                    return v2;
                }
            }
            if (d > adjk.size()) continue;
            gen = new ChoiceGenerator(adjk.size(), d);
            while ((choice = gen.next()) != null) {
                v2 = GraphUtils.asList(choice, adjk);
                if (!this.isIndependent(i, k, v2)) continue;
                return v2;
            }
        }
        return null;
    }

    @Override
    public boolean isIndependent(Node a, Node b, List<Node> c) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        nodes.addAll(c);
        nodes.add(a);
        nodes.add(b);
        Boss boss = new Boss(this.scorer);
        boss.setAlgType(Boss.AlgType.BOSS1);
        boss.bestOrder(nodes);
        boolean adjacent = this.scorer.adjacent(a, b);
        return !adjacent;
    }

    @Override
    public double getScore() {
        return 0.0;
    }

    @Override
    public List<Node> getVariables() {
        return this.scorer.getPi();
    }

    @Override
    public void setVerbose(boolean verbose) {
    }

    public Graph getDag() {
        return this.scorer.getGraph(false);
    }
}

