/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.Boss;
import edu.cmu.tetrad.search.Individual;
import edu.cmu.tetrad.search.Population;
import edu.cmu.tetrad.search.Score;
import edu.cmu.tetrad.search.SemBicScore;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ForkJoinPool;
import org.apache.commons.math3.util.FastMath;

public class SimpleDemoGA {
    private final Score score;
    private final Population population;
    private int numIterations = 40;

    public SimpleDemoGA(Score score, int numIndividuals) {
        this.score = score;
        this.population = new Population(score, score.getVariables(), numIndividuals);
    }

    public Graph search() {
        this.population.initializePopulation();
        int chunk = FastMath.min(25, this.population.getNumGenes() / 2);
        class MyTask
        implements Callable<Boolean> {
            private final Population population;
            private final int j;
            private final int chunk;

            MyTask(Population population, int j, int chunk) {
                this.population = population;
                this.j = j;
                this.chunk = chunk;
            }

            @Override
            public Boolean call() {
                Individual ind = SimpleDemoGA.this.bossContiguous(this.population.getFittestIndividual(), this.j, this.chunk);
                this.population.add(ind);
                return true;
            }
        }
        ArrayList<MyTask> tasks = new ArrayList<MyTask>();
        for (int k = 0; k < this.numIterations; ++k) {
            for (int i = 0; i < chunk; ++i) {
                for (int j = i; j < this.population.getNumGenes() - chunk; j += chunk) {
                    tasks.add(new MyTask(this.population, j, chunk));
                }
            }
        }
        ForkJoinPool.commonPool().invokeAll(tasks);
        System.out.println("Fitness: " + this.population.getFittestIndividual().getFitness());
        return this.population.getFittestIndividual().getGraph(true);
    }

    private Individual bossContiguous(Individual individual, int start, int chunk) {
        List<Node> pi = individual.getGenes();
        ArrayList<Node> pi2 = new ArrayList<Node>();
        for (int j = 0; j < chunk; ++j) {
            pi2.add(pi.get(start + j));
        }
        SemBicScore score2 = ((SemBicScore)this.score).subset(pi2);
        Boss boss = new Boss(score2);
        boss.setAlgType(Boss.AlgType.BOSS1);
        boss.setVerbose(true);
        List<Node> pi3 = boss.bestOrder(pi2);
        ArrayList<Node> pi4 = new ArrayList<Node>(pi);
        for (int j = 0; j < chunk; ++j) {
            pi4.set(start + j, pi3.get(j));
        }
        return new Individual(this.score, pi4);
    }
}

