/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.Fasts;
import edu.cmu.tetrad.search.GraphSearch;
import edu.cmu.tetrad.search.IFas;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.SepsetMap;
import edu.cmu.tetrad.search.SepsetsPossibleDsep;
import edu.cmu.tetrad.search.SepsetsSet;
import edu.cmu.tetrad.search.SvarFciOrient;
import edu.cmu.tetrad.util.MillisecondTimes;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.math3.util.FastMath;

public final class SvarFci
implements GraphSearch {
    private Graph graph;
    private SepsetMap sepsets;
    private Knowledge knowledge = new Knowledge();
    private final List<Node> variables = new ArrayList<Node>();
    private final IndependenceTest independenceTest;
    private boolean completeRuleSetUsed;
    private int maxPathLength = -1;
    private int depth = -1;
    private final TetradLogger logger = TetradLogger.getInstance();
    private boolean verbose;
    private double penaltyDiscount = 2.0;

    public SvarFci(IndependenceTest independenceTest) {
        if (independenceTest == null) {
            throw new NullPointerException();
        }
        this.independenceTest = independenceTest;
        this.variables.addAll(independenceTest.getVariables());
        this.buildIndexing(independenceTest.getVariables());
    }

    public SvarFci(IndependenceTest independenceTest, List<Node> searchVars) {
        if (independenceTest == null) {
            throw new NullPointerException();
        }
        this.independenceTest = independenceTest;
        this.variables.addAll(independenceTest.getVariables());
        HashSet<Node> remVars = new HashSet<Node>();
        for (Node node1 : this.variables) {
            boolean search = false;
            for (Node node2 : searchVars) {
                if (!node1.getName().equals(node2.getName())) continue;
                search = true;
            }
            if (search) continue;
            remVars.add(node1);
        }
        this.variables.removeAll(remVars);
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        if (depth < -1) {
            throw new IllegalArgumentException("Depth must be -1 (unlimited) or >= 0: " + depth);
        }
        this.depth = depth;
    }

    @Override
    public Graph search() {
        this.getIndependenceTest().getVariables();
        return this.search(new Fasts(this.getIndependenceTest()));
    }

    public Graph search(IFas fas) {
        this.logger.log("info", "Starting FCI algorithm.");
        this.logger.log("info", "Independence test = " + this.getIndependenceTest() + ".");
        fas.setKnowledge(this.getKnowledge());
        fas.setDepth(this.depth);
        fas.setVerbose(this.verbose);
        this.graph = fas.search();
        this.sepsets = fas.getSepsets();
        this.graph.reorientAllWith(Endpoint.CIRCLE);
        SepsetsPossibleDsep sp = new SepsetsPossibleDsep(this.graph, this.independenceTest, this.knowledge, this.depth, this.maxPathLength);
        sp.setVerbose(this.verbose);
        if (this.isPossibleDsepSearchDone()) {
            SvarFciOrient svarFciOrient = new SvarFciOrient(new SepsetsSet(this.sepsets, this.independenceTest), this.independenceTest);
            svarFciOrient.setKnowledge(this.knowledge);
            svarFciOrient.ruleR0(this.graph);
            for (Edge edge : new ArrayList<Edge>(this.graph.getEdges())) {
                Node y;
                Node x = edge.getNode1();
                List<Node> sepset = sp.getSepset(x, y = edge.getNode2());
                if (sepset == null) continue;
                this.graph.removeEdge(x, y);
                this.sepsets.set(x, y, sepset);
                System.out.println("Possible DSEP Removed " + x + "--- " + y + " sepset = " + sepset);
                this.removeSimilarPairs(this.getIndependenceTest(), x, y, sepset);
            }
            this.graph.reorientAllWith(Endpoint.CIRCLE);
        }
        long time5 = MillisecondTimes.timeMillis();
        long time6 = MillisecondTimes.timeMillis();
        this.logger.log("info", "Step CI C: " + (double)(time6 - time5) / 1000.0 + "s");
        SvarFciOrient fciOrient = new SvarFciOrient(new SepsetsSet(this.sepsets, this.independenceTest), this.independenceTest);
        fciOrient.setCompleteRuleSetUsed(this.completeRuleSetUsed);
        fciOrient.setMaxPathLength(this.maxPathLength);
        fciOrient.setKnowledge(this.knowledge);
        fciOrient.ruleR0(this.graph);
        fciOrient.doFinalOrientation(this.graph);
        return this.graph;
    }

    public SepsetMap getSepsets() {
        return this.sepsets;
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    public void setKnowledge(Knowledge knowledge) {
        if (knowledge == null) {
            throw new NullPointerException();
        }
        this.knowledge = knowledge;
    }

    public boolean isCompleteRuleSetUsed() {
        return this.completeRuleSetUsed;
    }

    public void setCompleteRuleSetUsed(boolean completeRuleSetUsed) {
        this.completeRuleSetUsed = completeRuleSetUsed;
    }

    public boolean isPossibleDsepSearchDone() {
        return true;
    }

    public int getMaxPathLength() {
        return this.maxPathLength == Integer.MAX_VALUE ? -1 : this.maxPathLength;
    }

    public void setMaxPathLength(int maxPathLength) {
        if (maxPathLength < -1) {
            throw new IllegalArgumentException("Max path length must be -1 (unlimited) or >= 0: " + maxPathLength);
        }
        this.maxPathLength = maxPathLength;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public IndependenceTest getIndependenceTest() {
        return this.independenceTest;
    }

    public double getPenaltyDiscount() {
        return this.penaltyDiscount;
    }

    public void setPenaltyDiscount(double penaltyDiscount) {
        this.penaltyDiscount = penaltyDiscount;
    }

    private void buildIndexing(List<Node> nodes) {
        ConcurrentHashMap<Node, Integer> hashIndices = new ConcurrentHashMap<Node, Integer>();
        for (Node node : nodes) {
            hashIndices.put(node, this.variables.indexOf(node));
        }
    }

    private void removeSimilarPairs(IndependenceTest test, Node x, Node y, List<Node> condSet) {
        int i;
        System.out.println("Entering removeSimilarPairs method...");
        System.out.println("original independence: " + x + " and " + y + " conditional on " + condSet);
        if (x.getName().equals("time") || y.getName().equals("time")) {
            System.out.println("Not removing similar pairs b/c variable pair includes time.");
            return;
        }
        for (Node tempNode : condSet) {
            if (!tempNode.getName().equals("time")) continue;
            System.out.println("Not removing similar pairs b/c conditioning set includes time.");
            return;
        }
        int ntiers = this.knowledge.getNumTiers();
        int indx_tier = this.knowledge.isInWhichTier(x);
        int indy_tier = this.knowledge.isInWhichTier(y);
        int tier_diff = FastMath.max(indx_tier, indy_tier) - FastMath.min(indx_tier, indy_tier);
        int indx_comp = -1;
        int indy_comp = -1;
        List<String> tier_x = this.knowledge.getTier(indx_tier);
        List<String> tier_y = this.knowledge.getTier(indy_tier);
        for (i = 0; i < tier_x.size(); ++i) {
            if (!this.getNameNoLag(x.getName()).equals(this.getNameNoLag(tier_x.get(i)))) continue;
            indx_comp = i;
            break;
        }
        for (i = 0; i < tier_y.size(); ++i) {
            if (!this.getNameNoLag(y.getName()).equals(this.getNameNoLag(tier_y.get(i)))) continue;
            indy_comp = i;
            break;
        }
        if (indx_comp == -1) {
            System.out.println("WARNING: indx_comp = -1!!!! ");
        }
        if (indy_comp == -1) {
            System.out.println("WARNING: indy_comp = -1!!!! ");
        }
        for (i = 0; i < ntiers - tier_diff && !Thread.currentThread().isInterrupted(); ++i) {
            String tempNode1;
            List<String> new_tier;
            int condAB_tier;
            int cond_diff;
            int j;
            int ind_temp;
            List<String> temptier;
            int ind_temptier;
            ArrayList<Node> condSetAB;
            Node y1;
            Node x1;
            String B;
            String A;
            List<String> tmp_tier2;
            List<String> tmp_tier1;
            if (this.knowledge.getTier(i).size() == 1) continue;
            if (indx_tier >= indy_tier) {
                tmp_tier1 = this.knowledge.getTier(i + tier_diff);
                tmp_tier2 = this.knowledge.getTier(i);
                A = tmp_tier1.get(indx_comp);
                if (A.equals(B = tmp_tier2.get(indy_comp)) || A.equals(tier_x.get(indx_comp)) && B.equals(tier_y.get(indy_comp)) || B.equals(tier_x.get(indx_comp)) && A.equals(tier_y.get(indy_comp))) continue;
                x1 = test.getVariable(A);
                y1 = test.getVariable(B);
                this.graph.removeEdge(x1, y1);
                System.out.println("removed edge between " + x1 + " and " + y1 + " because of structure knowledge");
                condSetAB = new ArrayList<Node>();
                for (Node tempNode : condSet) {
                    if (Thread.currentThread().isInterrupted()) break;
                    ind_temptier = this.knowledge.isInWhichTier(tempNode);
                    temptier = this.knowledge.getTier(ind_temptier);
                    ind_temp = -1;
                    for (j = 0; j < temptier.size() && !Thread.currentThread().isInterrupted(); ++j) {
                        if (!this.getNameNoLag(tempNode.getName()).equals(this.getNameNoLag(temptier.get(j)))) continue;
                        ind_temp = j;
                        break;
                    }
                    cond_diff = indx_tier - ind_temptier;
                    condAB_tier = this.knowledge.isInWhichTier(x1) - cond_diff;
                    if (condAB_tier < 0 || condAB_tier > ntiers - 1 || this.knowledge.getTier(condAB_tier).size() == 1) {
                        System.out.println("Warning: For nodes " + x1 + "," + y1 + " the conditioning variable is outside of window, so not added to SepSet");
                        continue;
                    }
                    new_tier = this.knowledge.getTier(condAB_tier);
                    tempNode1 = new_tier.get(ind_temp);
                    System.out.println("adding variable " + tempNode1 + " to SepSet");
                    condSetAB.add(test.getVariable(tempNode1));
                }
                System.out.println("done");
                this.getSepsets().set(x1, y1, condSetAB);
                continue;
            }
            tmp_tier1 = this.knowledge.getTier(i);
            tmp_tier2 = this.knowledge.getTier(i + tier_diff);
            A = tmp_tier1.get(indx_comp);
            if (A.equals(B = tmp_tier2.get(indy_comp)) || A.equals(tier_x.get(indx_comp)) && B.equals(tier_y.get(indy_comp)) || B.equals(tier_x.get(indx_comp)) && A.equals(tier_y.get(indy_comp))) continue;
            x1 = test.getVariable(A);
            y1 = test.getVariable(B);
            this.graph.removeEdge(x1, y1);
            System.out.println("removed edge between " + x1 + " and " + y1 + " because of structure knowledge");
            condSetAB = new ArrayList();
            for (Node tempNode : condSet) {
                if (Thread.currentThread().isInterrupted()) break;
                ind_temptier = this.knowledge.isInWhichTier(tempNode);
                temptier = this.knowledge.getTier(ind_temptier);
                ind_temp = -1;
                for (j = 0; j < temptier.size(); ++j) {
                    if (!this.getNameNoLag(tempNode.getName()).equals(this.getNameNoLag(temptier.get(j)))) continue;
                    ind_temp = j;
                    break;
                }
                cond_diff = indx_tier - ind_temptier;
                condAB_tier = this.knowledge.isInWhichTier(x1) - cond_diff;
                if (condAB_tier < 0 || condAB_tier > ntiers - 1 || this.knowledge.getTier(condAB_tier).size() == 1) {
                    System.out.println("Warning: For nodes " + x1 + "," + y1 + " the conditioning variable is outside of window, so not added to SepSet");
                    continue;
                }
                new_tier = this.knowledge.getTier(condAB_tier);
                tempNode1 = new_tier.get(ind_temp);
                System.out.println("adding variable " + tempNode1 + " to SepSet");
                condSetAB.add(test.getVariable(tempNode1));
            }
            System.out.println("done");
            this.getSepsets().set(x1, y1, condSetAB);
        }
    }

    public String getNameNoLag(Object obj) {
        String tempS = obj.toString();
        if (tempS.indexOf(58) == -1) {
            return tempS;
        }
        return tempS.substring(0, tempS.indexOf(58));
    }
}

