/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.KnowledgeEdge;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.search.SearchLogUtils;
import edu.cmu.tetrad.search.SepsetProducer;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.util.FastMath;

public final class SvarFciOrient {
    private final SepsetProducer sepsets;
    private Knowledge knowledge = new Knowledge();
    private boolean changeFlag = true;
    private boolean completeRuleSetUsed;
    private boolean possibleDsepSearchDone = true;
    private int maxPathLength = -1;
    private final TetradLogger logger = TetradLogger.getInstance();
    private boolean verbose;
    private Graph truePag;
    private final IndependenceTest independenceTest;

    public SvarFciOrient(SepsetProducer sepsets, IndependenceTest independenceTest) {
        this.sepsets = sepsets;
        this.independenceTest = independenceTest;
    }

    public Graph orient(Graph graph) {
        this.logger.log("info", "Starting FCI algorithm.");
        this.ruleR0(graph);
        if (this.verbose) {
            System.out.println("R0");
        }
        this.doFinalOrientation(graph);
        if (this.verbose) {
            this.logger.log("graph", "Returning graph: " + graph);
        }
        return graph;
    }

    public SepsetProducer getSepsets() {
        return this.sepsets;
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    public void setKnowledge(Knowledge knowledge) {
        if (knowledge == null) {
            throw new NullPointerException();
        }
        this.knowledge = knowledge;
    }

    public boolean isCompleteRuleSetUsed() {
        return this.completeRuleSetUsed;
    }

    public void setCompleteRuleSetUsed(boolean completeRuleSetUsed) {
        this.completeRuleSetUsed = completeRuleSetUsed;
    }

    private List<Node> getSepset(Node i, Node k) {
        return this.sepsets.getSepset(i, k);
    }

    public void ruleR0(Graph graph) {
        graph.reorientAllWith(Endpoint.CIRCLE);
        this.fciOrientbk(this.knowledge, graph, graph.getNodes());
        List<Node> nodes = graph.getNodes();
        for (Node b : nodes) {
            int[] combination;
            List<Node> adjacentNodes = graph.getAdjacentNodes(b);
            if (adjacentNodes.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
            while ((combination = cg.next()) != null) {
                Node a = adjacentNodes.get(combination[0]);
                Node c = adjacentNodes.get(combination[1]);
                if (this.knowledge.isInWhichTier(a) == 0 && this.knowledge.isInWhichTier(b) == 0 && this.knowledge.isInWhichTier(c) == 0) {
                    System.out.println("Skipping triple a,b,c : " + a + " , " + b + " , " + c);
                    continue;
                }
                if (graph.isAdjacentTo(a, c) || graph.isDefCollider(a, b, c) || !this.sepsets.isUnshieldedCollider(a, b, c) || !this.isArrowpointAllowed(a, b, graph) || !this.isArrowpointAllowed(c, b, graph)) continue;
                graph.setEndpoint(a, b, Endpoint.ARROW);
                graph.setEndpoint(c, b, Endpoint.ARROW);
                if (this.verbose) {
                    this.logger.log("colliderOrientations", SearchLogUtils.colliderOrientedMsg(a, b, c));
                    System.out.println(SearchLogUtils.colliderOrientedMsg(a, b, c));
                    String location = "R0";
                    this.printWrongColliderMessage(a, b, c, graph);
                }
                this.orientSimilarPairs(graph, this.knowledge, a, b, Endpoint.ARROW);
                this.orientSimilarPairs(graph, this.knowledge, c, b, Endpoint.ARROW);
            }
        }
    }

    private void printWrongColliderMessage(Node a, Node b, Node c, Graph graph) {
        if (this.truePag != null && graph.isDefCollider(a, b, c) && !this.truePag.isDefCollider(a, b, c)) {
            System.out.println("R0: Orienting collider by mistake: " + a + "*->" + b + "<-*" + c);
        }
    }

    public void doFinalOrientation(Graph graph) {
        if (this.completeRuleSetUsed) {
            this.zhangFinalOrientation(graph);
        } else {
            this.spirtesFinalOrientation(graph);
        }
    }

    private void spirtesFinalOrientation(Graph graph) {
        this.changeFlag = true;
        boolean firstTime = true;
        while (this.changeFlag) {
            this.changeFlag = false;
            this.rulesR1R2cycle(graph);
            this.ruleR3(graph);
            if (this.changeFlag || firstTime && !this.knowledge.isEmpty()) {
                this.ruleR4B(graph);
                firstTime = false;
            }
            if (!this.verbose) continue;
            System.out.println("Epoch");
        }
    }

    private void zhangFinalOrientation(Graph graph) {
        this.changeFlag = true;
        boolean firstTime = true;
        while (this.changeFlag) {
            this.changeFlag = false;
            this.rulesR1R2cycle(graph);
            this.ruleR3(graph);
            if (this.changeFlag || firstTime && !this.knowledge.isEmpty()) {
                this.ruleR4B(graph);
                firstTime = false;
            }
            if (!this.verbose) continue;
            System.out.println("Epoch");
        }
        if (this.isCompleteRuleSetUsed()) {
            this.ruleR5(graph);
            this.changeFlag = true;
            while (this.changeFlag) {
                this.changeFlag = false;
                this.ruleR6R7(graph);
            }
            this.changeFlag = true;
            while (this.changeFlag) {
                this.changeFlag = false;
                this.rulesR8R9R10(graph);
            }
        }
    }

    public void rulesR1R2cycle(Graph graph) {
        List<Node> nodes = graph.getNodes();
        for (Node B : nodes) {
            int[] combination;
            List<Node> adj = graph.getAdjacentNodes(B);
            if (adj.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adj.size(), 2);
            while ((combination = cg.next()) != null) {
                Node A = adj.get(combination[0]);
                Node C = adj.get(combination[1]);
                this.ruleR1(A, B, C, graph);
                this.ruleR1(C, B, A, graph);
                this.ruleR2(A, B, C, graph);
                this.ruleR2(C, B, A, graph);
            }
        }
    }

    private void ruleR1(Node a, Node b, Node c, Graph graph) {
        if (graph.isAdjacentTo(a, c)) {
            return;
        }
        if (graph.getEndpoint(a, b) == Endpoint.ARROW && graph.getEndpoint(c, b) == Endpoint.CIRCLE) {
            if (!this.isArrowpointAllowed(b, c, graph)) {
                return;
            }
            graph.setEndpoint(c, b, Endpoint.TAIL);
            graph.setEndpoint(b, c, Endpoint.ARROW);
            this.changeFlag = true;
            if (this.verbose) {
                this.logger.log("impliedOrientations", SearchLogUtils.edgeOrientedMsg("Away from collider", graph.getEdge(b, c)));
                System.out.println(SearchLogUtils.edgeOrientedMsg("Away from collider", graph.getEdge(b, c)));
            }
            this.orientSimilarPairs(graph, this.getKnowledge(), c, b, Endpoint.TAIL);
            this.orientSimilarPairs(graph, this.getKnowledge(), b, c, Endpoint.ARROW);
        }
    }

    private boolean isNoncollider(Node a, Node b, Node c) {
        return this.sepsets.isUnshieldedNoncollider(a, b, c);
    }

    private void ruleR2(Node a, Node b, Node c, Graph graph) {
        if (graph.isAdjacentTo(a, c) && graph.getEndpoint(a, c) == Endpoint.CIRCLE && graph.getEndpoint(a, b) == Endpoint.ARROW && graph.getEndpoint(b, c) == Endpoint.ARROW && (graph.getEndpoint(b, a) == Endpoint.TAIL || graph.getEndpoint(c, b) == Endpoint.TAIL)) {
            if (!this.isArrowpointAllowed(a, c, graph)) {
                return;
            }
            graph.setEndpoint(a, c, Endpoint.ARROW);
            this.orientSimilarPairs(graph, this.getKnowledge(), a, c, Endpoint.ARROW);
            if (this.verbose) {
                this.logger.log("impliedOrientations", SearchLogUtils.edgeOrientedMsg("Away from ancestor", graph.getEdge(a, c)));
                System.out.println(SearchLogUtils.edgeOrientedMsg("Away from ancestor", graph.getEdge(a, c)));
            }
            this.changeFlag = true;
        }
    }

    public void ruleR3(Graph graph) {
        List<Node> nodes = graph.getNodes();
        for (Node B : nodes) {
            List<Node> intoBArrows = graph.getNodesInTo(B, Endpoint.ARROW);
            List<Node> intoBCircles = graph.getNodesInTo(B, Endpoint.CIRCLE);
            for (Node D : intoBCircles) {
                int[] choice;
                if (intoBArrows.size() < 2) continue;
                ChoiceGenerator gen = new ChoiceGenerator(intoBArrows.size(), 2);
                while ((choice = gen.next()) != null) {
                    Node C;
                    Node A = intoBArrows.get(choice[0]);
                    if (graph.isAdjacentTo(A, C = intoBArrows.get(choice[1])) || !graph.isAdjacentTo(A, D) || !graph.isAdjacentTo(C, D) || graph.getEndpoint(A, D) != Endpoint.CIRCLE || graph.getEndpoint(C, D) != Endpoint.CIRCLE || !this.isArrowpointAllowed(D, B, graph)) continue;
                    graph.setEndpoint(D, B, Endpoint.ARROW);
                    this.orientSimilarPairs(graph, this.getKnowledge(), D, B, Endpoint.ARROW);
                    if (this.verbose) {
                        this.logger.log("impliedOrientations", SearchLogUtils.edgeOrientedMsg("Double triangle", graph.getEdge(D, B)));
                        System.out.println(SearchLogUtils.edgeOrientedMsg("Double triangle", graph.getEdge(D, B)));
                    }
                    this.changeFlag = true;
                }
            }
        }
    }

    private void ruleR4A(Graph graph) {
        List<Node> nodes = graph.getNodes();
        for (Node b : nodes) {
            List<Node> possA = graph.getNodesOutTo(b, Endpoint.ARROW);
            List<Node> possC = graph.getNodesInTo(b, Endpoint.CIRCLE);
            for (Node a : possA) {
                for (Node c : possC) {
                    if (!graph.isParentOf(a, c) || graph.getEndpoint(b, c) != Endpoint.ARROW) continue;
                    LinkedList<Node> reachable = new LinkedList<Node>();
                    reachable.add(a);
                    if (!this.verbose) continue;
                    System.out.println("Found CPDAG " + a + " " + b + " " + c);
                    this.reachablePathFind(a, b, c, reachable, graph);
                }
            }
        }
    }

    private void reachablePathFind(Node a, Node b, Node c, LinkedList<Node> reachable, Graph graph) {
        HashSet<Node> cParents = new HashSet<Node>(graph.getParents(c));
        HashSet<Node> visited = new HashSet<Node>();
        visited.add(b);
        visited.add(c);
        Node e = reachable.getFirst();
        int distance = 0;
        while (reachable.size() > 0) {
            Node x = reachable.removeFirst();
            visited.add(x);
            if (e == x) {
                int _maxPathLength;
                e = x;
                int n = _maxPathLength = this.maxPathLength == -1 ? 1000 : this.maxPathLength;
                if (++distance > 0 && distance > _maxPathLength) continue;
            }
            List<Node> pathExtensions = graph.getNodesInTo(x, Endpoint.ARROW);
            pathExtensions.removeAll(visited);
            for (Node d : pathExtensions) {
                if (!graph.isAdjacentTo(d, c)) {
                    this.doDdpOrientation(d, a, b, c, graph);
                    return;
                }
                if (!cParents.contains(d) || graph.getEndpoint(x, d) != Endpoint.ARROW) continue;
                reachable.add(d);
            }
        }
    }

    private void doDdpOrientation(Node d, Node a, Node b, Node c, Graph graph) {
        List<Node> sepset = this.getSepset(d, c);
        if (sepset == null) {
            return;
        }
        if (sepset.contains(b)) {
            graph.setEndpoint(c, b, Endpoint.TAIL);
            this.orientSimilarPairs(graph, this.getKnowledge(), c, b, Endpoint.TAIL);
            if (this.verbose) {
                this.logger.log("impliedOrientations", SearchLogUtils.edgeOrientedMsg("Definite discriminating path d = " + d, graph.getEdge(b, c)));
                System.out.println(SearchLogUtils.edgeOrientedMsg("Definite discriminating path d = " + d, graph.getEdge(b, c)));
            }
        } else {
            if (!this.isArrowpointAllowed(a, b, graph)) {
                return;
            }
            if (!this.isArrowpointAllowed(c, b, graph)) {
                return;
            }
            graph.setEndpoint(a, b, Endpoint.ARROW);
            graph.setEndpoint(c, b, Endpoint.ARROW);
            this.orientSimilarPairs(graph, this.getKnowledge(), a, b, Endpoint.ARROW);
            this.orientSimilarPairs(graph, this.getKnowledge(), c, b, Endpoint.ARROW);
            this.logger.log("colliderOrientations", SearchLogUtils.colliderOrientedMsg("Definite discriminating path.. d = " + d, a, b, c));
        }
        this.changeFlag = true;
    }

    public void ruleR4B(Graph graph) {
        List<Node> nodes = graph.getNodes();
        for (Node b : nodes) {
            List<Node> possA = graph.getNodesOutTo(b, Endpoint.ARROW);
            List<Node> possC = graph.getNodesInTo(b, Endpoint.CIRCLE);
            for (Node a : possA) {
                for (Node c : possC) {
                    if (!graph.isParentOf(a, c) || graph.getEndpoint(b, c) != Endpoint.ARROW) continue;
                    this.ddpOrient(a, b, c, graph);
                }
            }
        }
    }

    public void ddpOrient(Node a, Node b, Node c, Graph graph) {
        ArrayDeque<Node> Q = new ArrayDeque<Node>();
        HashSet<Node> V = new HashSet<Node>();
        Node e = null;
        int distance = 0;
        HashMap<Node, Node> previous = new HashMap<Node, Node>();
        List<Node> cParents = graph.getParents(c);
        Q.offer(a);
        V.add(a);
        V.add(b);
        previous.put(a, b);
        while (!Q.isEmpty()) {
            Node t = (Node)Q.poll();
            if (e == null || e == t) {
                e = t;
                if (++distance > 0 && distance > (this.maxPathLength == -1 ? 1000 : this.maxPathLength)) {
                    return;
                }
            }
            List<Node> nodesInTo = graph.getNodesInTo(t, Endpoint.ARROW);
            for (Node d : nodesInTo) {
                if (V.contains(d)) continue;
                previous.put(d, t);
                Node p = (Node)previous.get(t);
                if (!graph.isDefCollider(d, t, p)) continue;
                previous.put(d, t);
                if (!graph.isAdjacentTo(d, c) && this.doDdpOrientation(d, a, b, c, previous, graph)) {
                    return;
                }
                if (!cParents.contains(d)) continue;
                Q.offer(d);
                V.add(d);
            }
        }
    }

    private boolean doDdpOrientation(Node d, Node a, Node b, Node c, Map<Node, Node> previous, Graph graph) {
        if (graph.isAdjacentTo(d, c)) {
            throw new IllegalArgumentException();
        }
        List<Node> path = this.getPath(d, previous);
        boolean ind = this.getSepsets().isIndependent(d, c, path);
        ArrayList<Node> path2 = new ArrayList<Node>(path);
        path2.remove(b);
        boolean ind2 = this.getSepsets().isIndependent(d, c, path2);
        if (!ind && !ind2) {
            List<Node> sepset = this.getSepsets().getSepset(d, c);
            if (this.verbose) {
                System.out.println("Sepset for d = " + d + " and c = " + c + " = " + sepset);
            }
            if (sepset == null) {
                if (this.verbose) {
                    System.out.println("Must be a sepset: " + d + " and " + c + "; they're non-adjacent.");
                }
                return false;
            }
            ind = sepset.contains(b);
        }
        if (ind) {
            graph.setEndpoint(c, b, Endpoint.TAIL);
            this.orientSimilarPairs(graph, this.getKnowledge(), c, b, Endpoint.TAIL);
            if (this.verbose) {
                this.logger.log("impliedOrientations", SearchLogUtils.edgeOrientedMsg("Definite discriminating path d = " + d, graph.getEdge(b, c)));
                System.out.println(SearchLogUtils.edgeOrientedMsg("Definite discriminating path d = " + d, graph.getEdge(b, c)));
            }
        } else {
            if (!this.isArrowpointAllowed(a, b, graph)) {
                return false;
            }
            if (!this.isArrowpointAllowed(c, b, graph)) {
                return false;
            }
            graph.setEndpoint(a, b, Endpoint.ARROW);
            graph.setEndpoint(c, b, Endpoint.ARROW);
            this.orientSimilarPairs(graph, this.getKnowledge(), a, b, Endpoint.ARROW);
            this.orientSimilarPairs(graph, this.getKnowledge(), c, b, Endpoint.ARROW);
            if (this.verbose) {
                this.logger.log("impliedOrientations", SearchLogUtils.colliderOrientedMsg("Definite discriminating path.. d = " + d, a, b, c));
                System.out.println(SearchLogUtils.colliderOrientedMsg("Definite discriminating path.. d = " + d, a, b, c));
            }
        }
        this.changeFlag = true;
        return true;
    }

    private void printDdp(Node d, List<Node> path, Node a, Node b, Node c, Graph graph) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        nodes.add(d);
        nodes.addAll(path);
        nodes.add(a);
        nodes.add(b);
        nodes.add(c);
        if (this.verbose) {
            System.out.println("DDP subgraph = " + graph.subgraph(nodes));
        }
    }

    private List<Node> getPath(Node c, Map<Node, Node> previous) {
        ArrayList<Node> l = new ArrayList<Node>();
        Node p = c;
        do {
            if ((p = previous.get(p)) == null) continue;
            l.add(p);
        } while (p != null);
        return l;
    }

    public void ruleR5(Graph graph) {
        List<Node> nodes = graph.getNodes();
        for (Node a : nodes) {
            List<Node> adjacents = graph.getNodesInTo(a, Endpoint.CIRCLE);
            for (Node b : adjacents) {
                if (graph.getEndpoint(a, b) != Endpoint.CIRCLE) continue;
                List<List<Node>> ucCirclePaths = this.getUcCirclePaths(a, b, graph);
                for (List<Node> u : ucCirclePaths) {
                    if (u.size() < 3) continue;
                    Node c = u.get(1);
                    Node d = u.get(u.size() - 2);
                    if (graph.isAdjacentTo(a, d) || graph.isAdjacentTo(b, c)) continue;
                    this.logger.log("colliderOrientations", SearchLogUtils.edgeOrientedMsg("Orient circle path", graph.getEdge(a, b)));
                    graph.setEndpoint(a, b, Endpoint.TAIL);
                    this.orientSimilarPairs(graph, this.getKnowledge(), a, b, Endpoint.TAIL);
                    graph.setEndpoint(b, a, Endpoint.TAIL);
                    this.orientSimilarPairs(graph, this.getKnowledge(), b, a, Endpoint.TAIL);
                    this.orientTailPath(u, graph);
                    this.changeFlag = true;
                }
            }
        }
    }

    public void ruleR6R7(Graph graph) {
        List<Node> nodes = graph.getNodes();
        for (Node b : nodes) {
            List<Node> adjacents = graph.getAdjacentNodes(b);
            if (adjacents.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adjacents.size(), 2);
            int[] choice = cg.next();
            while (choice != null) {
                Node c;
                Node a = adjacents.get(choice[0]);
                if (!graph.isAdjacentTo(a, c = adjacents.get(choice[1])) && graph.getEndpoint(b, a) == Endpoint.TAIL && graph.getEndpoint(c, b) == Endpoint.CIRCLE) {
                    if (graph.getEndpoint(a, b) == Endpoint.TAIL) {
                        graph.setEndpoint(c, b, Endpoint.TAIL);
                        this.orientSimilarPairs(graph, this.getKnowledge(), c, b, Endpoint.TAIL);
                        this.logger.log("impliedOrientations", SearchLogUtils.edgeOrientedMsg("Single tails (tail)", graph.getEdge(c, b)));
                        this.changeFlag = true;
                    }
                    if (graph.getEndpoint(a, b) == Endpoint.CIRCLE) {
                        this.logger.log("impliedOrientations", SearchLogUtils.edgeOrientedMsg("Single tails (tail)", graph.getEdge(c, b)));
                        graph.setEndpoint(c, b, Endpoint.TAIL);
                        this.orientSimilarPairs(graph, this.getKnowledge(), c, b, Endpoint.TAIL);
                        this.changeFlag = true;
                    }
                }
                choice = cg.next();
            }
        }
    }

    public void rulesR8R9R10(Graph graph) {
        List<Node> nodes = graph.getNodes();
        for (Node c : nodes) {
            List<Node> intoCArrows = graph.getNodesInTo(c, Endpoint.ARROW);
            for (Node a : intoCArrows) {
                boolean b;
                if (graph.getEndpoint(c, a) != Endpoint.CIRCLE || this.ruleR8(a, c, graph) || (b = this.ruleR9(a, c, graph))) continue;
                this.ruleR10(a, c, graph);
            }
        }
    }

    private void orientTailPath(List<Node> path, Graph graph) {
        for (int i = 0; i < path.size() - 1; ++i) {
            Node n1 = path.get(i);
            Node n2 = path.get(i + 1);
            graph.setEndpoint(n1, n2, Endpoint.TAIL);
            this.orientSimilarPairs(graph, this.getKnowledge(), n1, n2, Endpoint.TAIL);
            graph.setEndpoint(n2, n1, Endpoint.TAIL);
            this.orientSimilarPairs(graph, this.getKnowledge(), n2, n1, Endpoint.TAIL);
            this.changeFlag = true;
            this.logger.log("impliedOrientations", SearchLogUtils.edgeOrientedMsg("Orient circle undirectedPaths", graph.getEdge(n1, n2)));
        }
    }

    private List<List<Node>> getUcPdPaths(Node n1, Node n2, Graph graph) {
        LinkedList<List<Node>> ucPdPaths = new LinkedList<List<Node>>();
        LinkedList<Node> soFar = new LinkedList<Node>();
        soFar.add(n1);
        List<Node> adjacencies = graph.getAdjacentNodes(n1);
        for (Node curr : adjacencies) {
            this.getUcPdPsHelper(curr, soFar, n2, ucPdPaths, graph);
        }
        return ucPdPaths;
    }

    private void getUcPdPsHelper(Node curr, List<Node> soFar, Node end, List<List<Node>> ucPdPaths, Graph graph) {
        Node prev2;
        if (soFar.contains(curr)) {
            return;
        }
        Node prev = soFar.get(soFar.size() - 1);
        if (graph.getEndpoint(prev, curr) == Endpoint.TAIL || graph.getEndpoint(curr, prev) == Endpoint.ARROW) {
            return;
        }
        if (soFar.size() >= 2 && graph.isAdjacentTo(prev2 = soFar.get(soFar.size() - 2), curr)) {
            return;
        }
        soFar.add(curr);
        if (curr.equals(end)) {
            ucPdPaths.add(new LinkedList<Node>(soFar));
        } else {
            List<Node> adjacents = graph.getAdjacentNodes(curr);
            for (Node next : adjacents) {
                this.getUcPdPsHelper(next, soFar, end, ucPdPaths, graph);
            }
        }
        soFar.remove(soFar.get(soFar.size() - 1));
    }

    private List<List<Node>> getUcCirclePaths(Node n1, Node n2, Graph graph) {
        LinkedList<List<Node>> ucCirclePaths = new LinkedList<List<Node>>();
        List<List<Node>> ucPdPaths = this.getUcPdPaths(n1, n2, graph);
        for (List<Node> path : ucPdPaths) {
            Node sj;
            Node j;
            for (int i = 0; i < path.size() - 1 && graph.getEndpoint(j = path.get(i), sj = path.get(i + 1)) == Endpoint.CIRCLE && graph.getEndpoint(sj, j) == Endpoint.CIRCLE; ++i) {
                if (i != path.size() - 2) continue;
                ucCirclePaths.add(path);
            }
        }
        return ucCirclePaths;
    }

    private boolean ruleR8(Node a, Node c, Graph graph) {
        List<Node> intoCArrows = graph.getNodesInTo(c, Endpoint.ARROW);
        for (Node b : intoCArrows) {
            if (!graph.isAdjacentTo(a, b) || !graph.isAdjacentTo(b, c) || graph.getEndpoint(b, a) != Endpoint.TAIL || graph.getEndpoint(c, b) != Endpoint.TAIL || graph.getEndpoint(a, b) == Endpoint.TAIL) continue;
            this.logger.log("impliedOrientations", SearchLogUtils.edgeOrientedMsg("R8", graph.getEdge(c, a)));
            graph.setEndpoint(c, a, Endpoint.TAIL);
            this.orientSimilarPairs(graph, this.getKnowledge(), c, a, Endpoint.TAIL);
            this.changeFlag = true;
            return true;
        }
        return false;
    }

    private boolean ruleR9(Node a, Node c, Graph graph) {
        List<List<Node>> ucPdPsToC = this.getUcPdPaths(a, c, graph);
        for (List<Node> u : ucPdPsToC) {
            Node b = u.get(1);
            if (graph.isAdjacentTo(b, c) || b == c) continue;
            this.logger.log("impliedOrientations", SearchLogUtils.edgeOrientedMsg("R9", graph.getEdge(c, a)));
            graph.setEndpoint(c, a, Endpoint.TAIL);
            this.orientSimilarPairs(graph, this.getKnowledge(), c, a, Endpoint.TAIL);
            this.changeFlag = true;
            return true;
        }
        return false;
    }

    private boolean ruleR10(Node a, Node c, Graph graph) {
        List<Node> intoCArrows = graph.getNodesInTo(c, Endpoint.ARROW);
        for (Node b : intoCArrows) {
            if (b == a || graph.getEndpoint(c, b) != Endpoint.TAIL) continue;
            for (Node d : intoCArrows) {
                if (d == a || d == b || graph.getEndpoint(d, c) != Endpoint.TAIL) continue;
                List<List<Node>> ucPdPsToB = this.getUcPdPaths(a, b, graph);
                List<List<Node>> ucPdPsToD = this.getUcPdPaths(a, d, graph);
                for (List<Node> u1 : ucPdPsToB) {
                    Node m = u1.get(1);
                    for (List<Node> u2 : ucPdPsToD) {
                        Node n = u2.get(1);
                        if (m.equals(n) || graph.isAdjacentTo(m, n)) continue;
                        this.logger.log("impliedOrientations", SearchLogUtils.edgeOrientedMsg("R10", graph.getEdge(c, a)));
                        graph.setEndpoint(c, a, Endpoint.TAIL);
                        this.changeFlag = true;
                        this.orientSimilarPairs(graph, this.getKnowledge(), c, a, Endpoint.TAIL);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private void fciOrientbk(Knowledge bk, Graph graph, List<Node> variables) {
        Node to;
        Node from;
        KnowledgeEdge edge;
        this.logger.log("info", "Starting BK Orientation.");
        Iterator<KnowledgeEdge> it = bk.forbiddenEdgesIterator();
        while (it.hasNext()) {
            edge = it.next();
            from = SearchGraphUtils.translate(edge.getFrom(), variables);
            to = SearchGraphUtils.translate(edge.getTo(), variables);
            if (from == null || to == null || graph.getEdge(from, to) == null) continue;
            graph.setEndpoint(to, from, Endpoint.ARROW);
            graph.setEndpoint(from, to, Endpoint.CIRCLE);
            this.changeFlag = true;
            this.logger.log("knowledgeOrientation", SearchLogUtils.edgeOrientedMsg("Knowledge", graph.getEdge(from, to)));
        }
        it = bk.requiredEdgesIterator();
        while (it.hasNext()) {
            edge = it.next();
            from = SearchGraphUtils.translate(edge.getFrom(), variables);
            to = SearchGraphUtils.translate(edge.getTo(), variables);
            if (from == null || to == null || graph.getEdge(from, to) == null) continue;
            graph.setEndpoint(to, from, Endpoint.TAIL);
            graph.setEndpoint(from, to, Endpoint.ARROW);
            this.changeFlag = true;
            this.logger.log("knowledgeOrientation", SearchLogUtils.edgeOrientedMsg("Knowledge", graph.getEdge(from, to)));
        }
        this.logger.log("info", "Finishing BK Orientation.");
    }

    private boolean isArrowpointAllowed(Node x, Node y, Graph graph) {
        if (graph.getEndpoint(x, y) == Endpoint.ARROW) {
            return true;
        }
        if (graph.getEndpoint(x, y) == Endpoint.TAIL) {
            return false;
        }
        if (graph.getEndpoint(y, x) == Endpoint.ARROW) {
            return true;
        }
        if (graph.getEndpoint(y, x) == Endpoint.TAIL && !this.knowledge.isForbidden(x.getName(), y.getName())) {
            return true;
        }
        return graph.getEndpoint(y, x) == Endpoint.CIRCLE;
    }

    public boolean isPossibleDsepSearchDone() {
        return this.possibleDsepSearchDone;
    }

    public void setPossibleDsepSearchDone(boolean possibleDsepSearchDone) {
        this.possibleDsepSearchDone = possibleDsepSearchDone;
    }

    public int getMaxPathLength() {
        return this.maxPathLength;
    }

    public void setMaxPathLength(int maxPathLength) {
        if (maxPathLength < -1) {
            throw new IllegalArgumentException("Max path length must be -1 (unlimited) or >= 0: " + maxPathLength);
        }
        this.maxPathLength = maxPathLength;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setTruePag(Graph truePag) {
        this.truePag = truePag;
    }

    public Graph getTruePag() {
        return this.truePag;
    }

    public void setChangeFlag(boolean changeFlag) {
        this.changeFlag = changeFlag;
    }

    public boolean isChangeFlag() {
        return this.changeFlag;
    }

    private void orientSimilarPairs(Graph graph, Knowledge knowledge, Node x, Node y, Endpoint mark) {
        int i;
        if (x.getName().equals("time") || y.getName().equals("time")) {
            return;
        }
        System.out.println("Entering orient similar pairs method for x and y: " + x + ", " + y);
        int ntiers = knowledge.getNumTiers();
        int indx_tier = knowledge.isInWhichTier(x);
        int indy_tier = knowledge.isInWhichTier(y);
        int tier_diff = FastMath.max(indx_tier, indy_tier) - FastMath.min(indx_tier, indy_tier);
        int indx_comp = -1;
        int indy_comp = -1;
        List<String> tier_x = knowledge.getTier(indx_tier);
        List<String> tier_y = knowledge.getTier(indy_tier);
        for (i = 0; i < tier_x.size(); ++i) {
            if (!this.getNameNoLag(x.getName()).equals(this.getNameNoLag(tier_x.get(i)))) continue;
            indx_comp = i;
            break;
        }
        for (i = 0; i < tier_y.size(); ++i) {
            if (!this.getNameNoLag(y.getName()).equals(this.getNameNoLag(tier_y.get(i)))) continue;
            indy_comp = i;
            break;
        }
        if (indx_comp == -1) {
            System.out.println("WARNING: indx_comp = -1!!!! ");
        }
        if (indy_comp == -1) {
            System.out.println("WARNING: indy_comp = -1!!!! ");
        }
        for (i = 0; i < ntiers - tier_diff; ++i) {
            Node y1;
            Node x1;
            String B;
            if (knowledge.getTier(i).size() == 1 || indx_tier < indy_tier) continue;
            List<String> tmp_tier1 = knowledge.getTier(i + tier_diff);
            List<String> tmp_tier2 = knowledge.getTier(i);
            String A = tmp_tier1.get(indx_comp);
            if (A.equals(B = tmp_tier2.get(indy_comp)) || A.equals(tier_x.get(indx_comp)) && B.equals(tier_y.get(indy_comp)) || B.equals(tier_x.get(indx_comp)) && A.equals(tier_y.get(indy_comp)) || !graph.isAdjacentTo(x1 = this.independenceTest.getVariable(A), y1 = this.independenceTest.getVariable(B)) || graph.getEndpoint(x1, y1) != Endpoint.CIRCLE) continue;
            System.out.print("Orient edge " + graph.getEdge(x1, y1).toString());
            graph.setEndpoint(x1, y1, mark);
            System.out.println(" by structure knowledge as: " + graph.getEdge(x1, y1).toString());
        }
    }

    public String getNameNoLag(Object obj) {
        String tempS = obj.toString();
        if (tempS.indexOf(58) == -1) {
            return tempS;
        }
        return tempS.substring(0, tempS.indexOf(58));
    }
}

