/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.KnowledgeEdge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.BDeuScore;
import edu.cmu.tetrad.search.GraphScore;
import edu.cmu.tetrad.search.GraphSearch;
import edu.cmu.tetrad.search.IndTestDSep;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.Score;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.search.SearchLogUtils;
import edu.cmu.tetrad.search.SemBicScore;
import edu.cmu.tetrad.search.SepsetProducer;
import edu.cmu.tetrad.search.SepsetsGreedy;
import edu.cmu.tetrad.search.SvarFciOrient;
import edu.cmu.tetrad.search.TsFges2;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.MillisecondTimes;
import edu.cmu.tetrad.util.TetradLogger;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.math3.util.FastMath;

public final class SvarGFci
implements GraphSearch {
    private final Graph dag = null;
    private Graph graph;
    private Knowledge knowledge = new Knowledge();
    private final List<Node> variables = new ArrayList<Node>();
    private IndependenceTest independenceTest;
    private boolean completeRuleSetUsed;
    private int maxPathLength = -1;
    private int maxIndegree = -1;
    private final TetradLogger logger = TetradLogger.getInstance();
    private boolean verbose;
    ICovarianceMatrix covarianceMatrix;
    int sampleSize;
    private double penaltyDiscount = 2.0;
    private double samplePrior = 10.0;
    private double structurePrior = 1.0;
    private PrintStream out = System.out;
    private boolean faithfulnessAssumed = true;
    private Score score;
    private SepsetProducer sepsets;
    private final int depth = -1;

    public SvarGFci(IndependenceTest test, Score score) {
        if (score == null) {
            throw new NullPointerException();
        }
        this.sampleSize = score.getSampleSize();
        this.score = score;
        this.independenceTest = test;
    }

    @Override
    public Graph search() {
        long time1 = MillisecondTimes.timeMillis();
        List<Node> nodes = this.getIndependenceTest().getVariables();
        this.logger.log("info", "Starting svarGFCI algorithm.");
        this.logger.log("info", "Independence test = " + this.getIndependenceTest() + ".");
        this.graph = new EdgeListGraph(nodes);
        if (this.score == null) {
            this.setScore();
        }
        TsFges2 fges = new TsFges2(this.score);
        fges.setKnowledge(this.getKnowledge());
        fges.setVerbose(this.verbose);
        fges.setNumCPDAGsToStore(0);
        fges.setFaithfulnessAssumed(this.faithfulnessAssumed);
        this.graph = fges.search();
        EdgeListGraph fgesGraph = new EdgeListGraph(this.graph);
        this.sepsets = new SepsetsGreedy(fgesGraph, this.independenceTest, null, this.maxIndegree);
        for (Node b : nodes) {
            int[] combination;
            List<Node> adjacentNodes = fgesGraph.getAdjacentNodes(b);
            if (adjacentNodes.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
            while ((combination = cg.next()) != null && !Thread.currentThread().isInterrupted()) {
                Node c;
                Node a = adjacentNodes.get(combination[0]);
                if (!this.graph.isAdjacentTo(a, c = adjacentNodes.get(combination[1])) || !fgesGraph.isAdjacentTo(a, c) || this.sepsets.getSepset(a, c) == null) continue;
                this.graph.removeEdge(a, c);
                this.removeSimilarEdges(a, c);
            }
        }
        this.modifiedR0(fgesGraph);
        SvarFciOrient fciOrient = new SvarFciOrient(this.sepsets, this.independenceTest);
        fciOrient.setKnowledge(this.getKnowledge());
        fciOrient.setCompleteRuleSetUsed(this.completeRuleSetUsed);
        fciOrient.setMaxPathLength(this.maxPathLength);
        fciOrient.doFinalOrientation(this.graph);
        GraphUtils.replaceNodes(this.graph, this.independenceTest.getVariables());
        return this.graph;
    }

    private void setScore() {
        Score score;
        this.sampleSize = this.independenceTest.getSampleSize();
        double penaltyDiscount = this.getPenaltyDiscount();
        DataSet dataSet = (DataSet)this.independenceTest.getData();
        ICovarianceMatrix cov = this.independenceTest.getCov();
        if (this.independenceTest instanceof IndTestDSep) {
            score = new GraphScore(this.dag);
        } else if (cov != null) {
            this.covarianceMatrix = cov;
            SemBicScore score0 = new SemBicScore(cov);
            score0.setPenaltyDiscount(penaltyDiscount);
            score = score0;
        } else if (dataSet.isContinuous()) {
            this.covarianceMatrix = new CovarianceMatrix(dataSet);
            SemBicScore score0 = new SemBicScore(this.covarianceMatrix);
            score0.setPenaltyDiscount(penaltyDiscount);
            score = score0;
        } else if (dataSet.isDiscrete()) {
            BDeuScore score0 = new BDeuScore(dataSet);
            score0.setSamplePrior(this.samplePrior);
            score0.setStructurePrior(this.structurePrior);
            score = score0;
        } else {
            throw new IllegalArgumentException("Mixed data not supported.");
        }
        this.score = score;
    }

    public int getMaxIndegree() {
        return this.maxIndegree;
    }

    public void setMaxIndegree(int maxIndegree) {
        if (maxIndegree < -1) {
            throw new IllegalArgumentException("Depth must be -1 (unlimited) or >= 0: " + maxIndegree);
        }
        this.maxIndegree = maxIndegree;
    }

    public void modifiedR0(Graph fgesGraph) {
        this.graph.reorientAllWith(Endpoint.CIRCLE);
        this.fciOrientbk(this.knowledge, this.graph, this.graph.getNodes());
        List<Node> nodes = this.graph.getNodes();
        for (Node b : nodes) {
            int[] combination;
            List<Node> adjacentNodes = this.graph.getAdjacentNodes(b);
            if (adjacentNodes.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
            while ((combination = cg.next()) != null) {
                List<Node> sepset;
                Node c;
                Node a = adjacentNodes.get(combination[0]);
                if (fgesGraph.isDefCollider(a, b, c = adjacentNodes.get(combination[1]))) {
                    this.graph.setEndpoint(a, b, Endpoint.ARROW);
                    this.graph.setEndpoint(c, b, Endpoint.ARROW);
                    this.orientSimilarPairs(this.graph, this.knowledge, a, b);
                    this.orientSimilarPairs(this.graph, this.knowledge, c, b);
                    continue;
                }
                if (!fgesGraph.isAdjacentTo(a, c) || this.graph.isAdjacentTo(a, c) || (sepset = this.sepsets.getSepset(a, c)) == null || sepset.contains(b)) continue;
                this.graph.setEndpoint(a, b, Endpoint.ARROW);
                this.graph.setEndpoint(c, b, Endpoint.ARROW);
                this.orientSimilarPairs(this.graph, this.knowledge, a, b);
                this.orientSimilarPairs(this.graph, this.knowledge, c, b);
            }
        }
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    public void setKnowledge(Knowledge knowledge) {
        if (knowledge == null) {
            throw new NullPointerException();
        }
        this.knowledge = knowledge;
    }

    public boolean isCompleteRuleSetUsed() {
        return this.completeRuleSetUsed;
    }

    public void setCompleteRuleSetUsed(boolean completeRuleSetUsed) {
        this.completeRuleSetUsed = completeRuleSetUsed;
    }

    public int getMaxPathLength() {
        return this.maxPathLength;
    }

    public void setMaxPathLength(int maxPathLength) {
        if (maxPathLength < -1) {
            throw new IllegalArgumentException("Max path length must be -1 (unlimited) or >= 0: " + maxPathLength);
        }
        this.maxPathLength = maxPathLength;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public IndependenceTest getIndependenceTest() {
        return this.independenceTest;
    }

    public double getPenaltyDiscount() {
        return this.penaltyDiscount;
    }

    public void setPenaltyDiscount(double penaltyDiscount) {
        this.penaltyDiscount = penaltyDiscount;
    }

    public ICovarianceMatrix getCovMatrix() {
        return this.covarianceMatrix;
    }

    public ICovarianceMatrix getCovarianceMatrix() {
        return this.covarianceMatrix;
    }

    public void setCovarianceMatrix(ICovarianceMatrix covarianceMatrix) {
        this.covarianceMatrix = covarianceMatrix;
    }

    public PrintStream getOut() {
        return this.out;
    }

    public void setOut(PrintStream out) {
        this.out = out;
    }

    public void setIndependenceTest(IndependenceTest independenceTest) {
        this.independenceTest = independenceTest;
    }

    public void setFaithfulnessAssumed(boolean faithfulnessAssumed) {
        this.faithfulnessAssumed = faithfulnessAssumed;
    }

    private void buildIndexing(List<Node> nodes) {
        ConcurrentHashMap<Node, Integer> hashIndices = new ConcurrentHashMap<Node, Integer>();
        int i = 0;
        for (Node node : nodes) {
            hashIndices.put(node, i++);
        }
    }

    private void fciOrientbk(Knowledge knowledge, Graph graph, List<Node> variables) {
        Node to;
        Node from;
        KnowledgeEdge edge;
        this.logger.log("info", "Starting BK Orientation.");
        Iterator<KnowledgeEdge> it = knowledge.forbiddenEdgesIterator();
        while (it.hasNext()) {
            edge = it.next();
            from = SearchGraphUtils.translate(edge.getFrom(), variables);
            to = SearchGraphUtils.translate(edge.getTo(), variables);
            if (from == null || to == null || graph.getEdge(from, to) == null) continue;
            graph.setEndpoint(to, from, Endpoint.ARROW);
            graph.setEndpoint(from, to, Endpoint.CIRCLE);
            this.logger.log("knowledgeOrientation", SearchLogUtils.edgeOrientedMsg("Knowledge", graph.getEdge(from, to)));
        }
        it = knowledge.requiredEdgesIterator();
        while (it.hasNext()) {
            edge = it.next();
            from = SearchGraphUtils.translate(edge.getFrom(), variables);
            to = SearchGraphUtils.translate(edge.getTo(), variables);
            if (from == null || to == null || graph.getEdge(from, to) == null) continue;
            graph.setEndpoint(to, from, Endpoint.TAIL);
            graph.setEndpoint(from, to, Endpoint.ARROW);
            this.logger.log("knowledgeOrientation", SearchLogUtils.edgeOrientedMsg("Knowledge", graph.getEdge(from, to)));
        }
        this.logger.log("info", "Finishing BK Orientation.");
    }

    public void setSamplePrior(double samplePrior) {
        this.samplePrior = samplePrior;
    }

    public void setStructurePrior(double structurePrior) {
        this.structurePrior = structurePrior;
    }

    private int freeDegree(List<Node> nodes, Graph graph) {
        int max = 0;
        for (Node x : nodes) {
            List<Node> opposites = graph.getAdjacentNodes(x);
            for (Node y : opposites) {
                HashSet<Node> adjx = new HashSet<Node>(opposites);
                adjx.remove(y);
                if (adjx.size() <= max) continue;
                max = adjx.size();
            }
        }
        return max;
    }

    private void orientSimilarPairs(Graph graph, Knowledge knowledge, Node x, Node y) {
        int i;
        if (x.getName().equals("time") || y.getName().equals("time")) {
            return;
        }
        System.out.println("Entering orient similar pairs method for x and y: " + x + ", " + y);
        int ntiers = knowledge.getNumTiers();
        int indx_tier = knowledge.isInWhichTier(x);
        int indy_tier = knowledge.isInWhichTier(y);
        int tier_diff = FastMath.max(indx_tier, indy_tier) - FastMath.min(indx_tier, indy_tier);
        int indx_comp = -1;
        int indy_comp = -1;
        List<String> tier_x = knowledge.getTier(indx_tier);
        List<String> tier_y = knowledge.getTier(indy_tier);
        for (i = 0; i < tier_x.size(); ++i) {
            if (!this.getNameNoLag(x.getName()).equals(this.getNameNoLag(tier_x.get(i)))) continue;
            indx_comp = i;
            break;
        }
        for (i = 0; i < tier_y.size(); ++i) {
            if (!this.getNameNoLag(y.getName()).equals(this.getNameNoLag(tier_y.get(i)))) continue;
            indy_comp = i;
            break;
        }
        if (indx_comp == -1) {
            System.out.println("WARNING: indx_comp = -1!!!! ");
        }
        if (indy_comp == -1) {
            System.out.println("WARNING: indy_comp = -1!!!! ");
        }
        for (i = 0; i < ntiers - tier_diff; ++i) {
            Node y1;
            Node x1;
            String B;
            if (knowledge.getTier(i).size() == 1 || indx_tier < indy_tier) continue;
            List<String> tmp_tier1 = knowledge.getTier(i + tier_diff);
            List<String> tmp_tier2 = knowledge.getTier(i);
            String A = tmp_tier1.get(indx_comp);
            if (A.equals(B = tmp_tier2.get(indy_comp)) || A.equals(tier_x.get(indx_comp)) && B.equals(tier_y.get(indy_comp)) || B.equals(tier_x.get(indx_comp)) && A.equals(tier_y.get(indy_comp)) || !graph.isAdjacentTo(x1 = this.independenceTest.getVariable(A), y1 = this.independenceTest.getVariable(B)) || graph.getEndpoint(x1, y1) != Endpoint.CIRCLE) continue;
            System.out.print("Orient edge " + graph.getEdge(x1, y1).toString());
            graph.setEndpoint(x1, y1, Endpoint.ARROW);
            System.out.println(" by structure knowledge as: " + graph.getEdge(x1, y1).toString());
        }
    }

    public String getNameNoLag(Object obj) {
        String tempS = obj.toString();
        if (tempS.indexOf(58) == -1) {
            return tempS;
        }
        return tempS.substring(0, tempS.indexOf(58));
    }

    private List<List<Node>> returnSimilarPairs(Node x, Node y) {
        int i;
        System.out.println("$$$$$ Entering returnSimilarPairs method with x,y = " + x + ", " + y);
        if (x.getName().equals("time") || y.getName().equals("time")) {
            return new ArrayList<List<Node>>();
        }
        int ntiers = this.knowledge.getNumTiers();
        int indx_tier = this.knowledge.isInWhichTier(x);
        int indy_tier = this.knowledge.isInWhichTier(y);
        int tier_diff = FastMath.max(indx_tier, indy_tier) - FastMath.min(indx_tier, indy_tier);
        int indx_comp = -1;
        int indy_comp = -1;
        List<String> tier_x = this.knowledge.getTier(indx_tier);
        List<String> tier_y = this.knowledge.getTier(indy_tier);
        for (i = 0; i < tier_x.size(); ++i) {
            if (!this.getNameNoLag(x.getName()).equals(this.getNameNoLag(tier_x.get(i)))) continue;
            indx_comp = i;
            break;
        }
        for (i = 0; i < tier_y.size(); ++i) {
            if (!this.getNameNoLag(y.getName()).equals(this.getNameNoLag(tier_y.get(i)))) continue;
            indy_comp = i;
            break;
        }
        System.out.println("original independence: " + x + " and " + y);
        if (indx_comp == -1) {
            System.out.println("WARNING: indx_comp = -1!!!! ");
        }
        if (indy_comp == -1) {
            System.out.println("WARNING: indy_comp = -1!!!! ");
        }
        ArrayList<Node> simListX = new ArrayList<Node>();
        ArrayList<Node> simListY = new ArrayList<Node>();
        for (i = 0; i < ntiers - tier_diff; ++i) {
            String B;
            String A;
            List<String> tmp_tier2;
            List<String> tmp_tier1;
            if (this.knowledge.getTier(i).size() == 1) continue;
            if (indx_tier >= indy_tier) {
                tmp_tier1 = this.knowledge.getTier(i + tier_diff);
                tmp_tier2 = this.knowledge.getTier(i);
                A = tmp_tier1.get(indx_comp);
                B = tmp_tier2.get(indy_comp);
            } else {
                tmp_tier1 = this.knowledge.getTier(i);
                tmp_tier2 = this.knowledge.getTier(i + tier_diff);
                A = tmp_tier1.get(indx_comp);
                B = tmp_tier2.get(indy_comp);
            }
            if (A.equals(B) || A.equals(tier_x.get(indx_comp)) && B.equals(tier_y.get(indy_comp)) || B.equals(tier_x.get(indx_comp)) && A.equals(tier_y.get(indy_comp))) continue;
            Node x1 = this.graph.getNode(A);
            Node y1 = this.graph.getNode(B);
            System.out.println("Adding pair to simList = " + x1 + " and " + y1);
            simListX.add(x1);
            simListY.add(y1);
        }
        ArrayList<List<Node>> pairList = new ArrayList<List<Node>>();
        pairList.add(simListX);
        pairList.add(simListY);
        return pairList;
    }

    public void removeSimilarEdges(Node x, Node y) {
        List<List<Node>> simList = this.returnSimilarPairs(x, y);
        if (simList.isEmpty()) {
            return;
        }
        List<Node> x1List = simList.get(0);
        List<Node> y1List = simList.get(1);
        Iterator<Node> itx = x1List.iterator();
        Iterator<Node> ity = y1List.iterator();
        while (itx.hasNext() && ity.hasNext()) {
            Node x1 = itx.next();
            Node y1 = ity.next();
            System.out.println("$$$$$$$$$$$ similar pair x,y = " + x1 + ", " + y1);
            System.out.println("removing edge between x = " + x1 + " and y = " + y1);
            Edge oldxy = this.graph.getEdge(x1, y1);
            this.graph.removeEdge(oldxy);
        }
    }
}

