/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.KnowledgeEdge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeEqualityMode;
import edu.cmu.tetrad.graph.NodePair;
import edu.cmu.tetrad.graph.OrderedPair;
import edu.cmu.tetrad.search.GraphScore;
import edu.cmu.tetrad.search.GrowShrinkTree;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.MagSemBicScore;
import edu.cmu.tetrad.search.MeekRules;
import edu.cmu.tetrad.search.Score;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.util.RandomUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.math3.util.FastMath;
import org.jetbrains.annotations.NotNull;

public class TeyssierScorer {
    private final List<Node> variables;
    private final Map<Node, Integer> variablesHash;
    private final Score score;
    private final IndependenceTest test;
    private int maxIndegree;
    private Map<Object, ArrayList<Node>> bookmarkedOrders = new HashMap<Object, ArrayList<Node>>();
    private Map<Object, ArrayList<Pair>> bookmarkedScores = new HashMap<Object, ArrayList<Pair>>();
    private Map<Object, Map<Node, Integer>> bookmarkedOrderHashes = new HashMap<Object, Map<Node, Integer>>();
    private Map<Object, Double> bookmarkedRunningScores = new HashMap<Object, Double>();
    private Map<Node, Map<Set<Node>, Double>> cache = new HashMap<Node, Map<Set<Node>, Double>>();
    private Map<Node, Integer> orderHash;
    private ArrayList<Node> pi;
    private ArrayList<Pair> scores;
    private Knowledge knowledge = new Knowledge();
    private ArrayList<Set<Node>> prefixes;
    private boolean useScore = true;
    private boolean useRaskuttiUhler;
    private boolean useBackwardScoring;
    private boolean cachingScores = true;
    private double runningScore = 0.0;
    private Graph mag = null;
    private GrowShrinkTree GST;

    public TeyssierScorer(IndependenceTest test, Score score) {
        NodeEqualityMode.setEqualityMode(NodeEqualityMode.Type.OBJECT);
        this.score = score;
        this.test = test;
        this.GST = new GrowShrinkTree(score);
        if (score != null) {
            this.variables = score.getVariables();
            this.pi = new ArrayList<Node>(this.variables);
        } else if (test != null) {
            this.variables = test.getVariables();
            this.pi = new ArrayList<Node>(this.variables);
        } else {
            throw new IllegalArgumentException("Need both a score and a test,");
        }
        this.orderHash = new HashMap<Node, Integer>();
        this.nodesHash(this.orderHash, this.pi);
        this.variablesHash = new HashMap<Node, Integer>();
        this.nodesHash(this.variablesHash, this.variables);
        if (score instanceof GraphScore) {
            this.useScore = false;
        }
    }

    public TeyssierScorer(TeyssierScorer scorer) {
        this.variables = new ArrayList<Node>(scorer.variables);
        this.variablesHash = new HashMap<Node, Integer>();
        for (Node node : scorer.variablesHash.keySet()) {
            this.variablesHash.put(node, scorer.variablesHash.get(node));
        }
        this.score = scorer.score;
        this.test = scorer.test;
        this.bookmarkedOrders = new HashMap<Object, ArrayList<Node>>();
        for (Object object : scorer.bookmarkedOrders.keySet()) {
            this.bookmarkedOrders.put(object, scorer.bookmarkedOrders.get(object));
        }
        this.bookmarkedScores = new HashMap<Object, ArrayList<Pair>>();
        for (Object object : scorer.bookmarkedScores.keySet()) {
            this.bookmarkedScores.put(object, new ArrayList(scorer.bookmarkedScores.get(object)));
        }
        this.bookmarkedOrderHashes = new HashMap<Object, Map<Node, Integer>>();
        for (Object object : scorer.bookmarkedOrderHashes.keySet()) {
            this.bookmarkedOrderHashes.put(object, new HashMap<Node, Integer>(scorer.bookmarkedOrderHashes.get(object)));
        }
        this.bookmarkedRunningScores = new HashMap<Object, Double>(scorer.bookmarkedRunningScores);
        this.orderHash = new HashMap<Node, Integer>(scorer.orderHash);
        this.pi = new ArrayList<Node>(scorer.pi);
        this.scores = new ArrayList<Pair>(scorer.scores);
        this.knowledge = scorer.knowledge;
        this.useScore = scorer.useScore;
        this.useRaskuttiUhler = scorer.useRaskuttiUhler;
        this.useBackwardScoring = scorer.useBackwardScoring;
        this.cachingScores = scorer.cachingScores;
        this.runningScore = scorer.runningScore;
        this.maxIndegree = scorer.maxIndegree;
        this.prefixes = new ArrayList<Set<Node>>(scorer.prefixes);
    }

    public void moveToEnd(Node z) {
        this.moveTo(z, this.size() - 1);
    }

    public void setUseScore(boolean useScore) {
        if (!(this.score instanceof GraphScore)) {
            this.useScore = useScore;
        }
    }

    public void setCachingScores(boolean cachingScores) {
        this.cachingScores = cachingScores;
    }

    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = knowledge;
    }

    public void setUseRaskuttiUhler(boolean useRaskuttiUhler) {
        this.useRaskuttiUhler = useRaskuttiUhler;
        this.useScore = false;
    }

    public void setUseBackwardScoring(boolean useBackwardScoring) {
        this.useBackwardScoring = useBackwardScoring;
    }

    public double score(List<Node> order, Graph mag) {
        this.mag = mag;
        return this.score(order);
    }

    public double score(List<Node> order) {
        int i1;
        this.pi = new ArrayList<Node>(order);
        this.scores = new ArrayList();
        for (i1 = 0; i1 < order.size(); ++i1) {
            this.scores.add(null);
        }
        this.prefixes = new ArrayList();
        for (i1 = 0; i1 < order.size(); ++i1) {
            this.prefixes.add(null);
        }
        this.initializeScores();
        return this.score();
    }

    public double score() {
        return this.sum();
    }

    private double sum() {
        double score = 0.0;
        for (int i = 0; i < this.pi.size(); ++i) {
            if (this.scores.get(i) == null) {
                this.recalculate(i);
            }
            double score1 = this.scores.get(i).getScore();
            score += score1;
        }
        return score;
    }

    public boolean swaptuck(Node x, Node y, Node z, boolean doZ) {
        boolean moved = false;
        if (this.index(y) < this.index(x)) {
            this.moveTo(x, this.index(y));
            moved = true;
        }
        if (doZ && this.index(y) < this.index(z)) {
            this.moveTo(z, this.index(y));
            moved = true;
        }
        return moved;
    }

    public boolean swaptuck(Node x, Node y) {
        if (this.index(x) < this.index(y)) {
            return false;
        }
        if (this.index(y) < this.index(x)) {
            this.moveTo(x, this.index(y));
            return true;
        }
        return false;
    }

    public void tuckWithoutMovingAncestors(Node x, Node y) {
        if (this.index(x) > this.index(y)) {
            this.moveTo(x, this.index(y));
        }
    }

    public boolean tuck(Node k, Node j) {
        return this.tuck(k, this.index(j));
    }

    public boolean tuck(Node k, int j) {
        if (this.adjacent(k, this.get(j))) {
            return false;
        }
        if (j >= this.index(k)) {
            return false;
        }
        Set<Node> ancestors = this.getAncestors(k);
        for (int i = j + 1; i <= this.index(k); ++i) {
            if (!ancestors.contains(this.get(i))) continue;
            this.moveTo(this.get(i), j++);
        }
        return true;
    }

    public void moveTo(Node v, int toIndex) {
        int vIndex = this.index(v);
        if (vIndex == toIndex) {
            return;
        }
        if (this.lastMoveSame(vIndex, toIndex)) {
            return;
        }
        this.pi.remove(v);
        this.pi.add(toIndex, v);
        if (toIndex < vIndex) {
            this.updateScores(toIndex, vIndex);
        } else {
            this.updateScores(vIndex, toIndex);
        }
    }

    public boolean swap(Node m, Node n) {
        int i = this.orderHash.get(m);
        int j = this.orderHash.get(n);
        this.pi.set(i, n);
        this.pi.set(j, m);
        if (this.violatesKnowledge(this.pi)) {
            this.pi.set(i, m);
            this.pi.set(j, n);
            return false;
        }
        if (i < j) {
            this.updateScores(i, j);
        } else {
            this.updateScores(j, i);
        }
        return true;
    }

    public boolean coveredEdge(Node x, Node y) {
        Set<Node> px = this.getParents(x);
        Set<Node> py = this.getParents(y);
        px.remove(y);
        py.remove(x);
        return px.equals(py);
    }

    public List<Node> getPi() {
        return new ArrayList<Node>(this.pi);
    }

    public List<Node> getOrderShallow() {
        return this.pi;
    }

    public int index(Node v) {
        Integer integer = this.orderHash.get(v);
        if (integer == null) {
            throw new IllegalArgumentException("First 'evaluate' a permutation containing variable " + v + ".");
        }
        return integer;
    }

    public Set<Node> getParents(int p) {
        if (this.scores.get(p) == null) {
            this.recalculate(p);
        }
        return new HashSet<Node>(this.scores.get(p).getParents());
    }

    public Set<Node> getChildren(int p) {
        Set<Node> adj = this.getAdjacentNodes(this.get(p));
        adj.removeAll(this.getParents(p));
        return adj;
    }

    public Set<Node> getParents(Node v) {
        return this.getParents(this.index(v));
    }

    public Set<Node> getChildren(Node v) {
        return this.getChildren(this.index(v));
    }

    public Set<Node> getAdjacentNodes(Node v) {
        HashSet<Node> adj = new HashSet<Node>();
        for (Node w : this.pi) {
            if (!this.getParents(v).contains(w) && !this.getParents(w).contains(v)) continue;
            adj.add(w);
        }
        return adj;
    }

    public Set<Node> getAncestralNodes(Node v) {
        HashSet<Node> adj = new HashSet<Node>();
        for (Node w : this.pi) {
            if (!this.getAncestors(v).contains(w) && !this.getAncestors(w).contains(v)) continue;
            adj.add(w);
        }
        return adj;
    }

    public Graph getGraph(boolean cpDag) {
        if (cpDag) {
            List<Node> order = this.getPi();
            EdgeListGraph G1 = new EdgeListGraph(this.variables);
            for (int p = 0; p < order.size(); ++p) {
                for (Node z : this.getParents(p)) {
                    G1.addDirectedEdge(z, order.get(p));
                }
            }
            GraphUtils.replaceNodes(G1, this.variables);
            MeekRules rules = new MeekRules();
            rules.setKnowledge(this.knowledge);
            rules.orientImplied(G1);
            return G1;
        }
        List<Node> order = this.getPi();
        EdgeListGraph G1 = new EdgeListGraph(this.variables);
        for (int p = 0; p < order.size(); ++p) {
            for (Node z : this.getParents(p)) {
                G1.addDirectedEdge(z, order.get(p));
            }
        }
        GraphUtils.replaceNodes(G1, this.variables);
        return G1;
    }

    public void orientbk(Knowledge bk, Graph graph, List<Node> variables) {
        Node to;
        Node from;
        KnowledgeEdge edge;
        Iterator<KnowledgeEdge> it = bk.forbiddenEdgesIterator();
        while (it.hasNext() && !Thread.currentThread().isInterrupted()) {
            edge = it.next();
            from = SearchGraphUtils.translate(edge.getFrom(), variables);
            to = SearchGraphUtils.translate(edge.getTo(), variables);
            if (from == null || to == null || graph.getEdge(from, to) == null) continue;
            graph.setEndpoint(to, from, Endpoint.ARROW);
        }
        it = bk.requiredEdgesIterator();
        while (it.hasNext() && !Thread.currentThread().isInterrupted()) {
            edge = it.next();
            from = SearchGraphUtils.translate(edge.getFrom(), variables);
            to = SearchGraphUtils.translate(edge.getTo(), variables);
            if (from == null || to == null || graph.getEdge(from, to) == null) continue;
            graph.setEndpoint(from, to, Endpoint.ARROW);
        }
    }

    private List<Edge> orderEdges() {
        ArrayList<Edge> orderedEdges = new ArrayList<Edge>();
        int i = this.pi.size();
        block0: while (i-- > 0) {
            Node y = this.pi.get(i);
            Set<Node> pa = this.getParents(i);
            for (int j = 0; j < i; ++j) {
                Node x = this.pi.get(j);
                if (!pa.contains(x)) continue;
                Edge e = new Edge(x, y, Endpoint.TAIL, Endpoint.ARROW);
                orderedEdges.add(e);
                pa.remove(x);
                if (pa.isEmpty()) continue block0;
            }
        }
        return orderedEdges;
    }

    public Graph findCompelled() {
        EdgeListGraph G = new EdgeListGraph(this.variables);
        List<Edge> orderedEdges = this.orderEdges();
        Node remainderCompelled = null;
        Node remainderReversible = null;
        block0: while (!orderedEdges.isEmpty()) {
            Edge e = orderedEdges.remove(0);
            Node x = e.getNode1();
            Node y = e.getNode2();
            if (remainderCompelled != null) {
                if (remainderCompelled == y) {
                    G.addEdge(e);
                    continue;
                }
                remainderCompelled = null;
            }
            if (remainderReversible != null) {
                if (remainderReversible == y) {
                    G.addUndirectedEdge(x, y);
                    continue;
                }
                remainderReversible = null;
            }
            if (G.isParentOf(x, y)) continue;
            List<Node> compelled = G.getParents(x);
            Set<Node> xPa = this.getParents(x);
            Set<Node> yPa = this.getParents(y);
            for (Node w : compelled) {
                if (yPa.contains(w)) {
                    G.addEdge(e);
                    continue block0;
                }
                G.addDirectedEdge(w, y);
            }
            yPa.remove(x);
            for (Node z : yPa) {
                if (xPa.contains(z)) continue;
                G.addEdge(e);
                remainderCompelled = y;
                continue block0;
            }
            G.addUndirectedEdge(x, y);
            remainderReversible = y;
        }
        return G;
    }

    public List<NodePair> getAdjacencies() {
        List<Node> order = this.getPi();
        HashSet<NodePair> pairs = new HashSet<NodePair>();
        for (int i = 0; i < order.size(); ++i) {
            for (int j = 0; j < i; ++j) {
                Node y;
                Node x = order.get(i);
                if (!this.adjacent(x, y = order.get(j))) continue;
                pairs.add(new NodePair(x, y));
            }
        }
        return new ArrayList<NodePair>(pairs);
    }

    public Map<Node, Set<Node>> getAdjMap() {
        HashMap<Node, Set<Node>> adjMap = new HashMap<Node, Set<Node>>();
        for (Node node1 : this.getPi()) {
            if (!adjMap.containsKey(node1)) {
                adjMap.put(node1, new HashSet());
            }
            for (Node node2 : this.getParents(node1)) {
                if (!adjMap.containsKey(node2)) {
                    adjMap.put(node2, new HashSet());
                }
                ((Set)adjMap.get(node1)).add(node2);
                ((Set)adjMap.get(node2)).add(node1);
            }
        }
        return adjMap;
    }

    public Map<Node, Set<Node>> getChildMap() {
        HashMap<Node, Set<Node>> childMap = new HashMap<Node, Set<Node>>();
        for (Node node1 : this.getPi()) {
            for (Node node2 : this.getParents(node1)) {
                if (!childMap.containsKey(node2)) {
                    childMap.put(node2, new HashSet());
                }
                ((Set)childMap.get(node2)).add(node1);
            }
        }
        return childMap;
    }

    public Set<Node> getAncestors(Node node) {
        HashSet<Node> ancestors = new HashSet<Node>();
        this.collectAncestorsVisit(node, ancestors);
        return ancestors;
    }

    public Set<Node> getDescendants(Node node) {
        HashSet<Node> descendants = new HashSet<Node>();
        this.collectDescendantVisit(node, descendants);
        return descendants;
    }

    private void collectAncestorsVisit(Node node, Set<Node> ancestors) {
        if (ancestors.contains(node)) {
            return;
        }
        ancestors.add(node);
        Set<Node> parents = this.getParents(node);
        if (!parents.isEmpty()) {
            for (Node parent : parents) {
                this.collectAncestorsVisit(parent, ancestors);
            }
        }
    }

    private void collectDescendantVisit(Node node, Set<Node> ancestors) {
        if (ancestors.contains(node)) {
            return;
        }
        ancestors.add(node);
        Set<Node> children = this.getChildren(node);
        if (!children.isEmpty()) {
            for (Node parent : children) {
                this.collectDescendantVisit(parent, ancestors);
            }
        }
    }

    public List<OrderedPair<Node>> getEdges() {
        List<Node> order = this.getPi();
        ArrayList<OrderedPair<Node>> edges = new ArrayList<OrderedPair<Node>>();
        for (Node y : order) {
            for (Node x : this.getParents(y)) {
                edges.add(new OrderedPair<Node>(x, y));
            }
        }
        return edges;
    }

    public int getNumEdges() {
        int numEdges = 0;
        for (int p = 0; p < this.pi.size(); ++p) {
            numEdges += this.getParents(p).size();
        }
        return numEdges;
    }

    public Node get(int j) {
        return this.pi.get(j);
    }

    public void bookmark(int key) {
        try {
            this.bookmarkedOrders.put(key, new ArrayList<Node>(this.pi));
            this.bookmarkedScores.put(key, new ArrayList<Pair>(this.scores));
            this.bookmarkedOrderHashes.put(key, new HashMap<Node, Integer>(this.orderHash));
            this.bookmarkedRunningScores.put(key, this.runningScore);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void bookmark() {
        this.bookmark(Integer.MIN_VALUE);
    }

    public void goToBookmark(int key) {
        if (!this.bookmarkedOrders.containsKey(key)) {
            throw new IllegalArgumentException("That key was not bookmarked: " + key);
        }
        this.pi = new ArrayList(this.bookmarkedOrders.get(key));
        this.scores = new ArrayList(this.bookmarkedScores.get(key));
        this.orderHash = new HashMap<Node, Integer>(this.bookmarkedOrderHashes.get(key));
        this.runningScore = this.bookmarkedRunningScores.get(key);
    }

    public void goToBookmark() {
        this.goToBookmark(Integer.MIN_VALUE);
    }

    public void clearBookmarks() {
        this.bookmarkedOrders.clear();
        this.bookmarkedScores.clear();
        this.bookmarkedOrderHashes.clear();
        this.bookmarkedRunningScores.clear();
    }

    public int size() {
        return this.pi.size();
    }

    public void shuffleVariables() {
        this.pi = new ArrayList<Node>(this.pi);
        RandomUtil.shuffle(this.pi);
        this.score(this.pi);
    }

    public List<Node> getShuffledVariables() {
        List<Node> variables = this.getPi();
        RandomUtil.shuffle(variables);
        return variables;
    }

    public boolean adjacent(Node a, Node b) {
        if (a == b) {
            return false;
        }
        return this.getParents(a).contains(b) || this.getParents(b).contains(a);
    }

    public boolean ancestorAdjacent(Node a, Node b) {
        if (a == b) {
            return false;
        }
        return this.getAncestors(a).contains(b) || this.getAncestors(b).contains(a);
    }

    public boolean collider(Node a, Node b, Node c) {
        return this.getParents(b).contains(a) && this.getParents(b).contains(c);
    }

    public boolean ancestralCollider(Node a, Node b, Node c) {
        return this.getAncestors(b).contains(a) && this.getAncestors(b).contains(c);
    }

    public boolean triangle(Node a, Node b, Node c) {
        return this.adjacent(a, b) && this.adjacent(b, c) && this.adjacent(a, c);
    }

    public boolean clique(List<Node> W) {
        for (int i = 0; i < W.size(); ++i) {
            for (int j = i + 1; j < W.size(); ++j) {
                if (this.adjacent(W.get(i), W.get(j))) continue;
                return false;
            }
        }
        return true;
    }

    private boolean violatesKnowledge(List<Node> order) {
        if (!this.knowledge.isEmpty()) {
            for (int i = 0; i < order.size(); ++i) {
                for (int j = i + 1; j < order.size(); ++j) {
                    if (!this.knowledge.isForbidden(order.get(i).getName(), order.get(j).getName())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void initializeScores() {
        for (int i1 = 0; i1 < this.pi.size(); ++i1) {
            this.prefixes.set(i1, null);
        }
        this.updateScores(0, this.pi.size() - 1);
    }

    private void updateScores(int i1, int i2) {
        for (int i = i1; i <= i2; ++i) {
            this.orderHash.put(this.pi.get(i), i);
            this.scores.set(i, null);
        }
    }

    private double score(Node n, Set<Node> pi) {
        if (this.cachingScores) {
            this.cache.computeIfAbsent(n, w -> new HashMap());
            Double score = this.cache.get(n).get(pi);
            if (score != null) {
                return score;
            }
        }
        int[] parentIndices = new int[pi.size()];
        int k = 0;
        for (Node p : pi) {
            parentIndices[k++] = this.variablesHash.get(p);
        }
        if (this.mag != null) {
            ((MagSemBicScore)this.score).setMag(this.mag);
        }
        double v = this.score.localScore((int)this.variablesHash.get(n), parentIndices);
        if (this.cachingScores) {
            this.cache.computeIfAbsent(n, w -> new HashMap());
            this.cache.get(n).put(new HashSet<Node>(pi), v);
        }
        return v;
    }

    public Set<Node> getPrefix(int i) {
        HashSet<Node> prefix = new HashSet<Node>();
        for (int j = 0; j < i; ++j) {
            prefix.add(this.pi.get(j));
        }
        return prefix;
    }

    public Score getScoreObject() {
        return this.score;
    }

    public IndependenceTest getTestObject() {
        return this.test;
    }

    private void recalculate(int p) {
        if (this.prefixes.get(p) == null || !this.prefixes.get(p).containsAll(this.getPrefix(p))) {
            Pair p2 = this.getParentsInternal(p);
            this.runningScore = this.scores.get(p) == null ? (this.runningScore += p2.score) : (this.runningScore += p2.score - this.scores.get(p).score);
            this.scores.set(p, p2);
        }
    }

    private void nodesHash(Map<Node, Integer> nodesHash, List<Node> variables) {
        for (int i = 0; i < variables.size(); ++i) {
            nodesHash.put(variables.get(i), i);
        }
    }

    private boolean lastMoveSame(int i1, int i2) {
        if (i1 <= i2) {
            Set<Node> prefix0 = this.getPrefix(i1);
            for (int i = i1; i <= i2; ++i) {
                prefix0.add(this.get(i));
                if (prefix0.equals(this.prefixes.get(i))) continue;
                return false;
            }
        } else {
            Set<Node> prefix0 = this.getPrefix(i1);
            for (int i = i2; i <= i1; ++i) {
                prefix0.add(this.get(i));
                if (prefix0.equals(this.prefixes.get(i))) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    private Pair getGrowShrinkScore(int p) {
        LinkedHashSet<Node> parents;
        HashSet<Node> prefix;
        Node n = this.pi.get(p);
        double sMax = this.GST.GrowShrink(n, prefix = new HashSet<Node>(this.getPrefix(p)), parents = new LinkedHashSet<Node>());
        return new Pair(parents, Double.isNaN(sMax) ? Double.NEGATIVE_INFINITY : sMax);
    }

    private Pair getGrowShrinkIndependent(int p) {
        Node n = this.pi.get(p);
        HashSet<Node> parents = new HashSet<Node>();
        Set<Node> prefix = this.getPrefix(p);
        boolean changed1 = true;
        while (changed1) {
            changed1 = false;
            for (Node z0 : prefix) {
                if (parents.contains(z0) || !this.knowledge.isEmpty() && this.knowledge.isForbidden(z0.getName(), n.getName())) continue;
                if (!this.knowledge.isEmpty() && this.knowledge.isRequired(z0.getName(), n.getName())) {
                    parents.add(z0);
                    continue;
                }
                if (!this.test.checkIndependence(n, z0, new ArrayList<Node>(parents)).dependent()) continue;
                parents.add(z0);
                changed1 = true;
            }
            for (Node z1 : new HashSet(parents)) {
                if (!this.knowledge.isEmpty() && this.knowledge.isRequired(z1.getName(), n.getName())) continue;
                parents.remove(z1);
                if (this.test.checkIndependence(n, z1, new ArrayList<Node>(parents)).dependent()) {
                    parents.add(z1);
                    continue;
                }
                changed1 = true;
            }
        }
        return new Pair(parents, -parents.size());
    }

    private Pair getParentsInternal(int p) {
        if (this.useRaskuttiUhler) {
            return this.getRaskuttiUhlerParents(p);
        }
        if (this.useScore) {
            return this.getGrowShrinkScore(p);
        }
        return this.getGrowShrinkIndependent(p);
    }

    private Pair getRaskuttiUhlerParents(int p) {
        Node x = this.pi.get(p);
        HashSet<Node> parents = new HashSet<Node>();
        Set<Node> prefix = this.getPrefix(p);
        for (Node y : prefix) {
            HashSet<Node> minus = new HashSet<Node>(prefix);
            minus.remove(y);
            ArrayList<Node> z = new ArrayList<Node>(minus);
            Collections.sort(z);
            if (!this.test.checkIndependence(x, y, z).dependent()) continue;
            parents.add(y);
        }
        return new Pair(parents, -parents.size());
    }

    public Set<Set<Node>> getSkeleton() {
        List<Node> order = this.getPi();
        HashSet<Set<Node>> skeleton = new HashSet<Set<Node>>();
        for (Node y : order) {
            for (Node x : this.getParents(y)) {
                HashSet<Node> adj = new HashSet<Node>();
                adj.add(x);
                adj.add(y);
                skeleton.add(adj);
            }
        }
        return skeleton;
    }

    public boolean parent(Node k, Node j) {
        return this.getParents(j).contains(k);
    }

    private static class Pair {
        private final Set<Node> parents;
        private final double score;

        private Pair(Set<Node> parents, double score) {
            this.parents = parents;
            this.score = score;
        }

        public Set<Node> getParents() {
            return this.parents;
        }

        public double getScore() {
            return this.score;
        }

        public int hashCode() {
            return this.parents.hashCode() + (int)FastMath.floor(10000.0 * this.score);
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof Pair)) {
                return false;
            }
            Pair thatPair = (Pair)o;
            return this.parents.equals(thatPair.parents) && this.score == thatPair.score;
        }
    }

    class MyTask
    implements Callable<Boolean> {
        final List<Node> pi;
        final Map<Node, Integer> orderHash;
        TeyssierScorer scorer;
        int chunk;
        private final int from;
        private final int to;

        MyTask(List<Node> pi, TeyssierScorer scorer, int chunk, Map<Node, Integer> orderHash, int from, int to) {
            this.pi = pi;
            this.scorer = scorer;
            this.chunk = chunk;
            this.orderHash = orderHash;
            this.from = from;
            this.to = to;
        }

        @Override
        public Boolean call() throws InterruptedException {
            for (int i = this.from; i <= this.to; ++i) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException();
                }
                TeyssierScorer.this.recalculate(i);
            }
            return true;
        }
    }
}

