/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeEqualityMode;
import edu.cmu.tetrad.graph.NodePair;
import edu.cmu.tetrad.graph.OrderedPair;
import edu.cmu.tetrad.search.GraphScore;
import edu.cmu.tetrad.search.Score;
import edu.cmu.tetrad.search.SearchGraphUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.math3.util.FastMath;
import org.jetbrains.annotations.NotNull;

public class TeyssierScorer2 {
    private final List<Node> variables;
    private final Map<Node, Integer> variablesHash;
    private final Score score;
    private Map<Object, ArrayList<Node>> bookmarkedOrders = new HashMap<Object, ArrayList<Node>>();
    private Map<Object, ArrayList<Pair>> bookmarkedScores = new HashMap<Object, ArrayList<Pair>>();
    private Map<Object, Map<Node, Integer>> bookmarkedOrderHashes = new HashMap<Object, Map<Node, Integer>>();
    private Map<Object, Float> bookmarkedRunningScores = new HashMap<Object, Float>();
    private final Map<Node, Integer> orderHash;
    private List<Node> pi;
    private List<Pair> scores;
    private Knowledge knowledge = new Knowledge();
    private boolean useScore = true;
    private boolean useRaskuttiUhler;
    private boolean useBackwardScoring;
    private boolean cachingScores = true;
    private float runningScore = 0.0f;
    private int maxIndegree = -1;

    public TeyssierScorer2(TeyssierScorer2 scorer) {
        this.variables = new ArrayList<Node>(scorer.variables);
        this.variablesHash = new HashMap<Node, Integer>();
        for (Node node : scorer.variablesHash.keySet()) {
            this.variablesHash.put(node, scorer.variablesHash.get(node));
        }
        this.score = scorer.score;
        this.bookmarkedOrders = new HashMap<Object, ArrayList<Node>>();
        for (Object object : scorer.bookmarkedOrders.keySet()) {
            this.bookmarkedOrders.put(object, scorer.bookmarkedOrders.get(object));
        }
        this.bookmarkedScores = new HashMap<Object, ArrayList<Pair>>();
        for (Object object : scorer.bookmarkedScores.keySet()) {
            this.bookmarkedScores.put(object, new ArrayList(scorer.bookmarkedScores.get(object)));
        }
        this.bookmarkedOrderHashes = new HashMap<Object, Map<Node, Integer>>();
        for (Object object : scorer.bookmarkedOrderHashes.keySet()) {
            this.bookmarkedOrderHashes.put(object, new HashMap<Node, Integer>(scorer.bookmarkedOrderHashes.get(object)));
        }
        this.bookmarkedRunningScores = new HashMap<Object, Float>(scorer.bookmarkedRunningScores);
        this.orderHash = new HashMap<Node, Integer>(scorer.orderHash);
        this.pi = new ArrayList<Node>(scorer.pi);
        this.scores = new ArrayList<Pair>(scorer.scores);
        this.knowledge = scorer.knowledge;
        this.useScore = scorer.useScore;
        this.useRaskuttiUhler = scorer.useRaskuttiUhler;
        this.useBackwardScoring = scorer.useBackwardScoring;
        this.cachingScores = scorer.cachingScores;
        this.runningScore = scorer.runningScore;
        this.maxIndegree = scorer.maxIndegree;
    }

    public TeyssierScorer2(Score score) {
        NodeEqualityMode.setEqualityMode(NodeEqualityMode.Type.OBJECT);
        this.score = score;
        if (score == null) {
            throw new IllegalArgumentException("Need a score");
        }
        this.variables = score.getVariables();
        this.pi = new ArrayList<Node>(this.variables);
        this.orderHash = new HashMap<Node, Integer>();
        this.nodesHash(this.orderHash, this.pi);
        this.variablesHash = new HashMap<Node, Integer>();
        this.nodesHash(this.variablesHash, this.variables);
        if (score instanceof GraphScore) {
            this.useScore = false;
        }
    }

    public boolean tuck(Node k, int j) {
        if (!this.adjacent(k, this.get(j))) {
            return false;
        }
        if (j >= this.index(k)) {
            return false;
        }
        int _j = j;
        int _k = this.index(k);
        this.bookmark(-55);
        Set<Node> ancestors = this.getAncestors(k);
        for (int i = j + 1; i <= this.index(k); ++i) {
            if (!ancestors.contains(this.get(i))) continue;
            this.moveToNoUpdate(this.get(i), j++);
        }
        this.updateScores(_j, _k);
        return true;
    }

    public void setUseScore(boolean useScore) {
        if (!(this.score instanceof GraphScore)) {
            this.useScore = useScore;
        }
    }

    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = new Knowledge(knowledge);
    }

    public float score(List<Node> order) {
        this.pi = new ArrayList<Node>(order);
        this.scores = new ArrayList<Pair>();
        for (int i1 = 0; i1 < order.size(); ++i1) {
            this.scores.add(null);
        }
        this.clearBookmarks();
        this.initializeScores();
        return this.score();
    }

    public float score() {
        return this.sum();
    }

    private float sum() {
        float score = 0.0f;
        for (int i = 0; i < this.pi.size(); ++i) {
            float score1 = this.scores.get(i).getScore();
            score += score1;
        }
        return score;
    }

    public void moveTo(Node v, int toIndex) {
        int vIndex = this.index(v);
        if (vIndex == toIndex) {
            return;
        }
        this.pi.remove(v);
        this.pi.add(toIndex, v);
        if (toIndex < vIndex) {
            this.updateScores(toIndex, vIndex);
        } else {
            this.updateScores(vIndex, toIndex);
        }
    }

    public boolean swap(Node m, Node n) {
        int i = this.orderHash.get(m);
        int j = this.orderHash.get(n);
        this.pi.set(i, n);
        this.pi.set(j, m);
        if (this.violatesKnowledge(this.pi)) {
            this.pi.set(i, m);
            this.pi.set(j, n);
            return false;
        }
        if (i < j) {
            this.updateScores(i, j);
        } else {
            this.updateScores(j, i);
        }
        return true;
    }

    public boolean coveredEdge(Node x, Node y) {
        if (!this.adjacent(x, y)) {
            return false;
        }
        Set<Node> px = this.getParents(x);
        Set<Node> py = this.getParents(y);
        px.remove(y);
        py.remove(x);
        return px.equals(py);
    }

    public List<Node> getPi() {
        return new ArrayList<Node>(this.pi);
    }

    public int index(Node v) {
        Integer integer = this.orderHash.get(v);
        if (integer == null) {
            throw new IllegalArgumentException("First 'evaluate' a permutation containing variable " + v + ".");
        }
        return integer;
    }

    public Set<Node> getParents(int p) {
        return new HashSet<Node>(this.scores.get(p).getParents());
    }

    public Set<Node> getParents(Node v) {
        return this.getParents(this.index(v));
    }

    public Set<Node> getAdjacentNodes(Node v) {
        HashSet<Node> adj = new HashSet<Node>();
        for (Node w : this.pi) {
            if (!this.getParents(v).contains(w) && !this.getParents(w).contains(v)) continue;
            adj.add(w);
        }
        return adj;
    }

    public Graph getGraph(boolean cpDag) {
        List<Node> order = this.getPi();
        EdgeListGraph G1 = new EdgeListGraph(this.getPi());
        for (int p = 0; p < order.size(); ++p) {
            for (Node z : this.getParents(p)) {
                G1.addDirectedEdge(z, order.get(p));
            }
        }
        if (cpDag) {
            return SearchGraphUtils.cpdagForDag(G1);
        }
        return G1;
    }

    public List<NodePair> getAdjacencies() {
        List<Node> order = this.getPi();
        HashSet<NodePair> pairs = new HashSet<NodePair>();
        for (int i = 0; i < order.size(); ++i) {
            for (int j = 0; j < i; ++j) {
                Node y;
                Node x = order.get(i);
                if (!this.adjacent(x, y = order.get(j))) continue;
                pairs.add(new NodePair(x, y));
            }
        }
        return new ArrayList<NodePair>(pairs);
    }

    public Set<Node> getAncestors(Node node) {
        HashSet<Node> ancestors = new HashSet<Node>();
        this.collectAncestorsVisit(node, ancestors);
        return ancestors;
    }

    private void collectAncestorsVisit(Node node, Set<Node> ancestors) {
        if (ancestors.contains(node)) {
            return;
        }
        ancestors.add(node);
        Set<Node> parents = this.getParents(node);
        if (!parents.isEmpty()) {
            for (Node parent : parents) {
                this.collectAncestorsVisit(parent, ancestors);
            }
        }
    }

    public List<OrderedPair<Node>> getEdges() {
        List<Node> order = this.getPi();
        ArrayList<OrderedPair<Node>> edges = new ArrayList<OrderedPair<Node>>();
        for (Node y : order) {
            for (Node x : this.getParents(y)) {
                edges.add(new OrderedPair<Node>(x, y));
            }
        }
        return edges;
    }

    public int getNumEdges() {
        int numEdges = 0;
        for (int p = 0; p < this.pi.size(); ++p) {
            numEdges += this.getParents(p).size();
        }
        return numEdges;
    }

    public Node get(int j) {
        return this.pi.get(j);
    }

    public void bookmark(Object key) {
        if (!this.bookmarkedOrders.containsKey(key)) {
            this.bookmarkedOrders.put(key, new ArrayList<Node>(this.pi));
            this.bookmarkedScores.put(key, new ArrayList<Pair>(this.scores));
            this.bookmarkedOrderHashes.put(key, new HashMap<Node, Integer>(this.orderHash));
            this.bookmarkedRunningScores.put(key, Float.valueOf(this.runningScore));
        } else {
            int i;
            List pi2 = this.bookmarkedOrders.get(key);
            List scores2 = this.bookmarkedScores.get(key);
            Map<Node, Integer> hashes2 = this.bookmarkedOrderHashes.get(key);
            int first = 0;
            int last = this.size() - 1;
            for (i = 0; i < this.size(); ++i) {
                if (this.pi.get(i) == pi2.get(i)) continue;
                first = i;
                break;
            }
            for (i = this.size() - 1; i >= 0; --i) {
                if (this.pi.get(i) == pi2.get(i)) continue;
                last = i;
                break;
            }
            for (i = first; i <= last; ++i) {
                pi2.set(i, this.pi.get(i));
                scores2.set(i, this.scores.get(i));
                hashes2.put((Node)pi2.get(i), this.orderHash.get(pi2.get(i)));
            }
            this.bookmarkedRunningScores.put(key, Float.valueOf(this.runningScore));
        }
    }

    public void bookmark() {
        this.bookmark(Integer.MIN_VALUE);
    }

    public void goToBookmark(Object key) {
        int i;
        if (!this.bookmarkedOrders.containsKey(key)) {
            throw new IllegalArgumentException("That key was not bookmarked.");
        }
        List pi2 = this.bookmarkedOrders.get(key);
        List scores2 = this.bookmarkedScores.get(key);
        Map<Node, Integer> hashes2 = this.bookmarkedOrderHashes.get(key);
        Float runningScore2 = this.bookmarkedRunningScores.get(key);
        int first = this.size();
        int last = -1;
        for (i = 0; i < this.size(); ++i) {
            if (this.pi.get(i) == pi2.get(i)) continue;
            first = i;
            break;
        }
        for (i = this.size() - 1; i >= 0; --i) {
            if (this.pi.get(i) == pi2.get(i)) continue;
            last = i;
            break;
        }
        for (i = first; i <= last; ++i) {
            if (this.pi.get(i) == pi2.get(i)) continue;
            this.pi.set(i, (Node)pi2.get(i));
            this.scores.set(i, (Pair)scores2.get(i));
            this.orderHash.put(this.pi.get(i), hashes2.get(this.pi.get(i)));
        }
        this.runningScore = runningScore2.floatValue();
    }

    public void goToBookmark() {
        this.goToBookmark(Integer.MIN_VALUE);
    }

    public void clearBookmarks() {
        this.bookmarkedOrders.clear();
        this.bookmarkedScores.clear();
        this.bookmarkedOrderHashes.clear();
        this.bookmarkedRunningScores.clear();
    }

    public int size() {
        return this.pi.size();
    }

    public boolean adjacent(Node a, Node b) {
        if (a == b) {
            return false;
        }
        return this.parent(a, b) || this.parent(b, a);
    }

    public boolean collider(Node a, Node b, Node c) {
        return this.getParents(b).contains(a) && this.getParents(b).contains(c);
    }

    public boolean triangle(Node a, Node b, Node c) {
        return this.adjacent(a, b) && this.adjacent(b, c) && this.adjacent(a, c);
    }

    public boolean clique(List<Node> W) {
        for (int i = 0; i < W.size(); ++i) {
            for (int j = i + 1; j < W.size(); ++j) {
                if (this.adjacent(W.get(i), W.get(j))) continue;
                return false;
            }
        }
        return true;
    }

    private boolean violatesKnowledge(List<Node> order) {
        if (!this.knowledge.isEmpty()) {
            for (int i = 0; i < order.size(); ++i) {
                for (int j = i + 1; j < order.size(); ++j) {
                    if (!this.knowledge.isForbidden(order.get(i).getName(), order.get(j).getName())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void initializeScores() {
        this.updateScores(0, this.pi.size() - 1);
    }

    public void updateScores(int i1, int i2) {
        for (int i = i1; i <= i2; ++i) {
            this.orderHash.put(this.pi.get(i), i);
            this.recalculate(i);
        }
    }

    private int getChunkSize(int n) {
        int chunk = n / Runtime.getRuntime().availableProcessors();
        if (chunk < 100) {
            chunk = 100;
        }
        return chunk;
    }

    public void setMaxIndegree(int maxIndegree) {
        this.maxIndegree = maxIndegree;
    }

    private float score(Node n, Set<Node> pi) {
        int[] parentIndices = new int[pi.size()];
        int k = 0;
        for (Node p : pi) {
            parentIndices[k++] = this.variablesHash.get(p);
        }
        return (float)this.score.localScore((int)this.variablesHash.get(n), parentIndices);
    }

    public Set<Node> getPrefix(int i) {
        HashSet<Node> prefix = new HashSet<Node>();
        for (int j = 0; j < i; ++j) {
            prefix.add(this.pi.get(j));
        }
        return prefix;
    }

    private void recalculate(int p) {
        Pair p2 = this.getGrowShrinkScore(p);
        this.runningScore = this.scores.get(p) == null ? (this.runningScore += p2.score) : (this.runningScore += p2.score - this.scores.get(p).getScore());
        this.scores.set(p, p2);
    }

    private void nodesHash(Map<Node, Integer> nodesHash, List<Node> variables) {
        for (int i = 0; i < variables.size(); ++i) {
            nodesHash.put(variables.get(i), i);
        }
    }

    @NotNull
    private Pair getGrowShrinkScore(int p) {
        Node n = this.pi.get(p);
        HashSet<Node> parents = new HashSet<Node>();
        boolean changed = true;
        float sMax = this.score(n, new HashSet<Node>());
        Set<Node> prefix1 = this.getPrefix(p);
        ArrayList<Node> prefix = new ArrayList<Node>(prefix1);
        if (this.useBackwardScoring) {
            parents.addAll(prefix);
            sMax = this.score(n, parents);
            changed = false;
        }
        while (changed) {
            changed = false;
            Node z = null;
            for (Node z0 : prefix) {
                if (parents.contains(z0) || !this.knowledge.isEmpty() && this.knowledge.isForbidden(z0.getName(), n.getName())) continue;
                parents.add(z0);
                float s2 = this.score(n, parents);
                if (s2 > sMax) {
                    sMax = s2;
                    z = z0;
                }
                parents.remove(z0);
            }
            if (z == null) continue;
            parents.add(z);
            if (this.maxIndegree > 0 && parents.size() > this.maxIndegree) break;
            changed = true;
        }
        boolean changed2 = true;
        while (changed2) {
            changed2 = false;
            Node w = null;
            for (Node z0 : new HashSet<Node>(parents)) {
                parents.remove(z0);
                float s2 = this.score(n, parents);
                if (s2 > sMax) {
                    sMax = s2;
                    w = z0;
                }
                parents.add(z0);
            }
            if (w == null) continue;
            parents.remove(w);
            changed2 = true;
        }
        if (this.useScore) {
            return new Pair(parents, Float.isNaN(sMax) ? Float.NEGATIVE_INFINITY : sMax);
        }
        return new Pair(parents, -parents.size());
    }

    public Set<Set<Node>> getSkeleton() {
        List<Node> order = this.getPi();
        HashSet<Set<Node>> skeleton = new HashSet<Set<Node>>();
        for (Node y : order) {
            for (Node x : this.getParents(y)) {
                HashSet<Node> adj = new HashSet<Node>();
                adj.add(x);
                adj.add(y);
                skeleton.add(adj);
            }
        }
        return skeleton;
    }

    public void moveToNoUpdate(Node v, int toIndex) {
        if (!this.pi.contains(v)) {
            return;
        }
        int vIndex = this.index(v);
        if (vIndex == toIndex) {
            return;
        }
        this.pi.remove(v);
        this.pi.add(toIndex, v);
    }

    public boolean parent(Node k, Node j) {
        return this.getParents(j).contains(k);
    }

    public double remove(Node x) {
        Set<Node> adj = this.getAdjacentNodes(x);
        int index = this.index(x);
        this.scores.remove(index);
        this.pi.remove(x);
        this.orderHash.remove(x);
        this.variables.remove(x);
        this.variablesHash.remove(x);
        for (int i = index; i < this.pi.size(); ++i) {
            if (!adj.contains(this.get(i))) continue;
            this.recalculate(i);
            this.orderHash.put(this.pi.get(i), i);
        }
        this.updateScores(index, this.pi.size() - 1);
        this.clearBookmarks();
        return this.score();
    }

    public static class Pair {
        private final Set<Node> parents;
        private final float score;

        private Pair(Set<Node> parents, float score) {
            this.parents = parents;
            this.score = score;
        }

        public Set<Node> getParents() {
            return this.parents;
        }

        public float getScore() {
            return this.score;
        }

        public int hashCode() {
            return this.parents.hashCode() + (int)FastMath.floor(10000.0 * (double)this.score);
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof Pair)) {
                return false;
            }
            Pair thatPair = (Pair)o;
            return this.parents.equals(thatPair.parents) && this.score == thatPair.score;
        }
    }

    class MyTask
    implements Callable<Boolean> {
        final List<Node> pi;
        final Map<Node, Integer> orderHash;
        TeyssierScorer2 scorer;
        int chunk;
        private final int from;
        private final int to;

        MyTask(List<Node> pi, TeyssierScorer2 scorer, int chunk, Map<Node, Integer> orderHash, int from, int to) {
            this.pi = pi;
            this.scorer = scorer;
            this.chunk = chunk;
            this.orderHash = orderHash;
            this.from = from;
            this.to = to;
        }

        @Override
        public Boolean call() throws InterruptedException {
            for (int i = this.from; i <= this.to; ++i) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException();
                }
                TeyssierScorer2.this.recalculate(i);
            }
            return true;
        }
    }
}

