/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.MeekRules;
import edu.cmu.tetrad.search.Score;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.math3.util.FastMath;

public class TeyssierScorerExperimental {
    private final Score score;
    private final List<Node> variables;
    private final int n;
    private final int[] order;
    private final Map<Integer, Set<Integer>> parents;
    private final double[] scores;

    public TeyssierScorerExperimental(Score score) {
        this.score = score;
        this.variables = score.getVariables();
        this.n = this.variables.size();
        this.order = new int[this.n];
        this.parents = new HashMap<Integer, Set<Integer>>();
        this.scores = new double[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.order[i] = i;
        }
        this.reset();
    }

    private void reset() {
        for (int i = 0; i < this.n; ++i) {
            int x = this.order[i];
            HashSet<Integer> xParents = new HashSet<Integer>();
            this.parents.put(x, xParents);
            this.scores[x] = this.growShrink(i, i, Collections.emptySet(), xParents);
        }
    }

    public void shuffleOrder() {
        for (int i = 0; i < this.n - 2; ++i) {
            int j = RandomUtils.nextInt(i, this.n);
            int x = this.order[j];
            this.order[j] = this.order[i];
            this.order[i] = x;
        }
        this.reset();
    }

    public void setOrder(Graph graph) {
        LinkedList<Integer> order = new LinkedList<Integer>();
        for (int i : this.order) {
            order.add(i);
        }
        int i = this.n;
        while (i-- > 0) {
            int j;
            ListIterator itr = order.listIterator(order.size());
            while (!this.validSink(this.variables.get(j = ((Integer)itr.previous()).intValue()), graph)) {
            }
            graph.removeNode(this.variables.get(j));
            this.order[i] = j;
            itr.remove();
        }
        this.reset();
    }

    private boolean validSink(Node x, Graph graph) {
        LinkedList<Node> neighbors = new LinkedList<Node>();
        for (Edge edge : graph.getEdges(x)) {
            if (edge.getDistalEndpoint(x) == Endpoint.ARROW) {
                return false;
            }
            if (edge.getProximalEndpoint(x) != Endpoint.TAIL) continue;
            neighbors.add(edge.getDistalNode(x));
        }
        while (!neighbors.isEmpty()) {
            Node y = (Node)neighbors.pop();
            for (Node z : neighbors) {
                if (graph.isAdjacentTo(y, z)) continue;
                return false;
            }
        }
        return true;
    }

    public double getScore() {
        double score = 0.0;
        for (int i = 0; i < this.n; ++i) {
            score += this.scores[i];
        }
        return score;
    }

    public boolean hasParent(int i, int j) {
        return this.parents.get(this.order[i]).contains(this.order[j]);
    }

    private Set<Integer> getAncestors(int i, int j) {
        HashSet<Integer> ancestors = new HashSet<Integer>();
        ancestors.add(this.order[i]);
        for (int k = i; k > j; --k) {
            if (!ancestors.contains(this.order[k])) continue;
            ancestors.addAll((Collection<Integer>)this.parents.get(k));
        }
        ancestors.remove(this.order[j]);
        return ancestors;
    }

    public boolean tuck(int i, int j) {
        int x;
        Set<Integer> ancestors = this.getAncestors(i, j);
        HashMap<Integer, HashSet<Integer>> parents = new HashMap<Integer, HashSet<Integer>>();
        int n = i - j + 1;
        int[] order = new int[n];
        double[] scores = new double[n];
        double diff = 0.0;
        int ii = 0;
        int jj = n;
        while (i >= j) {
            x = this.order[i];
            HashSet<Integer> xParents = new HashSet<Integer>();
            parents.put(x, xParents);
            if (ancestors.contains(x)) {
                order[--jj] = x;
                scores[jj] = this.growShrink(i--, j, ancestors, xParents);
                diff += scores[jj] - this.scores[x];
                continue;
            }
            order[ii] = x;
            scores[ii] = this.growShrink(i--, j + n - 1, ancestors, xParents);
            diff += scores[ii++] - this.scores[x];
        }
        if (diff <= 0.0) {
            return false;
        }
        while (ii < n) {
            x = order[ii];
            this.order[j++] = x;
            this.parents.replace(x, (Set)parents.get(x));
            this.scores[x] = scores[ii++];
        }
        while (jj > 0) {
            x = order[--jj];
            this.order[j++] = x;
            this.parents.replace(x, (Set)parents.get(x));
            this.scores[x] = scores[jj];
        }
        return true;
    }

    private int[] toArray(Set<Integer> set) {
        int i = 0;
        int[] array = new int[set.size()];
        for (Integer j : set) {
            array[i++] = j;
        }
        return array;
    }

    private int[] toArray(Set<Integer> set, int remove) {
        int i = 0;
        int[] array = new int[set.size() - 1];
        for (Integer j : set) {
            if (j == remove) continue;
            array[i++] = j;
        }
        return array;
    }

    private double growShrink(int i, int j, Set<Integer> allowWithin, Set<Integer> parents) {
        int z;
        int x = this.order[i];
        double sMax = this.score.localScore(x, this.toArray(parents));
        int lb = FastMath.min(i, j);
        int ub = FastMath.max(i, j);
        do {
            z = -1;
            for (int k = 0; k <= ub; ++k) {
                int y;
                if (k == i || parents.contains(y = this.order[k]) || k >= lb && !allowWithin.contains(y)) continue;
                parents.add(y);
                double s = this.score.localScore(x, this.toArray(parents));
                parents.remove(y);
                if (s <= sMax) continue;
                sMax = s;
                z = y;
            }
            if (z == -1) continue;
            parents.add(z);
        } while (z != -1);
        do {
            z = -1;
            for (int remove : parents) {
                double s = this.score.localScore(x, this.toArray(parents, remove));
                if (s <= sMax) continue;
                sMax = s;
                z = remove;
            }
            if (z == -1) continue;
            parents.remove(z);
        } while (z != -1);
        return sMax;
    }

    public Graph getGraph(boolean cpDag) {
        EdgeListGraph graph = new EdgeListGraph(this.variables);
        for (int a : this.order) {
            for (int b : this.parents.get(a)) {
                graph.addDirectedEdge(this.variables.get(b), this.variables.get(a));
            }
        }
        if (cpDag) {
            MeekRules rules = new MeekRules();
            rules.orientImplied(graph);
        }
        return graph;
    }

    public int size() {
        return this.n;
    }
}

