/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.KnowledgeEdge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.graph.OrderedPair;
import edu.cmu.tetrad.search.GraphScorer;
import edu.cmu.tetrad.search.GraphSearch;
import edu.cmu.tetrad.search.ISemBicScore;
import edu.cmu.tetrad.search.LocalDiscreteScore;
import edu.cmu.tetrad.search.MeekRules;
import edu.cmu.tetrad.search.Score;
import edu.cmu.tetrad.search.ScoredGraph;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.ForkJoinPoolInstance;
import edu.cmu.tetrad.util.MillisecondTimes;
import edu.cmu.tetrad.util.TaskManager;
import edu.cmu.tetrad.util.TetradLogger;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.RecursiveTask;
import org.apache.commons.math3.util.FastMath;

public final class TsFges2
implements GraphSearch,
GraphScorer {
    private Knowledge knowledge = new Knowledge();
    private List<Node> variables;
    private Graph trueGraph;
    private Graph externalGraph;
    private Graph boundGraph;
    private long elapsedTime;
    private int cycleBound = -1;
    private Score score;
    private final TetradLogger logger = TetradLogger.getInstance();
    private final LinkedList<ScoredGraph> topGraphs = new LinkedList();
    private int numCPDAGsToStore;
    private boolean verbose;
    private SortedSet<Arrow> sortedArrows;
    private Map<OrderedPair<Node>, Set<Arrow>> lookupArrows;
    private Map<Node, Set<Node>> neighbors;
    private ConcurrentMap<Node, Integer> hashIndices;
    private ForkJoinPool pool = ForkJoinPoolInstance.getInstance().getPool();
    private double totalScore;
    private Graph effectEdgesGraph;
    private PrintStream out = System.out;
    private Graph adjacencies;
    private Graph graph;
    int arrowIndex;
    private double modelScore;
    private Mode mode = Mode.heuristicSpeedup;
    private boolean faithfulnessAssumed = false;
    private int maxIndegree = -1;
    final int maxThreads = ForkJoinPoolInstance.getInstance().getPool().getParallelism();
    final int[] count = new int[1];
    Set<Edge> removedEdges = new HashSet<Edge>();

    public TsFges2(Score score) {
        if (score == null) {
            throw new NullPointerException();
        }
        this.setScore(score);
        this.graph = new EdgeListGraph(this.getVariables());
    }

    public void setFaithfulnessAssumed(boolean faithfulnessAssumed) {
        this.faithfulnessAssumed = faithfulnessAssumed;
    }

    public boolean isFaithfulnessAssumed() {
        return this.faithfulnessAssumed;
    }

    @Override
    public Graph search() {
        this.topGraphs.clear();
        this.lookupArrows = new ConcurrentHashMap<OrderedPair<Node>, Set<Arrow>>();
        ArrayList<Node> nodes = new ArrayList<Node>(this.variables);
        this.graph = new EdgeListGraph(nodes);
        if (this.adjacencies != null) {
            this.adjacencies = GraphUtils.replaceNodes(this.adjacencies, nodes);
        }
        if (this.externalGraph != null) {
            this.graph = new EdgeListGraph(this.externalGraph);
            this.graph = GraphUtils.replaceNodes(this.graph, nodes);
        }
        this.addRequiredEdges(this.graph);
        if (this.faithfulnessAssumed) {
            this.initializeForwardEdgesFromEmptyGraph(this.getVariables());
            this.mode = Mode.heuristicSpeedup;
            this.fes();
            this.bes();
            this.mode = Mode.coverNoncolliders;
            this.initializeTwoStepEdges(this.getVariables());
        } else {
            this.initializeForwardEdgesFromEmptyGraph(this.getVariables());
            this.mode = Mode.heuristicSpeedup;
            this.fes();
            this.bes();
            this.mode = Mode.allowUnfaithfulness;
            this.initializeForwardEdgesFromExistingGraph(this.getVariables());
        }
        this.fes();
        this.bes();
        long start = MillisecondTimes.timeMillis();
        this.totalScore = 0.0;
        long endTime = MillisecondTimes.timeMillis();
        this.elapsedTime = endTime - start;
        this.logger.log("graph", "\nReturning this graph: " + this.graph);
        this.logger.log("info", "Elapsed time = " + (double)this.elapsedTime / 1000.0 + " s");
        this.logger.flush();
        this.modelScore = this.totalScore;
        return this.graph;
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = new Knowledge(knowledge);
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public void setTrueGraph(Graph trueGraph) {
        this.trueGraph = trueGraph;
    }

    public double getScore(Graph dag) {
        return this.scoreDag(dag);
    }

    public LinkedList<ScoredGraph> getTopGraphs() {
        return this.topGraphs;
    }

    public int getnumCPDAGsToStore() {
        return this.numCPDAGsToStore;
    }

    public void setNumCPDAGsToStore(int numCPDAGsToStore) {
        if (numCPDAGsToStore < 0) {
            throw new IllegalArgumentException("# graphs to store must at least 0: " + numCPDAGsToStore);
        }
        this.numCPDAGsToStore = numCPDAGsToStore;
    }

    public Graph getExternalGraph() {
        return this.externalGraph;
    }

    public void setExternalGraph(Graph externalGraph) {
        if (externalGraph != null) {
            externalGraph = GraphUtils.replaceNodes(externalGraph, this.variables);
            if (this.verbose) {
                this.out.println("Initial graph variables: " + externalGraph.getNodes());
                this.out.println("Data set variables: " + this.variables);
            }
            if (!new HashSet<Node>(externalGraph.getNodes()).equals(new HashSet<Node>(this.variables))) {
                throw new IllegalArgumentException("Variables aren't the same.");
            }
        }
        this.externalGraph = externalGraph;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setOut(PrintStream out) {
        this.out = out;
    }

    public PrintStream getOut() {
        return this.out;
    }

    public Graph getAdjacencies() {
        return this.adjacencies;
    }

    public void setAdjacencies(Graph adjacencies) {
        this.adjacencies = adjacencies;
    }

    public int getCycleBound() {
        return this.cycleBound;
    }

    public void setCycleBound(int cycleBound) {
        if (cycleBound != -1 && cycleBound < 1) {
            throw new IllegalArgumentException("Cycle bound needs to be -1 or >= 1: " + cycleBound);
        }
        this.cycleBound = cycleBound;
    }

    public void setParallelism(int numProcessors) {
        this.pool = new ForkJoinPool(numProcessors);
    }

    public void setBoundGraph(Graph boundGraph) {
        this.boundGraph = GraphUtils.replaceNodes(boundGraph, this.getVariables());
    }

    public double getPenaltyDiscount() {
        if (this.score instanceof ISemBicScore) {
            return ((ISemBicScore)this.score).getPenaltyDiscount();
        }
        return 2.0;
    }

    public void setSamplePrior(double samplePrior) {
        if (this.score instanceof LocalDiscreteScore) {
            ((LocalDiscreteScore)this.score).setSamplePrior(samplePrior);
        }
    }

    public void setStructurePrior(double expectedNumParents) {
        if (this.score instanceof LocalDiscreteScore) {
            ((LocalDiscreteScore)this.score).setStructurePrior(expectedNumParents);
        }
    }

    public void setPenaltyDiscount(double penaltyDiscount) {
        if (this.score instanceof ISemBicScore) {
            ((ISemBicScore)this.score).setPenaltyDiscount(penaltyDiscount);
        }
    }

    public int getMaxIndegree() {
        return this.maxIndegree;
    }

    public void setMaxIndegree(int maxIndegree) {
        if (maxIndegree < -1) {
            throw new IllegalArgumentException();
        }
        this.maxIndegree = maxIndegree;
    }

    private void setScore(Score totalScore) {
        this.score = totalScore;
        this.variables = new ArrayList<Node>();
        for (Node node : totalScore.getVariables()) {
            if (node.getNodeType() != NodeType.MEASURED) continue;
            this.variables.add(node);
        }
        this.buildIndexing(totalScore.getVariables());
        this.maxIndegree = this.score.getMaxDegree();
    }

    public int getMinChunk(int n) {
        int minChunk = 100;
        return FastMath.max(n / this.maxThreads, minChunk);
    }

    private void initializeForwardEdgesFromEmptyGraph(final List<Node> nodes) {
        this.sortedArrows = new ConcurrentSkipListSet<Arrow>();
        this.lookupArrows = new ConcurrentHashMap<OrderedPair<Node>, Set<Arrow>>();
        this.neighbors = new ConcurrentHashMap<Node, Set<Node>>();
        final HashSet emptySet = new HashSet();
        long start = MillisecondTimes.timeMillis();
        this.effectEdgesGraph = new EdgeListGraph(nodes);
        class InitializeFromEmptyGraphTask
        extends RecursiveTask<Boolean> {
            @Override
            protected Boolean compute() {
                ArrayDeque<NodeTaskEmptyGraph> tasks = new ArrayDeque<NodeTaskEmptyGraph>();
                int numNodesPerTask = FastMath.max(100, nodes.size() / TsFges2.this.maxThreads);
                for (int i = 0; i < nodes.size(); i += numNodesPerTask) {
                    NodeTaskEmptyGraph task = new NodeTaskEmptyGraph(i, FastMath.min(nodes.size(), i + numNodesPerTask), nodes, emptySet);
                    tasks.add(task);
                    task.fork();
                    for (NodeTaskEmptyGraph _task : new ArrayList(tasks)) {
                        if (!_task.isDone()) continue;
                        _task.join();
                        tasks.remove(_task);
                    }
                    while (tasks.size() > TsFges2.this.maxThreads) {
                        NodeTaskEmptyGraph _task = (NodeTaskEmptyGraph)tasks.poll();
                        _task.join();
                    }
                }
                for (NodeTaskEmptyGraph task : tasks) {
                    task.join();
                }
                return true;
            }
        }
        this.pool.invoke(new InitializeFromEmptyGraphTask());
        long stop = MillisecondTimes.timeMillis();
        if (this.verbose) {
            this.out.println("Elapsed initializeForwardEdgesFromEmptyGraph = " + (stop - start) + " ms");
        }
    }

    private void initializeTwoStepEdges(List<Node> nodes) {
        this.count[0] = 0;
        this.sortedArrows = new ConcurrentSkipListSet<Arrow>();
        this.lookupArrows = new ConcurrentHashMap<OrderedPair<Node>, Set<Arrow>>();
        this.neighbors = new ConcurrentHashMap<Node, Set<Node>>();
        if (this.effectEdgesGraph == null) {
            this.effectEdgesGraph = new EdgeListGraph(nodes);
        }
        if (this.externalGraph != null) {
            for (Edge edge : this.externalGraph.getEdges()) {
                if (this.effectEdgesGraph.isAdjacentTo(edge.getNode1(), edge.getNode2())) continue;
                this.effectEdgesGraph.addUndirectedEdge(edge.getNode1(), edge.getNode2());
            }
        }
        HashSet emptySet = new HashSet(0);
        class InitializeFromExistingGraphTask
        extends RecursiveTask<Boolean> {
            private final int chunk;
            private final int from;
            private final int to;
            final /* synthetic */ List val$nodes;
            final /* synthetic */ Set val$emptySet;

            public InitializeFromExistingGraphTask(int chunk, int from, int to) {
                this.val$nodes = list;
                this.val$emptySet = set;
                this.chunk = chunk;
                this.from = from;
                this.to = to;
            }

            @Override
            protected Boolean compute() {
                if (TaskManager.getInstance().isCanceled()) {
                    return false;
                }
                if (this.to - this.from <= this.chunk) {
                    for (int i = this.from; i < this.to; ++i) {
                        if ((i + 1) % 1000 == 0) {
                            TsFges2.this.count[0] = TsFges2.this.count[0] + 1000;
                            TsFges2.this.out.println("Initializing effect edges: " + TsFges2.this.count[0]);
                        }
                        Node y = (Node)this.val$nodes.get(i);
                        HashSet<Node> g = new HashSet<Node>();
                        for (Node n : TsFges2.this.graph.getAdjacentNodes(y)) {
                            for (Node m : TsFges2.this.graph.getAdjacentNodes(n)) {
                                if (TsFges2.this.graph.isAdjacentTo(y, m) || TsFges2.this.graph.isDefCollider(m, n, y)) continue;
                                g.add(m);
                            }
                        }
                        for (Node x : g) {
                            if (TsFges2.this.existsKnowledge() && (TsFges2.this.getKnowledge().isForbidden(x.getName(), y.getName()) && TsFges2.this.getKnowledge().isForbidden(y.getName(), x.getName()) || !TsFges2.this.validSetByKnowledge(y, this.val$emptySet)) || TsFges2.this.adjacencies != null && !TsFges2.this.adjacencies.isAdjacentTo(x, y) || TsFges2.this.removedEdges.contains(Edges.undirectedEdge(x, y))) continue;
                            TsFges2.this.calculateArrowsForward(x, y);
                        }
                    }
                } else {
                    int mid = (this.to + this.from) / 2;
                    InitializeFromExistingGraphTask left = new InitializeFromExistingGraphTask(this.chunk, this.from, mid);
                    InitializeFromExistingGraphTask right = new InitializeFromExistingGraphTask(this.chunk, mid, this.to);
                    left.fork();
                    right.compute();
                    left.join();
                }
                return true;
            }
        }
        this.pool.invoke(new InitializeFromExistingGraphTask(this.getMinChunk(nodes.size()), 0, nodes.size()));
    }

    private void initializeForwardEdgesFromExistingGraph(List<Node> nodes) {
        this.count[0] = 0;
        this.sortedArrows = new ConcurrentSkipListSet<Arrow>();
        this.lookupArrows = new ConcurrentHashMap<OrderedPair<Node>, Set<Arrow>>();
        this.neighbors = new ConcurrentHashMap<Node, Set<Node>>();
        if (this.effectEdgesGraph == null) {
            this.effectEdgesGraph = new EdgeListGraph(nodes);
        }
        if (this.externalGraph != null) {
            for (Edge edge : this.externalGraph.getEdges()) {
                if (this.effectEdgesGraph.isAdjacentTo(edge.getNode1(), edge.getNode2())) continue;
                this.effectEdgesGraph.addUndirectedEdge(edge.getNode1(), edge.getNode2());
            }
        }
        HashSet emptySet = new HashSet(0);
        class InitializeFromExistingGraphTask
        extends RecursiveTask<Boolean> {
            private final int chunk;
            private final int from;
            private final int to;
            final /* synthetic */ List val$nodes;
            final /* synthetic */ Set val$emptySet;

            public InitializeFromExistingGraphTask(int chunk, int from, int to) {
                this.val$nodes = list;
                this.val$emptySet = set;
                this.chunk = chunk;
                this.from = from;
                this.to = to;
            }

            @Override
            protected Boolean compute() {
                if (TaskManager.getInstance().isCanceled()) {
                    return false;
                }
                if (this.to - this.from <= this.chunk) {
                    for (int i = this.from; i < this.to && !Thread.currentThread().isInterrupted(); ++i) {
                        if ((i + 1) % 1000 == 0) {
                            TsFges2.this.count[0] = TsFges2.this.count[0] + 1000;
                            TsFges2.this.out.println("Initializing effect edges: " + TsFges2.this.count[0]);
                        }
                        Node y = (Node)this.val$nodes.get(i);
                        ArrayList<Node> cond = new ArrayList<Node>();
                        HashSet<Node> D = new HashSet<Node>(TsFges2.this.graph.paths().getDconnectedVars(y, cond));
                        D.remove(y);
                        TsFges2.this.effectEdgesGraph.getAdjacentNodes(y).forEach(D::remove);
                        for (Node x : D) {
                            if (TsFges2.this.existsKnowledge() && (TsFges2.this.getKnowledge().isForbidden(x.getName(), y.getName()) && TsFges2.this.getKnowledge().isForbidden(y.getName(), x.getName()) || !TsFges2.this.validSetByKnowledge(y, this.val$emptySet)) || TsFges2.this.adjacencies != null && !TsFges2.this.adjacencies.isAdjacentTo(x, y)) continue;
                            TsFges2.this.calculateArrowsForward(x, y);
                        }
                    }
                } else {
                    int mid = (this.to + this.from) / 2;
                    InitializeFromExistingGraphTask left = new InitializeFromExistingGraphTask(this.chunk, this.from, mid);
                    InitializeFromExistingGraphTask right = new InitializeFromExistingGraphTask(this.chunk, mid, this.to);
                    left.fork();
                    right.compute();
                    left.join();
                }
                return true;
            }
        }
        this.pool.invoke(new InitializeFromExistingGraphTask(this.getMinChunk(nodes.size()), 0, nodes.size()));
    }

    private void fes() {
        TetradLogger.getInstance().log("info", "** FORWARD EQUIVALENCE SEARCH");
        while (!this.sortedArrows.isEmpty() && !Thread.currentThread().isInterrupted()) {
            double bump;
            Set<Node> T;
            boolean inserted;
            Node y;
            Arrow arrow = this.sortedArrows.first();
            this.sortedArrows.remove(arrow);
            Node x = arrow.getA();
            if (this.graph.isAdjacentTo(x, y = arrow.getB()) || !arrow.getNaYX().equals(this.getNaYX(x, y)) || !this.getTNeighbors(x, y).containsAll(arrow.getHOrT()) || !this.validInsert(x, y, arrow.getHOrT(), this.getNaYX(x, y)) || !(inserted = this.insert(x, y, T = arrow.getHOrT(), bump = arrow.getBump()))) continue;
            this.totalScore += bump;
            Set<Node> visited = this.reapplyOrientation(x, y, null);
            HashSet<Node> toProcess = new HashSet<Node>();
            for (Node node : visited) {
                Set<Node> storedNeighbors;
                if (Thread.currentThread().isInterrupted()) break;
                Set<Node> neighbors1 = this.getNeighbors(node);
                if (neighbors1.equals(storedNeighbors = this.neighbors.get(node))) continue;
                toProcess.add(node);
            }
            toProcess.add(x);
            toProcess.add(y);
            this.storeGraph();
            this.reevaluateForward(toProcess, arrow);
        }
    }

    private void bes() {
        TetradLogger.getInstance().log("info", "** BACKWARD EQUIVALENCE SEARCH");
        this.sortedArrows = new ConcurrentSkipListSet<Arrow>();
        this.lookupArrows = new ConcurrentHashMap<OrderedPair<Node>, Set<Arrow>>();
        this.neighbors = new ConcurrentHashMap<Node, Set<Node>>();
        this.initializeArrowsBackward();
        while (!this.sortedArrows.isEmpty() && !Thread.currentThread().isInterrupted()) {
            double bump;
            Set<Node> H;
            boolean deleted;
            Edge edge;
            Arrow arrow = this.sortedArrows.first();
            this.sortedArrows.remove(arrow);
            Node x = arrow.getA();
            Node y = arrow.getB();
            if (!arrow.getNaYX().equals(this.getNaYX(x, y)) || !this.graph.isAdjacentTo(x, y) || (edge = this.graph.getEdge(x, y)).pointsTowards(x)) continue;
            HashSet<Node> diff = new HashSet<Node>(arrow.getNaYX());
            diff.removeAll(arrow.getHOrT());
            if (!this.validDelete(x, y, arrow.getHOrT(), arrow.getNaYX()) || !(deleted = this.delete(x, y, H = arrow.getHOrT(), bump = arrow.getBump(), arrow.getNaYX()))) continue;
            this.totalScore += bump;
            this.clearArrow(x, y);
            Set<Node> visited = this.reapplyOrientation(x, y, H);
            HashSet<Node> toProcess = new HashSet<Node>();
            for (Node node : visited) {
                Set<Node> storedNeighbors;
                Set<Node> neighbors1 = this.getNeighbors(node);
                if (neighbors1.equals(storedNeighbors = this.neighbors.get(node))) continue;
                toProcess.add(node);
            }
            toProcess.add(x);
            toProcess.add(y);
            toProcess.addAll(this.getCommonAdjacents(x, y));
            this.storeGraph();
            this.reevaluateBackward(toProcess);
        }
        this.meekOrientRestricted(this.getVariables(), this.getKnowledge());
    }

    private Set<Node> getCommonAdjacents(Node x, Node y) {
        HashSet<Node> commonChildren = new HashSet<Node>(this.graph.getAdjacentNodes(x));
        commonChildren.retainAll(this.graph.getAdjacentNodes(y));
        return commonChildren;
    }

    private Set<Node> reapplyOrientation(Node x, Node y, Set<Node> newArrows) {
        HashSet<Node> toProcess = new HashSet<Node>();
        toProcess.add(x);
        toProcess.add(y);
        if (newArrows != null) {
            toProcess.addAll(newArrows);
        }
        return this.meekOrientRestricted(new ArrayList<Node>(toProcess), this.getKnowledge());
    }

    private boolean existsKnowledge() {
        return !this.knowledge.isEmpty();
    }

    private void initializeArrowsBackward() {
        for (Edge edge : this.graph.getEdges()) {
            if (Thread.currentThread().isInterrupted()) break;
            Node x = edge.getNode1();
            Node y = edge.getNode2();
            if (this.existsKnowledge() && !this.getKnowledge().noEdgeRequired(x.getName(), y.getName())) continue;
            this.clearArrow(x, y);
            this.clearArrow(y, x);
            if (edge.pointsTowards(y)) {
                this.calculateArrowsBackward(x, y);
            } else if (edge.pointsTowards(x)) {
                this.calculateArrowsBackward(y, x);
            } else {
                this.calculateArrowsBackward(x, y);
                this.calculateArrowsBackward(y, x);
            }
            this.neighbors.put(x, this.getNeighbors(x));
            this.neighbors.put(y, this.getNeighbors(y));
        }
    }

    private void reevaluateForward(Set<Node> nodes, Arrow arrow) {
        class AdjTask
        extends RecursiveTask<Boolean> {
            private final List<Node> nodes;
            private final int from;
            private final int to;
            private final int chunk;

            public AdjTask(int chunk, List<Node> nodes, int from, int to) {
                this.nodes = nodes;
                this.from = from;
                this.to = to;
                this.chunk = chunk;
            }

            @Override
            protected Boolean compute() {
                if (this.to - this.from <= this.chunk) {
                    for (int _w = this.from; _w < this.to && !Thread.currentThread().isInterrupted(); ++_w) {
                        List<Node> adj;
                        Node x = this.nodes.get(_w);
                        if (TsFges2.this.mode == Mode.heuristicSpeedup) {
                            adj = TsFges2.this.effectEdgesGraph.getAdjacentNodes(x);
                        } else if (TsFges2.this.mode == Mode.coverNoncolliders) {
                            HashSet<Node> g = new HashSet<Node>();
                            for (Node n : TsFges2.this.graph.getAdjacentNodes(x)) {
                                for (Node m : TsFges2.this.graph.getAdjacentNodes(n)) {
                                    if (TsFges2.this.graph.isAdjacentTo(x, m) || TsFges2.this.graph.isDefCollider(m, n, x)) continue;
                                    g.add(m);
                                }
                            }
                            adj = new ArrayList<Node>(g);
                        } else if (TsFges2.this.mode == Mode.allowUnfaithfulness) {
                            HashSet<Node> D = new HashSet<Node>(TsFges2.this.graph.paths().getDconnectedVars(x, new ArrayList<Node>()));
                            D.remove(x);
                            adj = new ArrayList<Node>(D);
                        } else {
                            throw new IllegalStateException();
                        }
                        for (Node w : adj) {
                            if (TsFges2.this.adjacencies != null && !TsFges2.this.adjacencies.isAdjacentTo(w, x) || w == x || TsFges2.this.graph.isAdjacentTo(w, x)) continue;
                            TsFges2.this.clearArrow(w, x);
                            TsFges2.this.calculateArrowsForward(w, x);
                        }
                    }
                } else {
                    int mid = (this.to - this.from) / 2;
                    ArrayList<AdjTask> tasks = new ArrayList<AdjTask>();
                    tasks.add(new AdjTask(this.chunk, this.nodes, this.from, this.from + mid));
                    tasks.add(new AdjTask(this.chunk, this.nodes, this.from + mid, this.to));
                    ForkJoinTask.invokeAll(tasks);
                }
                return true;
            }
        }
        AdjTask task = new AdjTask(this.getMinChunk(nodes.size()), new ArrayList<Node>(nodes), 0, nodes.size());
        this.pool.invoke(task);
    }

    private void calculateArrowsForward(Node a, Node b) {
        if (this.mode == Mode.heuristicSpeedup && !this.effectEdgesGraph.isAdjacentTo(a, b)) {
            return;
        }
        if (this.adjacencies != null && !this.adjacencies.isAdjacentTo(a, b)) {
            return;
        }
        this.neighbors.put(b, this.getNeighbors(b));
        if (this.existsKnowledge() && this.getKnowledge().isForbidden(a.getName(), b.getName())) {
            return;
        }
        Set<Node> naYX = this.getNaYX(a, b);
        if (!GraphUtils.isClique(naYX, this.graph)) {
            return;
        }
        List<Node> TNeighbors = this.getTNeighbors(a, b);
        int _maxIndegree = this.maxIndegree == -1 ? 1000 : this.maxIndegree;
        int _max = FastMath.min(TNeighbors.size(), _maxIndegree - this.graph.getIndegree(b));
        HashSet previousCliques = new HashSet();
        previousCliques.add(new HashSet());
        HashSet<HashSet<Node>> newCliques = new HashSet<HashSet<Node>>();
        block0: for (int i = 0; i <= _max; ++i) {
            int[] choice;
            ChoiceGenerator gen = new ChoiceGenerator(TNeighbors.size(), i);
            while ((choice = gen.next()) != null && !Thread.currentThread().isInterrupted()) {
                Set<Node> T = GraphUtils.asSet(choice, TNeighbors);
                HashSet<Node> union = new HashSet<Node>(naYX);
                union.addAll(T);
                boolean foundAPreviousClique = false;
                for (Set set : previousCliques) {
                    if (!union.containsAll(set)) continue;
                    foundAPreviousClique = true;
                    break;
                }
                if (!foundAPreviousClique) break block0;
                if (!GraphUtils.isClique(union, this.graph)) continue;
                newCliques.add(union);
                double bump = this.insertEval(a, b, T, naYX, this.hashIndices);
                if (!(bump > 0.0)) continue;
                this.addArrow(a, b, naYX, T, bump);
            }
            previousCliques = newCliques;
            newCliques = new HashSet();
        }
    }

    private void addArrow(Node a, Node b, Set<Node> naYX, Set<Node> hOrT, double bump) {
        Arrow arrow = new Arrow(bump, a, b, hOrT, naYX, this.arrowIndex++);
        this.sortedArrows.add(arrow);
        this.addLookupArrow(a, b, arrow);
    }

    private void reevaluateBackward(Set<Node> toProcess) {
        for (Node r : toProcess) {
            this.neighbors.put(r, this.getNeighbors(r));
            List<Node> adjacentNodes = this.graph.getAdjacentNodes(r);
            class BackwardTask
            extends RecursiveTask<Boolean> {
                private final Node r;
                private final List<Node> adj;
                private final Map<Node, Integer> hashIndices;
                private final int chunk;
                private final int from;
                private final int to;

                public BackwardTask(Node r, List<Node> adj, int chunk, int from, int to, Map<Node, Integer> hashIndices) {
                    this.adj = adj;
                    this.hashIndices = hashIndices;
                    this.chunk = chunk;
                    this.from = from;
                    this.to = to;
                    this.r = r;
                }

                @Override
                protected Boolean compute() {
                    if (this.to - this.from <= this.chunk) {
                        for (int _w = this.from; _w < this.to; ++_w) {
                            Node w = this.adj.get(_w);
                            Edge e = TsFges2.this.graph.getEdge(w, this.r);
                            if (e == null) continue;
                            if (e.pointsTowards(this.r)) {
                                TsFges2.this.clearArrow(w, this.r);
                                TsFges2.this.clearArrow(this.r, w);
                                TsFges2.this.calculateArrowsBackward(w, this.r);
                                continue;
                            }
                            if (!Edges.isUndirectedEdge(TsFges2.this.graph.getEdge(w, this.r))) continue;
                            TsFges2.this.clearArrow(w, this.r);
                            TsFges2.this.clearArrow(this.r, w);
                            TsFges2.this.calculateArrowsBackward(w, this.r);
                            TsFges2.this.calculateArrowsBackward(this.r, w);
                        }
                    } else {
                        int mid = (this.to - this.from) / 2;
                        ArrayList<BackwardTask> tasks = new ArrayList<BackwardTask>();
                        tasks.add(new BackwardTask(this.r, this.adj, this.chunk, this.from, this.from + mid, this.hashIndices));
                        tasks.add(new BackwardTask(this.r, this.adj, this.chunk, this.from + mid, this.to, this.hashIndices));
                        ForkJoinTask.invokeAll(tasks);
                    }
                    return true;
                }
            }
            this.pool.invoke(new BackwardTask(r, adjacentNodes, this.getMinChunk(adjacentNodes.size()), 0, adjacentNodes.size(), this.hashIndices));
        }
    }

    private void calculateArrowsBackward(Node a, Node b) {
        if (this.existsKnowledge() && !this.getKnowledge().noEdgeRequired(a.getName(), b.getName())) {
            return;
        }
        Set<Node> naYX = this.getNaYX(a, b);
        ArrayList<Node> _naYX = new ArrayList<Node>(naYX);
        int _depth = _naYX.size();
        for (int i = 0; i <= _depth; ++i) {
            int[] choice;
            ChoiceGenerator gen = new ChoiceGenerator(_naYX.size(), i);
            while ((choice = gen.next()) != null && !Thread.currentThread().isInterrupted()) {
                double bump;
                Set<Node> diff = GraphUtils.asSet(choice, _naYX);
                HashSet<Node> h = new HashSet<Node>(_naYX);
                h.removeAll(diff);
                if (this.existsKnowledge() && !this.validSetByKnowledge(b, h) || !((bump = this.deleteEval(a, b, diff, naYX, this.hashIndices)) > 0.0)) continue;
                this.addArrow(a, b, naYX, h, bump);
            }
        }
    }

    public double getModelScore() {
        return this.modelScore;
    }

    private List<Node> getTNeighbors(Node x, Node y) {
        List<Edge> yEdges = this.graph.getEdges(y);
        ArrayList<Node> tNeighbors = new ArrayList<Node>();
        for (Edge edge : yEdges) {
            Node z;
            if (!Edges.isUndirectedEdge(edge) || this.graph.isAdjacentTo(z = edge.getDistalNode(y), x)) continue;
            tNeighbors.add(z);
        }
        return tNeighbors;
    }

    private Set<Node> getNeighbors(Node y) {
        List<Edge> yEdges = this.graph.getEdges(y);
        HashSet<Node> neighbors = new HashSet<Node>();
        for (Edge edge : yEdges) {
            if (!Edges.isUndirectedEdge(edge)) continue;
            Node z = edge.getDistalNode(y);
            neighbors.add(z);
        }
        return neighbors;
    }

    private double insertEval(Node x, Node y, Set<Node> t, Set<Node> naYX, Map<Node, Integer> hashIndices) {
        HashSet<Node> set = new HashSet<Node>(naYX);
        set.addAll(t);
        set.addAll(this.graph.getParents(y));
        return this.scoreGraphChange(y, set, x, hashIndices);
    }

    private double deleteEval(Node x, Node y, Set<Node> diff, Set<Node> naYX, Map<Node, Integer> hashIndices) {
        HashSet<Node> set = new HashSet<Node>(diff);
        set.addAll(this.graph.getParents(y));
        set.remove(x);
        return -this.scoreGraphChange(y, set, x, hashIndices);
    }

    private boolean insert(Node x, Node y, Set<Node> T, double bump) {
        int numEdges;
        if (this.graph.isAdjacentTo(x, y)) {
            return false;
        }
        Edge trueEdge = null;
        if (this.trueGraph != null) {
            Node _x = this.trueGraph.getNode(x.getName());
            Node _y = this.trueGraph.getNode(y.getName());
            trueEdge = this.trueGraph.getEdge(_x, _y);
        }
        if (this.boundGraph != null && !this.boundGraph.isAdjacentTo(x, y)) {
            return false;
        }
        this.graph.addDirectedEdge(x, y);
        this.addSimilarEdges(x, y);
        if (this.verbose) {
            String label = this.trueGraph != null && trueEdge != null ? "*" : "";
            TetradLogger.getInstance().log("insertedEdges", this.graph.getNumEdges() + ". INSERT " + this.graph.getEdge(x, y) + " " + T + " " + bump + " " + label);
        }
        if ((numEdges = this.graph.getNumEdges()) % 1000 == 0) {
            this.out.println("Num edges added: " + numEdges);
        }
        if (this.verbose) {
            String label = this.trueGraph != null && trueEdge != null ? "*" : "";
            this.out.println(this.graph.getNumEdges() + ". INSERT " + this.graph.getEdge(x, y) + " " + T + " " + bump + " " + label + " degree = " + GraphUtils.getDegree(this.graph) + " indegree = " + GraphUtils.getIndegree(this.graph));
        }
        for (Node _t : T) {
            if (Thread.currentThread().isInterrupted()) break;
            this.graph.removeEdge(_t, y);
            this.removeSimilarEdges(_t, y);
            if (this.boundGraph != null && !this.boundGraph.isAdjacentTo(_t, y)) continue;
            this.graph.addDirectedEdge(_t, y);
            this.addSimilarEdges(_t, y);
            if (!this.verbose) continue;
            String message = "--- Directing " + this.graph.getEdge(_t, y);
            TetradLogger.getInstance().log("directedEdges", message);
            this.out.println(message);
        }
        return true;
    }

    private boolean delete(Node x, Node y, Set<Node> H, double bump, Set<Node> naYX) {
        Edge trueEdge = null;
        if (this.trueGraph != null) {
            Node _x = this.trueGraph.getNode(x.getName());
            Node _y = this.trueGraph.getNode(y.getName());
            trueEdge = this.trueGraph.getEdge(_x, _y);
        }
        Edge oldxy = this.graph.getEdge(x, y);
        HashSet<Node> diff = new HashSet<Node>(naYX);
        diff.removeAll(H);
        this.graph.removeEdge(oldxy);
        this.removedEdges.add(Edges.undirectedEdge(x, y));
        this.removeSimilarEdges(x, y);
        int numEdges = this.graph.getNumEdges();
        if (numEdges % 1000 == 0) {
            this.out.println("Num edges (backwards) = " + numEdges);
        }
        if (this.verbose) {
            String label = this.trueGraph != null && trueEdge != null ? "*" : "";
            String message = this.graph.getNumEdges() + ". DELETE " + x + "-->" + y + " H = " + H + " NaYX = " + naYX + " diff = " + diff + " (" + bump + ") " + label;
            TetradLogger.getInstance().log("deletedEdges", message);
            this.out.println(message);
        }
        for (Node h : H) {
            Edge oldxh;
            if (this.graph.isParentOf(h, y) || this.graph.isParentOf(h, x)) continue;
            Edge oldyh = this.graph.getEdge(y, h);
            this.graph.removeEdge(oldyh);
            this.graph.addEdge(Edges.directedEdge(y, h));
            this.removeSimilarEdges(y, h);
            this.addSimilarEdges(y, h);
            if (this.verbose) {
                TetradLogger.getInstance().log("directedEdges", "--- Directing " + oldyh + " to " + this.graph.getEdge(y, h));
                this.out.println("--- Directing " + oldyh + " to " + this.graph.getEdge(y, h));
            }
            if (!Edges.isUndirectedEdge(oldxh = this.graph.getEdge(x, h))) continue;
            this.graph.removeEdge(oldxh);
            this.graph.addEdge(Edges.directedEdge(x, h));
            this.removeSimilarEdges(x, h);
            this.addSimilarEdges(x, h);
            if (!this.verbose) continue;
            TetradLogger.getInstance().log("directedEdges", "--- Directing " + oldxh + " to " + this.graph.getEdge(x, h));
            this.out.println("--- Directing " + oldxh + " to " + this.graph.getEdge(x, h));
        }
        return true;
    }

    private boolean validInsert(Node x, Node y, Set<Node> T, Set<Node> naYX) {
        boolean violatesKnowledge = false;
        if (this.existsKnowledge()) {
            if (this.knowledge.isForbidden(x.getName(), y.getName())) {
                violatesKnowledge = true;
            }
            for (Node t : T) {
                if (!this.knowledge.isForbidden(t.getName(), y.getName())) continue;
                violatesKnowledge = true;
            }
        }
        HashSet<Node> union = new HashSet<Node>(T);
        union.addAll(naYX);
        boolean clique = GraphUtils.isClique(union, this.graph);
        boolean noCycle = !this.existsUnblockedSemiDirectedPath(y, x, union, this.cycleBound);
        return clique && noCycle && !violatesKnowledge;
    }

    private boolean validDelete(Node x, Node y, Set<Node> H, Set<Node> naYX) {
        boolean violatesKnowledge = false;
        if (this.existsKnowledge()) {
            for (Node h : H) {
                if (this.knowledge.isForbidden(x.getName(), h.getName())) {
                    violatesKnowledge = true;
                }
                if (!this.knowledge.isForbidden(y.getName(), h.getName())) continue;
                violatesKnowledge = true;
            }
        }
        HashSet<Node> diff = new HashSet<Node>(naYX);
        diff.removeAll(H);
        return GraphUtils.isClique(diff, this.graph) && !violatesKnowledge;
    }

    private void addRequiredEdges(Graph graph) {
        if (!this.existsKnowledge()) {
            return;
        }
        Iterator<KnowledgeEdge> it = this.getKnowledge().requiredEdgesIterator();
        while (it.hasNext() && !Thread.currentThread().isInterrupted()) {
            KnowledgeEdge next = it.next();
            Node nodeA = graph.getNode(next.getFrom());
            Node nodeB = graph.getNode(next.getTo());
            if (graph.paths().isAncestorOf(nodeB, nodeA)) continue;
            graph.removeEdges(nodeA, nodeB);
            graph.addDirectedEdge(nodeA, nodeB);
            TetradLogger.getInstance().log("insertedEdges", "Adding edge by knowledge: " + graph.getEdge(nodeA, nodeB));
        }
        for (Edge edge : graph.getEdges()) {
            Node nodeB;
            Node nodeA;
            String B;
            if (Thread.currentThread().isInterrupted()) break;
            String A = edge.getNode1().getName();
            if (this.knowledge.isForbidden(A, B = edge.getNode2().getName())) {
                nodeA = edge.getNode1();
                nodeB = edge.getNode2();
                if (nodeA == null || nodeB == null) {
                    throw new NullPointerException();
                }
                if (graph.isAdjacentTo(nodeA, nodeB) && !graph.isChildOf(nodeA, nodeB) && !graph.paths().isAncestorOf(nodeA, nodeB)) {
                    graph.removeEdges(nodeA, nodeB);
                    graph.addDirectedEdge(nodeB, nodeA);
                    TetradLogger.getInstance().log("insertedEdges", "Adding edge by knowledge: " + graph.getEdge(nodeB, nodeA));
                }
                if (graph.isChildOf(nodeA, nodeB) || !this.getKnowledge().isForbidden(nodeA.getName(), nodeB.getName()) || graph.paths().isAncestorOf(nodeA, nodeB)) continue;
                graph.removeEdges(nodeA, nodeB);
                graph.addDirectedEdge(nodeB, nodeA);
                TetradLogger.getInstance().log("insertedEdges", "Adding edge by knowledge: " + graph.getEdge(nodeB, nodeA));
                continue;
            }
            if (!this.knowledge.isForbidden(B, A)) continue;
            nodeA = edge.getNode2();
            nodeB = edge.getNode1();
            if (nodeA == null || nodeB == null) {
                throw new NullPointerException();
            }
            if (graph.isAdjacentTo(nodeA, nodeB) && !graph.isChildOf(nodeA, nodeB) && !graph.paths().isAncestorOf(nodeA, nodeB)) {
                graph.removeEdges(nodeA, nodeB);
                graph.addDirectedEdge(nodeB, nodeA);
                TetradLogger.getInstance().log("insertedEdges", "Adding edge by knowledge: " + graph.getEdge(nodeB, nodeA));
            }
            if (graph.isChildOf(nodeA, nodeB) || !this.getKnowledge().isForbidden(nodeA.getName(), nodeB.getName()) || graph.paths().isAncestorOf(nodeA, nodeB)) continue;
            graph.removeEdges(nodeA, nodeB);
            graph.addDirectedEdge(nodeB, nodeA);
            TetradLogger.getInstance().log("insertedEdges", "Adding edge by knowledge: " + graph.getEdge(nodeB, nodeA));
        }
    }

    private boolean validSetByKnowledge(Node y, Set<Node> subset) {
        for (Node node : subset) {
            if (!this.getKnowledge().isForbidden(node.getName(), y.getName())) continue;
            return false;
        }
        return true;
    }

    private Set<Node> getNaYX(Node x, Node y) {
        List<Node> adj = this.graph.getAdjacentNodes(y);
        HashSet<Node> nayx = new HashSet<Node>();
        for (Node z : adj) {
            Edge yz;
            if (z == x || !Edges.isUndirectedEdge(yz = this.graph.getEdge(y, z)) || !this.graph.isAdjacentTo(z, x)) continue;
            nayx.add(z);
        }
        return nayx;
    }

    private boolean existsUnblockedSemiDirectedPath(Node from, Node to, Set<Node> cond, int bound) {
        LinkedList<Node> Q = new LinkedList<Node>();
        HashSet<Node> V = new HashSet<Node>();
        Q.offer(from);
        V.add(from);
        Node e = null;
        int distance = 0;
        block0: while (!Q.isEmpty()) {
            Node t = (Node)Q.remove();
            if (t == to) {
                return true;
            }
            if (e == t) {
                e = null;
                if (++distance > (bound == -1 ? 1000 : bound)) {
                    return false;
                }
            }
            for (Node u : this.graph.getAdjacentNodes(t)) {
                if (Thread.currentThread().isInterrupted()) continue block0;
                Edge edge = this.graph.getEdge(t, u);
                Node c = TsFges2.traverseSemiDirected(t, edge);
                if (c == null || cond.contains(c)) continue;
                if (c == to) {
                    return true;
                }
                if (V.contains(c)) continue;
                V.add(c);
                Q.offer(c);
                if (e != null) continue;
                e = u;
            }
        }
        return false;
    }

    private static Node traverseSemiDirected(Node node, Edge edge) {
        if (node == edge.getNode1()) {
            if (edge.getEndpoint1() == Endpoint.TAIL) {
                return edge.getNode2();
            }
        } else if (node == edge.getNode2() && edge.getEndpoint2() == Endpoint.TAIL) {
            return edge.getNode1();
        }
        return null;
    }

    private Set<Node> reorientNode(List<Node> nodes) {
        this.addRequiredEdges(this.graph);
        return this.meekOrientRestricted(nodes, this.getKnowledge());
    }

    private Set<Node> meekOrientRestricted(List<Node> nodes, Knowledge knowledge) {
        MeekRules rules = new MeekRules();
        rules.setKnowledge(knowledge);
        return rules.orientImplied(this.graph);
    }

    private void buildIndexing(List<Node> nodes) {
        this.hashIndices = new ConcurrentHashMap<Node, Integer>();
        int i = -1;
        for (Node n : nodes) {
            this.hashIndices.put(n, ++i);
        }
    }

    private synchronized void clearArrow(Node x, Node y) {
        OrderedPair<Node> pair = new OrderedPair<Node>(x, y);
        Set<Arrow> lookupArrows = this.lookupArrows.get(pair);
        if (lookupArrows != null) {
            this.sortedArrows.removeAll(lookupArrows);
        }
        this.lookupArrows.remove(pair);
    }

    private void addLookupArrow(Node i, Node j, Arrow arrow) {
        OrderedPair<Node> pair = new OrderedPair<Node>(i, j);
        Set<Arrow> arrows = this.lookupArrows.get(pair);
        if (arrows == null) {
            arrows = new ConcurrentSkipListSet<Arrow>();
            this.lookupArrows.put(pair, arrows);
        }
        arrows.add(arrow);
    }

    @Override
    public double scoreDag(Graph dag) {
        this.buildIndexing(dag.getNodes());
        double _score = 0.0;
        for (Node y : dag.getNodes()) {
            HashSet<Node> parents = new HashSet<Node>(dag.getParents(y));
            int[] parentIndices = new int[parents.size()];
            Iterator pi = parents.iterator();
            int count = 0;
            while (pi.hasNext()) {
                Node nextParent = (Node)pi.next();
                parentIndices[count++] = (Integer)this.hashIndices.get(nextParent);
            }
            int yIndex = (Integer)this.hashIndices.get(y);
            _score += this.score.localScore(yIndex, parentIndices);
        }
        return _score;
    }

    private double scoreGraphChange(Node y, Set<Node> parents, Node x, Map<Node, Integer> hashIndices) {
        int yIndex = hashIndices.get(y);
        if (parents.contains(x)) {
            return Double.NaN;
        }
        int[] parentIndices = new int[parents.size()];
        int count = 0;
        for (Node parent : parents) {
            parentIndices[count++] = hashIndices.get(parent);
        }
        return this.score.localScoreDiff(hashIndices.get(x), yIndex, parentIndices);
    }

    private List<Node> getVariables() {
        return this.variables;
    }

    private void storeGraph() {
        if (this.getnumCPDAGsToStore() > 0) {
            EdgeListGraph graphCopy = new EdgeListGraph(this.graph);
            this.topGraphs.addLast(new ScoredGraph(graphCopy, this.totalScore));
        }
        if (this.topGraphs.size() == this.getnumCPDAGsToStore() + 1) {
            this.topGraphs.removeFirst();
        }
    }

    public String logEdgeBayesFactorsString(Graph dag) {
        Map<Edge, Double> factors = this.logEdgeBayesFactors(dag);
        return this.logBayesPosteriorFactorsString(factors, this.scoreDag(dag));
    }

    public Map<Edge, Double> logEdgeBayesFactors(Graph dag) {
        HashMap<Edge, Double> logBayesFactors = new HashMap<Edge, Double>();
        double withEdge = this.scoreDag(dag);
        for (Edge edge : dag.getEdges()) {
            dag.removeEdge(edge);
            double withoutEdge = this.scoreDag(dag);
            double difference = withEdge - withoutEdge;
            logBayesFactors.put(edge, difference);
            dag.addEdge(edge);
        }
        return logBayesFactors;
    }

    private String logBayesPosteriorFactorsString(final Map<Edge, Double> factors, double modelScore) {
        DecimalFormat nf = new DecimalFormat("0.00");
        StringBuilder builder = new StringBuilder();
        ArrayList<Edge> edges = new ArrayList<Edge>(factors.keySet());
        Collections.sort(edges, new Comparator<Edge>(){

            @Override
            public int compare(Edge o1, Edge o2) {
                return -Double.compare((Double)factors.get(o1), (Double)factors.get(o2));
            }
        });
        builder.append("Edge Posterior Log Bayes Factors:\n\n");
        builder.append("For a DAG in the IMaGES pattern with model totalScore m, for each edge e in the DAG, the model totalScore that would result from removing each edge, calculating the resulting model totalScore m(e), and then reporting m - m(e). The totalScore used is the IMScore, L - SUM_i{kc ln n(i)}, L is the maximum likelihood of the model, k isthe number of parameters of the model, n(i) is the sample size of the ith data set, and c is the penalty penaltyDiscount. Note that the more negative the totalScore, the more important the edge is to the posterior probability of the IMaGES model. Edges are given in order of their importance so measured.\n\n");
        int i = 0;
        for (Edge edge : edges) {
            builder.append(++i).append(". ").append(edge).append(" ").append(nf.format(factors.get(edge))).append("\n");
        }
        return builder.toString();
    }

    private List<List<Node>> returnSimilarPairs(Node x, Node y) {
        int i;
        System.out.println("$$$$$ Entering returnSimilarPairs method with x,y = " + x + ", " + y);
        if (x.getName().equals("time") || y.getName().equals("time")) {
            return new ArrayList<List<Node>>();
        }
        int ntiers = this.knowledge.getNumTiers();
        int indx_tier = this.knowledge.isInWhichTier(x);
        int indy_tier = this.knowledge.isInWhichTier(y);
        int tier_diff = FastMath.max(indx_tier, indy_tier) - FastMath.min(indx_tier, indy_tier);
        int indx_comp = -1;
        int indy_comp = -1;
        List<String> tier_x = this.knowledge.getTier(indx_tier);
        List<String> tier_y = this.knowledge.getTier(indy_tier);
        for (i = 0; i < tier_x.size(); ++i) {
            if (!this.getNameNoLag(x.getName()).equals(this.getNameNoLag(tier_x.get(i)))) continue;
            indx_comp = i;
            break;
        }
        for (i = 0; i < tier_y.size(); ++i) {
            if (!this.getNameNoLag(y.getName()).equals(this.getNameNoLag(tier_y.get(i)))) continue;
            indy_comp = i;
            break;
        }
        System.out.println("original independence: " + x + " and " + y);
        if (indx_comp == -1) {
            System.out.println("WARNING: indx_comp = -1!!!! ");
        }
        if (indy_comp == -1) {
            System.out.println("WARNING: indy_comp = -1!!!! ");
        }
        ArrayList<Node> simListX = new ArrayList<Node>();
        ArrayList<Node> simListY = new ArrayList<Node>();
        for (i = 0; i < ntiers - tier_diff; ++i) {
            String B;
            String A;
            List<String> tmp_tier2;
            List<String> tmp_tier1;
            if (this.knowledge.getTier(i).size() == 1) continue;
            if (indx_tier >= indy_tier) {
                tmp_tier1 = this.knowledge.getTier(i + tier_diff);
                tmp_tier2 = this.knowledge.getTier(i);
                A = tmp_tier1.get(indx_comp);
                B = tmp_tier2.get(indy_comp);
            } else {
                tmp_tier1 = this.knowledge.getTier(i);
                tmp_tier2 = this.knowledge.getTier(i + tier_diff);
                A = tmp_tier1.get(indx_comp);
                B = tmp_tier2.get(indy_comp);
            }
            if (A.equals(B) || A.equals(tier_x.get(indx_comp)) && B.equals(tier_y.get(indy_comp)) || B.equals(tier_x.get(indx_comp)) && A.equals(tier_y.get(indy_comp))) continue;
            Node x1 = this.graph.getNode(A);
            Node y1 = this.graph.getNode(B);
            System.out.println("Adding pair to simList = " + x1 + " and " + y1);
            simListX.add(x1);
            simListY.add(y1);
        }
        ArrayList<List<Node>> pairList = new ArrayList<List<Node>>();
        pairList.add(simListX);
        pairList.add(simListY);
        return pairList;
    }

    public String getNameNoLag(Object obj) {
        String tempS = obj.toString();
        if (tempS.indexOf(58) == -1) {
            return tempS;
        }
        return tempS.substring(0, tempS.indexOf(58));
    }

    public void addSimilarEdges(Node x, Node y) {
        List<List<Node>> simList = this.returnSimilarPairs(x, y);
        if (simList.isEmpty()) {
            return;
        }
        List<Node> x1List = simList.get(0);
        List<Node> y1List = simList.get(1);
        Iterator<Node> itx = x1List.iterator();
        Iterator<Node> ity = y1List.iterator();
        while (itx.hasNext() && ity.hasNext()) {
            Node x1 = itx.next();
            Node y1 = ity.next();
            System.out.println("$$$$$$$$$$$ similar pair x,y = " + x1 + ", " + y1);
            System.out.println("adding edge between x = " + x1 + " and y = " + y1);
            this.graph.addDirectedEdge(x1, y1);
        }
    }

    public void removeSimilarEdges(Node x, Node y) {
        List<List<Node>> simList = this.returnSimilarPairs(x, y);
        if (simList.isEmpty()) {
            return;
        }
        List<Node> x1List = simList.get(0);
        List<Node> y1List = simList.get(1);
        Iterator<Node> itx = x1List.iterator();
        Iterator<Node> ity = y1List.iterator();
        while (itx.hasNext() && ity.hasNext()) {
            Node x1 = itx.next();
            Node y1 = ity.next();
            System.out.println("$$$$$$$$$$$ similar pair x,y = " + x1 + ", " + y1);
            System.out.println("removing edge between x = " + x1 + " and y = " + y1);
            Edge oldxy = this.graph.getEdge(x1, y1);
            this.graph.removeEdge(oldxy);
            this.removedEdges.add(Edges.undirectedEdge(x1, y1));
        }
    }

    private static enum Mode {
        allowUnfaithfulness,
        heuristicSpeedup,
        coverNoncolliders;

    }

    private static class Arrow
    implements Comparable<Arrow> {
        private final double bump;
        private final Node a;
        private final Node b;
        private final Set<Node> hOrT;
        private final Set<Node> naYX;
        private final int index;

        public Arrow(double bump, Node a, Node b, Set<Node> hOrT, Set<Node> naYX, int index) {
            this.bump = bump;
            this.a = a;
            this.b = b;
            this.hOrT = hOrT;
            this.naYX = naYX;
            this.index = index;
        }

        public double getBump() {
            return this.bump;
        }

        public Node getA() {
            return this.a;
        }

        public Node getB() {
            return this.b;
        }

        public Set<Node> getHOrT() {
            return this.hOrT;
        }

        public Set<Node> getNaYX() {
            return this.naYX;
        }

        @Override
        public int compareTo(Arrow arrow) {
            if (arrow == null) {
                throw new NullPointerException();
            }
            int compare = Double.compare(arrow.getBump(), this.getBump());
            if (compare == 0) {
                return Integer.compare(this.getIndex(), arrow.getIndex());
            }
            return compare;
        }

        public String toString() {
            return "Arrow<" + this.a + "->" + this.b + " bump = " + this.bump + " t/h = " + this.hOrT + " naYX = " + this.naYX + ">";
        }

        public int getIndex() {
            return this.index;
        }
    }

    class NodeTaskEmptyGraph
    extends RecursiveTask<Boolean> {
        private final int from;
        private final int to;
        private final List<Node> nodes;
        private final Set<Node> emptySet;

        public NodeTaskEmptyGraph(int from, int to, List<Node> nodes, Set<Node> emptySet) {
            this.from = from;
            this.to = to;
            this.nodes = nodes;
            this.emptySet = emptySet;
        }

        @Override
        protected Boolean compute() {
            for (int i = this.from; i < this.to; ++i) {
                if ((i + 1) % 1000 == 0) {
                    TsFges2.this.count[0] = TsFges2.this.count[0] + 1000;
                    TsFges2.this.out.println("Initializing effect edges: " + TsFges2.this.count[0]);
                }
                Node y = this.nodes.get(i);
                TsFges2.this.neighbors.put(y, this.emptySet);
                for (int j = i + 1; j < this.nodes.size() && !Thread.currentThread().isInterrupted(); ++j) {
                    Node x = this.nodes.get(j);
                    if (TsFges2.this.existsKnowledge() && (TsFges2.this.getKnowledge().isForbidden(x.getName(), y.getName()) && TsFges2.this.getKnowledge().isForbidden(y.getName(), x.getName()) || !TsFges2.this.validSetByKnowledge(y, this.emptySet)) || TsFges2.this.adjacencies != null && !TsFges2.this.adjacencies.isAdjacentTo(x, y)) continue;
                    int child = (Integer)TsFges2.this.hashIndices.get(y);
                    int parent = (Integer)TsFges2.this.hashIndices.get(x);
                    double bump = TsFges2.this.score.localScoreDiff(parent, child);
                    if (TsFges2.this.boundGraph != null && !TsFges2.this.boundGraph.isAdjacentTo(x, y)) continue;
                    if (bump > 0.0) {
                        Edge edge = Edges.undirectedEdge(x, y);
                        TsFges2.this.effectEdgesGraph.addEdge(edge);
                    }
                    if (!(bump > 0.0)) continue;
                    TsFges2.this.addArrow(x, y, this.emptySet, this.emptySet, bump);
                    TsFges2.this.addArrow(y, x, this.emptySet, this.emptySet, bump);
                }
            }
            return true;
        }
    }
}

