/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.IndependenceFacts;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.GraphSearch;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.MeekRules;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.search.SearchLogUtils;
import edu.cmu.tetrad.search.Vcfas;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.CombinationGenerator;
import edu.cmu.tetrad.util.MillisecondTimes;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.math3.util.FastMath;

public final class VcpcFast
implements GraphSearch {
    private final IndependenceTest independenceTest;
    private Knowledge knowledge = new Knowledge();
    private int depth = 1000;
    private Graph graph;
    private long elapsedTime;
    private Set<Triple> colliderTriples;
    private Set<Triple> noncolliderTriples;
    private Set<Triple> ambiguousTriples;
    private Set<Edge> definitelyNonadjacencies;
    private boolean aggressivelyPreventCycles;
    private final TetradLogger logger = TetradLogger.getInstance();
    private Map<Edge, List<Node>> apparentlyNonadjacencies;
    private boolean verbose;
    private IndependenceFacts facts;

    public VcpcFast(IndependenceTest independenceTest) {
        if (independenceTest == null) {
            throw new NullPointerException();
        }
        this.independenceTest = independenceTest;
    }

    public boolean isAggressivelyPreventCycles() {
        return this.aggressivelyPreventCycles;
    }

    public void setAggressivelyPreventCycles(boolean aggressivelyPreventCycles) {
        this.aggressivelyPreventCycles = aggressivelyPreventCycles;
    }

    public void setDepth(int depth) {
        if (depth < -1) {
            throw new IllegalArgumentException("Depth must be -1 or >= 0: " + depth);
        }
        if (depth == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Depth must not be Integer.MAX_VALUE, due to a known bug.");
        }
        this.depth = depth;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = new Knowledge(knowledge);
    }

    public IndependenceTest getIndependenceTest() {
        return this.independenceTest;
    }

    public int getDepth() {
        return this.depth;
    }

    public Set<Triple> getAmbiguousTriples() {
        return new HashSet<Triple>(this.ambiguousTriples);
    }

    public Set<Triple> getColliderTriples() {
        return new HashSet<Triple>(this.colliderTriples);
    }

    public Set<Triple> getNoncolliderTriples() {
        return new HashSet<Triple>(this.noncolliderTriples);
    }

    public Set<Edge> getAdjacencies() {
        return new HashSet<Edge>(this.graph.getEdges());
    }

    public Set<Edge> getApparentNonadjacencies() {
        return new HashSet<Edge>(this.apparentlyNonadjacencies.keySet());
    }

    public Set<Edge> getDefiniteNonadjacencies() {
        return new HashSet<Edge>(this.definitelyNonadjacencies);
    }

    @Override
    public Graph search() {
        int[] combination;
        this.logger.log("info", "Starting VCCPC algorithm");
        this.logger.log("info", "Independence test = " + this.getIndependenceTest() + ".");
        this.ambiguousTriples = new HashSet<Triple>();
        this.colliderTriples = new HashSet<Triple>();
        this.noncolliderTriples = new HashSet<Triple>();
        Vcfas fas = new Vcfas(this.getIndependenceTest());
        this.definitelyNonadjacencies = new HashSet<Edge>();
        long startTime = MillisecondTimes.timeMillis();
        List<Node> allNodes = this.getIndependenceTest().getVariables();
        fas.setKnowledge(this.getKnowledge());
        fas.setDepth(this.getDepth());
        fas.setVerbose(this.verbose);
        this.graph = fas.search();
        this.apparentlyNonadjacencies = fas.getApparentlyNonadjacencies();
        if (this.verbose) {
            System.out.println("CPC orientation...");
        }
        SearchGraphUtils.pcOrientbk(this.knowledge, this.graph, allNodes);
        this.orientUnshieldedTriples(this.knowledge, this.getIndependenceTest(), this.getDepth());
        MeekRules meekRules = new MeekRules();
        meekRules.setAggressivelyPreventCycles(this.aggressivelyPreventCycles);
        meekRules.setKnowledge(this.knowledge);
        meekRules.orientImplied(this.graph);
        ArrayList<Triple> ambiguousTriples = new ArrayList<Triple>(this.graph.underlines().getAmbiguousTriples());
        int[] dims = new int[ambiguousTriples.size()];
        for (int i = 0; i < ambiguousTriples.size(); ++i) {
            dims[i] = 2;
        }
        ArrayList<Iterator<Edge>> patterns = new ArrayList<Iterator<Edge>>();
        IdentityHashMap newColliders = new IdentityHashMap();
        IdentityHashMap newNonColliders = new IdentityHashMap();
        CombinationGenerator generator = new CombinationGenerator(dims);
        while ((combination = generator.next()) != null) {
            Iterator<Edge> _graph = new EdgeListGraph(this.graph);
            newColliders.put(_graph, new ArrayList());
            newNonColliders.put(_graph, new ArrayList());
            for (int k = 0; k < combination.length; ++k) {
                Triple triple = (Triple)ambiguousTriples.get(k);
                _graph.underlines().removeAmbiguousTriple(triple.getX(), triple.getY(), triple.getZ());
                if (combination[k] == 0) {
                    ((List)newColliders.get(_graph)).add(triple);
                    Node x = triple.getX();
                    Node y = triple.getY();
                    Node z = triple.getZ();
                    _graph.setEndpoint(x, y, Endpoint.ARROW);
                    _graph.setEndpoint(z, y, Endpoint.ARROW);
                }
                if (combination[k] != 1) continue;
                ((List)newNonColliders.get(_graph)).add(triple);
            }
            patterns.add(_graph);
        }
        block3: for (Graph graph : new ArrayList(patterns)) {
            Node z;
            Node y;
            Node x;
            List colliders = (List)newColliders.get(graph);
            List nonColliders = (List)newNonColliders.get(graph);
            for (Triple triple : colliders) {
                x = triple.getX();
                y = triple.getY();
                z = triple.getZ();
                if (!graph.getEdge(x, y).pointsTowards(x) && !graph.getEdge(y, z).pointsTowards(z)) continue;
                patterns.remove(graph);
                continue block3;
            }
            for (Triple triple : colliders) {
                x = triple.getX();
                y = triple.getY();
                z = triple.getZ();
                graph.setEndpoint(x, y, Endpoint.ARROW);
                graph.setEndpoint(z, y, Endpoint.ARROW);
            }
            for (Triple triple : nonColliders) {
                x = triple.getX();
                y = triple.getY();
                z = triple.getZ();
                if (graph.getEdge(x, y).pointsTowards(y)) {
                    graph.removeEdge(y, z);
                    graph.addDirectedEdge(y, z);
                }
                if (!graph.getEdge(y, z).pointsTowards(y)) continue;
                graph.removeEdge(x, y);
                graph.addDirectedEdge(y, x);
            }
            for (Edge edge : graph.getEdges()) {
                x = edge.getNode1();
                y = edge.getNode2();
                if (!Edges.isBidirectedEdge(edge)) continue;
                graph.removeEdge(x, y);
                graph.addUndirectedEdge(x, y);
            }
            MeekRules rules = new MeekRules();
            rules.orientImplied(graph);
            if (!graph.paths().existsDirectedCycle()) continue;
            patterns.remove(graph);
        }
        block8: for (Edge edge : this.apparentlyNonadjacencies.keySet()) {
            Node x = edge.getNode1();
            Node y = edge.getNode2();
            for (Graph _graph : new ArrayList(patterns)) {
                ArrayList<Node> boundaryX = new ArrayList<Node>(this.boundary(x, _graph));
                ArrayList<Node> boundaryY = new ArrayList<Node>(this.boundary(y, _graph));
                ArrayList<Node> futureX = new ArrayList<Node>(this.future(x, _graph));
                ArrayList<Node> futureY = new ArrayList<Node>(this.future(y, _graph));
                if (y == x || boundaryX.contains(y) || boundaryY.contains(x)) continue;
                IndependenceTest test = this.independenceTest;
                if ((futureX.contains(y) || test.checkIndependence(x, y, boundaryX).independent()) && (futureY.contains(x) || test.checkIndependence(y, x, boundaryY).independent())) continue;
                continue block8;
            }
            this.definitelyNonadjacencies.add(edge);
        }
        for (Edge edge : this.definitelyNonadjacencies) {
            if (!this.apparentlyNonadjacencies.containsKey(edge)) continue;
            this.apparentlyNonadjacencies.keySet().remove(edge);
        }
        System.out.println("VCPC:");
        long endTime = MillisecondTimes.timeMillis();
        this.elapsedTime = endTime - startTime;
        System.out.println("Search Time (seconds):" + this.elapsedTime / 1000L + " s");
        System.out.println("Search Time (milli):" + this.elapsedTime + " ms");
        System.out.println("# of Apparent Nonadj: " + this.apparentlyNonadjacencies.size());
        System.out.println("# of Definite Nonadj: " + this.definitelyNonadjacencies.size());
        TetradLogger.getInstance().log("apparentlyNonadjacencies", "\n Apparent Non-adjacencies" + this.apparentlyNonadjacencies);
        TetradLogger.getInstance().log("definitelyNonadjacencies", "\n Definite Non-adjacencies" + this.definitelyNonadjacencies);
        TetradLogger.getInstance().log("graph", "\nReturning this graph: " + this.graph);
        TetradLogger.getInstance().log("info", "Elapsed time = " + (double)this.elapsedTime / 1000.0 + " s");
        TetradLogger.getInstance().log("info", "Finishing CPC algorithm.");
        TetradLogger.getInstance().flush();
        return this.graph;
    }

    private Set<Node> boundary(Node x, Graph graph) {
        HashSet<Node> boundary = new HashSet<Node>();
        List<Node> adj = graph.getAdjacentNodes(x);
        for (Node y : adj) {
            if (!graph.isParentOf(y, x) && !Edges.isUndirectedEdge(graph.getEdge(x, y))) continue;
            boundary.add(y);
        }
        return boundary;
    }

    private Set<Node> future(Node x, Graph graph) {
        HashSet<Node> futureNodes = new HashSet<Node>();
        LinkedList<Node> path = new LinkedList<Node>();
        VcpcFast.futureNodeVisit(graph, x, path, futureNodes);
        futureNodes.remove(x);
        List<Node> adj = graph.getAdjacentNodes(x);
        for (Node y : adj) {
            if (!graph.isParentOf(y, x) && !Edges.isUndirectedEdge(graph.getEdge(x, y))) continue;
            futureNodes.remove(y);
        }
        return futureNodes;
    }

    private static Node traverseFuturePath(Node node, Edge edge1, Edge edge2) {
        Endpoint E1 = edge1.getProximalEndpoint(node);
        Endpoint E2 = edge2.getProximalEndpoint(node);
        Endpoint E3 = edge2.getDistalEndpoint(node);
        Endpoint E4 = edge1.getDistalEndpoint(node);
        if (E1 == Endpoint.ARROW && E2 == Endpoint.ARROW && E3 == Endpoint.TAIL) {
            return null;
        }
        if (E4 == Endpoint.ARROW) {
            return null;
        }
        if (E4 == Endpoint.TAIL && E1 == Endpoint.TAIL && E2 == Endpoint.TAIL && E3 == Endpoint.TAIL) {
            return null;
        }
        return edge2.getDistalNode(node);
    }

    public static void futureNodeVisit(Graph graph, Node b, LinkedList<Node> path, Set<Node> futureNodes) {
        path.addLast(b);
        futureNodes.add(b);
        for (Edge edge2 : graph.getEdges(b)) {
            Node c;
            int size = path.size();
            if (path.size() < 2) {
                c = edge2.getDistalNode(b);
            } else {
                Node a = path.get(size - 2);
                Edge edge1 = graph.getEdge(a, b);
                c = VcpcFast.traverseFuturePath(b, edge1, edge2);
            }
            if (c == null || path.contains(c)) continue;
            VcpcFast.futureNodeVisit(graph, c, path, futureNodes);
        }
        path.removeLast();
    }

    private void orientUnshieldedTriples(Knowledge knowledge, IndependenceTest test, int depth) {
        TetradLogger.getInstance().log("info", "Starting Collider Orientation:");
        this.colliderTriples = new HashSet<Triple>();
        this.noncolliderTriples = new HashSet<Triple>();
        this.ambiguousTriples = new HashSet<Triple>();
        List<Node> nodes = this.graph.getNodes();
        for (Node y : nodes) {
            int[] combination;
            List<Node> adjacentNodes = this.graph.getAdjacentNodes(y);
            if (adjacentNodes.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
            while ((combination = cg.next()) != null) {
                Node z;
                Node x = adjacentNodes.get(combination[0]);
                if (this.graph.isAdjacentTo(x, z = adjacentNodes.get(combination[1]))) continue;
                CpcTripleType type = this.getPopulationTripleType(x, y, z, test, depth, this.graph, this.verbose);
                if (type == CpcTripleType.COLLIDER) {
                    if (this.colliderAllowed(x, y, z, knowledge)) {
                        this.graph.setEndpoint(x, y, Endpoint.ARROW);
                        this.graph.setEndpoint(z, y, Endpoint.ARROW);
                        TetradLogger.getInstance().log("colliderOrientations", SearchLogUtils.colliderOrientedMsg(x, y, z));
                    }
                    this.colliderTriples.add(new Triple(x, y, z));
                    continue;
                }
                if (type == CpcTripleType.AMBIGUOUS) {
                    Triple triple = new Triple(x, y, z);
                    this.ambiguousTriples.add(triple);
                    this.graph.underlines().addAmbiguousTriple(triple.getX(), triple.getY(), triple.getZ());
                    Edge edge = Edges.undirectedEdge(x, z);
                    this.definitelyNonadjacencies.add(edge);
                    continue;
                }
                this.noncolliderTriples.add(new Triple(x, y, z));
            }
        }
        TetradLogger.getInstance().log("info", "Finishing Collider Orientation.");
    }

    public CpcTripleType getPopulationTripleType(Node x, Node y, Node z, IndependenceTest test, int depth, Graph graph, boolean verbose) {
        List<Node> cond;
        int[] choice;
        ChoiceGenerator cg;
        int d;
        this.setFacts(this.facts);
        System.out.println("NameS" + this.facts.getVariableNames());
        int numSepsetsContainingY = 0;
        int numSepsetsNotContainingY = 0;
        List<Node> _nodes = graph.getAdjacentNodes(x);
        _nodes.remove(z);
        TetradLogger.getInstance().log("adjacencies", "Adjacents for " + x + "--" + y + "--" + z + " = " + _nodes);
        int _depth = depth;
        if (_depth == -1) {
            _depth = 1000;
        }
        _depth = FastMath.min(_depth, _nodes.size());
        for (d = 0; d <= _depth; ++d) {
            cg = new ChoiceGenerator(_nodes.size(), d);
            while ((choice = cg.next()) != null) {
                cond = GraphUtils.asList(choice, _nodes);
                if (this.facts.isIndependent(x, z, cond)) {
                    System.out.println("Indep Fact said: " + x + " _||_ " + z + " | " + cond);
                    if (cond.contains(y)) {
                        ++numSepsetsContainingY;
                    } else {
                        ++numSepsetsNotContainingY;
                    }
                } else {
                    System.out.println("This is not Indep by facts: " + x + " _||_ " + z + " | " + cond);
                }
                if (numSepsetsContainingY <= 0 || numSepsetsNotContainingY <= 0) continue;
                return CpcTripleType.AMBIGUOUS;
            }
        }
        _nodes = graph.getAdjacentNodes(z);
        _nodes.remove(x);
        TetradLogger.getInstance().log("adjacencies", "Adjacents for " + x + "--" + y + "--" + z + " = " + _nodes);
        _depth = depth;
        if (_depth == -1) {
            _depth = 1000;
        }
        _depth = FastMath.min(_depth, _nodes.size());
        for (d = 0; d <= _depth; ++d) {
            cg = new ChoiceGenerator(_nodes.size(), d);
            while ((choice = cg.next()) != null) {
                cond = GraphUtils.asList(choice, _nodes);
                if (test.checkIndependence(x, z, cond).independent()) {
                    if (cond.contains(y)) {
                        ++numSepsetsContainingY;
                    } else {
                        ++numSepsetsNotContainingY;
                    }
                }
                if (numSepsetsContainingY <= 0 || numSepsetsNotContainingY <= 0) continue;
                return CpcTripleType.AMBIGUOUS;
            }
        }
        if (numSepsetsContainingY > 0) {
            return CpcTripleType.NONCOLLIDER;
        }
        if (verbose) {
            System.out.println("Orienting " + x + "-->" + y + "&lt;-" + z);
        }
        return CpcTripleType.COLLIDER;
    }

    private boolean colliderAllowed(Node x, Node y, Node z, Knowledge knowledge) {
        return VcpcFast.isArrowpointAllowed1(x, y, knowledge) && VcpcFast.isArrowpointAllowed1(z, y, knowledge);
    }

    public static boolean isArrowpointAllowed1(Node from, Node to, Knowledge knowledge) {
        return knowledge == null || !knowledge.isRequired(to.toString(), from.toString()) && !knowledge.isForbidden(from.toString(), to.toString());
    }

    public Graph getGraph() {
        return this.graph;
    }

    public void setGraph(Graph graph) {
        this.graph = graph;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setFacts(IndependenceFacts facts) {
        this.facts = facts;
    }

    public static enum CpcTripleType {
        COLLIDER,
        NONCOLLIDER,
        AMBIGUOUS;

    }
}

