/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.sem;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.OutOfRangeException;

public class EmpiricalCdf
implements RealDistribution {
    private final List<Double> data;

    public EmpiricalCdf(List<Double> data) {
        if (data == null) {
            throw new NullPointerException();
        }
        this.data = data;
        Collections.sort(data);
    }

    @Override
    public double cumulativeProbability(double x) {
        double y;
        int count = 0;
        Iterator<Double> iterator = this.data.iterator();
        while (iterator.hasNext() && (y = iterator.next().doubleValue()) <= x) {
            ++count;
        }
        return (double)count / (double)this.data.size();
    }

    @Override
    public double probability(double v) {
        return 0.0;
    }

    @Override
    public double density(double v) {
        double d1 = v - 0.05;
        double d2 = v + 0.05;
        double n2 = this.cumulativeProbability(d1);
        double n1 = this.cumulativeProbability(d2);
        return (n1 - n2) / (d2 - d1);
    }

    @Override
    @Deprecated
    public double cumulativeProbability(double v, double v1) throws NumberIsTooLargeException {
        throw new UnsupportedOperationException();
    }

    @Override
    public double inverseCumulativeProbability(double v) throws OutOfRangeException {
        return 0.0;
    }

    @Override
    public double getNumericalMean() {
        return 0.0;
    }

    @Override
    public double getNumericalVariance() {
        return 0.0;
    }

    @Override
    public double getSupportLowerBound() {
        return 0.0;
    }

    @Override
    public double getSupportUpperBound() {
        return 0.0;
    }

    @Override
    @Deprecated
    public boolean isSupportLowerBoundInclusive() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean isSupportUpperBoundInclusive() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSupportConnected() {
        return false;
    }

    @Override
    public void reseedRandomGenerator(long l) {
    }

    @Override
    public double sample() {
        return 0.0;
    }

    @Override
    public double[] sample(int i) {
        return new double[0];
    }
}

