/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.sem;

import edu.cmu.tetrad.calculator.expression.Context;
import edu.cmu.tetrad.calculator.expression.Expression;
import edu.cmu.tetrad.calculator.parser.ExpressionLexer;
import edu.cmu.tetrad.calculator.parser.Token;
import edu.cmu.tetrad.data.BoxDataSet;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.data.Simulator;
import edu.cmu.tetrad.data.VerticalDoubleDataBox;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.graph.Paths;
import edu.cmu.tetrad.graph.SemGraph;
import edu.cmu.tetrad.graph.TimeLagGraph;
import edu.cmu.tetrad.sem.GeneralizedSemPm;
import edu.cmu.tetrad.sem.ParamType;
import edu.cmu.tetrad.sem.Parameter;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetrad.util.IM;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.StatUtils;
import edu.cmu.tetrad.util.Vector;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.math3.analysis.MultivariateFunction;
import org.apache.commons.math3.optim.InitialGuess;
import org.apache.commons.math3.optim.MaxEval;
import org.apache.commons.math3.optim.PointValuePair;
import org.apache.commons.math3.optim.nonlinear.scalar.GoalType;
import org.apache.commons.math3.optim.nonlinear.scalar.ObjectiveFunction;
import org.apache.commons.math3.optim.nonlinear.scalar.noderiv.PowellOptimizer;
import org.apache.commons.math3.util.FastMath;

public class GeneralizedSemIm
implements IM,
Simulator {
    static final long serialVersionUID = 23L;
    private final GeneralizedSemPm pm;
    private final Map<String, Double> parameterValues;
    private boolean guaranteeIid = true;

    public GeneralizedSemIm(GeneralizedSemPm pm) {
        this.pm = new GeneralizedSemPm(pm);
        this.parameterValues = new HashMap<String, Double>();
        Set<String> parameters = pm.getParameters();
        for (String parameter : parameters) {
            Expression expression = pm.getParameterExpression(parameter);
            Context context = this.parameterValues::get;
            double initialValue = expression.evaluate(context);
            this.parameterValues.put(parameter, initialValue);
        }
    }

    public GeneralizedSemIm(GeneralizedSemPm pm, SemIm semIm) {
        this(pm);
        Parameter paramObject;
        SemPm semPm = semIm.getSemPm();
        Set<String> parameters = pm.getParameters();
        for (String parameter : parameters) {
            paramObject = semPm.getParameter(parameter);
            if (paramObject != null) continue;
            return;
        }
        for (String parameter : parameters) {
            paramObject = semPm.getParameter(parameter);
            if (paramObject == null) {
                throw new IllegalArgumentException("Parameter missing from Gaussian SEM IM: " + parameter);
            }
            double value = semIm.getParamValue(paramObject);
            if (paramObject.getType() == ParamType.VAR) {
                value = FastMath.sqrt(value);
            }
            this.setParameterValue(parameter, value);
        }
    }

    public static GeneralizedSemIm serializableInstance() {
        return new GeneralizedSemIm(GeneralizedSemPm.serializableInstance());
    }

    public GeneralizedSemPm getGeneralizedSemPm() {
        return new GeneralizedSemPm(this.pm);
    }

    public void setParameterValue(String parameter, double value) {
        if (parameter == null) {
            throw new NullPointerException("Parameter not specified.");
        }
        if (!this.parameterValues.containsKey(parameter)) {
            throw new IllegalArgumentException("Not a parameter in this model: " + parameter);
        }
        this.parameterValues.put(parameter, value);
    }

    public double getParameterValue(String parameter) {
        if (parameter == null) {
            throw new NullPointerException("Parameter not specified.");
        }
        if (!this.parameterValues.containsKey(parameter)) {
            throw new IllegalArgumentException("Not a parameter in this model: " + parameter);
        }
        return this.parameterValues.get(parameter);
    }

    public String getNodeSubstitutedString(Node node) {
        Token token;
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        String expressionString = this.pm.getNodeExpressionString(node);
        if (expressionString == null) {
            return null;
        }
        ExpressionLexer lexer = new ExpressionLexer(expressionString);
        StringBuilder buf = new StringBuilder();
        while ((token = lexer.nextTokenIncludingWhitespace()) != Token.EOF) {
            Double value;
            String tokenString = lexer.getTokenString();
            if (token == Token.PARAMETER && (value = this.parameterValues.get(tokenString)) != null) {
                buf.append(nf.format(value));
                continue;
            }
            buf.append(tokenString);
        }
        return buf.toString();
    }

    public String getNodeSubstitutedString(Node node, Map<String, Double> substitutedValues) {
        Token token;
        if (node == null) {
            throw new NullPointerException();
        }
        if (substitutedValues == null) {
            throw new NullPointerException();
        }
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        String expressionString = this.pm.getNodeExpressionString(node);
        ExpressionLexer lexer = new ExpressionLexer(expressionString);
        StringBuilder buf = new StringBuilder();
        while ((token = lexer.nextTokenIncludingWhitespace()) != Token.EOF) {
            String tokenString = lexer.getTokenString();
            if (token == Token.PARAMETER) {
                Double value = substitutedValues.get(tokenString);
                if (value == null) {
                    value = this.parameterValues.get(tokenString);
                }
                if (value != null) {
                    buf.append(nf.format(value));
                    continue;
                }
            }
            buf.append(tokenString);
        }
        return buf.toString();
    }

    public String toString() {
        String string;
        ArrayList<String> parameters = new ArrayList<String>(this.pm.getParameters());
        Collections.sort(parameters);
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        StringBuilder buf = new StringBuilder();
        GeneralizedSemPm pm = this.getGeneralizedSemPm();
        buf.append("\nVariable nodes:\n");
        for (Node node : pm.getVariableNodes()) {
            string = this.getNodeSubstitutedString(node);
            buf.append("\n").append(node).append(" = ").append(string);
        }
        buf.append("\n\nErrors:\n");
        for (Node node : pm.getErrorNodes()) {
            string = this.getNodeSubstitutedString(node);
            buf.append("\n").append(node).append(" ~ ").append(string);
        }
        buf.append("\n\nParameter values:\n");
        for (String parameter : parameters) {
            double value = this.getParameterValue(parameter);
            buf.append("\n").append(parameter).append(" = ").append(nf.format(value));
        }
        return buf.toString();
    }

    @Override
    public synchronized DataSet simulateData(int sampleSize, boolean latentDataSaved) {
        if (this.pm.getGraph().isTimeLagModel()) {
            return this.simulateTimeSeries(sampleSize);
        }
        return this.simulateDataFisher(sampleSize);
    }

    private DataSet simulateTimeSeries(int sampleSize) {
        SemGraph semGraph = new SemGraph(this.getSemPm().getGraph());
        semGraph.setShowErrorTerms(true);
        TimeLagGraph timeLagGraph = this.getSemPm().getGraph().getTimeLagGraph();
        ArrayList<Node> variables = new ArrayList<Node>();
        for (Node node2 : timeLagGraph.getLag0Nodes()) {
            if (node2.getNodeType() == NodeType.ERROR) continue;
            variables.add(new ContinuousVariable(timeLagGraph.getNodeId(node2).getName()));
        }
        List<Node> lag0Nodes = timeLagGraph.getLag0Nodes();
        lag0Nodes.removeIf(node -> node.getNodeType() == NodeType.ERROR);
        BoxDataSet fullData = new BoxDataSet(new VerticalDoubleDataBox(sampleSize, variables.size()), variables);
        HashMap<Node, Integer> nodeIndices = new HashMap<Node, Integer>();
        for (int i = 0; i < lag0Nodes.size(); ++i) {
            nodeIndices.put(lag0Nodes.get(i), i);
        }
        Graph contemporaneousDag = timeLagGraph.subgraph(timeLagGraph.getLag0Nodes());
        Paths paths = contemporaneousDag.paths();
        List<Node> initialOrder = contemporaneousDag.getNodes();
        List<Node> tierOrdering = paths.validOrder(initialOrder, true);
        tierOrdering.removeIf(node -> node.getNodeType() == NodeType.ERROR);
        HashMap<String, Double> variableValues = new HashMap<String, Double>();
        Context context = term -> {
            Double value = this.parameterValues.get(term);
            if (value != null) {
                return value;
            }
            value = (Double)variableValues.get(term);
            if (value != null) {
                return value;
            }
            return RandomUtil.getInstance().nextNormal(0.0, 1.0);
        };
        for (int currentStep = 0; currentStep < sampleSize; ++currentStep) {
            int col;
            for (Node node3 : tierOrdering) {
                Expression expression = this.pm.getNodeExpression(node3);
                double value = expression.evaluate(context);
                col = (Integer)nodeIndices.get(node3);
                fullData.setDouble(currentStep, col, value);
                variableValues.put(node3.getName(), value);
            }
            for (Node node3 : lag0Nodes) {
                TimeLagGraph.NodeId _id = timeLagGraph.getNodeId(node3);
                for (int lag = 1; lag <= timeLagGraph.getMaxLag(); ++lag) {
                    Node _node = timeLagGraph.getNode(_id.getName(), lag);
                    col = lag0Nodes.indexOf(node3);
                    if (_node == null || currentStep - lag + 1 < 0) continue;
                    double _value = fullData.getDouble(currentStep - lag + 1, col);
                    variableValues.put(_node.getName(), _value);
                }
            }
        }
        return fullData;
    }

    public DataSet simulateDataRecursive(int sampleSize, boolean latentDataSaved) {
        List<Node> variables = this.pm.getNodes();
        HashMap<String, Double> std = new HashMap<String, Double>();
        HashMap<String, Double> variableValues = new HashMap<String, Double>();
        Context context = term -> {
            Double value = this.parameterValues.get(term);
            if (value != null) {
                return value;
            }
            value = (Double)variableValues.get(term);
            if (value != null) {
                return value * 2.0 / (Double)std.get(term);
            }
            throw new IllegalArgumentException("No value recorded for '" + term + "'");
        };
        LinkedList<Node> continuousVariables = new LinkedList<Node>();
        List<Node> nonErrorVariables = this.pm.getVariableNodes();
        for (Node node : nonErrorVariables) {
            ContinuousVariable var = new ContinuousVariable(node.getName());
            var.setNodeType(node.getNodeType());
            if (var.getNodeType() == NodeType.ERROR) continue;
            continuousVariables.add(var);
        }
        BoxDataSet fullDataSet = new BoxDataSet(new VerticalDoubleDataBox(sampleSize, continuousVariables.size()), continuousVariables);
        SemGraph graph = this.pm.getGraph();
        List<Node> tierOrdering = graph.getFullTierOrdering();
        int[] tierIndices = new int[variables.size()];
        for (int i = 0; i < tierIndices.length; ++i) {
            tierIndices[i] = nonErrorVariables.indexOf(tierOrdering.get(i));
        }
        for (int tier = 0; tier < variables.size(); ++tier) {
            double[] v = new double[sampleSize];
            int col = tierIndices[tier];
            if (col == -1) continue;
            for (int row = 0; row < sampleSize; ++row) {
                double value;
                variableValues.clear();
                Node node = tierOrdering.get(tier);
                Expression expression = this.pm.getNodeExpression(node);
                v[row] = value = expression.evaluate(context);
                variableValues.put(node.getName(), value);
                fullDataSet.setDouble(row, col, value);
            }
            std.put(tierOrdering.get(tier).getName(), StatUtils.sd(v));
        }
        if (latentDataSaved) {
            return fullDataSet;
        }
        return DataUtils.restrictToMeasured(fullDataSet);
    }

    public DataSet simulateDataMinimizeSurface(int sampleSize, boolean latentDataSaved) {
        final HashMap<String, Double> variableValues = new HashMap<String, Double>();
        LinkedList<Node> continuousVariables = new LinkedList<Node>();
        final List<Node> variableNodes = this.pm.getVariableNodes();
        for (Node node : variableNodes) {
            ContinuousVariable var = new ContinuousVariable(node.getName());
            var.setNodeType(node.getNodeType());
            if (var.getNodeType() == NodeType.ERROR) continue;
            continuousVariables.add(var);
        }
        BoxDataSet fullDataSet = new BoxDataSet(new VerticalDoubleDataBox(sampleSize, continuousVariables.size()), continuousVariables);
        final Context context = term -> {
            Double value = this.parameterValues.get(term);
            if (value != null) {
                return value;
            }
            value = (Double)variableValues.get(term);
            if (value != null) {
                return value;
            }
            throw new IllegalArgumentException("No value recorded for '" + term + "'");
        };
        final double[] _metric = new double[1];
        MultivariateFunction function = new MultivariateFunction(){
            double metric;

            @Override
            public double value(double[] doubles) {
                int i;
                for (int i2 = 0; i2 < variableNodes.size(); ++i2) {
                    variableValues.put(((Node)variableNodes.get(i2)).getName(), doubles[i2]);
                }
                double[] image = new double[doubles.length];
                for (i = 0; i < variableNodes.size(); ++i) {
                    Node node = (Node)variableNodes.get(i);
                    Expression expression = GeneralizedSemIm.this.pm.getNodeExpression(node);
                    image[i] = expression.evaluate(context);
                    if (!Double.isNaN(image[i])) continue;
                    throw new IllegalArgumentException("Undefined value for expression " + expression);
                }
                this.metric = 0.0;
                for (i = 0; i < variableNodes.size(); ++i) {
                    double diff = doubles[i] - image[i];
                    this.metric += diff * diff;
                }
                for (i = 0; i < variableNodes.size(); ++i) {
                    variableValues.put(((Node)variableNodes.get(i)).getName(), image[i]);
                }
                _metric[0] = this.metric;
                return this.metric;
            }
        };
        PowellOptimizer search = new PowellOptimizer(1.0E-7, 1.0E-7);
        for (int row = 0; row < sampleSize; ++row) {
            for (Node variable : variableNodes) {
                Node error = this.pm.getErrorNode(variable);
                if (error == null) {
                    throw new NullPointerException();
                }
                Expression expression = this.pm.getNodeExpression(error);
                double value = expression.evaluate(context);
                if (Double.isNaN(value)) {
                    throw new IllegalArgumentException("Undefined value for expression: " + expression);
                }
                variableValues.put(error.getName(), value);
            }
            for (Node variable : variableNodes) {
                variableValues.put(variable.getName(), 0.0);
            }
            do {
                double[] values = new double[variableNodes.size()];
                for (int i = 0; i < values.length; ++i) {
                    values[i] = (Double)variableValues.get(variableNodes.get(i).getName());
                }
                PointValuePair pair = search.optimize(new InitialGuess(values), new ObjectiveFunction(function), GoalType.MINIMIZE, new MaxEval(100000));
                values = pair.getPoint();
                for (int i = 0; i < variableNodes.size(); ++i) {
                    variableValues.put(variableNodes.get(i).getName(), values[i]);
                    fullDataSet.setDouble(row, i, values[i]);
                }
            } while (!(_metric[0] < 0.01));
        }
        if (latentDataSaved) {
            return fullDataSet;
        }
        return DataUtils.restrictToMeasured(fullDataSet);
    }

    public DataSet simulateDataAvoidInfinity(int sampleSize, boolean latentDataSaved) {
        HashMap<String, Double> variableValues = new HashMap<String, Double>();
        LinkedList<Node> continuousVariables = new LinkedList<Node>();
        List<Node> variableNodes = this.pm.getVariableNodes();
        for (Node node : variableNodes) {
            ContinuousVariable var = new ContinuousVariable(node.getName());
            var.setNodeType(node.getNodeType());
            if (var.getNodeType() == NodeType.ERROR) continue;
            continuousVariables.add(var);
        }
        BoxDataSet fullDataSet = new BoxDataSet(new VerticalDoubleDataBox(sampleSize, continuousVariables.size()), continuousVariables);
        Context context = term -> {
            Double value = this.parameterValues.get(term);
            if (value != null) {
                return value;
            }
            value = (Double)variableValues.get(term);
            if (value != null) {
                return value;
            }
            throw new IllegalArgumentException("No value recorded for '" + term + "'");
        };
        boolean allInRange = true;
        block1: for (int row = 0; row < sampleSize; ++row) {
            double value;
            Expression expression;
            Node error;
            for (Node variable : variableNodes) {
                error = this.pm.getErrorNode(variable);
                if (error == null) {
                    throw new NullPointerException();
                }
                expression = this.pm.getNodeExpression(error);
                value = expression.evaluate(context);
                if (Double.isNaN(value)) {
                    throw new IllegalArgumentException("Undefined value for expression: " + expression);
                }
                variableValues.put(error.getName(), value);
            }
            for (Node variable : variableNodes) {
                error = this.pm.getErrorNode(variable);
                expression = this.pm.getNodeExpression(error);
                value = expression.evaluate(context);
                if (Double.isNaN(value)) {
                    throw new IllegalArgumentException("Undefined value for expression: " + expression);
                }
                variableValues.put(variable.getName(), 0.0);
            }
            double delta = 1.0E-10;
            int count = -1;
            while (++count < 5000) {
                Node node;
                int i;
                double[] values = new double[variableNodes.size()];
                for (i = 0; i < values.length; ++i) {
                    double value2;
                    node = variableNodes.get(i);
                    Expression expression2 = this.pm.getNodeExpression(node);
                    values[i] = value2 = expression2.evaluate(context);
                }
                allInRange = true;
                for (i = 0; i < values.length; ++i) {
                    node = variableNodes.get(i);
                    if (FastMath.abs((Double)variableValues.get(node.getName()) - values[i]) < 1.0E-10) continue;
                    if (!(FastMath.abs((Double)variableValues.get(node.getName())) < 1000000.0) && count < 1000) {
                        --row;
                        continue block1;
                    }
                    allInRange = false;
                    break;
                }
                for (i = 0; i < variableNodes.size(); ++i) {
                    variableValues.put(variableNodes.get(i).getName(), values[i]);
                }
                if (!allInRange) continue;
                break;
            }
            if (!allInRange) {
                --row;
                System.out.println("Trying another starting point...");
                continue;
            }
            for (int i = 0; i < variableNodes.size(); ++i) {
                double value3 = (Double)variableValues.get(variableNodes.get(i).getName());
                fullDataSet.setDouble(row, i, value3);
            }
        }
        if (latentDataSaved) {
            return fullDataSet;
        }
        return DataUtils.restrictToMeasured(fullDataSet);
    }

    public synchronized DataSet simulateDataFisher(int sampleSize) {
        return this.simulateDataFisher(sampleSize, 50, 1.0E-10);
    }

    public synchronized DataSet simulateDataFisher(int sampleSize, int intervalBetweenShocks, double epsilon) {
        boolean printedUndefined = false;
        boolean printedInfinite = false;
        if (intervalBetweenShocks < 1) {
            throw new IllegalArgumentException("Interval between shocks must be >= 1: " + intervalBetweenShocks);
        }
        if (epsilon <= 0.0) {
            throw new IllegalArgumentException("Epsilon must be > 0: " + epsilon);
        }
        HashMap<String, Double> variableValues = new HashMap<String, Double>();
        Context context = term -> {
            Double value = this.parameterValues.get(term);
            if (value != null) {
                return value;
            }
            value = (Double)variableValues.get(term);
            if (value != null) {
                return value;
            }
            throw new IllegalArgumentException("No value recorded for '" + term + "'");
        };
        List<Node> variableNodes = this.pm.getVariableNodes();
        double[] t1 = new double[variableNodes.size()];
        double[] t2 = new double[variableNodes.size()];
        double[] shocks = new double[variableNodes.size()];
        double[][] all = new double[variableNodes.size()][sampleSize];
        for (int row = 0; row < sampleSize; ++row) {
            int j;
            for (j = 0; j < t1.length; ++j) {
                Node error = this.pm.getErrorNode(variableNodes.get(j));
                if (error == null) {
                    throw new NullPointerException();
                }
                Expression expression = this.pm.getNodeExpression(error);
                double value = expression.evaluate(context);
                if (Double.isNaN(value)) {
                    throw new IllegalArgumentException("Undefined value for expression: " + expression);
                }
                variableValues.put(error.getName(), value);
                shocks[j] = value;
                if (this.guaranteeIid) {
                    t2[j] = shocks[j];
                    continue;
                }
                int n = j;
                t2[n] = t2[n] + shocks[j];
            }
            for (int i = 0; i < intervalBetweenShocks; ++i) {
                for (int j2 = 0; j2 < t1.length; ++j2) {
                    Node node = variableNodes.get(j2);
                    Expression expression = this.pm.getNodeExpression(node);
                    t2[j2] = expression.evaluate(context);
                    if (Double.isNaN(t2[j2]) && !printedUndefined) {
                        System.out.println("Undefined value.");
                        printedUndefined = true;
                    }
                    if (Double.isInfinite(t2[j2]) && !printedInfinite) {
                        System.out.println("Infinite value.");
                        printedInfinite = true;
                    }
                    variableValues.put(node.getName(), t2[j2]);
                }
                boolean converged = true;
                for (int j3 = 0; j3 < t1.length; ++j3) {
                    if (!(FastMath.abs(t2[j3] - t1[j3]) > epsilon)) continue;
                    converged = false;
                    break;
                }
                double[] t3 = t1;
                t1 = t2;
                t2 = t3;
                if (converged) break;
            }
            for (j = 0; j < t1.length; ++j) {
                all[j][row] = t1[j];
            }
        }
        ArrayList<Node> continuousVars = new ArrayList<Node>();
        for (Node node : variableNodes) {
            ContinuousVariable var = new ContinuousVariable(node.getName());
            var.setNodeType(node.getNodeType());
            continuousVars.add(var);
        }
        BoxDataSet boxDataSet = new BoxDataSet(new VerticalDoubleDataBox(all), continuousVars);
        return DataUtils.restrictToMeasured(boxDataSet);
    }

    public Vector simulateOneRecord(Vector e) {
        int i;
        HashMap<String, Double> variableValues = new HashMap<String, Double>();
        List<Node> variableNodes = this.pm.getVariableNodes();
        Context context = term -> {
            Double value = this.parameterValues.get(term);
            if (value != null) {
                return value;
            }
            value = (Double)variableValues.get(term);
            if (value != null) {
                return value;
            }
            throw new IllegalArgumentException("No value recorded for '" + term + "'");
        };
        for (int i2 = 0; i2 < variableNodes.size(); ++i2) {
            Node error = this.pm.getErrorNode(variableNodes.get(i2));
            if (error == null) {
                throw new NullPointerException();
            }
            variableValues.put(error.getName(), e.get(i2));
        }
        for (Node variable : variableNodes) {
            variableValues.put(variable.getName(), 0.0);
        }
        double delta = 1.0E-6;
        int count = -1;
        while (++count < 10000) {
            int i3;
            double[] values = new double[variableNodes.size()];
            for (i = 0; i < values.length; ++i) {
                double value;
                Node node = variableNodes.get(i);
                Expression expression = this.pm.getNodeExpression(node);
                values[i] = value = expression.evaluate(context);
            }
            boolean allInRange = true;
            for (i3 = 0; i3 < values.length; ++i3) {
                Node node = variableNodes.get(i3);
                if (FastMath.abs((Double)variableValues.get(node.getName()) - values[i3]) < 1.0E-6) continue;
                allInRange = false;
                break;
            }
            for (i3 = 0; i3 < variableNodes.size(); ++i3) {
                variableValues.put(variableNodes.get(i3).getName(), values[i3]);
            }
            if (!allInRange) continue;
            break;
        }
        Vector _case = new Vector(e.size());
        for (i = 0; i < variableNodes.size(); ++i) {
            double value = (Double)variableValues.get(variableNodes.get(i).getName());
            _case.set(i, value);
        }
        return _case;
    }

    public DataSet simulateDataNSteps(int sampleSize, boolean latentDataSaved) {
        HashMap<String, Double> variableValues = new HashMap<String, Double>();
        LinkedList<Node> continuousVariables = new LinkedList<Node>();
        List<Node> variableNodes = this.pm.getVariableNodes();
        for (Node node : variableNodes) {
            ContinuousVariable var = new ContinuousVariable(node.getName());
            var.setNodeType(node.getNodeType());
            if (var.getNodeType() == NodeType.ERROR) continue;
            continuousVariables.add(var);
        }
        BoxDataSet fullDataSet = new BoxDataSet(new VerticalDoubleDataBox(sampleSize, continuousVariables.size()), continuousVariables);
        Context context = term -> {
            Double value = this.parameterValues.get(term);
            if (value != null) {
                return value;
            }
            value = (Double)variableValues.get(term);
            if (value != null) {
                return value;
            }
            throw new IllegalArgumentException("No value recorded for '" + term + "'");
        };
        block1: for (int row = 0; row < sampleSize; ++row) {
            for (Node variable : variableNodes) {
                Node error = this.pm.getErrorNode(variable);
                if (error == null) {
                    throw new NullPointerException();
                }
                Expression expression = this.pm.getNodeExpression(error);
                double value = expression.evaluate(context);
                if (Double.isNaN(value)) {
                    throw new IllegalArgumentException("Undefined value for expression: " + expression);
                }
                variableValues.put(error.getName(), value);
            }
            for (Node variable : variableNodes) {
                variableValues.put(variable.getName(), 0.0);
            }
            for (int m = 0; m < 1; ++m) {
                double[] values = new double[variableNodes.size()];
                for (int i = 0; i < values.length; ++i) {
                    Node node = variableNodes.get(i);
                    Expression expression = this.pm.getNodeExpression(node);
                    double value = expression.evaluate(context);
                    if (Double.isNaN(value)) {
                        throw new IllegalArgumentException("Undefined value for expression: " + expression);
                    }
                    values[i] = value;
                }
                for (double value : values) {
                    if (value != Double.POSITIVE_INFINITY && value != Double.NEGATIVE_INFINITY) continue;
                    --row;
                    continue block1;
                }
                for (int i = 0; i < variableNodes.size(); ++i) {
                    variableValues.put(variableNodes.get(i).getName(), values[i]);
                }
            }
            for (int i = 0; i < variableNodes.size(); ++i) {
                double value = (Double)variableValues.get(variableNodes.get(i).getName());
                fullDataSet.setDouble(row, i, value);
            }
        }
        if (latentDataSaved) {
            return fullDataSet;
        }
        return DataUtils.restrictToMeasured(fullDataSet);
    }

    public GeneralizedSemPm getSemPm() {
        return new GeneralizedSemPm(this.pm);
    }

    public void setSubstitutions(Map<String, Double> parameterValues) {
        for (String parameter : parameterValues.keySet()) {
            if (!this.parameterValues.containsKey(parameter)) continue;
            this.parameterValues.put(parameter, parameterValues.get(parameter));
        }
    }

    public void setGuaranteeIid(boolean guaranteeIid) {
        this.guaranteeIid = guaranteeIid;
    }
}

