/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.sem;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.jet.math.Mult;
import cern.jet.math.PlusMult;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.SemGraph;
import edu.cmu.tetrad.util.MatrixUtils;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.math3.util.FastMath;

public class Ricf {
    public RicfResult ricf(SemGraph mag, ICovarianceMatrix covMatrix, double tolerance) {
        double _diff;
        double diff;
        mag.setShowErrorTerms(false);
        DoubleFactory2D factory = DoubleFactory2D.dense;
        Algebra algebra = new Algebra();
        DenseDoubleMatrix2D S = new DenseDoubleMatrix2D(covMatrix.getMatrix().toArray());
        int p = covMatrix.getDimension();
        if (p == 1) {
            return new RicfResult(S, S, null, null, 1, Double.NaN, covMatrix);
        }
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (String name : covMatrix.getVariableNames()) {
            nodes.add(mag.getNode(name));
        }
        DoubleMatrix2D omega = factory.diagonal(factory.diagonal(S));
        DoubleMatrix2D B = factory.identity(p);
        int[] ug = this.ugNodes(mag, nodes);
        int[] ugComp = this.complement(p, ug);
        if (ug.length > 0) {
            LinkedList<Node> _ugNodes = new LinkedList<Node>();
            for (int i : ug) {
                _ugNodes.add((Node)nodes.get(i));
            }
            Graph ugGraph = mag.subgraph(_ugNodes);
            ICovarianceMatrix ugCov = covMatrix.getSubmatrix(ug);
            DoubleMatrix2D lambdaInv = this.fitConGraph(ugGraph, ugCov, p + 1, tolerance).shat;
            omega.viewSelection(ug, ug).assign(lambdaInv);
        }
        int[][] pars = this.parentIndices(p, mag, nodes);
        int[][] spo = this.spouseIndices(p, mag, nodes);
        int i = 0;
        do {
            ++i;
            DoubleMatrix2D omegaOld = omega.copy();
            DoubleMatrix2D bOld = B.copy();
            for (int _v = 0; _v < p; ++_v) {
                DoubleMatrix2D XX;
                DenseDoubleMatrix2D oInv;
                DoubleMatrix2D a4;
                DoubleMatrix2D a3;
                DoubleMatrix2D a2;
                if (Arrays.binarySearch(ug, _v) >= 0) continue;
                int[] v = new int[]{_v};
                int[] vcomp = this.complement(p, v);
                int[] all = this.range(0, p - 1);
                int[] parv = pars[_v];
                int[] spov = spo[_v];
                DoubleMatrix2D a6 = B.viewSelection(v, parv);
                if (spov.length == 0) {
                    if (parv.length == 0 || i != 1) continue;
                    DoubleMatrix2D a1 = S.viewSelection(parv, parv);
                    a2 = S.viewSelection(v, parv);
                    a3 = algebra.inverse(a1);
                    a4 = algebra.mult(a2, a3);
                    a4.assign(Mult.mult(-1.0));
                    a6.assign(a4);
                    DoubleMatrix2D a7 = S.viewSelection(parv, v);
                    DoubleMatrix2D a9 = algebra.mult(a6, a7);
                    DoubleMatrix2D a8 = S.viewSelection(v, v);
                    DoubleMatrix2D a8b = omega.viewSelection(v, v);
                    a8b.assign(a8);
                    omega.viewSelection(v, v).assign(a9, PlusMult.plusMult(1.0));
                    continue;
                }
                if (parv.length != 0) {
                    oInv = new DenseDoubleMatrix2D(p, p);
                    a2 = omega.viewSelection(vcomp, vcomp);
                    a3 = algebra.inverse(a2);
                    oInv.viewSelection(vcomp, vcomp).assign(a3);
                    DoubleMatrix2D Z = algebra.mult(oInv.viewSelection(spov, vcomp), B.viewSelection(vcomp, all));
                    int lpa = parv.length;
                    int lspo = spov.length;
                    XX = new DenseDoubleMatrix2D(lpa + lspo, lpa + lspo);
                    int[] range1 = this.range(0, lpa - 1);
                    int[] range2 = this.range(lpa, lpa + lspo - 1);
                    XX.viewSelection(range1, range1).assign(S.viewSelection(parv, parv));
                    DoubleMatrix2D a11 = algebra.mult(S.viewSelection(parv, all), algebra.transpose(Z));
                    XX.viewSelection(range1, range2).assign(a11);
                    DoubleMatrix2D a12 = XX.viewSelection(range2, range1);
                    DoubleMatrix2D a13 = algebra.transpose(XX.viewSelection(range1, range2));
                    a12.assign(a13);
                    DoubleMatrix2D a14 = XX.viewSelection(range2, range2);
                    DoubleMatrix2D a15 = algebra.mult(Z, S);
                    DoubleMatrix2D a16 = algebra.mult(a15, algebra.transpose(Z));
                    a14.assign(a16);
                    DenseDoubleMatrix1D YX = new DenseDoubleMatrix1D(lpa + lspo);
                    DoubleMatrix1D a17 = YX.viewSelection(range1);
                    DoubleMatrix1D a18 = S.viewSelection(v, parv).viewRow(0);
                    a17.assign(a18);
                    DoubleMatrix1D a19 = YX.viewSelection(range2);
                    DoubleMatrix2D a20 = S.viewSelection(v, all);
                    DoubleMatrix1D a21 = algebra.mult(a20, algebra.transpose(Z)).viewRow(0);
                    a19.assign(a21);
                    DoubleMatrix2D a22 = algebra.inverse(XX);
                    DoubleMatrix1D temp = algebra.mult(algebra.transpose(a22), (DoubleMatrix1D)YX);
                    DoubleMatrix1D a23 = a6.viewRow(0);
                    DoubleMatrix1D a24 = temp.viewSelection(range1);
                    a23.assign(a24);
                    a23.assign(Mult.mult(-1.0));
                    omega.viewSelection(v, spov).viewRow(0).assign(temp.viewSelection(range2));
                    omega.viewSelection(spov, v).viewColumn(0).assign(temp.viewSelection(range2));
                    double tempVar = S.get(_v, _v) - algebra.mult(temp, (DoubleMatrix1D)YX);
                    DoubleMatrix2D a27 = omega.viewSelection(v, spov);
                    DoubleMatrix2D a28 = oInv.viewSelection(spov, spov);
                    DoubleMatrix2D a29 = omega.viewSelection(spov, v).copy();
                    DoubleMatrix2D a30 = algebra.mult(a27, a28);
                    DoubleMatrix2D a31 = algebra.mult(a30, a29);
                    omega.viewSelection(v, v).assign(tempVar);
                    omega.viewSelection(v, v).assign(a31, PlusMult.plusMult(1.0));
                    continue;
                }
                oInv = new DenseDoubleMatrix2D(p, p);
                a2 = omega.viewSelection(vcomp, vcomp);
                a3 = algebra.inverse(a2);
                oInv.viewSelection(vcomp, vcomp).assign(a3);
                a4 = oInv.viewSelection(spov, vcomp);
                DoubleMatrix2D a5 = B.viewSelection(vcomp, all);
                DoubleMatrix2D Z = algebra.mult(a4, a5);
                XX = algebra.mult(algebra.mult(Z, S), Z.viewDice());
                DoubleMatrix2D a20 = S.viewSelection(v, all);
                DoubleMatrix1D YX = algebra.mult(a20, Z.viewDice()).viewRow(0);
                DoubleMatrix2D a22 = algebra.inverse(XX);
                DoubleMatrix1D a23 = algebra.mult(algebra.transpose(a22), YX);
                DoubleMatrix1D a24 = omega.viewSelection(v, spov).viewRow(0);
                a24.assign(a23);
                DoubleMatrix1D a25 = omega.viewSelection(spov, v).viewColumn(0);
                a25.assign(a23);
                double tempVar = S.get(_v, _v) - algebra.mult(a24, YX);
                DoubleMatrix2D a27 = omega.viewSelection(v, spov);
                DoubleMatrix2D a28 = oInv.viewSelection(spov, spov);
                DoubleMatrix2D a29 = omega.viewSelection(spov, v).copy();
                DoubleMatrix2D a30 = algebra.mult(a27, a28);
                DoubleMatrix2D a31 = algebra.mult(a30, a29);
                omega.set(_v, _v, tempVar + a31.get(0, 0));
            }
            DoubleMatrix2D a32 = omega.copy();
            a32.assign(omegaOld, PlusMult.plusMult(-1.0));
            double diff1 = algebra.norm1(a32);
            DoubleMatrix2D a33 = B.copy();
            a33.assign(bOld, PlusMult.plusMult(-1.0));
            double diff2 = algebra.norm1(a32);
            _diff = diff = diff1 + diff2;
        } while (!(diff < tolerance));
        DoubleMatrix2D a34 = algebra.inverse(B);
        DoubleMatrix2D a35 = algebra.inverse(B.viewDice());
        DoubleMatrix2D sigmahat = algebra.mult(algebra.mult(a34, omega), a35);
        DoubleMatrix2D lambdahat = omega.copy();
        DoubleMatrix2D a36 = lambdahat.viewSelection(ugComp, ugComp);
        a36.assign(factory.make(ugComp.length, ugComp.length, 0.0));
        DoubleMatrix2D omegahat = omega.copy();
        DoubleMatrix2D a37 = omegahat.viewSelection(ug, ug);
        a37.assign(factory.make(ug.length, ug.length, 0.0));
        DoubleMatrix2D bhat = B.copy();
        return new RicfResult(sigmahat, lambdahat, bhat, omegahat, i, _diff, covMatrix);
    }

    public RicfResult ricf2(Graph mag, ICovarianceMatrix covMatrix, double tolerance) {
        double _diff;
        double diff;
        DoubleFactory2D factory = DoubleFactory2D.dense;
        Algebra algebra = new Algebra();
        DenseDoubleMatrix2D S = new DenseDoubleMatrix2D(covMatrix.getMatrix().toArray());
        int p = covMatrix.getDimension();
        if (p == 1) {
            return new RicfResult(S, S, null, null, 1, Double.NaN, covMatrix);
        }
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (String name : covMatrix.getVariableNames()) {
            nodes.add(mag.getNode(name));
        }
        DoubleMatrix2D omega = factory.diagonal(factory.diagonal(S));
        DoubleMatrix2D B = factory.identity(p);
        int[] ug = this.ugNodes(mag, nodes);
        int[] ugComp = this.complement(p, ug);
        if (ug.length > 0) {
            LinkedList<Node> _ugNodes = new LinkedList<Node>();
            for (int i : ug) {
                _ugNodes.add((Node)nodes.get(i));
            }
            Graph ugGraph = mag.subgraph(_ugNodes);
            ICovarianceMatrix ugCov = covMatrix.getSubmatrix(ug);
            DoubleMatrix2D lambdaInv = this.fitConGraph(ugGraph, ugCov, p + 1, tolerance).shat;
            omega.viewSelection(ug, ug).assign(lambdaInv);
        }
        int[][] pars = this.parentIndices(p, mag, nodes);
        int[][] spo = this.spouseIndices(p, mag, nodes);
        int i = 0;
        do {
            ++i;
            DoubleMatrix2D omegaOld = omega.copy();
            DoubleMatrix2D bOld = B.copy();
            for (int _v = 0; _v < p; ++_v) {
                DoubleMatrix2D XX;
                DenseDoubleMatrix2D oInv;
                DoubleMatrix2D a4;
                DoubleMatrix2D a3;
                DoubleMatrix2D a2;
                if (Arrays.binarySearch(ug, _v) >= 0) continue;
                int[] v = new int[]{_v};
                int[] vcomp = this.complement(p, v);
                int[] all = this.range(0, p - 1);
                int[] parv = pars[_v];
                int[] spov = spo[_v];
                DoubleMatrix2D a6 = B.viewSelection(v, parv);
                if (spov.length == 0) {
                    if (parv.length == 0 || i != 1) continue;
                    DoubleMatrix2D a1 = S.viewSelection(parv, parv);
                    a2 = S.viewSelection(v, parv);
                    a3 = algebra.inverse(a1);
                    a4 = algebra.mult(a2, a3);
                    a4.assign(Mult.mult(-1.0));
                    a6.assign(a4);
                    DoubleMatrix2D a7 = S.viewSelection(parv, v);
                    DoubleMatrix2D a9 = algebra.mult(a6, a7);
                    DoubleMatrix2D a8 = S.viewSelection(v, v);
                    DoubleMatrix2D a8b = omega.viewSelection(v, v);
                    a8b.assign(a8);
                    omega.viewSelection(v, v).assign(a9, PlusMult.plusMult(1.0));
                    continue;
                }
                if (parv.length != 0) {
                    oInv = new DenseDoubleMatrix2D(p, p);
                    a2 = omega.viewSelection(vcomp, vcomp);
                    a3 = algebra.inverse(a2);
                    oInv.viewSelection(vcomp, vcomp).assign(a3);
                    DoubleMatrix2D Z = algebra.mult(oInv.viewSelection(spov, vcomp), B.viewSelection(vcomp, all));
                    int lpa = parv.length;
                    int lspo = spov.length;
                    XX = new DenseDoubleMatrix2D(lpa + lspo, lpa + lspo);
                    int[] range1 = this.range(0, lpa - 1);
                    int[] range2 = this.range(lpa, lpa + lspo - 1);
                    XX.viewSelection(range1, range1).assign(S.viewSelection(parv, parv));
                    DoubleMatrix2D a11 = algebra.mult(S.viewSelection(parv, all), algebra.transpose(Z));
                    XX.viewSelection(range1, range2).assign(a11);
                    DoubleMatrix2D a12 = XX.viewSelection(range2, range1);
                    DoubleMatrix2D a13 = algebra.transpose(XX.viewSelection(range1, range2));
                    a12.assign(a13);
                    DoubleMatrix2D a14 = XX.viewSelection(range2, range2);
                    DoubleMatrix2D a15 = algebra.mult(Z, S);
                    DoubleMatrix2D a16 = algebra.mult(a15, algebra.transpose(Z));
                    a14.assign(a16);
                    DenseDoubleMatrix1D YX = new DenseDoubleMatrix1D(lpa + lspo);
                    DoubleMatrix1D a17 = YX.viewSelection(range1);
                    DoubleMatrix1D a18 = S.viewSelection(v, parv).viewRow(0);
                    a17.assign(a18);
                    DoubleMatrix1D a19 = YX.viewSelection(range2);
                    DoubleMatrix2D a20 = S.viewSelection(v, all);
                    DoubleMatrix1D a21 = algebra.mult(a20, algebra.transpose(Z)).viewRow(0);
                    a19.assign(a21);
                    DoubleMatrix2D a22 = algebra.inverse(XX);
                    DoubleMatrix1D temp = algebra.mult(algebra.transpose(a22), (DoubleMatrix1D)YX);
                    DoubleMatrix1D a23 = a6.viewRow(0);
                    DoubleMatrix1D a24 = temp.viewSelection(range1);
                    a23.assign(a24);
                    a23.assign(Mult.mult(-1.0));
                    omega.viewSelection(v, spov).viewRow(0).assign(temp.viewSelection(range2));
                    omega.viewSelection(spov, v).viewColumn(0).assign(temp.viewSelection(range2));
                    double tempVar = S.get(_v, _v) - algebra.mult(temp, (DoubleMatrix1D)YX);
                    DoubleMatrix2D a27 = omega.viewSelection(v, spov);
                    DoubleMatrix2D a28 = oInv.viewSelection(spov, spov);
                    DoubleMatrix2D a29 = omega.viewSelection(spov, v).copy();
                    DoubleMatrix2D a30 = algebra.mult(a27, a28);
                    DoubleMatrix2D a31 = algebra.mult(a30, a29);
                    omega.viewSelection(v, v).assign(tempVar);
                    omega.viewSelection(v, v).assign(a31, PlusMult.plusMult(1.0));
                    continue;
                }
                oInv = new DenseDoubleMatrix2D(p, p);
                a2 = omega.viewSelection(vcomp, vcomp);
                a3 = algebra.inverse(a2);
                oInv.viewSelection(vcomp, vcomp).assign(a3);
                a4 = oInv.viewSelection(spov, vcomp);
                DoubleMatrix2D a5 = B.viewSelection(vcomp, all);
                DoubleMatrix2D Z = algebra.mult(a4, a5);
                XX = algebra.mult(algebra.mult(Z, S), Z.viewDice());
                DoubleMatrix2D a20 = S.viewSelection(v, all);
                DoubleMatrix1D YX = algebra.mult(a20, Z.viewDice()).viewRow(0);
                DoubleMatrix2D a22 = algebra.inverse(XX);
                DoubleMatrix1D a23 = algebra.mult(algebra.transpose(a22), YX);
                DoubleMatrix1D a24 = omega.viewSelection(v, spov).viewRow(0);
                a24.assign(a23);
                DoubleMatrix1D a25 = omega.viewSelection(spov, v).viewColumn(0);
                a25.assign(a23);
                double tempVar = S.get(_v, _v) - algebra.mult(a24, YX);
                DoubleMatrix2D a27 = omega.viewSelection(v, spov);
                DoubleMatrix2D a28 = oInv.viewSelection(spov, spov);
                DoubleMatrix2D a29 = omega.viewSelection(spov, v).copy();
                DoubleMatrix2D a30 = algebra.mult(a27, a28);
                DoubleMatrix2D a31 = algebra.mult(a30, a29);
                omega.set(_v, _v, tempVar + a31.get(0, 0));
            }
            DoubleMatrix2D a32 = omega.copy();
            a32.assign(omegaOld, PlusMult.plusMult(-1.0));
            double diff1 = algebra.norm1(a32);
            DoubleMatrix2D a33 = B.copy();
            a33.assign(bOld, PlusMult.plusMult(-1.0));
            double diff2 = algebra.norm1(a32);
            _diff = diff = diff1 + diff2;
        } while (!(diff < tolerance));
        DoubleMatrix2D a34 = algebra.inverse(B);
        DoubleMatrix2D a35 = algebra.inverse(B.viewDice());
        DoubleMatrix2D sigmahat = algebra.mult(algebra.mult(a34, omega), a35);
        DoubleMatrix2D lambdahat = omega.copy();
        DoubleMatrix2D a36 = lambdahat.viewSelection(ugComp, ugComp);
        a36.assign(factory.make(ugComp.length, ugComp.length, 0.0));
        DoubleMatrix2D omegahat = omega.copy();
        DoubleMatrix2D a37 = omegahat.viewSelection(ug, ug);
        a37.assign(factory.make(ug.length, ug.length, 0.0));
        DoubleMatrix2D bhat = B.copy();
        return new RicfResult(sigmahat, lambdahat, bhat, omegahat, i, _diff, covMatrix);
    }

    public List<List<Node>> cliques(Graph graph) {
        List<Node> nodes = graph.getNodes();
        ArrayList<List<Node>> cliques = new ArrayList<List<Node>>();
        for (int i = 0; i < nodes.size(); ++i) {
            List<Node> adj = graph.getAdjacentNodes(nodes.get(i));
            TreeSet<Integer> L1 = new TreeSet<Integer>();
            L1.add(i);
            TreeSet<Integer> L2 = new TreeSet<Integer>();
            for (Node _adj : adj) {
                L2.add(nodes.indexOf(_adj));
            }
            int moved = -1;
            do {
                this.addNodesToRight(L1, L2, graph, nodes, moved);
                if (!this.isMaximal(L1, L2, graph, nodes)) continue;
                this.record(L1, cliques, nodes);
            } while ((moved = this.moveLastBack(L1, L2)) != -1);
        }
        return cliques;
    }

    private FitConGraphResult fitConGraph(Graph graph, ICovarianceMatrix cov, int n, double tol) {
        DoubleMatrix2D a32;
        double diff;
        DoubleFactory2D factory = DoubleFactory2D.dense;
        Algebra algebra = new Algebra();
        List<Node> nodes = graph.getNodes();
        String[] nodeNames = new String[nodes.size()];
        for (int i = 0; i < nodes.size(); ++i) {
            Node node = nodes.get(i);
            if (!cov.getVariableNames().contains(node.getName())) {
                throw new IllegalArgumentException("Node in graph not in cov matrix: " + node);
            }
            nodeNames[i] = node.getName();
        }
        DenseDoubleMatrix2D S = new DenseDoubleMatrix2D(cov.getSubmatrix(nodeNames).getMatrix().toArray());
        List<List<Node>> cli = this.cliques(graph = graph.subgraph(nodes));
        int nc = cli.size();
        if (nc == 1) {
            return new FitConGraphResult(S, 0.0, 0, 1);
        }
        int k = S.rows();
        int it = 0;
        DoubleMatrix2D K = algebra.inverse(factory.diagonal(factory.diagonal(S)));
        int[] all = this.range(0, k - 1);
        do {
            DoubleMatrix2D KOld = K.copy();
            ++it;
            for (List<Node> aCli : cli) {
                int[] a = this.asIndices(aCli, nodes);
                int[] b = this.complement(all, a);
                DoubleMatrix2D a1 = S.viewSelection(a, a);
                DoubleMatrix2D a2 = algebra.inverse(a1);
                DoubleMatrix2D a3 = K.viewSelection(a, b);
                DoubleMatrix2D a4 = K.viewSelection(b, b);
                DoubleMatrix2D a5 = algebra.inverse(a4);
                DoubleMatrix2D a6 = K.viewSelection(b, a).copy();
                DoubleMatrix2D a7 = algebra.mult(a3, a5);
                DoubleMatrix2D a8 = algebra.mult(a7, a6);
                a2.assign(a8, PlusMult.plusMult(1.0));
                DoubleMatrix2D a9 = K.viewSelection(a, a);
                a9.assign(a2);
            }
            a32 = K.copy();
            a32.assign(KOld, PlusMult.plusMult(-1.0));
        } while (!((diff = algebra.norm1(a32)) < tol));
        DoubleMatrix2D V = algebra.inverse(K);
        int numNodes = graph.getNumNodes();
        int df = numNodes * (numNodes - 1) / 2 - graph.getNumEdges();
        double dev = this.lik(algebra.inverse(V), S, n, k);
        return new FitConGraphResult(V, dev, df, it);
    }

    private int[] asIndices(List<Node> clique, List<Node> nodes) {
        int[] a = new int[clique.size()];
        for (int j = 0; j < clique.size(); ++j) {
            a[j] = nodes.indexOf(clique.get(j));
        }
        return a;
    }

    private double lik(DoubleMatrix2D K, DoubleMatrix2D S, int n, int k) {
        Algebra algebra = new Algebra();
        DoubleMatrix2D SK = algebra.mult(S, K);
        return (algebra.trace(SK) - FastMath.log(algebra.det(SK)) - (double)k) * (double)n;
    }

    private int[] range(int from, int to) {
        if (from < 0 || to < 0 || from > to) {
            throw new IllegalArgumentException();
        }
        int[] range = new int[to - from + 1];
        for (int k = from; k <= to; ++k) {
            range[k - from] = k;
        }
        return range;
    }

    private int[] complement(int p, int[] a) {
        Arrays.sort(a);
        int[] vcomp = new int[p - a.length];
        int k = -1;
        for (int j = 0; j < p; ++j) {
            if (Arrays.binarySearch(a, j) >= 0) continue;
            vcomp[++k] = j;
        }
        return vcomp;
    }

    private int[] complement(int[] all, int[] remove) {
        Arrays.sort(remove);
        int[] vcomp = new int[all.length - remove.length];
        int k = -1;
        for (int j = 0; j < all.length; ++j) {
            if (Arrays.binarySearch(remove, j) >= 0) continue;
            vcomp[++k] = j;
        }
        return vcomp;
    }

    private int[] ugNodes(Graph mag, List<Node> nodes) {
        LinkedList<Node> ugNodes = new LinkedList<Node>();
        for (Node node : nodes) {
            if (mag.getNodesInTo(node, Endpoint.ARROW).size() != 0) continue;
            ugNodes.add(node);
        }
        int[] indices = new int[ugNodes.size()];
        for (int j = 0; j < ugNodes.size(); ++j) {
            indices[j] = nodes.indexOf(ugNodes.get(j));
        }
        return indices;
    }

    private int[][] parentIndices(int p, Graph mag, List<Node> nodes) {
        int[][] pars = new int[p][];
        for (int i = 0; i < p; ++i) {
            List<Node> parents = mag.getParents(nodes.get(i));
            int[] indices = new int[parents.size()];
            for (int j = 0; j < parents.size(); ++j) {
                indices[j] = nodes.indexOf(parents.get(j));
            }
            pars[i] = indices;
        }
        return pars;
    }

    private int[][] spouseIndices(int p, Graph mag, List<Node> nodes) {
        int[][] spo = new int[p][];
        for (int i = 0; i < p; ++i) {
            List<Node> list1 = mag.getNodesOutTo(nodes.get(i), Endpoint.ARROW);
            List<Node> list2 = mag.getNodesInTo(nodes.get(i), Endpoint.ARROW);
            list1.retainAll(list2);
            int[] indices = new int[list1.size()];
            for (int j = 0; j < list1.size(); ++j) {
                indices[j] = nodes.indexOf(list1.get(j));
            }
            spo[i] = indices;
        }
        return spo;
    }

    private int moveLastBack(SortedSet<Integer> L1, SortedSet<Integer> L2) {
        if (L1.size() == 1) {
            return -1;
        }
        int moved = L1.last();
        L1.remove(moved);
        L2.add(moved);
        return moved;
    }

    private void addNodesToRight(SortedSet<Integer> L1, SortedSet<Integer> L2, Graph graph, List<Node> nodes, int moved) {
        for (int j : new TreeSet<Integer>(L2)) {
            if (j <= this.max(L1) || j <= moved || !this.addable(j, L1, graph, nodes)) continue;
            L1.add(j);
            L2.remove(j);
        }
    }

    private void record(SortedSet<Integer> L1, List<List<Node>> cliques, List<Node> nodes) {
        LinkedList<Node> clique = new LinkedList<Node>();
        Iterator iterator = L1.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            clique.add(nodes.get(i));
        }
        cliques.add(clique);
    }

    private boolean isMaximal(SortedSet<Integer> L1, SortedSet<Integer> L2, Graph graph, List<Node> nodes) {
        Iterator iterator = L2.iterator();
        while (iterator.hasNext()) {
            int j = (Integer)iterator.next();
            if (!this.addable(j, L1, graph, nodes)) continue;
            return false;
        }
        return true;
    }

    private int max(SortedSet<Integer> L1) {
        int max = Integer.MIN_VALUE;
        Iterator iterator = L1.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            if (i <= max) continue;
            max = i;
        }
        return max;
    }

    private boolean addable(int j, SortedSet<Integer> L1, Graph graph, List<Node> nodes) {
        Iterator iterator = L1.iterator();
        while (iterator.hasNext()) {
            int k = (Integer)iterator.next();
            if (graph.isAdjacentTo(nodes.get(j), nodes.get(k))) continue;
            return false;
        }
        return true;
    }

    public static class RicfResult {
        private final ICovarianceMatrix covMatrix;
        private final DoubleMatrix2D shat;
        private final DoubleMatrix2D lhat;
        private final DoubleMatrix2D bhat;
        private final DoubleMatrix2D ohat;
        private final int iterations;
        private final double diff;

        public RicfResult(DoubleMatrix2D shat, DoubleMatrix2D lhat, DoubleMatrix2D bhat, DoubleMatrix2D ohat, int iterations, double diff, ICovarianceMatrix covMatrix) {
            this.shat = shat;
            this.lhat = lhat;
            this.bhat = bhat;
            this.ohat = ohat;
            this.iterations = iterations;
            this.diff = diff;
            this.covMatrix = covMatrix;
        }

        public String toString() {
            return "\nSigma hat\n" + MatrixUtils.toStringSquare(this.getShat().toArray(), new DecimalFormat("0.0000"), this.covMatrix.getVariableNames()) + "\n\nLambda hat\n" + MatrixUtils.toStringSquare(this.getLhat().toArray(), new DecimalFormat("0.0000"), this.covMatrix.getVariableNames()) + "\n\nBeta hat\n" + MatrixUtils.toStringSquare(this.getBhat().toArray(), new DecimalFormat("0.0000"), this.covMatrix.getVariableNames()) + "\n\nOmega hat\n" + MatrixUtils.toStringSquare(this.getOhat().toArray(), new DecimalFormat("0.0000"), this.covMatrix.getVariableNames()) + "\n\nIterations\n" + this.getIterations() + "\n\ndiff = " + this.diff;
        }

        public DoubleMatrix2D getShat() {
            return this.shat;
        }

        public DoubleMatrix2D getLhat() {
            return this.lhat;
        }

        public DoubleMatrix2D getBhat() {
            return this.bhat;
        }

        public DoubleMatrix2D getOhat() {
            return this.ohat;
        }

        public int getIterations() {
            return this.iterations;
        }
    }

    public static class FitConGraphResult {
        private final DoubleMatrix2D shat;
        double deviance;
        int df;
        int iterations;

        public FitConGraphResult(DoubleMatrix2D shat, double deviance, int df, int iterations) {
            this.shat = shat;
            this.deviance = deviance;
            this.df = df;
            this.iterations = iterations;
        }

        public String toString() {
            return "\nSigma hat\n" + this.shat + "\nDeviance\n" + this.deviance + "\nDf\n" + this.df + "\nIterations\n" + this.iterations;
        }
    }
}

