/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.sem;

import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.SemGraph;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetrad.util.TetradSerializable;
import java.io.IOException;
import java.io.ObjectInputStream;

public final class SemEstimatorGibbsParams
implements TetradSerializable {
    static final long serialVersionUID = 23L;
    private SemIm startIm;
    private boolean flatPrior;
    private int numIterations;
    private double stretch;
    private final double tolerance;

    private SemEstimatorGibbsParams(SemIm startIm) {
        this.startIm = startIm;
        this.flatPrior = false;
        this.stretch = 0.0;
        this.numIterations = 1;
        this.tolerance = 1.0E-4;
    }

    public static SemEstimatorGibbsParams serializableInstance() {
        SemGraph graph = new SemGraph();
        graph.addNode(new GraphNode("X"));
        return new SemEstimatorGibbsParams(new SemIm(new SemPm(graph)));
    }

    public SemIm getStartIm() {
        return this.startIm;
    }

    public void setStartIm(SemIm startIm) {
        this.startIm = startIm;
    }

    public double getStretch() {
        return this.stretch;
    }

    public void setStretch(double stretch) {
        this.stretch = stretch;
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public int getNumIterations() {
        return this.numIterations;
    }

    public void setNumIterations(int numIterations) {
        this.numIterations = numIterations;
    }

    public void setFlatPrior(boolean flatPrior) {
        this.flatPrior = flatPrior;
    }

    public boolean isFlatPrior() {
        return this.flatPrior;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }
}

