/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.sem;

import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.graph.SemGraph;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemOptimizer;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetrad.util.Vector;
import java.util.List;

public class SemOptimizerRegression
implements SemOptimizer {
    static final long serialVersionUID = 23L;
    private int numRestarts = 1;

    public static SemOptimizerRegression serializableInstance() {
        return new SemOptimizerRegression();
    }

    @Override
    public void optimize(SemIm semIm) {
        if (this.numRestarts != 1) {
            throw new IllegalArgumentException("Number of restarts must be 1 for this method.");
        }
        Matrix covar = semIm.getSampleCovar();
        if (covar == null) {
            throw new NullPointerException("Sample covar has not been set.");
        }
        SemGraph graph = semIm.getSemPm().getGraph();
        List<Node> nodes = graph.getNodes();
        for (Node node : nodes) {
            if (node.getNodeType() != NodeType.MEASURED || !graph.isParameterizable(node)) continue;
            int idx = nodes.indexOf(node);
            List<Node> parents = graph.getParents(node);
            for (int i = 0; i < parents.size(); ++i) {
                Node nextParent = parents.get(i);
                if (nextParent.getNodeType() != NodeType.ERROR) continue;
                parents.remove(nextParent);
                break;
            }
            double variance = covar.get(idx, idx);
            if (parents.size() > 0) {
                Vector nodeParentsCov = new Vector(parents.size());
                Matrix parentsCov = new Matrix(parents.size(), parents.size());
                for (int i = 0; i < parents.size(); ++i) {
                    int idx2 = nodes.indexOf(parents.get(i));
                    nodeParentsCov.set(i, covar.get(idx, idx2));
                    for (int j = i; j < parents.size(); ++j) {
                        int idx3 = nodes.indexOf(parents.get(j));
                        parentsCov.set(i, j, covar.get(idx2, idx3));
                        parentsCov.set(j, i, covar.get(idx2, idx3));
                    }
                }
                Vector b = parentsCov.inverse().times(nodeParentsCov);
                variance -= nodeParentsCov.dotProduct(b);
                for (int i = 0; i < b.size(); ++i) {
                    int idx2 = nodes.indexOf(parents.get(i));
                    semIm.setParamValue(nodes.get(idx2), node, b.get(i));
                }
            }
            semIm.setParamValue(node, node, variance);
        }
        TetradLogger.getInstance().log("optimization", "FML = " + semIm.getScore());
    }

    @Override
    public void setNumRestarts(int numRestarts) {
        this.numRestarts = numRestarts;
    }

    @Override
    public int getNumRestarts() {
        return this.numRestarts;
    }

    public String toString() {
        return "Sem Optimizer Regression";
    }
}

