/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.sem;

import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.SemGraph;
import edu.cmu.tetrad.sem.ParamType;
import edu.cmu.tetrad.sem.Parameter;
import edu.cmu.tetrad.sem.SemIm;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import nu.xom.Attribute;
import nu.xom.Element;

public class SemXmlRenderer {
    public static Element getElement(SemIm semIm) {
        Element semElement = new Element("sem");
        semElement.appendChild(SemXmlRenderer.makeVariables(semIm));
        semElement.appendChild(SemXmlRenderer.makeEdges(semIm));
        semElement.appendChild(SemXmlRenderer.makeMarginalErrorDistribution(semIm));
        semElement.appendChild(SemXmlRenderer.makeJointErrorDistribution(semIm));
        return semElement;
    }

    private static Element makeVariables(SemIm semIm) {
        Element variable;
        Element variablesElement = new Element("semVariables");
        Iterator<Node> iterator = semIm.getSemPm().getMeasuredNodes().iterator();
        while (iterator.hasNext()) {
            Node node1;
            Node measuredNode = node1 = iterator.next();
            variable = new Element("continuousVariable");
            variable.addAttribute(new Attribute("name", measuredNode.getName()));
            variable.addAttribute(new Attribute("latent", "no"));
            variable.addAttribute(new Attribute("intercept", Double.toString(semIm.getIntercept(measuredNode))));
            variable.addAttribute(new Attribute("x", Integer.toString(measuredNode.getCenterX())));
            variable.addAttribute(new Attribute("y", Integer.toString(measuredNode.getCenterY())));
            variablesElement.appendChild(variable);
        }
        iterator = semIm.getSemPm().getLatentNodes().iterator();
        while (iterator.hasNext()) {
            Node node;
            Node latentNode = node = iterator.next();
            variable = new Element("continuousVariable");
            variable.addAttribute(new Attribute("name", latentNode.getName()));
            variable.addAttribute(new Attribute("latent", "yes"));
            variable.addAttribute(new Attribute("intercept", Double.toString(semIm.getIntercept(latentNode))));
            variable.addAttribute(new Attribute("x", Integer.toString(latentNode.getCenterX())));
            variable.addAttribute(new Attribute("y", Integer.toString(latentNode.getCenterY())));
            variablesElement.appendChild(variable);
        }
        return variablesElement;
    }

    private static Element makeEdges(SemIm semIm) {
        Element edgesElement = new Element("edges");
        for (Parameter parameter : semIm.getSemPm().getParameters()) {
            Parameter param = parameter;
            if (param.getType() != ParamType.COEF) continue;
            Element edge = new Element("edge");
            edge.addAttribute(new Attribute("causeNode", param.getNodeA().getName()));
            edge.addAttribute(new Attribute("effectNode", param.getNodeB().getName()));
            edge.addAttribute(new Attribute("coef", Double.toString(semIm.getParamValue(param))));
            edge.addAttribute(new Attribute("fixed", Boolean.valueOf(param.isFixed()).toString()));
            edgesElement.appendChild(edge);
        }
        return edgesElement;
    }

    private static Element makeMarginalErrorDistribution(SemIm semIm) {
        Element marginalErrorElement = new Element("marginalErrorDistribution");
        SemGraph semGraph = semIm.getSemPm().getGraph();
        semGraph.setShowErrorTerms(true);
        for (Node node : SemXmlRenderer.getExogenousNodes(semGraph)) {
            Element normal = new Element("normal");
            normal.addAttribute(new Attribute("variable", node.getName()));
            normal.addAttribute(new Attribute("variance", Double.toString(semIm.getParamValue(node, node))));
            marginalErrorElement.appendChild(normal);
        }
        return marginalErrorElement;
    }

    private static List<Node> getExogenousNodes(SemGraph graph) {
        ArrayList<Node> exogenousNodes = new ArrayList<Node>();
        for (Node node : graph.getNodes()) {
            exogenousNodes.add(graph.getExogenous(node));
        }
        return exogenousNodes;
    }

    private static Element makeJointErrorDistribution(SemIm semIm) {
        Element jointErrorElement = new Element("jointErrorDistribution");
        for (Parameter parameter : semIm.getSemPm().getParameters()) {
            Parameter param = parameter;
            if (param.getType() != ParamType.COVAR) continue;
            Element normal = new Element("normal");
            normal.addAttribute(new Attribute("node1", param.getNodeA().getName()));
            normal.addAttribute(new Attribute("node2", param.getNodeB().getName()));
            normal.addAttribute(new Attribute("covariance", Double.toString(param.getStartingValue())));
            jointErrorElement.appendChild(normal);
        }
        return jointErrorElement;
    }
}

