/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.session;

import edu.cmu.tetrad.session.SessionNode;
import java.util.EventObject;

public class SessionEvent
extends EventObject {
    public static final int NODE_ADDED = 0;
    public static final int NODE_REMOVED = 1;
    public static final int PARENT_ADDED = 2;
    public static final int PARENT_REMOVED = 3;
    public static final int MODEL_CREATED = 4;
    public static final int MODEL_DESTROYED = 5;
    public static final int MODEL_UNCLEAR = 6;
    public static final int EXECUTION_STARTED = 7;
    public static final int REPETITION_CHANGED = 8;
    public static final int ADDING_EDGE = 9;
    private SessionNode node;
    private SessionNode parent;
    private SessionNode child;
    private int type = -1;

    public SessionEvent(Object source, int type) {
        super(source);
        switch (type) {
            case 7: {
                this.type = type;
                break;
            }
            case 9: {
                this.type = type;
                break;
            }
            default: {
                throw new IllegalArgumentException("Not the type of event that requires zero session nodes as arguments.");
            }
        }
    }

    public SessionEvent(Object source, SessionNode node, int type) {
        super(source);
        if (node == null) {
            throw new NullPointerException();
        }
        this.node = node;
        switch (type) {
            case 0: 
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                this.type = type;
                break;
            }
            default: {
                throw new IllegalArgumentException("Not the type of event that requires one session node as argument.");
            }
        }
    }

    public SessionEvent(Object source, SessionNode parent, SessionNode child, int type) {
        super(source);
        this.parent = parent;
        this.child = child;
        switch (type) {
            case 2: 
            case 3: {
                this.type = type;
                break;
            }
            default: {
                throw new IllegalArgumentException("Not the type of event that requires two session nodes as arguments.");
            }
        }
    }

    public SessionEvent(Object source, SessionEvent event) {
        super(source);
        this.node = event.getNode();
        this.parent = event.getParent();
        this.child = event.getChild();
        this.type = event.getType();
    }

    public SessionNode getNode() {
        return this.node;
    }

    public SessionNode getParent() {
        return this.parent;
    }

    public SessionNode getChild() {
        return this.child;
    }

    public int getType() {
        return this.type;
    }
}

