/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.simulation;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphPersistence;
import edu.cmu.tetrad.simulation.Gdistance;
import edu.cmu.tetrad.util.DataConvertUtils;
import edu.pitt.dbmi.data.reader.Delimiter;
import edu.pitt.dbmi.data.reader.tabular.ContinuousTabularDatasetFileReader;
import java.io.File;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

public class GdistanceApply {
    public static void main(String ... args) {
        double xdist = 2.4;
        double ydist = 2.4;
        double zdist = 2.0;
        long timestart = System.nanoTime();
        System.out.println("Loading first graph");
        Graph graph1 = GraphPersistence.loadGraphTxt(new File("Motion_Corrected_Graphs/singlesub_motion_graph_025_04.txt"));
        long timegraph1 = System.nanoTime();
        System.out.println("Done loading first graph. Elapsed time: " + (timegraph1 - timestart) / 1000000000L + "s");
        System.out.println("Loading second graph");
        Graph graph2 = GraphPersistence.loadGraphTxt(new File("Motion_Corrected_Graphs/singlesub_motion_graph_027_04.txt"));
        long timegraph2 = System.nanoTime();
        System.out.println("Done loading second graph. Elapsed time: " + (timegraph2 - timegraph1) / 1000000000L + "s");
        graph1.removeNode(graph1.getNode("Motion_1"));
        graph1.removeNode(graph1.getNode("Motion_2"));
        graph1.removeNode(graph1.getNode("Motion_3"));
        graph1.removeNode(graph1.getNode("Motion_4"));
        graph1.removeNode(graph1.getNode("Motion_5"));
        graph1.removeNode(graph1.getNode("Motion_6"));
        graph2.removeNode(graph2.getNode("Motion_1"));
        graph2.removeNode(graph2.getNode("Motion_2"));
        graph2.removeNode(graph2.getNode("Motion_3"));
        graph2.removeNode(graph2.getNode("Motion_4"));
        graph2.removeNode(graph2.getNode("Motion_5"));
        graph2.removeNode(graph2.getNode("Motion_6"));
        String workingDirectory = System.getProperty("user.dir");
        System.out.println(workingDirectory);
        Path mapPath = Paths.get("coords.txt", new String[0]);
        System.out.println(mapPath);
        ContinuousTabularDatasetFileReader dataReaderMap = new ContinuousTabularDatasetFileReader(mapPath, Delimiter.COMMA);
        try {
            DataSet locationMap = (DataSet)DataConvertUtils.toDataModel(dataReaderMap.readInData());
            long timegraph3 = System.nanoTime();
            System.out.println("Done loading location map. Elapsed time: " + (timegraph3 - timegraph2) / 1000000000L + "s");
            System.out.println("Running Gdistance");
            Gdistance gdist = new Gdistance(locationMap, 2.4, 2.4, 2.0);
            List<Double> distance = gdist.distances(graph1, graph2);
            System.out.println(distance);
            System.out.println("Done running Distance. Elapsed time: " + (System.nanoTime() - timegraph3) / 1000000000L + "s");
            System.out.println("Total elapsed time: " + (System.nanoTime() - timestart) / 1000000000L + "s");
            PrintWriter writer = new PrintWriter("Gdistances.txt", "UTF-8");
            writer.println(distance);
            writer.close();
        }
        catch (Exception IOException2) {
            IOException2.printStackTrace();
        }
    }
}

