/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.simulation;

import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.RandomGraph;
import edu.cmu.tetrad.simulation.Gdistance;
import edu.cmu.tetrad.util.DataConvertUtils;
import edu.pitt.dbmi.data.reader.Delimiter;
import edu.pitt.dbmi.data.reader.tabular.ContinuousTabularDatasetFileReader;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class GdistanceTest {
    public static void main(String ... args) {
        int numVars = 16;
        int numEdges = 16;
        ArrayList<Node> vars = new ArrayList<Node>();
        for (int i = 0; i < 16; ++i) {
            vars.add(new ContinuousVariable("X" + i));
        }
        Graph testdag1 = RandomGraph.randomGraphRandomForwardEdges(vars, 0, 16, 30, 15, 15, false, true);
        Graph testdag2 = RandomGraph.randomGraphRandomForwardEdges(vars, 0, 16, 30, 15, 15, false, true);
        String workingDirectory = System.getProperty("user.dir");
        System.out.println(workingDirectory);
        Path mapPath = Paths.get("locationMap.txt", new String[0]);
        System.out.println(mapPath);
        ContinuousTabularDatasetFileReader dataReaderMap = new ContinuousTabularDatasetFileReader(mapPath, Delimiter.COMMA);
        try {
            DataSet locationMap = (DataSet)DataConvertUtils.toDataModel(dataReaderMap.readInData());
            double xdist = 2.4;
            double ydist = 2.4;
            double zdist = 2.0;
            Gdistance gdist = new Gdistance(locationMap, 2.4, 2.4, 2.0);
            List<Double> output = gdist.distances(testdag1, testdag2);
            System.out.println(output);
            PrintWriter writer = new PrintWriter("Gdistances.txt", "UTF-8");
            writer.println(output);
            writer.close();
        }
        catch (Exception IOException2) {
            IOException2.printStackTrace();
        }
    }
}

