/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.simulation;

import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataWriter;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.Fges;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.search.SemBicScore;
import edu.cmu.tetrad.simulation.HsimContinuous;
import edu.cmu.tetrad.simulation.HsimUtils;
import edu.cmu.tetrad.util.DataConvertUtils;
import edu.cmu.tetrad.util.DelimiterUtils;
import edu.cmu.tetrad.util.RandomUtil;
import edu.pitt.dbmi.data.reader.tabular.ContinuousTabularDatasetFileReader;
import java.io.FileWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class HsimAutoC {
    private boolean verbose;
    private DataSet data;
    private boolean write;
    private String filenameOut = "defaultOut";
    private char delimiter = (char)44;

    public HsimAutoC(DataSet indata) {
        this.data = indata;
    }

    public HsimAutoC(String readfilename, char delim) {
        String workingDirectory = System.getProperty("user.dir");
        System.out.println(workingDirectory);
        HashSet<String> eVars = new HashSet<String>();
        eVars.add("MULT");
        Path dataFile = Paths.get(readfilename, new String[0]);
        ContinuousTabularDatasetFileReader dataReader = new ContinuousTabularDatasetFileReader(dataFile, DelimiterUtils.toDelimiter(delim));
        try {
            this.data = (DataSet)DataConvertUtils.toDataModel(dataReader.readInData());
        }
        catch (Exception IOException2) {
            IOException2.printStackTrace();
        }
    }

    public double[] run(int resimSize) {
        double[] output = new double[5];
        CovarianceMatrix cov = new CovarianceMatrix(this.data);
        SemBicScore score = new SemBicScore(cov);
        score.setPenaltyDiscount(2.0);
        Fges fges = new Fges(score);
        fges.setVerbose(false);
        Graph estGraph = fges.search();
        Graph estGraphDAG = SearchGraphUtils.dagFromCPDAG(estGraph);
        Dag estDAG = new Dag(estGraphDAG);
        List<Node> remainingNodes = estGraph.getNodes();
        int randIndex = RandomUtil.getInstance().nextInt(remainingNodes.size());
        Node randomnode = remainingNodes.get(randIndex);
        if (this.verbose) {
            System.out.println("the first node is " + randomnode);
        }
        ArrayList<Node> queue = new ArrayList<Node>();
        queue.add(randomnode);
        while (queue.size() < resimSize) {
            remainingNodes.remove(randIndex);
            randIndex = RandomUtil.getInstance().nextInt(remainingNodes.size());
            randomnode = remainingNodes.get(randIndex);
            queue.add(randomnode);
        }
        HashSet<Node> simnodes = new HashSet<Node>(queue);
        if (this.verbose) {
            System.out.println("the resimmed nodes are " + simnodes);
        }
        HsimContinuous hsimC = new HsimContinuous(estDAG, simnodes, this.data);
        DataSet newDataSet = hsimC.hybridsimulate();
        if (this.write) {
            try {
                FileWriter fileWriter = new FileWriter(this.filenameOut);
                DataWriter.writeRectangularData(newDataSet, fileWriter, this.delimiter);
                fileWriter.close();
            }
            catch (Exception IOException2) {
                IOException2.printStackTrace();
            }
        }
        CovarianceMatrix newcov = new CovarianceMatrix(this.data);
        SemBicScore newscore = new SemBicScore(newcov);
        newscore.setPenaltyDiscount(2.0);
        Fges fgesOut = new Fges(newscore);
        fgesOut.setVerbose(false);
        Graph estGraphOut = fgesOut.search();
        estGraphOut = GraphUtils.replaceNodes(estGraphOut, estDAG.getNodes());
        Set<Node> allParents = HsimUtils.getAllParents(estGraphOut, simnodes);
        Set<Node> addParents = HsimUtils.getAllParents(estDAG, simnodes);
        allParents.addAll(addParents);
        Graph estEvalGraphOut = HsimUtils.evalEdges(estGraphOut, simnodes, allParents);
        Graph estEvalGraph = HsimUtils.evalEdges(estDAG, simnodes, allParents);
        estEvalGraphOut = GraphUtils.replaceNodes(estEvalGraphOut, estEvalGraph.getNodes());
        output = HsimUtils.errorEval(estEvalGraphOut, estEvalGraph);
        if (this.verbose) {
            System.out.println(output[0] + " " + output[1] + " " + output[2] + " " + output[3] + " " + output[4]);
        }
        return output;
    }

    public void setVerbose(boolean verbosity) {
        this.verbose = verbosity;
    }

    public void setWrite(boolean setwrite) {
        this.write = setwrite;
    }

    public void setFilenameOut(String filename) {
        this.filenameOut = filename;
    }

    public void setDelimiter(char delim) {
        this.delimiter = delim;
    }
}

