/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.simulation;

import edu.cmu.tetrad.data.BoxDataSet;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataWriter;
import edu.cmu.tetrad.data.VerticalIntDataBox;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.BDeuScore;
import edu.cmu.tetrad.search.Fges;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.simulation.Hsim;
import edu.cmu.tetrad.simulation.HsimUtils;
import edu.cmu.tetrad.util.DataConvertUtils;
import edu.cmu.tetrad.util.DelimiterUtils;
import edu.cmu.tetrad.util.RandomUtil;
import edu.pitt.dbmi.data.reader.tabular.VerticalDiscreteTabularDatasetFileReader;
import java.io.FileWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class HsimAutoRun {
    private boolean verbose;
    private DataSet data;
    private boolean write;
    private String filenameOut = "defaultOut";
    private char delimiter = (char)44;

    public HsimAutoRun(DataSet indata) {
        if (((BoxDataSet)indata).getDataBox() instanceof VerticalIntDataBox) {
            this.data = indata;
        } else {
            VerticalIntDataBox dataVertBox = HsimUtils.makeVertIntBox(indata);
            this.data = new BoxDataSet(dataVertBox, indata.getVariables());
        }
    }

    public HsimAutoRun(String readfilename, char delim) {
        String workingDirectory = System.getProperty("user.dir");
        System.out.println(workingDirectory);
        HashSet<String> eVars = new HashSet<String>();
        eVars.add("MULT");
        Path dataFile = Paths.get(readfilename, new String[0]);
        VerticalDiscreteTabularDatasetFileReader dataReader = new VerticalDiscreteTabularDatasetFileReader(dataFile, DelimiterUtils.toDelimiter(delim));
        try {
            this.data = (DataSet)DataConvertUtils.toDataModel(dataReader.readInData(eVars));
        }
        catch (Exception IOException2) {
            IOException2.printStackTrace();
        }
    }

    public double[] run(int resimSize) {
        HashSet<String> eVars = new HashSet<String>();
        eVars.add("MULT");
        double[] output = new double[5];
        try {
            BDeuScore score = new BDeuScore(this.data);
            double penaltyDiscount = 2.0;
            Fges fges = new Fges(score);
            fges.setVerbose(false);
            Graph estGraph = fges.search();
            EdgeListGraph estCPDAG = new EdgeListGraph(estGraph);
            Graph estGraphDAG = SearchGraphUtils.dagFromCPDAG(estCPDAG);
            Dag estDAG = new Dag(estGraphDAG);
            List<Node> allNodes = estGraph.getNodes();
            int size = allNodes.size();
            int randIndex = RandomUtil.getInstance().nextInt(size);
            Node centroid = allNodes.get(randIndex);
            if (this.verbose) {
                System.out.println("the centroid is " + centroid);
            }
            ArrayList<Object> queue = new ArrayList<Object>();
            queue.add(centroid);
            List<Object> queueAdd = new ArrayList();
            block2: while (queue.size() < resimSize) {
                int qsize = queue.size();
                for (int i = 0; i < qsize; ++i) {
                    queueAdd = estGraph.getAdjacentNodes((Node)queue.get(i));
                    queueAdd.removeAll(queue);
                    while (queueAdd.size() < 1) {
                        queueAdd.add(allNodes.get(RandomUtil.getInstance().nextInt(size)));
                    }
                    queue.addAll(queueAdd);
                    if (queue.size() >= resimSize) continue block2;
                }
            }
            while (queue.size() > resimSize) {
                queue.remove(queue.size() - 1);
            }
            HashSet<Node> simnodes = new HashSet<Node>(queue);
            if (this.verbose) {
                System.out.println("the resimmed nodes are " + simnodes);
            }
            Hsim hsim = new Hsim(estDAG, simnodes, this.data);
            DataSet newDataSet = hsim.hybridsimulate();
            if (this.write) {
                FileWriter fileWriter = new FileWriter(this.filenameOut);
                DataWriter.writeRectangularData(newDataSet, fileWriter, this.delimiter);
                fileWriter.close();
            }
            BDeuScore newscore = new BDeuScore(newDataSet);
            Fges fgesOut = new Fges(newscore);
            fgesOut.setVerbose(false);
            Graph estGraphOut = fgesOut.search();
            estGraphOut = GraphUtils.replaceNodes(estGraphOut, estDAG.getNodes());
            Set<Node> allParents = HsimUtils.getAllParents(estGraphOut, simnodes);
            Set<Node> addParents = HsimUtils.getAllParents(estDAG, simnodes);
            allParents.addAll(addParents);
            Graph estEvalGraphOut = HsimUtils.evalEdges(estGraphOut, simnodes, allParents);
            Graph estEvalGraph = HsimUtils.evalEdges(estDAG, simnodes, allParents);
            estEvalGraphOut = GraphUtils.replaceNodes(estEvalGraphOut, estEvalGraph.getNodes());
            output = HsimUtils.errorEval(estEvalGraphOut, estEvalGraph);
            if (this.verbose) {
                System.out.println(output[0] + " " + output[1] + " " + output[2] + " " + output[3] + " " + output[4]);
            }
        }
        catch (Exception IOException2) {
            IOException2.printStackTrace();
        }
        return output;
    }

    public void setVerbose(boolean verbosity) {
        this.verbose = verbosity;
    }

    public void setWrite(boolean setwrite) {
        this.write = setwrite;
    }

    public void setFilenameOut(String filename) {
        this.filenameOut = filename;
    }

    public void setDelimiter(char delim) {
        this.delimiter = delim;
    }
}

