/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.simulation;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.sem.SemEstimator;
import edu.cmu.tetrad.sem.SemEvidence;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetrad.sem.SemUpdater;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class HsimContinuous {
    private boolean verbose;
    private Dag mydag;
    private Set<Node> simnodes;
    private DataSet data;

    public HsimContinuous(Dag thedag, Set<Node> thesimnodes, DataSet thedata) {
        if (thedata.isDiscrete()) {
            throw new IllegalArgumentException("HsimContinuous only accepts continuous data.");
        }
        if (thedag == null) {
            throw new IllegalArgumentException("Hsim needs a Dag.");
        }
        if (thesimnodes == null) {
            throw new IllegalArgumentException("Please specify the nodes Hsim will resimulate.");
        }
        this.setVerbose();
        this.setDag(thedag);
        this.setData(thedata);
        this.setSimnodes(thesimnodes);
    }

    public DataSet hybridsimulate() {
        if (this.verbose) {
            System.out.println("Finding a Markov blanket for resimulated nodes");
        }
        HashSet mbAll = new HashSet();
        Set<Object> mbAdd = new HashSet();
        for (Node node : this.simnodes) {
            mbAdd = HsimContinuous.mb(this.mydag, node);
            mbAll.addAll(mbAdd);
        }
        mbAll.addAll(this.simnodes);
        if (this.verbose) {
            System.out.println("The Markov Blanket is " + mbAll);
        }
        if (this.verbose) {
            System.out.println("Finding a subgraph over the Markov Blanket and Resimulated Nodes");
        }
        ArrayList<Node> mbListAll = new ArrayList<Node>(mbAll);
        Graph subgraph = this.mydag.subgraph(mbListAll);
        if (this.verbose) {
            System.out.println("Learning an instantiated model for the subgraph");
        }
        SemPm subgraphPM = new SemPm(subgraph);
        SemEstimator subgraphEstimator = new SemEstimator(this.data, subgraphPM);
        SemIm subgraphIM = subgraphEstimator.estimate();
        if (this.verbose) {
            System.out.println("Starting resimulation loop");
        }
        for (int row = 0; row < this.data.getNumRows(); ++row) {
            SemEvidence evidence = new SemEvidence(subgraphIM);
            for (Node node : this.simnodes) {
                mbAll.remove(node);
            }
            for (Node i : mbAll) {
                int nodeColumn = this.data.getColumn(i);
                evidence.getProposition().setValue(i, this.data.getDouble(row, nodeColumn));
            }
            SemUpdater conditionUpdate = new SemUpdater(subgraphIM);
            conditionUpdate.setEvidence(evidence);
            SemIm updatedIM = conditionUpdate.getUpdatedSemIm();
            DataSet newValues = updatedIM.simulateData(1, false);
            for (Node node : this.simnodes) {
                this.data.setDouble(row, this.data.getColumn(node), newValues.getDouble(0, newValues.getColumn(node)));
            }
        }
        return this.data;
    }

    private static Set<Node> mb(Graph graph, Node z) {
        HashSet<Node> mb = new HashSet<Node>(graph.getAdjacentNodes(z));
        for (Node c : graph.getChildren(z)) {
            for (Node p : graph.getParents(c)) {
                if (p == z) continue;
                mb.add(p);
            }
        }
        return mb;
    }

    private void setVerbose() {
        this.verbose = false;
    }

    private void setDag(Dag thedag) {
        this.mydag = thedag;
    }

    private void setSimnodes(Set<Node> thenodes) {
        this.simnodes = thenodes;
    }

    private void setData(DataSet thedata) {
        this.data = thedata;
    }
}

