/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.simulation;

import edu.cmu.tetrad.data.BoxDataSet;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.VerticalIntDataBox;
import edu.cmu.tetrad.simulation.HsimAutoRun;
import edu.cmu.tetrad.simulation.HsimUtils;
import edu.cmu.tetrad.util.DataConvertUtils;
import edu.cmu.tetrad.util.DelimiterUtils;
import edu.pitt.dbmi.data.reader.tabular.VerticalDiscreteTabularDatasetFileReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;

public class HsimRepeatAutoRun {
    private boolean verbose;
    private DataSet data;
    private boolean write;
    private String filenameOut = "defaultOut";
    private char delimiter = (char)44;

    public HsimRepeatAutoRun(DataSet indata) {
        if (((BoxDataSet)indata).getDataBox() instanceof VerticalIntDataBox) {
            this.data = indata;
        } else {
            VerticalIntDataBox dataVertBox = HsimUtils.makeVertIntBox(indata);
            this.data = new BoxDataSet(dataVertBox, indata.getVariables());
        }
    }

    public HsimRepeatAutoRun(String readfilename, char delim) {
        String workingDirectory = System.getProperty("user.dir");
        System.out.println(workingDirectory);
        HashSet<String> eVars = new HashSet<String>();
        eVars.add("MULT");
        Path dataFile = Paths.get(readfilename, new String[0]);
        VerticalDiscreteTabularDatasetFileReader dataReader = new VerticalDiscreteTabularDatasetFileReader(dataFile, DelimiterUtils.toDelimiter(delim));
        try {
            this.data = (DataSet)DataConvertUtils.toDataModel(dataReader.readInData(eVars));
        }
        catch (Exception IOException2) {
            IOException2.printStackTrace();
        }
    }

    public double[] run(int resimSize, int repeat) {
        ArrayList<Integer> schedule = new ArrayList<Integer>();
        for (int i = 0; i < repeat; ++i) {
            schedule.add(resimSize);
        }
        double[] evalTotal = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
        Integer count0 = 1;
        Integer count1 = 1;
        Integer count2 = 1;
        Integer count3 = 1;
        Integer count4 = 1;
        for (Integer i : schedule) {
            Integer n;
            double[] evalIncrement;
            HsimAutoRun study = new HsimAutoRun(this.data);
            if (this.write) {
                study.setWrite(true);
                study.setFilenameOut(this.filenameOut);
                study.setDelimiter(this.delimiter);
            }
            if (this.verbose) {
                study.setVerbose(false);
            }
            if (!Double.isNaN((evalIncrement = study.run(i))[0])) {
                evalTotal[0] = evalTotal[0] + evalIncrement[0];
                n = count0;
                count0 = count0 + 1;
            }
            if (!Double.isNaN(evalIncrement[1])) {
                evalTotal[1] = evalTotal[1] + evalIncrement[1];
                n = count1;
                count1 = count1 + 1;
            }
            if (!Double.isNaN(evalIncrement[2])) {
                evalTotal[2] = evalTotal[2] + evalIncrement[2];
                n = count2;
                count2 = count2 + 1;
            }
            if (!Double.isNaN(evalIncrement[3])) {
                evalTotal[3] = evalTotal[3] + evalIncrement[3];
                n = count3;
                count3 = count3 + 1;
            }
            if (Double.isNaN(evalIncrement[4])) continue;
            evalTotal[4] = evalTotal[4] + evalIncrement[4];
            n = count4;
            count4 = count4 + 1;
        }
        evalTotal[0] = evalTotal[0] / (double)(count0 - 1);
        evalTotal[1] = evalTotal[1] / (double)(count1 - 1);
        evalTotal[2] = evalTotal[2] / (double)(count2 - 1);
        evalTotal[3] = evalTotal[3] / (double)(count3 - 1);
        evalTotal[4] = evalTotal[4] / (double)(count4 - 1);
        if (this.verbose) {
            System.out.println("Average eval scores: " + evalTotal[0] + " " + evalTotal[1] + " " + evalTotal[2] + " " + evalTotal[3] + " " + evalTotal[4]);
        }
        return evalTotal;
    }

    public void setVerbose(boolean verbosity) {
        this.verbose = verbosity;
    }

    public void setWrite(boolean setwrite) {
        this.write = setwrite;
    }

    public void setFilenameOut(String filename) {
        this.filenameOut = filename;
    }

    public void setDelimiter(char delim) {
        this.delimiter = delim;
    }
}

