/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.simulation;

import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.VerticalIntDataBox;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.RandomGraph;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.util.TextTable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class HsimUtils {
    public static Graph evalEdges(Graph inputgraph, Set<Node> simnodes, Set<Node> realnodes) {
        HashSet<Node> aNodes = new HashSet<Node>();
        aNodes.addAll(simnodes);
        aNodes.addAll(realnodes);
        ArrayList<Node> relevantNodes = new ArrayList<Node>(aNodes);
        Graph subgraph = inputgraph.subgraph(relevantNodes);
        Set<Edge> edges = subgraph.getEdges();
        for (Edge edge : edges) {
            if (!realnodes.contains(edge.getNode1()) || !realnodes.contains(edge.getNode2())) continue;
            subgraph.removeEdge(edge);
        }
        return subgraph;
    }

    public static Set<Node> getAllParents(Graph inputgraph, Set<Node> inputnodes) {
        ArrayList parents = new ArrayList();
        List<Object> pAdd = new ArrayList();
        for (Node node : inputnodes) {
            pAdd = inputgraph.getParents(node);
            parents.addAll(pAdd);
        }
        parents.removeAll(inputnodes);
        return new HashSet<Node>(parents);
    }

    public static double[] errorEval(Graph estCPDAG, Graph truePattern) {
        GraphUtils.GraphComparison comparison = SearchGraphUtils.getGraphComparison2(estCPDAG, truePattern);
        int adjTp = comparison.getAdjCor();
        int adjFp = comparison.getAdjFp();
        int adjFn = comparison.getAdjFn();
        int arrowptTp = comparison.getAhdCor();
        int arrowptFp = comparison.getAhdFp();
        int arrowptFn = comparison.getAhdFn();
        estCPDAG = GraphUtils.replaceNodes(estCPDAG, truePattern.getNodes());
        int[][] counts = GraphUtils.edgeMisclassificationCounts(truePattern, estCPDAG, false);
        double edgeRatio = HsimUtils.correctnessRatio(counts);
        double adjRecall = (double)adjTp / (double)(adjTp + adjFn);
        double adjPrecision = (double)adjTp / (double)(adjTp + adjFp);
        double arrowRecall = (double)arrowptTp / (double)(arrowptTp + arrowptFn);
        double arrowPrecision = (double)arrowptTp / (double)(arrowptTp + arrowptFp);
        double[] output = new double[]{edgeRatio, adjRecall, adjPrecision, arrowRecall, arrowPrecision};
        return output;
    }

    public static double correctnessRatio(int[][] counts) {
        TextTable table2 = new TextTable(9, 7);
        table2.setToken(1, 0, "---");
        table2.setToken(2, 0, "o-o");
        table2.setToken(3, 0, "o->");
        table2.setToken(4, 0, "&lt;-o");
        table2.setToken(5, 0, "-->");
        table2.setToken(6, 0, "&lt;--");
        table2.setToken(7, 0, "&lt;->");
        table2.setToken(8, 0, "No Edge");
        table2.setToken(0, 1, "---");
        table2.setToken(0, 2, "o-o");
        table2.setToken(0, 3, "o->");
        table2.setToken(0, 4, "-->");
        table2.setToken(0, 5, "&lt;->");
        table2.setToken(0, 6, "No Edge");
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 6; ++j) {
                if (i == 7 && j == 5) {
                    table2.setToken(8, 6, "*");
                    continue;
                }
                table2.setToken(i + 1, j + 1, "" + counts[i][j]);
            }
        }
        int correctEdges = 0;
        int estimatedEdges = 0;
        for (int i = 0; i < counts.length; ++i) {
            for (int j = 0; j < counts[0].length - 1; ++j) {
                if (i == 0 && j == 0 || i == 1 && j == 1 || i == 2 && j == 2 || i == 4 && j == 3 || i == 6 && j == 4) {
                    correctEdges += counts[i][j];
                }
                estimatedEdges += counts[i][j];
            }
        }
        return (double)correctEdges / (double)estimatedEdges;
    }

    public static VerticalIntDataBox makeVertIntBox(DataSet dataset) {
        int[][] data = new int[dataset.getNumColumns()][dataset.getNumRows()];
        for (int i = 0; i < dataset.getNumRows(); ++i) {
            for (int j = 0; j < dataset.getNumColumns(); ++j) {
                data[j][i] = dataset.getInt(i, j);
            }
        }
        return new VerticalIntDataBox(data);
    }

    public static String makeLatexTable(String[][] tablevalues) {
        String nl = System.lineSeparator();
        String output = "\\begin{table}[ht]" + nl;
        output = output + "\\begin{center}" + nl;
        int dim1 = tablevalues.length;
        int dim2 = tablevalues[0].length;
        output = output + "\\begin{tabular}{|";
        for (int c = 0; c < dim2; ++c) {
            output = output + "c|";
        }
        output = output + "}" + nl + "\\hline" + nl;
        for (String[] tablevalue : tablevalues) {
            for (int j = 0; j < dim2; ++j) {
                output = output + tablevalue[j];
                if (dim2 <= 1 || j == dim2 - 1) continue;
                output = output + " & ";
            }
            output = output + "\\\\ \\hline" + nl;
        }
        output = output + "\\end{tabular}" + nl + "\\end{center}" + nl + "\\end{table}" + nl;
        return output;
    }

    public static String[] formatErrorsArray(double[] inputArray, String formatting) {
        String[] output = new String[inputArray.length];
        for (int i = 0; i < inputArray.length; ++i) {
            output[i] = String.format(formatting, inputArray[i]);
        }
        return output;
    }

    public static Graph mkRandSEMDAG(int numVars, int numEdges) {
        ArrayList<Node> varslist = new ArrayList<Node>();
        for (int i = 0; i < numVars; ++i) {
            varslist.add(new ContinuousVariable("X" + i));
        }
        return RandomGraph.randomGraphRandomForwardEdges(varslist, 0, numEdges, 30, 15, 15, false, true);
    }
}

