/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.simulation;

import java.lang.reflect.Array;
import java.util.List;

public final class PRAOerrors {
    private double AdjRecall;
    private double AdjPrecision;
    private double OrientPrecision;
    private double OrientRecall;
    private String errorsName;

    public PRAOerrors(double[] input, String thename) {
        if (Array.getLength(input) == 5) {
            this.AdjRecall = input[1];
            this.AdjPrecision = input[2];
            this.OrientRecall = input[3];
            this.OrientPrecision = input[4];
            this.errorsName = thename;
        }
        if (Array.getLength(input) == 4) {
            this.AdjRecall = input[0];
            this.AdjPrecision = input[1];
            this.OrientRecall = input[2];
            this.OrientPrecision = input[3];
            this.errorsName = thename;
        }
        if (Array.getLength(input) != 4 && Array.getLength(input) != 5) {
            throw new IllegalArgumentException("Input array not of length 4 or 5");
        }
    }

    public PRAOerrors(List<PRAOerrors> input, String thename) {
        double totalAR = 0.0;
        double totalAP = 0.0;
        double totalOR = 0.0;
        double totalOP = 0.0;
        int countAR = 0;
        int countAP = 0;
        int countOR = 0;
        int countOP = 0;
        for (PRAOerrors errors : input) {
            if (!Double.isNaN(errors.getAdjRecall())) {
                totalAR += errors.getAdjRecall();
                ++countAR;
            }
            if (!Double.isNaN(errors.getAdjPrecision())) {
                totalAP += errors.getAdjPrecision();
                ++countAP;
            }
            if (!Double.isNaN(errors.getOrientRecall())) {
                totalOR += errors.getOrientRecall();
                ++countOR;
            }
            if (Double.isNaN(errors.getOrientPrecision())) continue;
            totalOP += errors.getOrientPrecision();
            ++countOP;
        }
        this.AdjRecall = totalAR / (double)countAR;
        this.AdjPrecision = totalAP / (double)countAP;
        this.OrientRecall = totalOR / (double)countOR;
        this.OrientPrecision = totalOP / (double)countOP;
        this.errorsName = thename;
    }

    public String getName() {
        return this.errorsName;
    }

    public double getAdjRecall() {
        return this.AdjRecall;
    }

    public double getAdjPrecision() {
        return this.AdjPrecision;
    }

    public double getOrientRecall() {
        return this.OrientRecall;
    }

    public double getOrientPrecision() {
        return this.OrientPrecision;
    }

    public String valuesToString() {
        return "AR: " + this.AdjRecall + " AP: " + this.AdjPrecision + " OR: " + this.OrientRecall + " OP: " + this.OrientPrecision;
    }

    public String allToString() {
        String nl = System.lineSeparator();
        return this.errorsName + nl + "AR: " + this.AdjRecall + " AP: " + this.AdjPrecision + " OR: " + this.OrientRecall + " OP: " + this.OrientPrecision;
    }

    public double[] toArray() {
        double[] output = new double[]{this.AdjRecall, this.AdjPrecision, this.OrientRecall, this.OrientPrecision};
        return output;
    }
}

