/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.stat;

import edu.cmu.tetrad.stat.RealVariance;

public class RealVarianceVector
implements RealVariance {
    private final double[][] data;
    private final int numOfRows;
    private final int numOfCols;

    public RealVarianceVector(double[][] data) {
        this.data = data;
        this.numOfRows = data.length;
        this.numOfCols = data[0].length;
    }

    private double[] computeMeans() {
        double[] mean = new double[this.numOfCols];
        for (int col = 0; col < this.numOfCols; ++col) {
            double sum = 0.0;
            for (int row = 0; row < this.numOfRows; ++row) {
                sum += this.data[row][col];
            }
            mean[col] = sum / (double)this.numOfRows;
        }
        return mean;
    }

    @Override
    public double[] compute(boolean biasCorrected) {
        double[] meanVariance = this.computeMeans();
        for (int col = 0; col < this.numOfCols; ++col) {
            double mean = meanVariance[col];
            double value = 0.0;
            double squareValue = 0.0;
            for (int row = 0; row < this.numOfRows; ++row) {
                double val = this.data[row][col] - mean;
                squareValue += val * val;
                value += val;
            }
            meanVariance[col] = biasCorrected ? (squareValue - value * value / (double)this.numOfRows) / (double)((float)this.numOfRows - 1.0f) : (squareValue - value * value / (double)this.numOfRows) / (double)this.numOfRows;
        }
        return meanVariance;
    }
}

