/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.stat;

import edu.cmu.tetrad.stat.Variance;

public class VarianceVector
implements Variance {
    private final float[][] data;
    private final int numOfRows;
    private final int numOfCols;

    public VarianceVector(float[][] data) {
        this.data = data;
        this.numOfRows = data.length;
        this.numOfCols = data[0].length;
    }

    private float[] computeMeans() {
        float[] mean = new float[this.numOfCols];
        for (int col = 0; col < this.numOfCols; ++col) {
            float sum = 0.0f;
            for (int row = 0; row < this.numOfRows; ++row) {
                sum += this.data[row][col];
            }
            mean[col] = sum / (float)this.numOfRows;
        }
        return mean;
    }

    @Override
    public float[] compute(boolean biasCorrected) {
        float[] meanVariance = this.computeMeans();
        for (int col = 0; col < this.numOfCols; ++col) {
            float mean = meanVariance[col];
            float value = 0.0f;
            float squareValue = 0.0f;
            for (int row = 0; row < this.numOfRows; ++row) {
                float val = this.data[row][col] - mean;
                squareValue += val * val;
                value += val;
            }
            meanVariance[col] = biasCorrected ? (squareValue - value * value / (float)this.numOfRows) / ((float)this.numOfRows - 1.0f) : (squareValue - value * value / (float)this.numOfRows) / (float)this.numOfRows;
        }
        return meanVariance;
    }
}

