/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.stat.correlation;

import edu.cmu.tetrad.stat.correlation.Covariance;

public class CovarianceMatrix
implements Covariance {
    private final float[][] data;
    private final int numOfRows;
    private final int numOfCols;

    public CovarianceMatrix(float[][] data) {
        this.data = data;
        this.numOfRows = data.length;
        this.numOfCols = data[0].length;
    }

    private float[] computeMeans() {
        float[] mean = new float[this.numOfCols];
        for (int col = 0; col < this.numOfCols; ++col) {
            float sum = 0.0f;
            for (int row = 0; row < this.numOfRows; ++row) {
                sum += this.data[row][col];
            }
            mean[col] = sum / (float)this.numOfRows;
        }
        return mean;
    }

    @Override
    public float[] computeLowerTriangle(boolean biasCorrected) {
        float[] covarianceMatrix = new float[this.numOfCols * (this.numOfCols + 1) / 2];
        float[] mean = this.computeMeans();
        int index = 0;
        for (int col = 0; col < this.numOfCols; ++col) {
            for (int col2 = 0; col2 < col; ++col2) {
                float variance = 0.0f;
                for (int row = 0; row < this.numOfRows; ++row) {
                    variance += ((this.data[row][col] - mean[col]) * (this.data[row][col2] - mean[col2]) - variance) / (float)(row + 1);
                }
                covarianceMatrix[index++] = biasCorrected ? variance * ((float)this.numOfRows / (float)(this.numOfRows - 1)) : variance;
            }
            float variance = 0.0f;
            for (int row = 0; row < this.numOfRows; ++row) {
                variance += ((this.data[row][col] - mean[col]) * (this.data[row][col] - mean[col]) - variance) / (float)(row + 1);
            }
            covarianceMatrix[index++] = biasCorrected ? variance * ((float)this.numOfRows / (float)(this.numOfRows - 1)) : variance;
        }
        return covarianceMatrix;
    }

    @Override
    public float[][] compute(boolean biasCorrected) {
        float[][] covarianceMatrix = new float[this.numOfCols][this.numOfCols];
        float[] mean = this.computeMeans();
        for (int col = 0; col < this.numOfCols; ++col) {
            for (int col2 = 0; col2 < col; ++col2) {
                float variance = 0.0f;
                for (int row = 0; row < this.numOfRows; ++row) {
                    variance += ((this.data[row][col] - mean[col]) * (this.data[row][col2] - mean[col2]) - variance) / (float)(row + 1);
                }
                covarianceMatrix[col][col2] = variance = biasCorrected ? variance * ((float)this.numOfRows / (float)(this.numOfRows - 1)) : variance;
                covarianceMatrix[col2][col] = variance;
            }
            float variance = 0.0f;
            for (int row = 0; row < this.numOfRows; ++row) {
                variance += ((this.data[row][col] - mean[col]) * (this.data[row][col] - mean[col]) - variance) / (float)(row + 1);
            }
            covarianceMatrix[col][col] = biasCorrected ? variance * ((float)this.numOfRows / (float)(this.numOfRows - 1)) : variance;
        }
        return covarianceMatrix;
    }
}

