/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.study;

import edu.cmu.tetrad.algcomparison.Comparison;
import edu.cmu.tetrad.algcomparison.algorithm.Algorithms;
import edu.cmu.tetrad.algcomparison.algorithm.oracle.pag.GFCI;
import edu.cmu.tetrad.algcomparison.graph.SingleGraph;
import edu.cmu.tetrad.algcomparison.independence.FisherZ;
import edu.cmu.tetrad.algcomparison.score.SemBicScore;
import edu.cmu.tetrad.algcomparison.simulation.SemSimulation;
import edu.cmu.tetrad.algcomparison.simulation.Simulations;
import edu.cmu.tetrad.algcomparison.statistic.AdjacencyPrecision;
import edu.cmu.tetrad.algcomparison.statistic.AdjacencyRecall;
import edu.cmu.tetrad.algcomparison.statistic.ArrowheadPrecision;
import edu.cmu.tetrad.algcomparison.statistic.ArrowheadRecall;
import edu.cmu.tetrad.algcomparison.statistic.ElapsedCpuTime;
import edu.cmu.tetrad.algcomparison.statistic.F1All;
import edu.cmu.tetrad.algcomparison.statistic.GraphExactlyRight;
import edu.cmu.tetrad.algcomparison.statistic.ParameterColumn;
import edu.cmu.tetrad.algcomparison.statistic.Statistics;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.util.Parameters;

public class BryanSensitivityStudy {
    public static void main(String ... args) {
        Statistics statistics = new Statistics();
        statistics.add(new ParameterColumn("sampleSize"));
        statistics.add(new ParameterColumn("penaltyDiscount"));
        statistics.add(new ParameterColumn("alpha"));
        statistics.add(new ParameterColumn("thresholdAlpha"));
        statistics.add(new AdjacencyPrecision());
        statistics.add(new AdjacencyRecall());
        statistics.add(new ArrowheadPrecision());
        statistics.add(new ArrowheadRecall());
        statistics.add(new F1All());
        statistics.add(new GraphExactlyRight());
        statistics.add(new ElapsedCpuTime());
        statistics.setWeight("AP", 1.0);
        statistics.setWeight("AR", 1.0);
        statistics.setWeight("AHP", 1.0);
        statistics.setWeight("AHR", 1.0);
        Algorithms algorithms = new Algorithms();
        algorithms.add(new GFCI(new FisherZ(), new SemBicScore()));
        Comparison comparison = new Comparison();
        comparison.setShowAlgorithmIndices(true);
        comparison.setShowSimulationIndices(true);
        comparison.setSortByUtility(false);
        comparison.setShowUtilities(false);
        comparison.setComparisonGraph(Comparison.ComparisonGraph.PAG_of_the_true_DAG);
        Parameters parameters = BryanSensitivityStudy.getParameters();
        Graph graph = BryanSensitivityStudy.getGraph1();
        Simulations simulations = new Simulations();
        simulations.add(new SemSimulation(new SingleGraph(graph)));
        comparison.compareFromSimulations("bryan.simulation", simulations, "graph1.txt", algorithms, statistics, parameters);
        parameters = BryanSensitivityStudy.getParameters();
        graph = BryanSensitivityStudy.getGraph2();
        simulations = new Simulations();
        simulations.add(new SemSimulation(new SingleGraph(graph)));
        comparison.compareFromSimulations("bryan.simulation", simulations, "graph2.txt", algorithms, statistics, parameters);
        parameters = BryanSensitivityStudy.getParameters();
        graph = BryanSensitivityStudy.getGraph3();
        simulations = new Simulations();
        simulations.add(new SemSimulation(new SingleGraph(graph)));
        comparison.compareFromSimulations("bryan.simulation", simulations, "graph3.txt", algorithms, statistics, parameters);
        parameters = BryanSensitivityStudy.getParameters();
        graph = BryanSensitivityStudy.getGraph4();
        simulations = new Simulations();
        simulations.add(new SemSimulation(new SingleGraph(graph)));
        comparison.compareFromSimulations("bryan.simulation", simulations, "graph4.txt", algorithms, statistics, parameters);
    }

    private static Parameters getParameters() {
        Parameters parameters = new Parameters();
        parameters.set("thresholdAlpha", (Object)0.5);
        parameters.set("numRuns", (Object)20);
        parameters.set("sampleSize", 500, 1000, 5000, 10000, 50000);
        parameters.set("coefLow", (Object)0.2);
        parameters.set("coefHigh", (Object)0.7);
        parameters.set("varLow", (Object)1);
        parameters.set("varHigh", (Object)3);
        parameters.set("verbose", (Object)false);
        parameters.set("coefSymmetric", (Object)true);
        parameters.set("randomizeColumns", (Object)true);
        parameters.set("depth", (Object)-1);
        parameters.set("symmetricFirstStep", (Object)false);
        parameters.set("faithfulnessAssumed", (Object)false);
        parameters.set("verbose", (Object)false);
        parameters.set("symmetricFirstStep", (Object)false);
        parameters.set("faithfulnessAssumed", (Object)true);
        parameters.set("maxDegree", (Object)100);
        parameters.set("maxIndegree", (Object)100);
        parameters.set("maxOutdegree", (Object)100);
        parameters.set("penaltyDiscount", (Object)1.0);
        parameters.set("structurePrior", (Object)3);
        parameters.set("alpha", 0.001, 0.01);
        parameters.set("stableFAS", (Object)true);
        parameters.set("concurrentFAS", (Object)true);
        parameters.set("colliderDiscoveryRule", 2, 3);
        return parameters;
    }

    private static Graph getGraph1() {
        GraphNode A = new GraphNode("A");
        GraphNode B = new GraphNode("B");
        GraphNode C = new GraphNode("C");
        GraphNode D = new GraphNode("D");
        GraphNode H1 = new GraphNode("H1");
        H1.setNodeType(NodeType.LATENT);
        EdgeListGraph graph = new EdgeListGraph();
        graph.addNode(A);
        graph.addNode(B);
        graph.addNode(C);
        graph.addNode(D);
        graph.addNode(H1);
        graph.addDirectedEdge(A, C);
        graph.addDirectedEdge(B, D);
        graph.addDirectedEdge(H1, C);
        graph.addDirectedEdge(H1, D);
        return graph;
    }

    private static Graph getGraph2() {
        GraphNode A = new GraphNode("A");
        GraphNode B = new GraphNode("B");
        GraphNode C = new GraphNode("C");
        GraphNode D = new GraphNode("D");
        GraphNode H1 = new GraphNode("H1");
        H1.setNodeType(NodeType.LATENT);
        GraphNode H2 = new GraphNode("H2");
        H2.setNodeType(NodeType.LATENT);
        EdgeListGraph graph = new EdgeListGraph();
        graph.addNode(A);
        graph.addNode(B);
        graph.addNode(C);
        graph.addNode(D);
        graph.addNode(H1);
        graph.addNode(H2);
        graph.addDirectedEdge(A, B);
        graph.addDirectedEdge(C, D);
        graph.addDirectedEdge(H1, A);
        graph.addDirectedEdge(H1, D);
        graph.addDirectedEdge(H2, B);
        graph.addDirectedEdge(H2, C);
        return graph;
    }

    private static Graph getGraph3() {
        GraphNode A = new GraphNode("A");
        GraphNode B = new GraphNode("B");
        GraphNode C = new GraphNode("C");
        GraphNode D = new GraphNode("D");
        GraphNode H1 = new GraphNode("H1");
        H1.setNodeType(NodeType.LATENT);
        GraphNode H2 = new GraphNode("H2");
        H2.setNodeType(NodeType.LATENT);
        GraphNode H3 = new GraphNode("H3");
        H3.setNodeType(NodeType.LATENT);
        GraphNode H4 = new GraphNode("H4");
        H4.setNodeType(NodeType.LATENT);
        EdgeListGraph graph = new EdgeListGraph();
        graph.addNode(A);
        graph.addNode(B);
        graph.addNode(C);
        graph.addNode(D);
        graph.addNode(H1);
        graph.addNode(H2);
        graph.addNode(H3);
        graph.addNode(H4);
        graph.addDirectedEdge(H1, A);
        graph.addDirectedEdge(H1, C);
        graph.addDirectedEdge(H2, A);
        graph.addDirectedEdge(H2, B);
        graph.addDirectedEdge(H3, B);
        graph.addDirectedEdge(H3, D);
        graph.addDirectedEdge(H4, C);
        graph.addDirectedEdge(H4, D);
        return graph;
    }

    private static Graph getGraph4() {
        GraphNode A = new GraphNode("A");
        GraphNode B = new GraphNode("B");
        GraphNode C = new GraphNode("C");
        GraphNode D = new GraphNode("D");
        GraphNode H1 = new GraphNode("H1");
        H1.setNodeType(NodeType.LATENT);
        GraphNode H2 = new GraphNode("H2");
        H2.setNodeType(NodeType.LATENT);
        EdgeListGraph graph = new EdgeListGraph();
        graph.addNode(A);
        graph.addNode(B);
        graph.addNode(C);
        graph.addNode(D);
        graph.addNode(H1);
        graph.addNode(H2);
        graph.addDirectedEdge(A, B);
        graph.addDirectedEdge(B, D);
        graph.addDirectedEdge(H1, B);
        graph.addDirectedEdge(H1, C);
        graph.addDirectedEdge(H2, C);
        graph.addDirectedEdge(H2, D);
        return graph;
    }
}

