/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.study.Conditions;

import edu.cmu.tetrad.algcomparison.Comparison;
import edu.cmu.tetrad.algcomparison.algorithm.Algorithms;
import edu.cmu.tetrad.algcomparison.algorithm.external.ExternalAlgorithmPcalgGes;
import edu.cmu.tetrad.algcomparison.algorithm.external.ExternalAlgorithmTetrad;
import edu.cmu.tetrad.algcomparison.algorithm.oracle.cpdag.Fges;
import edu.cmu.tetrad.algcomparison.score.SemBicScore;
import edu.cmu.tetrad.algcomparison.statistic.AdjacencyPrecision;
import edu.cmu.tetrad.algcomparison.statistic.AdjacencyRecall;
import edu.cmu.tetrad.algcomparison.statistic.ArrowheadPrecision;
import edu.cmu.tetrad.algcomparison.statistic.ArrowheadRecall;
import edu.cmu.tetrad.algcomparison.statistic.ElapsedCpuTime;
import edu.cmu.tetrad.algcomparison.statistic.F1Adj;
import edu.cmu.tetrad.algcomparison.statistic.F1All;
import edu.cmu.tetrad.algcomparison.statistic.F1Arrow;
import edu.cmu.tetrad.algcomparison.statistic.ParameterColumn;
import edu.cmu.tetrad.algcomparison.statistic.Statistics;
import edu.cmu.tetrad.util.Parameters;

public class Condition1 {
    public void generateTetradResults() {
        Parameters parameters = new Parameters();
        parameters.set("alpha", (Object)0.001);
        parameters.set("numRuns", (Object)10);
        parameters.set("useMaxPOrientationHeuristic", (Object)true);
        parameters.set("maxPOrientationMaxPathLength", (Object)3);
        Statistics statistics = new Statistics();
        statistics.add(new ParameterColumn("numMeasures"));
        statistics.add(new ParameterColumn("avgDegree"));
        statistics.add(new ParameterColumn("sampleSize"));
        statistics.add(new AdjacencyPrecision());
        statistics.add(new AdjacencyRecall());
        statistics.add(new ArrowheadPrecision());
        statistics.add(new ArrowheadRecall());
        statistics.add(new ElapsedCpuTime());
        statistics.setWeight("AP", 1.0);
        statistics.setWeight("AR", 0.5);
        statistics.setWeight("AHP", 1.0);
        statistics.setWeight("AHR", 0.5);
        Algorithms algorithms = new Algorithms();
        Comparison comparison = new Comparison();
        comparison.setShowAlgorithmIndices(true);
        comparison.setShowSimulationIndices(true);
        comparison.setSortByUtility(false);
        comparison.setShowUtilities(true);
        comparison.setSaveGraphs(true);
        parameters.set("penaltyDiscount", (Object)4);
        algorithms.add(new Fges(new SemBicScore()));
        comparison.compareFromFiles("/Users/user/comparison-data/condition_1", "/Users/user/causal-comparisons/condition_1", algorithms, statistics, parameters);
    }

    public void compileTable() {
        Parameters parameters = new Parameters();
        parameters.set("numRuns", (Object)10);
        Statistics statistics = new Statistics();
        statistics.add(new ParameterColumn("numMeasures"));
        statistics.add(new ParameterColumn("avgDegree"));
        statistics.add(new ParameterColumn("sampleSize"));
        statistics.add(new AdjacencyPrecision());
        statistics.add(new AdjacencyRecall());
        statistics.add(new ArrowheadPrecision());
        statistics.add(new ArrowheadRecall());
        statistics.add(new F1Adj());
        statistics.add(new F1Arrow());
        statistics.add(new F1All());
        statistics.add(new ElapsedCpuTime());
        statistics.setWeight("AP", 1.0);
        statistics.setWeight("AR", 0.5);
        statistics.setWeight("AHP", 1.0);
        statistics.setWeight("AHR", 0.5);
        Algorithms algorithms = new Algorithms();
        algorithms.add(new ExternalAlgorithmTetrad("FGES_(Fast_Greedy_Equivalence_Search)_using_Sem_BIC_Score,_penaltyDiscount_=_1"));
        algorithms.add(new ExternalAlgorithmTetrad("FGES_(Fast_Greedy_Equivalence_Search)_using_Sem_BIC_Score,_penaltyDiscount_=_2"));
        algorithms.add(new ExternalAlgorithmTetrad("FGES_(Fast_Greedy_Equivalence_Search)_using_Sem_BIC_Score,_penaltyDiscount_=_4"));
        algorithms.add(new ExternalAlgorithmPcalgGes("GES_pcalg_defaults_1.0*log(nrow(data)"));
        algorithms.add(new ExternalAlgorithmPcalgGes("GES_pcalg_defaults_2.0*log(nrow(data)"));
        Comparison comparison = new Comparison();
        comparison.setShowAlgorithmIndices(true);
        comparison.setShowSimulationIndices(true);
        comparison.setSortByUtility(false);
        comparison.setShowUtilities(false);
        comparison.setSaveGraphs(true);
        comparison.setComparisonGraph(Comparison.ComparisonGraph.CPDAG_of_the_true_DAG);
        comparison.generateReportFromExternalAlgorithms("/Users/user/comparison-data/condition_1", "/Users/user/causal-comparisons/condition_1", algorithms, statistics, parameters);
    }

    public static void main(String ... args) {
        new Condition1().compileTable();
    }
}

