/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.study;

import edu.cmu.tetrad.algcomparison.Comparison;
import edu.cmu.tetrad.algcomparison.algorithm.Algorithms;
import edu.cmu.tetrad.algcomparison.algorithm.oracle.pag.GFCI;
import edu.cmu.tetrad.algcomparison.independence.FisherZ;
import edu.cmu.tetrad.algcomparison.score.SemBicScore;
import edu.cmu.tetrad.algcomparison.statistic.AdjacencyPrecision;
import edu.cmu.tetrad.algcomparison.statistic.AdjacencyRecall;
import edu.cmu.tetrad.algcomparison.statistic.ArrowheadPrecision;
import edu.cmu.tetrad.algcomparison.statistic.ArrowheadRecall;
import edu.cmu.tetrad.algcomparison.statistic.ElapsedCpuTime;
import edu.cmu.tetrad.algcomparison.statistic.F1Adj;
import edu.cmu.tetrad.algcomparison.statistic.F1Arrow;
import edu.cmu.tetrad.algcomparison.statistic.MathewsCorrArrow;
import edu.cmu.tetrad.algcomparison.statistic.ParameterColumn;
import edu.cmu.tetrad.algcomparison.statistic.SHD;
import edu.cmu.tetrad.algcomparison.statistic.Statistics;
import edu.cmu.tetrad.util.Parameters;

public class ExampleCompareFromFiles {
    public static void main(String ... args) {
        Parameters parameters = new Parameters();
        parameters.set("numRuns", (Object)1);
        parameters.set("numMeasures", (Object)1000);
        parameters.set("numLatents", (Object)200);
        parameters.set("avgDegree", (Object)2);
        parameters.set("sampleSize", (Object)1000);
        parameters.set("penaltyDisount", (Object)2);
        parameters.set("alpha", (Object)1.0E-4);
        Statistics statistics = new Statistics();
        statistics.add(new ParameterColumn("avgDegree"));
        statistics.add(new ParameterColumn("sampleSize"));
        statistics.add(new AdjacencyPrecision());
        statistics.add(new AdjacencyRecall());
        statistics.add(new ArrowheadPrecision());
        statistics.add(new ArrowheadRecall());
        statistics.add(new MathewsCorrArrow());
        statistics.add(new F1Adj());
        statistics.add(new F1Arrow());
        statistics.add(new SHD());
        statistics.add(new ElapsedCpuTime());
        statistics.setWeight("AP", 1.0);
        statistics.setWeight("AR", 0.5);
        statistics.setWeight("AHP", 1.0);
        statistics.setWeight("AHR", 0.5);
        Algorithms algorithms = new Algorithms();
        algorithms.add(new GFCI(new FisherZ(), new SemBicScore()));
        Comparison comparison = new Comparison();
        comparison.setShowAlgorithmIndices(true);
        comparison.setShowSimulationIndices(false);
        comparison.setSortByUtility(true);
        comparison.setShowUtilities(true);
        comparison.setSaveGraphs(true);
        comparison.compareFromFiles("comparison", algorithms, statistics, parameters);
    }
}

