/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.study;

import edu.cmu.tetrad.algcomparison.Comparison;
import edu.cmu.tetrad.algcomparison.algorithm.Algorithms;
import edu.cmu.tetrad.algcomparison.algorithm.FirstInflection;
import edu.cmu.tetrad.algcomparison.algorithm.oracle.cpdag.Fges;
import edu.cmu.tetrad.algcomparison.graph.RandomForward;
import edu.cmu.tetrad.algcomparison.score.SemBicScore;
import edu.cmu.tetrad.algcomparison.simulation.LinearFisherModel;
import edu.cmu.tetrad.algcomparison.simulation.Simulations;
import edu.cmu.tetrad.algcomparison.statistic.AdjacencyPrecision;
import edu.cmu.tetrad.algcomparison.statistic.AdjacencyRecall;
import edu.cmu.tetrad.algcomparison.statistic.ArrowheadPrecision;
import edu.cmu.tetrad.algcomparison.statistic.ArrowheadPrecisionCommonEdges;
import edu.cmu.tetrad.algcomparison.statistic.ArrowheadRecall;
import edu.cmu.tetrad.algcomparison.statistic.ArrowheadRecallCommonEdges;
import edu.cmu.tetrad.algcomparison.statistic.ElapsedCpuTime;
import edu.cmu.tetrad.algcomparison.statistic.ParameterColumn;
import edu.cmu.tetrad.algcomparison.statistic.Statistics;
import edu.cmu.tetrad.util.Parameters;

public class ExampleFirstInflection {
    public static void main(String ... args) {
        Parameters parameters = new Parameters();
        parameters.set("numMeasures", 40, 100);
        parameters.set("avgDegree", (Object)2);
        parameters.set("sampleSize", 400, 800);
        parameters.set("numRuns", (Object)10);
        parameters.set("differentGraphs", (Object)true);
        parameters.set("numLatents", (Object)0);
        parameters.set("maxDegree", (Object)100);
        parameters.set("maxIndegree", (Object)100);
        parameters.set("maxOutdegree", (Object)100);
        parameters.set("connected", (Object)false);
        parameters.set("coefLow", (Object)0.2);
        parameters.set("coefHigh", (Object)0.9);
        parameters.set("varLow", (Object)1);
        parameters.set("varHigh", (Object)3);
        parameters.set("verbose", (Object)false);
        parameters.set("coefSymmetric", (Object)true);
        parameters.set("percentDiscrete", (Object)0);
        parameters.set("numCategories", (Object)3);
        parameters.set("differentGraphs", (Object)true);
        parameters.set("intervalBetweenShocks", (Object)10);
        parameters.set("intervalBetweenRecordings", (Object)10);
        parameters.set("fisherEpsilon", (Object)0.001);
        parameters.set("randomizeColumns", (Object)true);
        parameters.set("alpha", (Object)1.0E-8);
        parameters.set("depth", (Object)-1);
        parameters.set("penaltyDiscount", (Object)4);
        parameters.set("useMaxPOrientationHeuristic", (Object)false);
        parameters.set("maxPOrientationMaxPathLength", (Object)3);
        parameters.set("verbose", (Object)false);
        parameters.set("scaleFreeAlpha", (Object)1.0E-5);
        parameters.set("scaleFreeBeta", (Object)0.4);
        parameters.set("scaleFreeDeltaIn", (Object)0.1);
        parameters.set("scaleFreeDeltaOut", (Object)3);
        parameters.set("symmetricFirstStep", (Object)false);
        parameters.set("faithfulnessAssumed", (Object)true);
        parameters.set("maxDegree", (Object)100);
        Statistics statistics = new Statistics();
        statistics.add(new ParameterColumn("numMeasures"));
        statistics.add(new ParameterColumn("avgDegree"));
        statistics.add(new ParameterColumn("sampleSize"));
        statistics.add(new AdjacencyPrecision());
        statistics.add(new AdjacencyRecall());
        statistics.add(new ArrowheadPrecision());
        statistics.add(new ArrowheadRecall());
        statistics.add(new ArrowheadPrecisionCommonEdges());
        statistics.add(new ArrowheadRecallCommonEdges());
        statistics.add(new ElapsedCpuTime());
        statistics.setWeight("AP", 0.25);
        statistics.setWeight("AR", 0.25);
        statistics.setWeight("AHP", 0.25);
        statistics.setWeight("AHR", 0.25);
        Algorithms algorithms = new Algorithms();
        Fges fges = new Fges(new SemBicScore());
        algorithms.add(new FirstInflection(fges, "penaltyDiscount", 0.7, 5.0, 1.0));
        Simulations simulations = new Simulations();
        simulations.add(new LinearFisherModel(new RandomForward()));
        Comparison comparison = new Comparison();
        comparison.setShowAlgorithmIndices(true);
        comparison.setShowSimulationIndices(true);
        comparison.setSortByUtility(false);
        comparison.setShowUtilities(false);
        comparison.setComparisonGraph(Comparison.ComparisonGraph.CPDAG_of_the_true_DAG);
        comparison.compareFromSimulations("first.inflection", simulations, algorithms, statistics, parameters);
    }
}

