/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.study;

import edu.cmu.tetrad.algcomparison.Comparison;
import edu.cmu.tetrad.algcomparison.algorithm.Algorithms;
import edu.cmu.tetrad.algcomparison.algorithm.FirstInflection;
import edu.cmu.tetrad.algcomparison.algorithm.StARS;
import edu.cmu.tetrad.algcomparison.algorithm.StabilitySelection;
import edu.cmu.tetrad.algcomparison.algorithm.oracle.cpdag.Fges;
import edu.cmu.tetrad.algcomparison.graph.RandomForward;
import edu.cmu.tetrad.algcomparison.score.SemBicScore;
import edu.cmu.tetrad.algcomparison.simulation.LinearFisherModel;
import edu.cmu.tetrad.algcomparison.simulation.Simulations;
import edu.cmu.tetrad.algcomparison.statistic.AdjacencyPrecision;
import edu.cmu.tetrad.algcomparison.statistic.AdjacencyRecall;
import edu.cmu.tetrad.algcomparison.statistic.ArrowheadPrecision;
import edu.cmu.tetrad.algcomparison.statistic.ArrowheadRecall;
import edu.cmu.tetrad.algcomparison.statistic.ElapsedCpuTime;
import edu.cmu.tetrad.algcomparison.statistic.ParameterColumn;
import edu.cmu.tetrad.algcomparison.statistic.Statistics;
import edu.cmu.tetrad.util.Parameters;

public class ExampleStARS {
    public static void main(String ... args) {
        Parameters parameters = new Parameters();
        parameters.set("numMeasures", (Object)200);
        parameters.set("avgDegree", 2, 4, 6);
        parameters.set("sampleSize", 100, 500);
        parameters.set("numRuns", (Object)2);
        parameters.set("differentGraphs", (Object)true);
        parameters.set("numLatents", (Object)0);
        parameters.set("maxDegree", (Object)100);
        parameters.set("maxIndegree", (Object)100);
        parameters.set("maxOutdegree", (Object)100);
        parameters.set("connected", (Object)false);
        parameters.set("coefLow", (Object)0.2);
        parameters.set("coefHigh", (Object)0.9);
        parameters.set("varLow", (Object)1);
        parameters.set("varHigh", (Object)3);
        parameters.set("verbose", (Object)false);
        parameters.set("coefSymmetric", (Object)true);
        parameters.set("percentDiscrete", (Object)0);
        parameters.set("numCategories", (Object)3);
        parameters.set("differentGraphs", (Object)true);
        parameters.set("intervalBetweenShocks", (Object)10);
        parameters.set("intervalBetweenRecordings", (Object)10);
        parameters.set("fisherEpsilon", (Object)0.001);
        parameters.set("randomizeColumns", (Object)true);
        parameters.set("alpha", (Object)0.01);
        parameters.set("depth", (Object)-1);
        parameters.set("penaltyDiscount", (Object)2);
        parameters.set("useMaxPOrientationHeuristic", (Object)false);
        parameters.set("maxPOrientationMaxPathLength", (Object)3);
        parameters.set("verbose", (Object)false);
        parameters.set("scaleFreeAlpha", (Object)1.0E-5);
        parameters.set("scaleFreeBeta", (Object)0.4);
        parameters.set("scaleFreeDeltaIn", (Object)0.1);
        parameters.set("scaleFreeDeltaOut", (Object)3);
        parameters.set("symmetricFirstStep", (Object)false);
        parameters.set("faithfulnessAssumed", (Object)true);
        parameters.set("maxDegree", (Object)100);
        parameters.set("StARS.tolerance", (Object)0.5);
        parameters.set("StARS.cutoff", (Object)0.05);
        parameters.set("numSubsamples", (Object)7);
        parameters.set("percentSubsampleSize", (Object)0.5);
        parameters.set("percentStability", (Object)0.5);
        Statistics statistics = new Statistics();
        statistics.add(new ParameterColumn("numMeasures"));
        statistics.add(new ParameterColumn("avgDegree"));
        statistics.add(new ParameterColumn("sampleSize"));
        statistics.add(new AdjacencyPrecision());
        statistics.add(new AdjacencyRecall());
        statistics.add(new ArrowheadPrecision());
        statistics.add(new ArrowheadRecall());
        statistics.add(new ElapsedCpuTime());
        statistics.setWeight("AP", 0.25);
        statistics.setWeight("AR", 0.25);
        statistics.setWeight("AHP", 0.25);
        statistics.setWeight("AHR", 0.25);
        Algorithms algorithms = new Algorithms();
        parameters.set("logScale", (Object)false);
        algorithms.add(new StabilitySelection(new Fges(new SemBicScore())));
        algorithms.add(new StARS(new Fges(new SemBicScore()), "penaltyDiscount", 1.0, 5.0));
        algorithms.add(new FirstInflection(new Fges(new SemBicScore()), "penaltyDiscount", 1.0, 5.0, 0.1));
        Simulations simulations = new Simulations();
        simulations.add(new LinearFisherModel(new RandomForward()));
        Comparison comparison = new Comparison();
        comparison.setShowAlgorithmIndices(true);
        comparison.setShowSimulationIndices(true);
        comparison.setSortByUtility(false);
        comparison.setShowUtilities(false);
        comparison.setComparisonGraph(Comparison.ComparisonGraph.CPDAG_of_the_true_DAG);
        comparison.compareFromSimulations("first.inflection", simulations, algorithms, statistics, parameters);
    }
}

