/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.study;

import edu.cmu.tetrad.algcomparison.Comparison;
import edu.cmu.tetrad.algcomparison.algorithm.Algorithms;
import edu.cmu.tetrad.algcomparison.algorithm.continuous.dag.Lingam;
import edu.cmu.tetrad.algcomparison.algorithm.multi.FASK;
import edu.cmu.tetrad.algcomparison.algorithm.oracle.cpdag.FAS;
import edu.cmu.tetrad.algcomparison.algorithm.pairwise.R3;
import edu.cmu.tetrad.algcomparison.algorithm.pairwise.RSkew;
import edu.cmu.tetrad.algcomparison.graph.RandomForward;
import edu.cmu.tetrad.algcomparison.independence.FisherZ;
import edu.cmu.tetrad.algcomparison.score.SemBicScore;
import edu.cmu.tetrad.algcomparison.simulation.LinearFisherModel;
import edu.cmu.tetrad.algcomparison.simulation.Simulations;
import edu.cmu.tetrad.algcomparison.statistic.AdjacencyPrecision;
import edu.cmu.tetrad.algcomparison.statistic.AdjacencyRecall;
import edu.cmu.tetrad.algcomparison.statistic.ArrowheadPrecision;
import edu.cmu.tetrad.algcomparison.statistic.ArrowheadRecall;
import edu.cmu.tetrad.algcomparison.statistic.ElapsedCpuTime;
import edu.cmu.tetrad.algcomparison.statistic.ParameterColumn;
import edu.cmu.tetrad.algcomparison.statistic.Statistics;
import edu.cmu.tetrad.util.Parameters;

public class LingamStudy {
    public static void main(String ... args) {
        Statistics statistics = new Statistics();
        statistics.add(new ParameterColumn("penaltyDiscount"));
        statistics.add(new ParameterColumn("alpha"));
        statistics.add(new AdjacencyPrecision());
        statistics.add(new AdjacencyRecall());
        statistics.add(new ArrowheadPrecision());
        statistics.add(new ArrowheadRecall());
        statistics.add(new ElapsedCpuTime());
        statistics.setWeight("AP", 1.0);
        statistics.setWeight("AR", 1.0);
        statistics.setWeight("AHP", 1.0);
        statistics.setWeight("AHR", 1.0);
        Algorithms algorithms = new Algorithms();
        algorithms.add(new Lingam());
        algorithms.add(new R3(new FAS(new FisherZ())));
        algorithms.add(new RSkew(new FAS(new FisherZ())));
        algorithms.add(new FASK(new FisherZ(), new SemBicScore()));
        Comparison comparison = new Comparison();
        comparison.setShowAlgorithmIndices(true);
        comparison.setShowSimulationIndices(true);
        comparison.setSortByUtility(false);
        comparison.setShowUtilities(false);
        comparison.setComparisonGraph(Comparison.ComparisonGraph.true_DAG);
        Simulations simulations = new Simulations();
        simulations.add(new LinearFisherModel(new RandomForward()));
        comparison.compareFromSimulations("lingam", simulations, algorithms, statistics, LingamStudy.getParameters());
    }

    private static Parameters getParameters() {
        Parameters parameters = new Parameters();
        parameters.set("verbose", (Object)false);
        parameters.set("numRuns", (Object)10);
        parameters.set("sampleSize", (Object)1000);
        parameters.set("coefLow", (Object)0.2);
        parameters.set("coefHigh", (Object)0.7);
        parameters.set("coefSymmetric", (Object)true);
        parameters.set("randomizeColumns", (Object)true);
        parameters.set("depth", (Object)-1);
        parameters.set("symmetricFirstStep", (Object)false);
        parameters.set("faithfulnessAssumed", (Object)true);
        parameters.set("maxDegree", (Object)100);
        parameters.set("maxIndegree", (Object)100);
        parameters.set("maxOutdegree", (Object)100);
        parameters.set("numMeasures", (Object)10);
        parameters.set("avgDegree", (Object)2);
        parameters.set("penaltyDiscount", (Object)1.0);
        parameters.set("alpha", (Object)0.01);
        parameters.set("fastIcaA", (Object)1.1);
        parameters.set("fastIcaMaxIter", (Object)2000);
        parameters.set("fastIcaTolerance", (Object)1.0E-6);
        parameters.set("errorsNormal", (Object)false);
        parameters.set("randomizeColumns", (Object)true);
        return parameters;
    }
}

