/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util;

public final class CombinationGenerator {
    private final int[] dims;
    private final int[] local;
    private final int[] returned;
    private boolean begun;

    public CombinationGenerator(int[] dims) {
        this.dims = dims;
        this.local = new int[dims.length];
        this.returned = new int[dims.length];
        for (int i = 0; i < dims.length - 1; ++i) {
            this.local[i] = 0;
        }
        if (this.local.length > 0) {
            this.local[this.local.length - 1] = -1;
        }
        this.begun = false;
    }

    public int[] next() {
        int i = this.getNumObjects();
        while (--i > -1) {
            if (this.local[i] >= this.dims[i] - 1) continue;
            this.fill(i);
            this.begun = true;
            System.arraycopy(this.local, 0, this.returned, 0, this.getNumObjects());
            return this.returned;
        }
        if (this.begun) {
            return null;
        }
        this.begun = true;
        System.arraycopy(this.local, 0, this.returned, 0, this.getNumObjects());
        return this.returned;
    }

    public static void testPrint(int[] dims) {
        int[] choice;
        CombinationGenerator cg = new CombinationGenerator(dims);
        System.out.println();
        System.out.print("Printing combinations for (");
        for (int i = 0; i < dims.length; ++i) {
            System.out.print(dims[i]);
            if (i >= dims.length - 1) continue;
            System.out.print(", ");
        }
        System.out.println(")\n");
        while ((choice = cg.next()) != null) {
            if (choice.length == 0) {
                System.out.println("zero-length array");
                continue;
            }
            for (int aChoice : choice) {
                System.out.print(aChoice + "\t");
            }
            System.out.println();
        }
        System.out.println();
    }

    private int getNumObjects() {
        return this.local.length;
    }

    private void fill(int index) {
        int n = index;
        this.local[n] = this.local[n] + 1;
        for (int i = index + 1; i < this.getNumObjects(); ++i) {
            this.local[i] = 0;
        }
    }
}

