/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class DataUtility {
    private static final byte NEW_LINE = 10;
    private static final byte CARRIAGE_RETURN = 13;

    private DataUtility() {
    }

    public static int countColumn(File file, char delimiter) throws IOException {
        int count = 0;
        byte delim = (byte)delimiter;
        try (FileChannel fc = new RandomAccessFile(file, "r").getChannel();){
            MappedByteBuffer buffer = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
            byte currentChar = -1;
            int prevChar = 10;
            while (buffer.hasRemaining()) {
                currentChar = buffer.get();
                if (currentChar == 13) {
                    currentChar = 10;
                }
                if (currentChar == delim || currentChar == 10 && prevChar != 10) {
                    ++count;
                    if (currentChar == 10) break;
                }
                prevChar = currentChar;
            }
            if (currentChar != -1 && currentChar != 10) {
                ++count;
            }
        }
        return count;
    }

    public static int countLine(File file) throws IOException {
        int count = 0;
        try (FileChannel fc = new RandomAccessFile(file, "r").getChannel();){
            MappedByteBuffer buffer = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
            int prevChar = 10;
            while (buffer.hasRemaining()) {
                int currentChar = buffer.get();
                if (currentChar == 13) {
                    currentChar = 10;
                }
                if (currentChar == 10 && prevChar != 10) {
                    ++count;
                }
                prevChar = currentChar;
            }
            if (prevChar != 10) {
                ++count;
            }
        }
        return count;
    }
}

