/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.EdgeTypeProbability;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.pitt.dbmi.algo.resampling.ResamplingEdgeEnsemble;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public final class GraphTools {
    private GraphTools() {
    }

    private static Set<Edge> getUndirectedEdges(List<Graph> graphs) {
        HashSet<Edge> edges = new HashSet<Edge>();
        graphs.forEach(graph -> graph.getEdges().forEach(edge -> edges.add(new Edge(edge.getNode1(), edge.getNode2(), Endpoint.NULL, Endpoint.NULL))));
        return edges;
    }

    private static EdgeTypeProbability.EdgeType getEdgeType(Node node1, Node node2, Edge edge) {
        Endpoint end1 = edge.getProximalEndpoint(node1);
        Endpoint end2 = edge.getProximalEndpoint(node2);
        if (end1 == Endpoint.TAIL && end2 == Endpoint.ARROW) {
            return EdgeTypeProbability.EdgeType.ta;
        }
        if (end1 == Endpoint.ARROW && end2 == Endpoint.TAIL) {
            return EdgeTypeProbability.EdgeType.at;
        }
        if (end1 == Endpoint.CIRCLE && end2 == Endpoint.ARROW) {
            return EdgeTypeProbability.EdgeType.ca;
        }
        if (end1 == Endpoint.ARROW && end2 == Endpoint.CIRCLE) {
            return EdgeTypeProbability.EdgeType.ac;
        }
        if (end1 == Endpoint.CIRCLE && end2 == Endpoint.CIRCLE) {
            return EdgeTypeProbability.EdgeType.cc;
        }
        if (end1 == Endpoint.ARROW && end2 == Endpoint.ARROW) {
            return EdgeTypeProbability.EdgeType.aa;
        }
        if (end1 == Endpoint.TAIL && end2 == Endpoint.TAIL) {
            return EdgeTypeProbability.EdgeType.tt;
        }
        return EdgeTypeProbability.EdgeType.nil;
    }

    private static List<EdgeTypeProbability> getEdgeTypeProbabilities(Node node1, Node node2, List<Graph> graphs) {
        LinkedList<EdgeTypeProbability> edgeTypeProbabilities = new LinkedList<EdgeTypeProbability>();
        int noEdgeCounts = 0;
        HashMap<Edge, Integer> edgeTypeCounts = new HashMap<Edge, Integer>();
        for (Graph graph : graphs) {
            if (graph == null) continue;
            Edge edge = graph.getEdge(node1, node2);
            if (edge != null) {
                Integer edgeCounts = (Integer)edgeTypeCounts.get(edge);
                edgeCounts = edgeCounts == null ? 1 : edgeCounts + 1;
                edgeTypeCounts.put(edge, edgeCounts);
                continue;
            }
            ++noEdgeCounts;
        }
        for (Edge edge : edgeTypeCounts.keySet()) {
            double probability = (double)((Integer)edgeTypeCounts.get(edge)).intValue() / (double)graphs.size();
            EdgeTypeProbability.EdgeType edgeType = GraphTools.getEdgeType(node1, node2, edge);
            edgeTypeProbabilities.add(new EdgeTypeProbability(edgeType, edge.getProperties(), probability));
        }
        if (noEdgeCounts < graphs.size()) {
            edgeTypeProbabilities.add(new EdgeTypeProbability(EdgeTypeProbability.EdgeType.nil, (double)noEdgeCounts / (double)graphs.size()));
        }
        return edgeTypeProbabilities;
    }

    private static EdgeTypeProbability getHighestEdgeTypeProbability(List<EdgeTypeProbability> edgeTypeProbabilities) {
        EdgeTypeProbability highestEdgeTypeProb = null;
        if (edgeTypeProbabilities != null && !edgeTypeProbabilities.isEmpty()) {
            double maxEdgeProb = 0.0;
            for (EdgeTypeProbability etp : edgeTypeProbabilities) {
                EdgeTypeProbability.EdgeType edgeType = etp.getEdgeType();
                double prob = etp.getProbability();
                if (edgeType == EdgeTypeProbability.EdgeType.nil || !(prob > maxEdgeProb)) continue;
                highestEdgeTypeProb = etp;
                maxEdgeProb = prob;
            }
        }
        return highestEdgeTypeProb;
    }

    private static EdgeTypeProbability getHighestEdgeTypeProbability(List<EdgeTypeProbability> edgeTypeProbabilities, ResamplingEdgeEnsemble edgeEnsemble) {
        EdgeTypeProbability highestEdgeTypeProb = null;
        if (edgeTypeProbabilities != null && !edgeTypeProbabilities.isEmpty()) {
            double maxEdgeProb = 0.0;
            double noEdgeProb = 0.0;
            for (EdgeTypeProbability etp : edgeTypeProbabilities) {
                EdgeTypeProbability.EdgeType edgeType = etp.getEdgeType();
                double prob = etp.getProbability();
                if (edgeType == EdgeTypeProbability.EdgeType.nil) {
                    noEdgeProb = prob;
                    continue;
                }
                if (!(prob > maxEdgeProb)) continue;
                highestEdgeTypeProb = etp;
                maxEdgeProb = prob;
            }
            switch (edgeEnsemble) {
                case Highest: {
                    if (!(noEdgeProb > maxEdgeProb)) break;
                    highestEdgeTypeProb = null;
                    break;
                }
                case Majority: {
                    if (!(noEdgeProb > maxEdgeProb) && !(maxEdgeProb < 0.5)) break;
                    highestEdgeTypeProb = null;
                }
            }
        }
        return highestEdgeTypeProb;
    }

    private static Edge createEdge(EdgeTypeProbability edgeTypeProbability, Node n1, Node n2) {
        if (edgeTypeProbability == null) {
            return null;
        }
        switch (edgeTypeProbability.getEdgeType()) {
            case ta: {
                return new Edge(n1, n2, Endpoint.TAIL, Endpoint.ARROW);
            }
            case at: {
                return new Edge(n1, n2, Endpoint.ARROW, Endpoint.TAIL);
            }
            case ca: {
                return new Edge(n1, n2, Endpoint.CIRCLE, Endpoint.ARROW);
            }
            case ac: {
                return new Edge(n1, n2, Endpoint.ARROW, Endpoint.CIRCLE);
            }
            case cc: {
                return new Edge(n1, n2, Endpoint.CIRCLE, Endpoint.CIRCLE);
            }
            case aa: {
                return new Edge(n1, n2, Endpoint.ARROW, Endpoint.ARROW);
            }
            case tt: {
                return new Edge(n1, n2, Endpoint.TAIL, Endpoint.TAIL);
            }
        }
        return null;
    }

    private static Graph computeEdgeProbabilities(Graph graph) {
        for (Edge edge : graph.getEdges()) {
            List<EdgeTypeProbability> edgeTypeProbs = edge.getEdgeTypeProbabilities();
            if (edgeTypeProbs == null || edgeTypeProbs.isEmpty()) continue;
            double prob = 0.0;
            for (EdgeTypeProbability typeProbability : edgeTypeProbs) {
                if (typeProbability.getEdgeType() == EdgeTypeProbability.EdgeType.nil) continue;
                prob += typeProbability.getProbability();
            }
            edge.setProbability(prob);
        }
        return graph;
    }

    public static Graph createHighEdgeProbabilityGraph(List<Graph> graphs) {
        if ((graphs = GraphTools.addPagColorings(graphs)).isEmpty()) {
            return new EdgeListGraph();
        }
        List<Node> nodes = graphs.get(0).getNodes();
        Collections.sort(nodes);
        Graph graph = new EdgeListGraph(nodes);
        for (Edge e : GraphTools.getUndirectedEdges(graphs)) {
            Node n2;
            Node n1 = e.getNode1();
            List<EdgeTypeProbability> edgeTypeProbabilities = GraphTools.getEdgeTypeProbabilities(n1, n2 = e.getNode2(), graphs);
            EdgeTypeProbability highestEdgeTypeProb = GraphTools.getHighestEdgeTypeProbability(edgeTypeProbabilities);
            Edge edge = GraphTools.createEdge(highestEdgeTypeProb, n1, n2);
            if (edge == null) continue;
            for (EdgeTypeProbability etp : edgeTypeProbabilities) {
                edge.addEdgeTypeProbability(etp);
            }
            for (Edge.Property property : highestEdgeTypeProb.getProperties()) {
                edge.addProperty(property);
            }
            graph.addEdge(edge);
        }
        graph = GraphTools.computeEdgeProbabilities(graph);
        return graph;
    }

    public static Graph createHighEdgeProbabilityGraph(List<Graph> graphs, ResamplingEdgeEnsemble edgeEnsemble) {
        if ((graphs = GraphTools.addPagColorings(graphs)).isEmpty()) {
            return new EdgeListGraph();
        }
        List<Node> nodes = graphs.get(0).getNodes();
        Collections.sort(nodes);
        Graph graph = new EdgeListGraph(nodes);
        for (Edge e : GraphTools.getUndirectedEdges(graphs)) {
            Node n2;
            Node n1 = e.getNode1();
            List<EdgeTypeProbability> edgeTypeProbabilities = GraphTools.getEdgeTypeProbabilities(n1, n2 = e.getNode2(), graphs);
            EdgeTypeProbability highestEdgeTypeProb = GraphTools.getHighestEdgeTypeProbability(edgeTypeProbabilities, edgeEnsemble);
            Edge edge = GraphTools.createEdge(highestEdgeTypeProb, n1, n2);
            if (edge == null) continue;
            for (EdgeTypeProbability etp : edgeTypeProbabilities) {
                edge.addEdgeTypeProbability(etp);
            }
            for (Edge.Property property : highestEdgeTypeProb.getProperties()) {
                edge.addProperty(property);
            }
            graph.addEdge(edge);
        }
        graph = GraphTools.computeEdgeProbabilities(graph);
        return graph;
    }

    private static List<Graph> addPagColorings(List<Graph> graphs) {
        if (graphs == null) {
            return Collections.EMPTY_LIST;
        }
        return graphs.stream().filter(graph -> graph != null).map(graph -> {
            GraphUtils.addPagColoring(graph);
            return graph;
        }).collect(Collectors.toList());
    }
}

